// JavaScript para Configurações do Bingo

$(document).ready(function() {
    
    // ==========================================
    // MODAL: Bingo Geral
    // ==========================================
    $('.modalBingoGeral').on('click', function() {
        $('#modalBingoGeral').fadeIn();
    });

    $('#formbingogeral').on('submit', function(e) {
        e.preventDefault();
        
        var formData = $(this).serialize();
        var submitBtn = $('#subBingoGeral');
        
        submitBtn.prop('disabled', true).val('Atualizando...');
        
        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'sucesso') {
                    mostrarAlerta('#alerta-bingo-geral', response.mensagem, 'sucesso');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    mostrarAlerta('#alerta-bingo-geral', response.mensagem, 'erro');
                }
            },
            error: function() {
                mostrarAlerta('#alerta-bingo-geral', 'Erro ao conectar com o servidor', 'erro');
            },
            complete: function() {
                submitBtn.prop('disabled', false).val('Atualizar');
            }
        });
    });

    // ==========================================
    // MODAL: Bingo Prêmios
    // ==========================================
    $('.modalBingoPremios').on('click', function() {
        $('#modalBingoPremios').fadeIn();
    });

    $('#formbingopremios').on('submit', function(e) {
        e.preventDefault();
        
        var formData = $(this).serialize();
        var submitBtn = $('#subBingoPremios');
        
        submitBtn.prop('disabled', true).val('Atualizando...');
        
        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'sucesso') {
                    mostrarAlerta('#alerta-bingo-premios', response.mensagem, 'sucesso');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    mostrarAlerta('#alerta-bingo-premios', response.mensagem, 'erro');
                }
            },
            error: function() {
                mostrarAlerta('#alerta-bingo-premios', 'Erro ao conectar com o servidor', 'erro');
            },
            complete: function() {
                submitBtn.prop('disabled', false).val('Atualizar');
            }
        });
    });

    // ==========================================
    // MODAL: Bingo Cartelas
    // ==========================================
    $('.modalBingoCartelas').on('click', function() {
        $('#modalBingoCartelas').fadeIn();
    });

    $('#formbingocartelas').on('submit', function(e) {
        e.preventDefault();
        
        var formData = $(this).serialize();
        var submitBtn = $('#subBingoCartelas');
        
        submitBtn.prop('disabled', true).val('Atualizando...');
        
        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'sucesso') {
                    mostrarAlerta('#alerta-bingo-cartelas', response.mensagem, 'sucesso');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    mostrarAlerta('#alerta-bingo-cartelas', response.mensagem, 'erro');
                }
            },
            error: function() {
                mostrarAlerta('#alerta-bingo-cartelas', 'Erro ao conectar com o servidor', 'erro');
            },
            complete: function() {
                submitBtn.prop('disabled', false).val('Atualizar');
            }
        });
    });

    // ==========================================
    // MODAL: Bingo Tempo
    // ==========================================
    $('.modalBingoTempo').on('click', function() {
        $('#modalBingoTempo').fadeIn();
    });

    $('#formbingotempo').on('submit', function(e) {
        e.preventDefault();
        
        var formData = $(this).serialize();
        var submitBtn = $('#subBingoTempo');
        
        submitBtn.prop('disabled', true).val('Atualizando...');
        
        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'sucesso') {
                    mostrarAlerta('#alerta-bingo-tempo', response.mensagem, 'sucesso');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    mostrarAlerta('#alerta-bingo-tempo', response.mensagem, 'erro');
                }
            },
            error: function() {
                mostrarAlerta('#alerta-bingo-tempo', 'Erro ao conectar com o servidor', 'erro');
            },
            complete: function() {
                submitBtn.prop('disabled', false).val('Atualizar');
            }
        });
    });

    // ==========================================
    // MODAL: Bingo Extra
    // ==========================================
    $('.modalBingoExtra').on('click', function() {
        $('#modalBingoExtra').fadeIn();
    });

    $('#formbingoextra').on('submit', function(e) {
        e.preventDefault();
        
        var formData = $(this).serialize();
        var submitBtn = $('#subBingoExtra');
        
        submitBtn.prop('disabled', true).val('Atualizando...');
        
        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'sucesso') {
                    mostrarAlerta('#alerta-bingo-extra', response.mensagem, 'sucesso');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    mostrarAlerta('#alerta-bingo-extra', response.mensagem, 'erro');
                }
            },
            error: function() {
                mostrarAlerta('#alerta-bingo-extra', 'Erro ao conectar com o servidor', 'erro');
            },
            complete: function() {
                submitBtn.prop('disabled', false).val('Atualizar');
            }
        });
    });

});

// Função para mostrar alertas
function mostrarAlerta(seletor, mensagem, tipo) {
    var classe = tipo === 'sucesso' ? 'alerta-sucesso' : 'alerta-erro';
    var icone = tipo === 'sucesso' ? 'fa-check-circle' : 'fa-exclamation-triangle';
    
    $(seletor).html(
        '<div class="' + classe + '">' +
        '<i class="fas ' + icone + '"></i> ' + mensagem +
        '</div>'
    ).slideDown();
    
    setTimeout(function() {
        $(seletor).slideUp(function() {
            $(seletor).html('');
        });
    }, 5000);
}
