<?php
if (
    $_SERVER['REQUEST_METHOD'] !== 'POST' ||
    empty($_SERVER['HTTP_X_REQUESTED_WITH']) ||
    strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest'
) {
    header("Location: /painel/dashboard/");
    exit;
}

session_name('adm_session');
session_start();

require_once '../../../includes/db.php';

require_once 'auth_ajax_adm.php';

function valida_token_csrf($form_name) {
    $token = $_POST['csrf_token'] ?? '';
    return isset($_SESSION["csrf_token_$form_name"]) && $token === $_SESSION["csrf_token_$form_name"];
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $errors = [];

    $data = [
        "tokenroyal" => trim($_POST["tokenroyal"] ?? ''),
        "secretroyal" => trim($_POST["secretroyal"] ?? ''),
        "coderoyal" => trim($_POST["coderoyal"] ?? '')
    ];

    if (!valida_token_csrf('royalgames')) {
        $errors[] = "Falha. Por favor, tente novamente.";
    } else if (empty($data["tokenroyal"])) {
        $errors[] = "Agent Token Royal é obrigatório!";
    } else if (empty($data["secretroyal"])) {
        $errors[] = "Agent Secret Royal é obrigatório!";
    } else if (empty($data["coderoyal"])) {
        $errors[] = "Agent Code Royal é obrigatório!";
    }
    
    if (!empty($errors)) {
        $response = [
            "status" => "alertanao",
            "message" => "<p class='alertanao'>" . implode("<br>", $errors) . " <span><i class='fas fa-times'></i></span></p>"
        ];
    } else {
        try {
            $stmt = $pdo->prepare("UPDATE bet_adm_config SET bet_token_royal = :tokenroyal, bet_secret_royal = :secretroyal, bet_code_royal = :coderoyal WHERE id = 1");
            $stmt->bindParam(':tokenroyal', $data["tokenroyal"], PDO::PARAM_STR);
            $stmt->bindParam(':secretroyal', $data["secretroyal"], PDO::PARAM_STR);
            $stmt->bindParam(':coderoyal', $data["coderoyal"], PDO::PARAM_STR);

            if ($stmt->execute()) {
                $response = [
                    "status" => "alertasim",
                    "message" => "<p class='alertasim'>Credenciais Royal Games atualizadas com sucesso! <span><i class='fas fa-check'></i></span></p>"
                ];
            } else {
                $response = [
                    "status" => "alertanao",
                    "message" => "<p class='alertanao'>Erro ao atualizar credenciais Royal Games! <span><i class='fas fa-times'></i></span></p>"
                ];
            }
        } catch (PDOException $e) {
            $response = [
                "status" => "alertanao",
                "message" => "<p class='alertanao'>Erro no banco de dados: " . $e->getMessage() . " <span><i class='fas fa-times'></i></span></p>"
            ];
        }
    }
    
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}
?>