<?php
// Somente AJAX POST
if (
    $_SERVER['REQUEST_METHOD'] !== 'POST' ||
    empty($_SERVER['HTTP_X_REQUESTED_WITH']) ||
    strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest'
) {
    header("Location: /painel/dashboard/");
    exit;
}

session_name('adm_session');
session_start();

header('Content-Type: application/json; charset=utf-8');

// DB
require_once '../../../includes/db.php';

// Auth do admin (igual você usa nos outros)
require_once 'auth_ajax_adm.php';

// Composer (Minishlink)
require_once __DIR__ . '/../../../vendor/autoload.php';
require_once __DIR__ . '/../../../includes/db.php';
require_once __DIR__ . '/../../../includes/config.php';


use Minishlink\WebPush\WebPush;
use Minishlink\WebPush\Subscription;

// Valida CSRF
function valida_token_csrf($form_name) {
    $token = $_POST['csrf_token'] ?? '';
    return isset($_SESSION["csrf_token_$form_name"]) && hash_equals($_SESSION["csrf_token_$form_name"], $token);
}

$errors = [];

if (!valida_token_csrf('push')) {
    $errors[] = "Falha de segurança (CSRF). Atualize a página e tente novamente.";
}

$title  = trim($_POST['title'] ?? 'Notificação');
$body   = trim($_POST['body'] ?? '');
$url    = trim($_POST['url'] ?? '/');
$target = $_POST['target'] ?? 'all';

if ($body === '') $errors[] = "Mensagem vazia.";
if ($title === '') $title = "Notificação";
if ($url === '') $url = "/";

// opcional: normaliza link
if ($url[0] !== '/' && !preg_match('~^https?://~i', $url)) {
    $url = '/' . $url;
}

if (!in_array($target, ['all','logged','guest'], true)) {
    $target = 'all';
}

if (!empty($errors)) {
    echo json_encode([
        "success" => false,
        "message" => implode(" ", $errors)
    ]);
    exit;
}

try {
    $webPush = new WebPush([
        'VAPID' => [
            'subject' => VAPID_SUBJECT,
            'publicKey' => VAPID_PUBLIC_KEY,
            'privateKey' => VAPID_PRIVATE_KEY,
        ],
    ]);

    $payload = json_encode([
        'title' => $title,
        'body'  => $body,
        'url'   => $url,
        'icon'  => '/imagens/icon-192.png'
    ], JSON_UNESCAPED_UNICODE);

    // Filtra alvo
    $sql = "SELECT id, endpoint, p256dh, auth FROM push_subscriptions";
    if ($target === 'logged') $sql .= " WHERE usuario_id IS NOT NULL";
    if ($target === 'guest')  $sql .= " WHERE usuario_id IS NULL";

    $subs = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);

    if (!$subs) {
        echo json_encode([
            "success" => false,
            "message" => "Nenhum dispositivo inscrito para receber push."
        ]);
        exit;
    }

    foreach ($subs as $s) {
        if (empty($s['endpoint']) || empty($s['p256dh']) || empty($s['auth'])) continue;

        $subscription = Subscription::create([
            'endpoint' => $s['endpoint'],
            'keys' => [
                'p256dh' => $s['p256dh'],
                'auth'   => $s['auth'],
            ]
        ]);

        $webPush->queueNotification($subscription, $payload);
    }

    $sent = 0;
    $failed = 0;

    foreach ($webPush->flush() as $report) {
        if ($report->isSuccess()) {
            $sent++;
        } else {
            $failed++;

            // remove endpoints inválidos
            $endpoint = (string) $report->getRequest()->getUri();
            $del = $pdo->prepare("DELETE FROM push_subscriptions WHERE endpoint = ?");
            $del->execute([$endpoint]);
        }
    }

    // Regenera CSRF (igual seu padrão)
    $_SESSION['csrf_token_push'] = bin2hex(random_bytes(32));

    echo json_encode([
        "success" => true,
        "message" => "Notificação enviada.",
        "sent" => $sent,
        "failed" => $failed,
        "new_csrf" => $_SESSION['csrf_token_push']
    ]);
    exit;

} catch (Throwable $e) {
    echo json_encode([
        "success" => false,
        "message" => "Erro ao enviar push: " . $e->getMessage()
    ]);
    exit;
}
