<?php
// Impede acesso direto via navegador (GET)
if (
    $_SERVER['REQUEST_METHOD'] !== 'POST' ||
    empty($_SERVER['HTTP_X_REQUESTED_WITH']) ||
    strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest'
) {
    header("Location: /painel/dashboard/");
    exit;
}

session_name('adm_session');
session_start();

require_once '../../../includes/db.php';
require_once '../../../includes/config.php';

// Autenticação AJAX
require_once 'auth_ajax_adm.php';

// Função para validar CSRF dinamicamente
function valida_token_csrf($form_name) {
    $token = $_POST['csrf_token'] ?? '';
    return isset($_SESSION["csrf_token_$form_name"]) && $token === $_SESSION["csrf_token_$form_name"];
}

// Função para autenticação ClashPay
function authenticateClashPay($ClientIdClashPay, $ClientSecretClashPay) {
    $credentials = base64_encode($ClientIdClashPay . ':' . $ClientSecretClashPay);
    
    $authCh = curl_init('https://api.royalbenk.com/v2/oauth/token');
    curl_setopt($authCh, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($authCh, CURLOPT_POST, true);
    curl_setopt($authCh, CURLOPT_HTTPHEADER, [
        'Authorization: Basic ' . $credentials,
        'Content-Type: application/json'
    ]);

    $authResponse = curl_exec($authCh);
    $httpCode = curl_getinfo($authCh, CURLINFO_HTTP_CODE);
    curl_close($authCh);

    if ($httpCode !== 200) {
        return null;
    }

    $authResult = json_decode($authResponse, true);
    return $authResult['access_token'] ?? null;
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $errors = [];

    // Sanitiza e valida os dados de entrada
    $extrato_id = isset($_POST['extrato_id']) ? (int)$_POST['extrato_id'] : 0; 

    if (!valida_token_csrf('confirmar')) {
        $errors[] = "Falha na validação do token. Por favor, tente novamente.";
    } else {
        if ($extrato_id <= 0) {
            $errors[] = "ID do extrato inválido!";
        }
    }

    if (!empty($errors)) {
        $response = [
            "status" => "alertanao",
            "message" => "<p class='alertanao'>" . implode("<br>", $errors) . " <span><i class='fas fa-times'></i></span></p>"
        ];
    } else {
        $stmt = $pdo->prepare("SELECT bet_valor, bet_usuario FROM bet_transacoes WHERE id = :id LIMIT 1");
        $stmt->execute([':id' => $extrato_id]);
        $transacao = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($transacao) {
            $valorRetirada = $transacao['bet_valor'];
            $usuario_id = $transacao['bet_usuario'];

            $stmt = $pdo->prepare("SELECT bet_nome, bet_cpf FROM bet_usuarios WHERE id = :id");
            $stmt->execute([':id' => $usuario_id]);
            $usuarioDados = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($usuarioDados) {
                try {
                    // Autentica na API ClashPay
                    $jwtToken = authenticateClashPay($ClientIdClashPay, $ClientSecretClashPay);
                    
                    if (!$jwtToken) {
                        throw new Exception("Erro na autenticação ClashPay.");
                    }

                    $cpfLimpo = preg_replace('/[^0-9]/', '', $usuarioDados['bet_cpf']);
                    $host = $_SERVER['HTTP_HOST'];
                    $callback_url = "https://{$host}/dashboard/php/callback_retirada.php";
                    
                    // Gera ID externo único para esta transação
                    $external_id = uniqid('adm_ret_' . $usuario_id . '_', true);

                    $dados = [
                        "amount" => (float)number_format($valorRetirada, 2, '.', ''),
                        "external_id" => $external_id,
                        "payerQuestion" => "Retirada de saldo - Aprovação Admin",
                        "postbackUrl" => $callback_url,
                        "creditParty" => [
                            "key" => $cpfLimpo,
                            "keyType" => "CPF",
                            "document" => $cpfLimpo,
                            "name" => $usuarioDados['bet_nome']
                        ]
                    ];

                    // Envia requisição para API ClashPay
                    $ch = curl_init('https://api.royalbenk.com/v2/pix/payment');
                    curl_setopt_array($ch, [
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_POST => true,
                        CURLOPT_HTTPHEADER => [
                            "Authorization: Bearer $jwtToken",
                            "Content-Type: application/json"
                        ],
                        CURLOPT_POSTFIELDS => json_encode($dados)
                    ]);

                    $resposta = curl_exec($ch);
                    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                    curl_close($ch);

                    // Log para debug
                    error_log("ClashPay Admin Retirada - HTTP Code: $http_code");
                    error_log("ClashPay Admin Retirada - Response: $resposta");

                    $respostaJson = json_decode($resposta, true);

                    if ($http_code === 200 && isset($respostaJson['transactionId'])) {
                        $transactionId = $respostaJson['transactionId'];

                        // Atualiza registro da transação com ID da API ClashPay
                        $update = $pdo->prepare("UPDATE bet_transacoes SET bet_id_transacao = :id_transacao WHERE id = :id");
                        $update->execute([
                            ':id_transacao' => $transactionId,
                            ':id' => $extrato_id
                        ]);

                        // Gera novo token CSRF
                        $_SESSION['csrf_token_confirmar'] = bin2hex(random_bytes(32));

                        $response = [
                            "status" => "alertasim",
                            "message" => "<p class='alertasim'>Pagamento enviado com sucesso via ClashPay! <span><i class='fas fa-check'></i></span></p>"
                        ];

                    } else {
                        $errorMessage = "Erro ao processar pagamento via ClashPay. Código: {$http_code}";
                        
                        if (isset($respostaJson['message'])) {
                            error_log("ClashPay Admin Error: " . $respostaJson['message']);
                            
                            if (strpos($respostaJson['message'], 'invalid') !== false) {
                                $errorMessage = "Dados inválidos. Verifique as informações do usuário.";
                            } elseif (strpos($respostaJson['message'], 'insufficient') !== false) {
                                $errorMessage = "Saldo insuficiente na conta ClashPay.";
                            }
                        }
                        
                        $response = [
                            "status" => "alertanao",
                            "message" => "<p class='alertanao'>$errorMessage <span><i class='fas fa-times'></i></span></p>"
                        ];
                    }

                } catch (Exception $e) {
                    error_log("Erro ClashPay Admin Retirada: " . $e->getMessage());
                    $response = [
                        "status" => "alertanao",
                        "message" => "<p class='alertanao'>Erro no processamento da retirada. Tente novamente mais tarde. <span><i class='fas fa-times'></i></span></p>"
                    ];
                }

            } else {
                $response = [
                    "status" => "alertanao",
                    "message" => "<p class='alertanao'>Usuário da transação não encontrado! <span><i class='fas fa-times'></i></span></p>"
                ];
            }

        } else {
            $response = [
                "status" => "alertanao",
                "message" => "<p class='alertanao'>Transação não encontrada! <span><i class='fas fa-times'></i></span></p>"
            ];
        }
    }

    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}
?>