<?php
// Impede acesso direto via navegador (GET)
if (
    $_SERVER['REQUEST_METHOD'] !== 'POST' ||
    empty($_SERVER['HTTP_X_REQUESTED_WITH']) ||
    strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest'
) {
    header("Location: /painel/dashboard/");
    exit;
}
session_name('adm_session');
session_start();
require_once '../../../includes/db.php';
// Autenticação AJAX
require_once 'auth_ajax_adm.php';
// Função para validar CSRF dinamicamente
function valida_token_csrf($form_name) {
    $token = $_POST['csrf_token'] ?? '';
    return isset($_SESSION["csrf_token_$form_name"]) && $token === $_SESSION["csrf_token_$form_name"];
}

// Helper: limpa campo monetário brasileiro → float
function limpa_valor_monetario(string $valor): string {
    $valor = str_replace(array('R$', ' ', ' '), array('', '', ''), $valor);
    $valor = str_replace('.', '', $valor);   // remove pontos de milhares
    $valor = str_replace(',', '.', $valor);  // vírgula → ponto decimal
    return $valor;
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $errors = [];

    // Sanitiza e valida os dados de entrada
    $data = [
        'premio_quadra' => trim($_POST['premio_quadra'] ?? ''),
        'premio_quina'  => trim($_POST['premio_quina']  ?? ''),
        'premio_bingo'  => trim($_POST['premio_bingo']  ?? '')
    ];

    if (!valida_token_csrf('bingo_premios')) {
        $errors[] = "Falha. Por favor, tente novamente.";
    } else {

        // ── premio_quadra ───────────────────────────────────────
        if ($data['premio_quadra'] === '') {
            $errors[] = "O campo Prêmio da Quadra é obrigatório!";
        } else {
            $clean = limpa_valor_monetario($data['premio_quadra']);
            if (!preg_match('/^\d+(\.\d{1,2})?$/', $clean)) {
                $errors[] = "Valor do Prêmio da Quadra não aceito!";
            } else {
                $data['premio_quadra'] = (float)$clean;
                if ($data['premio_quadra'] < 0) {
                    $errors[] = "Prêmio da Quadra não pode ser negativo!";
                }
            }
        }

        // ── premio_quina ────────────────────────────────────────
        if ($data['premio_quina'] === '') {
            $errors[] = "O campo Prêmio da Quina é obrigatório!";
        } else {
            $clean = limpa_valor_monetario($data['premio_quina']);
            if (!preg_match('/^\d+(\.\d{1,2})?$/', $clean)) {
                $errors[] = "Valor do Prêmio da Quina não aceito!";
            } else {
                $data['premio_quina'] = (float)$clean;
                if ($data['premio_quina'] < 0) {
                    $errors[] = "Prêmio da Quina não pode ser negativo!";
                }
            }
        }

        // ── premio_bingo ────────────────────────────────────────
        if ($data['premio_bingo'] === '') {
            $errors[] = "O campo Prêmio do Bingo é obrigatório!";
        } else {
            $clean = limpa_valor_monetario($data['premio_bingo']);
            if (!preg_match('/^\d+(\.\d{1,2})?$/', $clean)) {
                $errors[] = "Valor do Prêmio do Bingo não aceito!";
            } else {
                $data['premio_bingo'] = (float)$clean;
                if ($data['premio_bingo'] < 0) {
                    $errors[] = "Prêmio do Bingo não pode ser negativo!";
                }
            }
        }
    }

    if (!empty($errors)) {
        $response = [
            "status"  => "alertanao",
            "message" => "<p class='alertanao'>" . implode("<br>", $errors) . " <span><i class='fas fa-times'></i></span></p>"
        ];
    } else {
        try {
            $stmt = $pdo->prepare("
                UPDATE configuracoes_jogo
                SET premio_quadra_default        = :quadra,
                    premio_quina_default         = :quina,
                    premio_cartela_cheia_default = :bingo
                WHERE id = 1
            ");
            $stmt->bindParam(':quadra', $data['premio_quadra']);
            $stmt->bindParam(':quina',  $data['premio_quina']);
            $stmt->bindParam(':bingo',  $data['premio_bingo']);
            $stmt->execute();

            // Regenera token CSRF
            $_SESSION['csrf_token_bingo_premios'] = bin2hex(random_bytes(32));

            $response = [
                "status"  => "alertasim",
                "message" => "<p class='alertasim'>Prêmios atualizados com sucesso! <span><i class='fas fa-check'></i></span></p>"
            ];
        } catch (PDOException $e) {
            $response = [
                "status"  => "alertanao",
                "message" => "<p class='alertanao'>Erro ao atualizar: " . $e->getMessage() . " <span><i class='fas fa-times'></i></span></p>"
            ];
        }
    }

    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}
?>
