<?php
// Impede acesso direto via navegador (GET)
if (
    $_SERVER['REQUEST_METHOD'] !== 'POST' ||
    empty($_SERVER['HTTP_X_REQUESTED_WITH']) ||
    strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest'
) {
    header("Location: /painel/dashboard/");
    exit;
}
session_name('adm_session');
session_start();
require_once '../../../includes/db.php';
// Autenticação AJAX
require_once 'auth_ajax_adm.php';
// Função para validar CSRF dinamicamente
function valida_token_csrf($form_name) {
    $token = $_POST['csrf_token'] ?? '';
    return isset($_SESSION["csrf_token_$form_name"]) && $token === $_SESSION["csrf_token_$form_name"];
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $errors = [];

    // Sanitiza e valida os dados de entrada
    $data = [
        'ativar_bots'     => $_POST['ativar_bots']     ?? '',
        'ativar_narracao' => $_POST['ativar_narracao'] ?? ''
    ];

    if (!valida_token_csrf('bingo_extra')) {
        $errors[] = "Falha. Por favor, tente novamente.";
    } else {

        // ── ativar_bots ─────────────────────────────────────────
        $data['ativar_bots'] = in_array((int)$data['ativar_bots'], [0, 1])
            ? (int)$data['ativar_bots']
            : 0;

        // ── ativar_narracao ─────────────────────────────────────
        $data['ativar_narracao'] = in_array((int)$data['ativar_narracao'], [0, 1])
            ? (int)$data['ativar_narracao']
            : 0;
    }

    if (!empty($errors)) {
        $response = [
            "status"  => "alertanao",
            "message" => "<p class='alertanao'>" . implode("<br>", $errors) . " <span><i class='fas fa-times'></i></span></p>"
        ];
    } else {
        try {
            $stmt = $pdo->prepare("
                UPDATE configuracoes_jogo
                SET ativar_bots     = :bots,
                    ativar_narracao = :narracao
                WHERE id = 1
            ");
            $stmt->bindParam(':bots',     $data['ativar_bots']);
            $stmt->bindParam(':narracao', $data['ativar_narracao']);
            $stmt->execute();

            // Regenera token CSRF
            $_SESSION['csrf_token_bingo_extra'] = bin2hex(random_bytes(32));

            $msg_bots     = $data['ativar_bots']     ? 'ativados'  : 'desativados';
            $msg_narracao = $data['ativar_narracao'] ? 'ativada'   : 'desativada';

            $response = [
                "status"  => "alertasim",
                "message" => "<p class='alertasim'>Bots {$msg_bots} e Narração {$msg_narracao}! <span><i class='fas fa-check'></i></span></p>"
            ];
        } catch (PDOException $e) {
            $response = [
                "status"  => "alertanao",
                "message" => "<p class='alertanao'>Erro ao atualizar: " . $e->getMessage() . " <span><i class='fas fa-times'></i></span></p>"
            ];
        }
    }

    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}
?>
