<?php
// Impede acesso direto via navegador (GET)
if (
    $_SERVER['REQUEST_METHOD'] !== 'POST' ||
    empty($_SERVER['HTTP_X_REQUESTED_WITH']) ||
    strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest'
) {
    header("Location: /painel/dashboard/");
    exit;
}
session_name('adm_session');
session_start();
require_once '../../../includes/db.php';
// Autenticação AJAX
require_once 'auth_ajax_adm.php';
// Função para validar CSRF dinamicamente
function valida_token_csrf($form_name) {
    $token = $_POST['csrf_token'] ?? '';
    return isset($_SESSION["csrf_token_$form_name"]) && $token === $_SESSION["csrf_token_$form_name"];
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $errors = [];

    // Sanitiza e valida os dados de entrada
    $data = [
        'min_cartelas'   => trim($_POST['min_cartelas']   ?? ''),
        'max_cartelas'   => trim($_POST['max_cartelas']   ?? ''),
        'valores_cartela'=> trim($_POST['valores_cartela'] ?? '')
    ];

    if (!valida_token_csrf('bingo_cartelas')) {
        $errors[] = "Falha. Por favor, tente novamente.";
    } else {

        // ── min_cartelas ────────────────────────────────────────
        if ($data['min_cartelas'] === '') {
            $errors[] = "O campo mínimo de cartelas é obrigatório!";
        } else {
            $data['min_cartelas'] = (int)$data['min_cartelas'];
            if ($data['min_cartelas'] < 1) {
                $errors[] = "Mínimo de cartelas deve ser pelo menos 1!";
            }
        }

        // ── max_cartelas ────────────────────────────────────────
        if ($data['max_cartelas'] === '') {
            $errors[] = "O campo máximo de cartelas é obrigatório!";
        } else {
            $data['max_cartelas'] = (int)$data['max_cartelas'];
            if ($data['max_cartelas'] > 200) {
                $errors[] = "Máximo de cartelas não pode exceder 200!";
            }
        }

        // ── cross: max >= min ───────────────────────────────────
        if (empty($errors) && $data['max_cartelas'] < $data['min_cartelas']) {
            $errors[] = "Máximo de cartelas deve ser maior ou igual ao mínimo!";
        }

        // ── valores_cartela (JSON) ──────────────────────────────
        if ($data['valores_cartela'] === '') {
            $errors[] = "O campo de valores da cartela é obrigatório!";
        } else {
            $valores_array = json_decode($data['valores_cartela'], true);
            if (!is_array($valores_array) || empty($valores_array)) {
                $errors[] = "Formato de valores inválido. Use JSON: [\"0.10\",\"0.20\",\"0.50\"]";
            } else {
                foreach ($valores_array as $valor) {
                    if (!is_numeric($valor) || (float)$valor <= 0) {
                        $errors[] = "Todos os valores devem ser números positivos!";
                        break;
                    }
                }
            }
        }
    }

    if (!empty($errors)) {
        $response = [
            "status"  => "alertanao",
            "message" => "<p class='alertanao'>" . implode("<br>", $errors) . " <span><i class='fas fa-times'></i></span></p>"
        ];
    } else {
        try {
            $stmt = $pdo->prepare("
                UPDATE configuracoes_jogo
                SET min_cartelas    = :min,
                    max_cartelas    = :max,
                    valores_cartela = :valores
                WHERE id = 1
            ");
            $stmt->bindParam(':min',    $data['min_cartelas']);
            $stmt->bindParam(':max',    $data['max_cartelas']);
            $stmt->bindParam(':valores',$data['valores_cartela']);
            $stmt->execute();

            // Regenera token CSRF
            $_SESSION['csrf_token_bingo_cartelas'] = bin2hex(random_bytes(32));

            $response = [
                "status"  => "alertasim",
                "message" => "<p class='alertasim'>Configurações de cartelas atualizadas com sucesso! <span><i class='fas fa-check'></i></span></p>"
            ];
        } catch (PDOException $e) {
            $response = [
                "status"  => "alertanao",
                "message" => "<p class='alertanao'>Erro ao atualizar: " . $e->getMessage() . " <span><i class='fas fa-times'></i></span></p>"
            ];
        }
    }

    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}
?>
