<?php
if (!defined('IN_INDEX')) {
    header("Location: /painel/dashboard/");
    exit();
}

// =====================
// CARREGAR CONFIG BÔNUS USA
// =====================
$BonusUsaValor   = 750.00;
$BonusUsaFrase   = 'Claim your {valor} bonus now';
$BonusUsaCotacao = 5.00;

$stmt = $pdo->prepare("SELECT bonus_usa_valor, bonus_usa_frase, bonus_usa_cotacao FROM bet_config WHERE id = 1 LIMIT 1");
$stmt->execute();
$cfg = $stmt->fetch(PDO::FETCH_ASSOC);

if ($cfg) {
    $BonusUsaValor   = (float)($cfg['bonus_usa_valor'] ?? 750);
    $BonusUsaFrase   = $cfg['bonus_usa_frase'] ?? 'Claim your {valor} bonus now';
    $BonusUsaCotacao = (float)($cfg['bonus_usa_cotacao'] ?? 5.00);
}

// =====================
// CARREGAR PARTIDAS DO TICKER
// =====================
$ticker_partidas = [];
try {
    $stmt = $pdo->prepare("SELECT * FROM ticker_partidas ORDER BY ordem ASC, id DESC");
    $stmt->execute();
    $ticker_partidas = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Throwable $e) {}

// =====================
// CARREGAR APOSTAS PENDENTES
// =====================
$apostas_pendentes = [];
try {
    $stmt = $pdo->prepare("
        SELECT a.*, u.bet_nome, u.bet_email, p.time_casa, p.time_fora, p.liga
        FROM apostas_esportivas a
        LEFT JOIN bet_usuarios u ON a.usuario_id = u.id
        LEFT JOIN ticker_partidas p ON a.partida_id = p.id
        ORDER BY a.created_at DESC
        LIMIT 100
    ");
    $stmt->execute();
    $apostas_pendentes = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Throwable $e) {}

// Contadores
$total_apostas_pendentes = 0;
$total_apostas_ganhas = 0;
$total_apostas_perdidas = 0;
foreach ($apostas_pendentes as $ap) {
    if ($ap['status'] === 'pendente') $total_apostas_pendentes++;
    if ($ap['status'] === 'ganhou') $total_apostas_ganhas++;
    if ($ap['status'] === 'perdeu') $total_apostas_perdidas++;
}

?>

<style>
  
/* ========================================================
   ESTILOS DOS MODAIS DE APOSTAS ESPORTIVAS
   ======================================================== */
.modal-large .modal-content {
    max-width: 900px;
    width: 95%;
    max-height: 85vh;
    overflow-y: auto;
}

/* Tabs dentro do modal */
.modal-tabs {
    display: flex;
    gap: 5px;
    margin-bottom: 20px;
    border-bottom: 2px solid #333;
    padding-bottom: 10px;
}

.modal-tab {
    background: #2d3748;
    border: none;
    color: #9ca3af;
    padding: 10px 20px;
    border-radius: 8px 8px 0 0;
    cursor: pointer;
    font-size: 14px;
    font-weight: 500;
    transition: all 0.2s ease;
}

.modal-tab:hover {
    background: #374151;
    color: #fff;
}

.modal-tab.active {
    background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
    color: #fff;
}

.modal-tab .badge {
    background: #ef4444;
    color: #fff;
    font-size: 10px;
    padding: 2px 6px;
    border-radius: 10px;
    margin-left: 6px;
}

.tab-content {
    display: none;
}

.tab-content.active {
    display: block;
}

/* Tabela de dados */
.table-admin {
    width: 100%;
    border-collapse: collapse;
    font-size: 13px;
}

.table-admin th,
.table-admin td {
    padding: 12px 10px;
    text-align: left;
    border-bottom: 1px solid #333;
}

.table-admin th {
    background: #1a1f2e;
    color: #9ca3af;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 11px;
    letter-spacing: 0.5px;
}

.table-admin tr:hover {
    background: rgba(255,255,255,0.03);
}

.table-admin td {
    color: #fff;
}

/* Status badges */
.status-badge {
    display: inline-block;
    padding: 4px 10px;
    border-radius: 20px;
    font-size: 11px;
    font-weight: 600;
    text-transform: uppercase;
}

.status-badge.live {
    background: rgba(239, 68, 68, 0.2);
    color: #ef4444;
}

.status-badge.upcoming {
    background: rgba(251, 191, 36, 0.2);
    color: #fbbf24;
}

.status-badge.finished {
    background: rgba(156, 163, 175, 0.2);
    color: #9ca3af;
}

.status-badge.pendente {
    background: rgba(251, 191, 36, 0.2);
    color: #fbbf24;
}

.status-badge.ganhou {
    background: rgba(16, 185, 129, 0.2);
    color: #10b981;
}

.status-badge.perdeu {
    background: rgba(239, 68, 68, 0.2);
    color: #ef4444;
}

.status-badge.ativo {
    background: rgba(16, 185, 129, 0.2);
    color: #10b981;
}

.status-badge.inativo {
    background: rgba(107, 114, 128, 0.2);
    color: #6b7280;
}

/* Botões de ação */
.btn-action {
    padding: 6px 12px;
    border: none;
    border-radius: 6px;
    cursor: pointer;
    font-size: 12px;
    font-weight: 500;
    transition: all 0.2s ease;
    margin-right: 5px;
}

.btn-action.edit {
    background: rgba(59, 130, 246, 0.2);
    color: #3b82f6;
}

.btn-action.edit:hover {
    background: rgba(59, 130, 246, 0.3);
}

.btn-action.delete {
    background: rgba(239, 68, 68, 0.2);
    color: #ef4444;
}

.btn-action.delete:hover {
    background: rgba(239, 68, 68, 0.3);
}

.btn-action.success {
    background: rgba(16, 185, 129, 0.2);
    color: #10b981;
}

.btn-action.success:hover {
    background: rgba(16, 185, 129, 0.3);
}

.btn-action.danger {
    background: rgba(239, 68, 68, 0.2);
    color: #ef4444;
}

.btn-action.danger:hover {
    background: rgba(239, 68, 68, 0.3);
}

/* Botão adicionar */
.btn-add-new {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    border: none;
    color: #fff;
    padding: 10px 20px;
    border-radius: 8px;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    margin-bottom: 15px;
    display: inline-flex;
    align-items: center;
    gap: 8px;
}

.btn-add-new:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(16, 185, 129, 0.4);
}

/* Form grid */
.form-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 15px;
}

.form-grid.cols-3 {
    grid-template-columns: repeat(3, 1fr);
}

.form-grid .form-row {
    margin-bottom: 0;
}

.form-grid .form-row.full-width {
    grid-column: 1 / -1;
}

@media (max-width: 768px) {
    .form-grid,
    .form-grid.cols-3 {
        grid-template-columns: 1fr;
    }
    
    .modal-tabs {
        flex-wrap: wrap;
    }
    
    .table-admin {
        font-size: 11px;
    }
    
    .table-admin th,
    .table-admin td {
        padding: 8px 5px;
    }
}

/* Resumo de stats */
.stats-row {
    display: flex;
    gap: 15px;
    margin-bottom: 20px;
    flex-wrap: wrap;
}

.stat-card {
    flex: 1;
    min-width: 120px;
    background: #252d3d;
    border-radius: 10px;
    padding: 15px;
    text-align: center;
}

.stat-card .stat-number {
    font-size: 24px;
    font-weight: 700;
    color: #fff;
}

.stat-card .stat-label {
    font-size: 11px;
    color: #9ca3af;
    text-transform: uppercase;
    margin-top: 5px;
}

.stat-card.yellow .stat-number { color: #fbbf24; }
.stat-card.green .stat-number { color: #10b981; }
.stat-card.red .stat-number { color: #ef4444; }

/* Scroll horizontal em tabelas */
.table-responsive {
    overflow-x: auto;
    margin: 0 -10px;
    padding: 0 10px;
}

/* Empty state */
.empty-state {
    text-align: center;
    padding: 40px 20px;
    color: #6b7280;
}

.empty-state i {
    font-size: 48px;
    margin-bottom: 15px;
    opacity: 0.5;
}

/* Logo form styles */
.logo-form {
  display: flex;
  gap: 12px;
  align-items: center;
  background: #0f172a;
  padding: 16px;
  border-radius: 14px;
  border: 1px solid #1e293b;
  max-width: 520px;
}

.logo-upload {
  flex: 1;
  background: #020617;
  border: 1px dashed #334155;
  border-radius: 12px;
  padding: 12px 16px;
  cursor: pointer;
  transition: .2s;
  color: #cbd5f5;
  text-align: center;
  font-weight: 600;
}

.logo-upload:hover {
  border-color: #38bdf8;
  color: #38bdf8;
  background: #020617;
}

.btn-logo {
  background: linear-gradient(135deg, #22c55e, #16a34a);
  border: none;
  border-radius: 12px;
  padding: 12px 22px;
  color: #022c22;
  font-weight: 800;
  cursor: pointer;
  transition: .2s;
  box-shadow: 0 8px 20px rgba(34,197,94,.35);
}

.btn-logo:hover {
  transform: translateY(-1px);
  box-shadow: 0 12px 30px rgba(34,197,94,.5);
}

/* Mensagens */
.logo-msg {
  margin-top: 14px;
  max-width: 520px;
}

.alertasim {
  background: rgba(34,197,94,.15);
  border: 1px solid #22c55e;
  color: #4ade80;
  padding: 12px 16px;
  border-radius: 12px;
  font-weight: 700;
}

.alertanao {
  background: rgba(239,68,68,.15);
  border: 1px solid #ef4444;
  color: #f87171;
  padding: 12px 16px;
  border-radius: 12px;
  font-weight: 700;
}

.alertasim span,
.alertanao span {
  float: right;
}
</style>

<div class="container-conteudo">
       <h2 class="titulo-funcoes">Funções</h2>
        <div class="grid-boxes">
            <button class="box-funcao modalGeraPix">
                <i class="fas fa-money-bill-wave"></i>
                <span>GeraPix (Gateway)</span>
            </button>
            <button class="box-funcao modalClashPay">
                <i class="fas fa-money-bill-wave"></i>
                <span>ClashPay (Gateway)</span>
            </button>
            <button class="box-funcao modalPlayFiver">
                <i class="fas fa-gamepad"></i>
                <span>PlayFiver (Jogos)</span>
            </button>

            <button class="box-funcao modalRoyalGames">
                <i class="fas fa-crown"></i>
                <span>Royal Games</span>
            </button>

             <button class="box-funcao modalValores">
                <i class="fas fa-coins"></i>
                <span>Depósito/Saque</span>
            </button>

            <button class="box-funcao modalFacebook">
                <i class="fab fa-facebook"></i>
                <span>Facebook (API)</span>
            </button>

            <button class="box-funcao modalEmail">
                <i class="fas fa-envelope"></i>
                <span>Email</span>
            </button>

            <button class="box-funcao modalLogo">
                <i class="fas fa-image"></i>
                <span>Logo</span>
            </button>

            <button class="box-funcao modalFavicon">
                <i class="fas fa-star"></i>
                <span>Favicon</span>
            </button>

            <button class="box-funcao modalSlider">
                <i class="fas fa-images"></i>
                <span>Slider</span>
            </button>

            <button class="box-funcao modalNomeUrl">
                <i class="fas fa-globe"></i>
                <span>Nome / URL</span>
            </button>

            <button class="box-funcao modalCores">
                <i class="fas fa-palette"></i>
                <span>Cores</span>
            </button>

            <button class="box-funcao modalRedes">
                <i class="fas fa-share-alt"></i>
                <span>Redes Sociais</span>
            </button>

            <button class="box-funcao modalBonusCadastro">
                <i class="fas fa-gift"></i>
                <span>Bônus Cadastro</span>
            </button>

            <button type="button" class="box-funcao modalBonusUsa">
                <i class="fas fa-flag-usa"></i>
                <span>Bônus USA (Inglês)</span>
            </button>

            <!-- NOVO: Sportsbook Completo -->
            <button class="box-funcao modalSportsbook">
                <i class="fas fa-futbol"></i>
                <span>Sportsbook</span>
                <?php if ($total_apostas_pendentes > 0): ?>
                <span style="background:#ef4444;color:#fff;font-size:10px;padding:2px 6px;border-radius:10px;margin-left:5px;">
                    <?= $total_apostas_pendentes ?>
                </span>
                <?php endif; ?>
            </button>

            <button class="box-funcao modalAfiliados">
                <i class="fas fa-users"></i>
                <span>Afiliados Porcentagem</span>
            </button>
            <button class="box-funcao modalPush">
  <i class="fas fa-bell"></i>
  <span>Notificações (Push)</span>
</button>

        </div>
</div>
<div id="modalPush" class="modal">
  <div class="modal-content">
    <span class="close-modal"><i class="fas fa-times"></i></span>
    <h2><i class="fas fa-bell" style="color:#fbbf24;margin-right:10px;"></i>Enviar Push</h2>

    <div id="alerta-push"></div>

    <form id="formPush" method="post" action="php/push_send.php">
      <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token_push'] ?? '' ?>">

      <div class="form-row">
        <div class="input-icon">
          <i class="fas fa-heading"></i>
          <input type="text" name="title" placeholder="Título" required>
        </div>
      </div>

      <div class="form-row">
        <div class="input-icon">
          <i class="fas fa-comment"></i>
          <input type="text" name="body" placeholder="Mensagem" required>
        </div>
      </div>

      <div class="form-row">
        <div class="input-icon">
          <i class="fas fa-link"></i>
          <input type="text" name="url" placeholder="Link ao clicar (ex: /promo)" value="/" required>
        </div>
      </div>

      <div class="form-row">
        <div class="input-icon">
          <i class="fas fa-users"></i>
          <select name="target">
            <option value="all">Enviar para TODOS</option>
            <option value="logged">Somente usuários logados</option>
            <option value="guest">Somente visitantes (deslogados)</option>
          </select>
        </div>
      </div>

      <input type="submit" id="subPush" class="submit-button espacobutton" value="Enviar Notificação">
    </form>

    <div class="info-modal">
      <p>✅ Envia push para mobile (Android/Chrome) que aceitaram permissão.</p>
    </div>
  </div>
</div>

<!-- Conteúdo dos modais -->
<div id="modalGeraPix" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2>Credenciais GeraPix</h2>
        <div id="alerta-gerapix"></div>
        <form id="formgerapix" action="php/gerapix.php">
              <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_gerapix'] ?? '' ?>">
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-key"></i>
                    <input type="text" name="tokengerapix" placeholder="SEU TOKEN SECRETO"  value="<?= $TokenGeraPix ?>">
                </div>
            </div>

            <input type="submit" id="subGerapix" class="submit-button espacobutton" value="Atualizar">
        </form>
            <div class="create-account"><a href="https://gerapix.digital/" target="_blank" rel="noopener noreferrer">Abrir conta na GeraPix</a></div> 
    </div>
</div>
<!-- Conteúdo dos modais -->
<div id="modalClashPay" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2>Credenciais ClashPay</h2>
        <div id="alerta-clashpay"></div>
        <form id="formclashpay" action="php/clashpay.php">
              <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_clashpay'] ?? '' ?>">
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-key"></i>
                    <input type="text" name="clientid" placeholder="SEU CLIENT ID CLASHPAY"  value="<?= $ClientIdClashPay ?>">
                </div>
            </div>

            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-key"></i>
                    <input type="text" name="clientsecret" placeholder="SEU CLIENT SECRET CLASHPAY"  value="<?= $ClientSecretClashPay ?>">
                </div>
            </div>
            <input type="submit" id="subClashPay" class="submit-button espacobutton" value="Atualizar">
        </form>
            <div class="create-account"><a href="https://clashpay.digital" target="_blank" rel="noopener noreferrer">Acessar ClashPay</a></div> 
    </div>
</div>
<div id="modalPlayFiver" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2>Credenciais PlayFiver</h2>
        <div id="alerta-playfiver"></div>
        <form id="formplayfiver" action="php/playfiver.php">
               <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_playfiver'] ?? '' ?>">
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-key"></i>
                    <input type="text" name="tokenplayfiverpublico" placeholder="SEU TOKEN PÚBLICO" value="<?= $TokenPlayFiverPublico ?>">
                </div>
            </div>
            
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-key"></i>
                    <input type="text" name="tokenplayfiversecreto" placeholder="SEU TOKEN SECRETO" value="<?= $TokenPlayFiverSecreto ?>">
                </div>
            </div>
            <input type="submit" id="subPlayfiver" class="submit-button espacobutton" value="Atualizar">
        </form>
            <div class="link-modal">
                <p>Sua URL de webhook para cadastro na PlayFiver</p>
                <p id="link-text-1">https://<?= $Site ?>/webhook/index.php</p>
                <button class="copy-btn" data-target="link-text-1">Copiar Link</button>
            </div>
            <div class="create-account"><a href="https://playfiver.app/register" target="_blank" rel="noopener noreferrer">Abrir conta na PlayFiver</a></div> 
    </div>
</div>

<div id="modalRoyalGames" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2>Credenciais Royal Games</h2>
        <div id="alerta-royalgames"></div>
        <form id="formroyalgames" action="php/royalgames.php">
               <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_royalgames'] ?? '' ?>">
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-key"></i>
                    <input type="text" name="tokenroyal" placeholder="AGENT TOKEN" value="<?= $AgentTokenRoyal ?>">
                </div>
            </div>
            
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-lock"></i>
                    <input type="text" name="secretroyal" placeholder="AGENT SECRET KEY" value="<?= $AgentSecretRoyal ?>">
                </div>
            </div>

            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-code"></i>
                    <input type="text" name="coderoyal" placeholder="AGENT CODE" value="<?= $AgentCodeRoyal ?>">
                </div>
            </div>
            <input type="submit" id="subRoyalGames" class="submit-button espacobutton" value="Atualizar">
        </form>
            <div class="create-account"><a href="https://painel.royalgamess.com/" target="_blank" rel="noopener noreferrer">Acessar Royal Games</a></div> 
    </div>
</div>

<div id="modalValores" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2>Depósito/Saque</h2>
        <div id="alerta-valores"></div>
        <form id="formvalores" action="php/valores.php">
               <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_valores'] ?? '' ?>">
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-wallet"></i>
                    <input type="text" id='deposito' name="deposito" placeholder="Valor mínimo de depósito">
                </div>
            </div>
            
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-hand-holding-usd"></i>
                    <input type="text" id='retirada' name="retirada" placeholder="Valor mínimo de saque">
                </div>
            </div>

           <div class="form-row toggle-row">
    <label class="toggle-switch">
        <input type="checkbox" id="togglePagamento" name="togglePagamento">
        <span class="switch-slider"></span>
    </label>
    <span class="toggle-label">Pagamento Automático</span>
</div>

<input type="hidden" name="pagamento_auto" id="pagamento_auto" value="0">

            <input type="submit" id="subValores" class="submit-button espacobutton" value="Atualizar">
        </form>
        <div class="info-modal">
            <p>Valor atual de depósito R$ <strong><?= number_format($ValorDeposito, 2, ',', '.') ?></strong> reais.</p>
            <p>Valor atual de retirada R$ <strong><?= number_format($ValorRetirada, 2, ',', '.') ?></strong> reais.</p>
            <p>Pagamento tipo: <strong><?= ($TipoPagamento == 1) ? "Automático" : "Manual"; ?></strong></p>
        </div>
    </div>
</div>

<div id="modalFacebook" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2>Facebook (API)</h2>
        <div id="alerta-facebook"></div>
        <form id="formfacebook" action="php/facebook.php">
              <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_facebook'] ?? '' ?>">
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-code"></i>
                    <input type="text" name="facepixel" placeholder="Seu Pixel FaceBook" value="<?= $FacePixel ?>">
                </div>
            </div>

            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-key"></i>
                    <input type="text" name="facetoken" placeholder="Seu Token FaceBook" value="<?= $FaceToken ?>">
                </div>
            </div>

            <input type="submit" id="subFacebook" class="submit-button espacobutton" value="Atualizar">
        </form>
<div class="link-modal">
    <p>Sua URL de divulgação no FaceBook</p>
    <p id="link-text-2">https://<?= $Site ?>/?modal=cadastro&utm=facebook</p>
    <button class="copy-btn" data-target="link-text-2">Copiar Link</button>
</div>
    </div>
</div>

<div id="modalEmail" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2>Configurações de Email</h2>
        <div id="alerta-email"></div>
        <form id="formemail" action="php/email.php">
              <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_email'] ?? '' ?>">
            
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-server"></i>
                    <input type="text" name="host" placeholder="Servidor de Saída (SMTP)">
                </div>
            </div>

            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-envelope"></i>
                    <input type="text" name="email" placeholder="E-mail de Suporte do Site">
                </div>
            </div>

            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-key"></i>
                    <input type="text" name="senha" placeholder="Senha da Conta de Email">
                </div>
            </div>

            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-plug"></i>
                    <select name="porta">
                        <option value="">Selecione a Porta SMTP</option>
                        <option value="465">465 (SMTP com SSL/TLS)</option>
                        <option value="587">587 (SMTP com STARTTLS)</option>
                        <option value="25">25 (SMTP padrão, sem criptografia ou com STARTTLS)</option>
                     </select>
                </div>
            </div>

            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-shield-alt"></i>
                    <select name="smtp">
                        <option value="">Tipo de Segurança</option>
                        <option value="ssl">SSL</option>
                        <option value="tls">TLS</option>
                        </select>
                    </div>
                </div>

            <input type="submit" id="subEmail" class="submit-button espacobutton" value="Atualizar">
        </form>
    </div>
</div>

<div id="modalLogo" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2>Imagem Logo</h2>
        <div id="alerta-logo"></div>
<form id="formLogo" action="php/logo.php" method="post" enctype="multipart/form-data" class="logo-form">
  <input type="hidden" name="csrf_token" id="csrf_logo" value="<?= $_SESSION['csrf_token_logo'] ?? '' ?>">

  <label class="logo-upload">
    <input type="file" name="logo" accept="image/png,image/jpeg,image/webp" required hidden>
    <span>📁 Selecionar logo</span>
  </label>

  <button type="submit" class="btn-logo">Salvar logo</button>
</form>

<div id="msgLogo" class="logo-msg"></div>

    </div>
</div>

<div id="modalFavicon" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2>Imagem Favicon</h2>
        <div id="alerta-favicon"></div>
        <form id="formFavicon"
      action="php/favicon.php"
      method="post"
      enctype="multipart/form-data"
      class="logo-form">

  <input type="hidden" name="csrf_token" id="csrf_favicon"
         value="<?= $_SESSION['csrf_token_favicon'] ?? '' ?>">

  <label class="logo-upload">
    <input type="file"
           name="favicon"
           accept="image/png"
           required
           hidden>
    <span>🧩 Selecionar favicon (PNG 48x48)</span>
  </label>

  <button type="submit" class="btn-logo">
    Salvar favicon
  </button>
</form>

<div id="msgFavicon" class="logo-msg"></div>


    </div>
</div>

<div id="modalSlider" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2>Imagens Sliders</h2>
        <div id="alerta-slider"></div>
       <form id="formSlider"
      action="php/slider.php"
      method="post"
      enctype="multipart/form-data"
      class="logo-form">

  <input type="hidden" name="csrf_token" id="csrf_slider"
         value="<?= $_SESSION['csrf_token_slider'] ?? '' ?>">

  <label class="logo-upload">
    <input type="file"
           name="slider[]"
           accept="image/png,image/jpeg,image/jpg,image/webp,image/gif"
           multiple
           required
           hidden>
    <span>🖼️ Selecionar 3 imagens do slider</span>
  </label>

  <button type="submit" class="btn-logo">
    Salvar slider
  </button>
</form>

<div id="msgSlider" class="logo-msg"></div>

    </div>
</div>
<div id="modalNomeUrl" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2>Nome / URL</h2>
        <div id="alerta-nomeurl"></div>
        <form id="formnomeurl" action="php/nomeurl.php">
              <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_nomeurl'] ?? '' ?>">
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-globe"></i>
                    <input type="text" name="nomesite" placeholder="Nome do Site" value="<?= $NomeSite ?>">
                </div>
            </div>
            
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-globe-americas"></i>
                    <input type="text" name="urlsite" placeholder="URL do site (https://)*" value="https://<?= $Site ?>">
                </div>
            </div>
            <input type="submit" id="subNomeUrl" class="submit-button espacobutton" value="Atualizar">
        </form>
    </div>
</div>

<div id="modalCores" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2>Cor do Template</h2>
        <div id="alerta-cores"></div>
        <form id="formcores" action="php/cores.php">
            <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_cores'] ?? '' ?>">

            <label class="color-option">
                <i class="fas fa-palette"></i>
                <input type="radio" name="cor" value="#00C774_#00B066_#000000">
                <span class="custom-radio" style="background-color: #00C774;"></span>
                <span class="color-label">Verde Neon</span>
            </label>

            <label class="color-option">
                <i class="fas fa-palette"></i>
                <input type="radio" name="cor" value="#FF8C42_#E67834_#000000">
                <span class="custom-radio" style="background-color: #FF8C42;"></span>
                <span class="color-label">Laranja</span>
            </label>

            <label class="color-option">
                <i class="fas fa-palette"></i>
                <input type="radio" name="cor" value="#007C91_#00667A_#FFFFFF">
                <span class="custom-radio" style="background-color: #007C91;"></span>
                <span class="color-label">Azul Petróleo</span>
            </label>

            <label class="color-option">
                <i class="fas fa-palette"></i>
                <input type="radio" name="cor" value="#FF2DC6_#E025B1_#FFFFFF">
                <span class="custom-radio" style="background-color: #FF2DC6;"></span>
                <span class="color-label">Pink Fluor</span>
            </label>

            <label class="color-option">
                <i class="fas fa-palette"></i>
                <input type="radio" name="cor" value="#FFD700_#E6C200_#000000">
                <span class="custom-radio" style="background-color: #FFD700;"></span>
                <span class="color-label">Amarelo Neon</span>
            </label>

            <input type="submit" id="subCores" class="submit-button espacobutton" value="Atualizar">
        </form>
    </div>
</div>

<div id="modalRedes" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2>Redes Sociais</h2>
        <div id="alerta-redes"></div>
        <form id="formredes" action="php/redes.php">
              <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_redes'] ?? '' ?>">
            
            <div class="form-row">
                <div class="input-icon">
                    <i class="fab fa-instagram"></i>
                    <input type="text" name="instagram" placeholder="Link do Instagram" value="<?= $Instagram ?>">
                </div>
            </div>

            <div class="form-row">
                <div class="input-icon">
                    <i class="fab fa-telegram-plane"></i>
                    <input type="text" name="telegram" placeholder="Link do Telegram" value="<?= $Telegram ?>">
                </div>
            </div>

            <input type="submit" id="subRedes" class="submit-button espacobutton" value="Atualizar">
        </form>
    </div>
</div>

<div id="modalBonusCadastro" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2>Valor do Bônus Cadastro</h2>
        <div id="alerta-bonuscadastro"></div>
        <form id="formbonuscadastro" action="php/bonuscadastro.php">
              <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_bonuscadastro'] ?? '' ?>">
                
                <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-wallet"></i>
                    <input type="text" id='bonuscadastro' name="valorbonus" placeholder="Valor de bônus">
                </div>
                </div>

                <div class="info-modal">
                    <p>Valor atual de Bônus R$ <strong><?= number_format($ValorBonusCadastro, 2, ',', '.') ?></strong> reais.</p>
                </div>

              <input type="submit" id="subBonusCadastro" class="submit-button espacobutton" value="Atualizar">
        </form>
    </div>
</div>

<div id="modalBonusUsa" class="modal">
  <div class="modal-content">
    <span class="close-modal"><i class="fas fa-times"></i></span>
    <h2>Bônus USA</h2>

    <div id="alerta-bonususa"></div>

    <form id="formbonususa" action="php/bonususa.php" method="post">
      <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token_bonususa'] ?? '' ?>">

      <div class="form-row">
        <div class="input-icon">
          <i class="fas fa-dollar-sign"></i>
          <input
            type="number"
            step="0.01"
            min="0"
            name="bonus_usa_valor"
            placeholder="Valor do bônus (ex: 750)"
            value="<?= htmlspecialchars(number_format($BonusUsaValor, 2, '.', ''), ENT_QUOTES, 'UTF-8') ?>"
          >
        </div>
      </div>

      <div class="form-row">
        <div class="input-icon">
          <i class="fas fa-exchange-alt"></i>
          <input
            type="number"
            step="0.01"
            min="0"
            name="bonus_usa_cotacao"
            placeholder="Cotação USD→BRL (ex: 5.00)"
            value="<?= htmlspecialchars(number_format($BonusUsaCotacao, 2, '.', ''), ENT_QUOTES, 'UTF-8') ?>"
          >
        </div>
      </div>

      <div class="form-row">
        <div class="input-icon">
          <i class="fas fa-font"></i>
          <input
            type="text"
            name="bonus_usa_frase"
            placeholder="Frase (use {valor})"
            value="<?= htmlspecialchars($BonusUsaFrase, ENT_QUOTES, 'UTF-8') ?>"
          >
        </div>
      </div>

      <input type="submit" id="subBonusUsa" class="submit-button espacobutton" value="Atualizar">
    </form>

    <div class="info-modal">
      <p>Exemplo: <strong>Claim your {valor} bonus now</strong> → vira "Claim your $750 bonus now".</p>
      <p>Exemplo: <strong>COTAÇÃO DOLAR ATUAL </strong> 5,26$ DOLAR hoje".</p>
    </div>
  </div>
</div>

<!-- =========================
     MODAL: SPORTSBOOK COMPLETO
========================= -->
<div id="modalSportsbook" class="modal modal-large">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2><i class="fas fa-futbol" style="color:#3b82f6;margin-right:10px;"></i>Gerenciar Sportsbook</h2>

        <!-- Tabs -->
        <div class="modal-tabs">
            <button class="modal-tab active" onclick="switchTab('partidas')">
                <i class="fas fa-table"></i> Partidas
            </button>
            <button class="modal-tab" onclick="switchTab('apostas')">
                <i class="fas fa-receipt"></i> Apostas
                <?php if ($total_apostas_pendentes > 0): ?>
                <span class="badge"><?= $total_apostas_pendentes ?></span>
                <?php endif; ?>
            </button>
            <button class="modal-tab" onclick="switchTab('nova-partida')">
                <i class="fas fa-plus"></i> Nova Partida
            </button>
        </div>

        <!-- TAB: PARTIDAS -->
        <div id="tab-partidas" class="tab-content active">
            <div class="table-responsive">
                <table class="table-admin">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Liga</th>
                            <th>Partida</th>
                            <th>Placar</th>
                            <th>Tempo</th>
                            <th>Status</th>
                            <th>Odds</th>
                            <th>Ativo</th>
                            <th>Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($ticker_partidas)): ?>
                        <tr>
                            <td colspan="9" class="empty-state">
                                <i class="fas fa-futbol"></i>
                                <p>Nenhuma partida cadastrada</p>
                            </td>
                        </tr>
                        <?php else: ?>
                        <?php foreach ($ticker_partidas as $partida): ?>
                        <tr>
                            <td>#<?= $partida['id'] ?></td>
                            <td><?= htmlspecialchars($partida['flag'] . ' ' . $partida['liga']) ?></td>
                            <td><?= htmlspecialchars($partida['time_casa'] . ' x ' . $partida['time_fora']) ?></td>
                            <td><strong><?= $partida['placar_casa'] ?> - <?= $partida['placar_fora'] ?></strong></td>
                            <td><?= htmlspecialchars($partida['tempo']) ?></td>
                            <td><span class="status-badge <?= $partida['status'] ?>"><?= strtoupper($partida['status']) ?></span></td>
                            <td>
                                <?= htmlspecialchars($partida['odd_label_1']) ?>: <strong><?= number_format($partida['odd_valor_1'], 2) ?></strong><br>
                                <?= htmlspecialchars($partida['odd_label_2']) ?>: <strong><?= number_format($partida['odd_valor_2'], 2) ?></strong>
                            </td>
                            <td>
                                <span class="status-badge <?= $partida['ativo'] ? 'ativo' : 'inativo' ?>">
                                    <?= $partida['ativo'] ? 'SIM' : 'NÃO' ?>
                                </span>
                            </td>
                            <td>
                                <button class="btn-action edit" onclick="editarPartida(<?= $partida['id'] ?>)" title="Editar">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="btn-action delete" onclick="deletarPartida(<?= $partida['id'] ?>)" title="Excluir">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- TAB: APOSTAS -->
        <div id="tab-apostas" class="tab-content">
            <!-- Stats -->
            <div class="stats-row">
                <div class="stat-card yellow">
                    <div class="stat-number"><?= $total_apostas_pendentes ?></div>
                    <div class="stat-label">Pendentes</div>
                </div>
                <div class="stat-card green">
                    <div class="stat-number"><?= $total_apostas_ganhas ?></div>
                    <div class="stat-label">Ganhas</div>
                </div>
                <div class="stat-card red">
                    <div class="stat-number"><?= $total_apostas_perdidas ?></div>
                    <div class="stat-label">Perdidas</div>
                </div>
            </div>

            <div class="table-responsive">
                <table class="table-admin">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Usuário</th>
                            <th>Partida</th>
                            <th>Aposta</th>
                            <th>Odd</th>
                            <th>Valor</th>
                            <th>Retorno</th>
                            <th>Status</th>
                            <th>Data</th>
                            <th>Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($apostas_pendentes)): ?>
                        <tr>
                            <td colspan="10" class="empty-state">
                                <i class="fas fa-receipt"></i>
                                <p>Nenhuma aposta realizada</p>
                            </td>
                        </tr>
                        <?php else: ?>
                        <?php foreach ($apostas_pendentes as $aposta): ?>
                        <tr>
                            <td>#<?= $aposta['id'] ?></td>
                            <td>
                                <strong><?= htmlspecialchars($aposta['bet_nome'] ?? 'N/A') ?></strong><br>
                                <small style="color:#6b7280;"><?= htmlspecialchars($aposta['bet_email'] ?? '') ?></small>
                            </td>
                            <td><?= htmlspecialchars($aposta['descricao_partida'] ?? $aposta['time_casa'] . ' x ' . $aposta['time_fora']) ?></td>
                            <td><?= htmlspecialchars($aposta['descricao_aposta'] ?? $aposta['tipo_aposta']) ?></td>
                            <td><strong><?= number_format($aposta['odd_selecionada'], 2) ?></strong></td>
                            <td>R$ <?= number_format($aposta['valor_apostado'], 2, ',', '.') ?></td>
                            <td style="color:#10b981;font-weight:600;">R$ <?= number_format($aposta['retorno_potencial'], 2, ',', '.') ?></td>
                            <td><span class="status-badge <?= $aposta['status'] ?>"><?= strtoupper($aposta['status']) ?></span></td>
                            <td><?= date('d/m/Y H:i', strtotime($aposta['created_at'])) ?></td>
                            <td>
                                <?php if ($aposta['status'] === 'pendente'): ?>
                                <button class="btn-action success" onclick="liquidarAposta(<?= $aposta['id'] ?>, 'ganhou')" title="Marcar como GANHOU">
                                    <i class="fas fa-check"></i>
                                </button>
                                <button class="btn-action danger" onclick="liquidarAposta(<?= $aposta['id'] ?>, 'perdeu')" title="Marcar como PERDEU">
                                    <i class="fas fa-times"></i>
                                </button>
                                <?php else: ?>
                                <span style="color:#6b7280;font-size:11px;">Liquidada</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- TAB: NOVA PARTIDA -->
        <div id="tab-nova-partida" class="tab-content">
            <div id="alerta-nova-partida"></div>
            
            <form id="formNovaPartida">
                <div class="form-grid">
                    <div class="form-row">
                        <div class="input-icon">
                            <i class="fas fa-flag"></i>
                            <input type="text" name="flag" placeholder="Emoji bandeira (ex: 🇧🇷)" maxlength="10">
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="input-icon">
                            <i class="fas fa-trophy"></i>
                            <input type="text" name="liga" placeholder="Liga/Campeonato" required>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="input-icon">
                            <i class="fas fa-home"></i>
                            <input type="text" name="time_casa" placeholder="Time da Casa" required>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="input-icon">
                            <i class="fas fa-plane"></i>
                            <input type="text" name="time_fora" placeholder="Time Visitante" required>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="input-icon">
                            <i class="fas fa-futbol"></i>
                            <input type="number" name="placar_casa" placeholder="Placar Casa" value="0" min="0">
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="input-icon">
                            <i class="fas fa-futbol"></i>
                            <input type="number" name="placar_fora" placeholder="Placar Visitante" value="0" min="0">
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="input-icon">
                            <i class="fas fa-clock"></i>
                            <input type="text" name="tempo" placeholder="Tempo (ex: 45', 90+3, HT)" value="AO VIVO">
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="input-icon">
                            <i class="fas fa-signal"></i>
                            <select name="status">
                                <option value="live">🔴 Ao Vivo</option>
                                <option value="upcoming">🟡 Em Breve</option>
                                <option value="finished">⚫ Encerrado</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="input-icon">
                            <i class="fas fa-tag"></i>
                            <input type="text" name="odd_label_1" placeholder="Label Odd 1 (ex: Mais de 2.5)" value="Mais de 2.5">
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="input-icon">
                            <i class="fas fa-percentage"></i>
                            <input type="number" step="0.01" name="odd_valor_1" placeholder="Valor Odd 1" value="1.85" min="1">
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="input-icon">
                            <i class="fas fa-tag"></i>
                            <input type="text" name="odd_label_2" placeholder="Label Odd 2 (ex: Menos de 2.5)" value="Menos de 2.5">
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="input-icon">
                            <i class="fas fa-percentage"></i>
                            <input type="number" step="0.01" name="odd_valor_2" placeholder="Valor Odd 2" value="1.95" min="1">
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="input-icon">
                            <i class="fas fa-sort-numeric-up"></i>
                            <input type="number" name="ordem" placeholder="Ordem de exibição" value="0" min="0">
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="input-icon">
                            <i class="fas fa-toggle-on"></i>
                            <select name="ativo">
                                <option value="1">✅ Ativo (visível no site)</option>
                                <option value="0">❌ Inativo (oculto)</option>
                            </select>
                        </div>
                    </div>
                </div>
                
                <input type="submit" id="subNovaPartida" class="submit-button espacobutton" value="Cadastrar Partida">
            </form>
        </div>
    </div>
</div>

<!-- =========================
     MODAL: EDITAR PARTIDA
========================= -->
<div id="modalEditarPartida" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2><i class="fas fa-edit" style="color:#3b82f6;margin-right:10px;"></i>Editar Partida</h2>
        
        <div id="alerta-editar-partida"></div>
        
        <form id="formEditarPartida">
            <input type="hidden" name="id" id="edit_partida_id">
            
            <div class="form-grid">
                <div class="form-row">
                    <div class="input-icon">
                        <i class="fas fa-flag"></i>
                        <input type="text" name="flag" id="edit_flag" placeholder="Emoji bandeira">
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="input-icon">
                        <i class="fas fa-trophy"></i>
                        <input type="text" name="liga" id="edit_liga" placeholder="Liga" required>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="input-icon">
                        <i class="fas fa-home"></i>
                        <input type="text" name="time_casa" id="edit_time_casa" placeholder="Time Casa" required>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="input-icon">
                        <i class="fas fa-plane"></i>
                        <input type="text" name="time_fora" id="edit_time_fora" placeholder="Time Fora" required>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="input-icon">
                        <i class="fas fa-futbol"></i>
                        <input type="number" name="placar_casa" id="edit_placar_casa" placeholder="Placar Casa" min="0">
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="input-icon">
                        <i class="fas fa-futbol"></i>
                        <input type="number" name="placar_fora" id="edit_placar_fora" placeholder="Placar Fora" min="0">
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="input-icon">
                        <i class="fas fa-clock"></i>
                        <input type="text" name="tempo" id="edit_tempo" placeholder="Tempo">
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="input-icon">
                        <i class="fas fa-signal"></i>
                        <select name="status" id="edit_status">
                            <option value="live">🔴 Ao Vivo</option>
                            <option value="upcoming">🟡 Em Breve</option>
                            <option value="finished">⚫ Encerrado</option>
                        </select>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="input-icon">
                        <i class="fas fa-tag"></i>
                        <input type="text" name="odd_label_1" id="edit_odd_label_1" placeholder="Label Odd 1">
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="input-icon">
                        <i class="fas fa-percentage"></i>
                        <input type="number" step="0.01" name="odd_valor_1" id="edit_odd_valor_1" placeholder="Valor Odd 1" min="1">
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="input-icon">
                        <i class="fas fa-tag"></i>
                        <input type="text" name="odd_label_2" id="edit_odd_label_2" placeholder="Label Odd 2">
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="input-icon">
                        <i class="fas fa-percentage"></i>
                        <input type="number" step="0.01" name="odd_valor_2" id="edit_odd_valor_2" placeholder="Valor Odd 2" min="1">
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="input-icon">
                        <i class="fas fa-sort-numeric-up"></i>
                        <input type="number" name="ordem" id="edit_ordem" placeholder="Ordem" min="0">
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="input-icon">
                        <i class="fas fa-toggle-on"></i>
                        <select name="ativo" id="edit_ativo">
                            <option value="1">✅ Ativo</option>
                            <option value="0">❌ Inativo</option>
                        </select>
                    </div>
                </div>
            </div>
            
            <input type="submit" id="subEditarPartida" class="submit-button espacobutton" value="Salvar Alterações">
        </form>
    </div>
</div>

<div id="modalAfiliados" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2>Afiliados Porcentagem</h2>
        <div id="alerta-afiliados"></div>
        <form id="formafiliados" action="php/afiliados.php">
              <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_afiliados'] ?? '' ?>">
                
<div class="form-row"> 
  <div class="input-icon">
    <i class="fas fa-percentage"></i>
    <select name="porcentagem_afiliados" id="select-porcentagem">
      <option value="">Selecione a porcentagem</option>
      <option value="5">5%</option>
      <option value="10">10%</option>
      <option value="15">15%</option>
      <option value="20">20%</option>
      <option value="25">25%</option>
      <option value="30">30%</option>
      <option value="35">35%</option>
      <option value="40">40%</option>
      <option value="45">45%</option>
      <option value="50">50%</option>
      <option value="55">55%</option>
      <option value="60">60%</option>
      <option value="65">65%</option>
      <option value="70">70%</option>
      <option value="75">75%</option>
    </select>
  </div>
</div>
              <input type="submit" id="subAfiliados" class="submit-button espacobutton" value="Atualizar">
        </form>
    </div>
</div>

<script>
// =====================
// MODAIS (ABRIR / FECHAR) ✅ (padronizado)
// =====================
function openModal(id) {
  document.getElementById(id)?.classList.add('show');
  document.getElementById('overlay')?.classList.add('show');
}

function closeAllModals() {
  document.querySelectorAll('.modal').forEach(m => m.classList.remove('show'));
  document.getElementById('overlay')?.classList.remove('show');
}

document.addEventListener('click', function (e) {
  // Abrir modais
  if (e.target.closest('.modalClashPay'))   { e.preventDefault(); openModal('modalClashPay'); return; }
  if (e.target.closest('.modalGeraPix'))    { e.preventDefault(); openModal('modalGeraPix'); return; }
  if (e.target.closest('.modalPlayFiver'))  { e.preventDefault(); openModal('modalPlayFiver'); return; }
  if (e.target.closest('.modalRoyalGames')) { e.preventDefault(); openModal('modalRoyalGames'); return; }
  if (e.target.closest('.modalValores'))    { e.preventDefault(); openModal('modalValores'); return; }
  if (e.target.closest('.modalFacebook'))   { e.preventDefault(); openModal('modalFacebook'); return; }
  if (e.target.closest('.modalEmail'))      { e.preventDefault(); openModal('modalEmail'); return; }
  if (e.target.closest('.modalLogo'))       { e.preventDefault(); openModal('modalLogo'); return; }
  if (e.target.closest('.modalFavicon'))    { e.preventDefault(); openModal('modalFavicon'); return; }
  if (e.target.closest('.modalSlider'))     { e.preventDefault(); openModal('modalSlider'); return; }
  if (e.target.closest('.modalNomeUrl'))    { e.preventDefault(); openModal('modalNomeUrl'); return; }
  if (e.target.closest('.modalCores'))      { e.preventDefault(); openModal('modalCores'); return; }
  if (e.target.closest('.modalRedes'))      { e.preventDefault(); openModal('modalRedes'); return; }
  if (e.target.closest('.modalBonusCadastro')) { e.preventDefault(); openModal('modalBonusCadastro'); return; }
  if (e.target.closest('.modalBonusUsa'))   { e.preventDefault(); openModal('modalBonusUsa'); return; }
  if (e.target.closest('.modalSportsbook')) { e.preventDefault(); openModal('modalSportsbook'); return; }
  if (e.target.closest('.modalAfiliados'))  { e.preventDefault(); openModal('modalAfiliados'); return; }
  if (e.target.closest('.modalPush'))       { e.preventDefault(); openModal('modalPush'); return; }

  // Fechar no overlay
  if (e.target.id === 'overlay') { closeAllModals(); return; }

  // Fechar no X
  if (e.target.closest('.close-modal')) { closeAllModals(); return; }
});


</script>