<?php
session_start();
$usuario_logado = isset($_SESSION['usuario_id']);
$confirmou18 = isset($_COOKIE['age_ok']) && $_COOKIE['age_ok'] === '1';
$mostrar_modal_18 = (!$usuario_logado && !$confirmou18);

function gerar_token_csrf($form) {
    $token = bin2hex(random_bytes(32));
    $_SESSION["csrf_token_$form"] = $token;
    return $token;
}

if ($_SERVER["REQUEST_METHOD"] == "GET") {
    $token_contato = gerar_token_csrf('contato');
    $token_login = gerar_token_csrf('login');
    $token_cadastro = gerar_token_csrf('cadastro');
    $token_recuperar_senha = gerar_token_csrf('recuperar_senha');
    $token_retirada = gerar_token_csrf('retirada');
}

define('IN_INDEX', true);
require_once 'includes/db.php';
require_once 'includes/config.php';

if (isset($_SESSION['usuario_id'])) {
    header("Location: /dashboard/");
    exit;
}

if (isset($_COOKIE['auth_token'])) {
    $token = $_COOKIE['auth_token'];
    $stmt = $pdo->prepare("SELECT id, bet_status FROM bet_usuarios WHERE bet_token = ?");
    $stmt->execute([$token]);
    $usuario = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($usuario && $usuario['bet_status'] == 1) {
        $_SESSION['usuario_id'] = $usuario['id'];
        header("Location: /dashboard/");
        exit;
    } else {
        setcookie("auth_token", "", time() - 3600, "/");
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="format-detection" content="telephone=no">
    <title><?= $NomeSite ?> Cassino e Apostas Online com Bônus Exclusivos</title>
    <link rel="icon" type="image/png" href="imagens/<?= $Favicon ?>">
    <meta name="description" content="Jogue na <?= $NomeSite ?> e descubra o melhor cassino online ao vivo!">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="css/estilos.php">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>

    <style>
/* ===== USANDO A ESTRUTURA ORIGINAL QUE FUNCIONA ===== */

.overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.72);
    z-index: 9998;
    backdrop-filter: blur(2px);
    display: none;
}

.overlay.show {
    display: block;
}

/* Modal - Estrutura Original */
.modal {
    z-index: 9999;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
}

.modal.show {
    display: block;
}

/* Modal Content */
.modal-content {
    background: linear-gradient(180deg, #1a1c22 0%, #111218 100%);
    margin: 5% auto;
    padding: 20px;
    border: 1px solid rgba(255, 255, 255, 0.08);
    border-radius: 18px;
    width: 90%;
    max-width: 500px;
    box-shadow: 0 20px 80px rgba(0, 0, 0, 0.65);
    position: relative;
    animation: modalFadeIn 0.3s ease;
}

@keyframes modalFadeIn {
    from {
        opacity: 0;
        transform: scale(0.95);
    }
    to {
        opacity: 1;
        transform: scale(1);
    }
}

.close-modal {
    position: absolute;
    top: 16px;
    right: 16px;
    width: 42px;
    height: 42px;
    border-radius: 12px;
    border: 1px solid rgba(255, 255, 255, 0.12);
    background: rgba(0, 0, 0, 0.35);
    color: #fff;
    cursor: pointer;
    font-size: 18px;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
}

.close-modal:hover {
    background: rgba(255, 255, 255, 0.1);
    transform: rotate(90deg);
}

.modal-content h2 {
    text-align: center;
    color: #f5a200;
    margin: 10px 0 20px;
    font-size: 22px;
}

.form-row {
    margin-bottom: 15px;
}

.input-icon {
    display: flex;
    align-items: center;
    gap: 10px;
    background: rgba(0, 0, 0, 0.25);
    border: 1px solid rgba(255, 255, 255, 0.10);
    border-radius: 14px;
    padding: 14px;
    transition: border-color 0.3s ease;
}

.input-icon:focus-within {
    border-color: rgba(245, 162, 0, 0.5);
}

.input-icon i {
    width: 28px;
    display: flex;
    justify-content: center;
    opacity: 0.9;
    font-size: 18px;
    color: rgba(255, 255, 255, 0.7);
}

.input-icon input,
.input-icon textarea {
    flex: 1;
    background: transparent;
    border: none;
    outline: none;
    color: #fff;
    font-size: 16px;
}

.input-icon input::placeholder,
.input-icon textarea::placeholder {
    color: rgba(255, 255, 255, 0.35);
}

.auth-eye {
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.65);
    cursor: pointer;
    font-size: 16px;
    transition: color 0.3s ease;
    padding: 0;
}

.auth-eye:hover {
    color: #f5a200;
}

.recover-password {
    margin: 10px 0;
    text-align: left;
}

.recover-password a,
.create-account a,
.log-in a {
    color: #f5a200;
    cursor: pointer;
    text-decoration: none;
    transition: opacity 0.3s ease;
    font-size: 14px;
}

.recover-password a:hover,
.create-account a:hover,
.log-in a:hover {
    opacity: 0.8;
    text-decoration: underline;
}

.submit-button {
    width: 100%;
    margin-top: 15px;
    border: none;
    border-radius: 12px;
    padding: 14px;
    cursor: pointer;
    font-size: 18px;
    font-weight: 800;
    color: #111;
    background: linear-gradient(180deg, #ffb300 0%, #f59f00 100%);
    box-shadow: 0 10px 26px rgba(245, 162, 0, 0.35);
    transition: all 0.3s ease;
}

.submit-button:hover {
    transform: translateY(-2px);
    box-shadow: 0 12px 30px rgba(245, 162, 0, 0.45);
}

.submit-button:active {
    transform: translateY(1px);
}

.create-account,
.log-in {
    text-align: center;
    margin-top: 20px;
    color: rgba(255, 255, 255, 0.55);
    font-size: 14px;
}

.create-account a,
.log-in a {
    color: #f5a200;
    font-weight: 700;
    margin-left: 5px;
}

.termos {
    margin-top: 15px;
    font-size: 12px;
    color: rgba(255, 255, 255, 0.55);
    line-height: 1.5;
}

.termos p {
    color: #f5a200;
    font-weight: 700;
    margin-bottom: 5px;
}

.termos a {
    color: #f5a200;
    cursor: pointer;
    transition: opacity 0.3s ease;
}

.termos a:hover {
    opacity: 0.8;
    text-decoration: underline;
}

.bottom-nav{position:fixed;bottom:0;left:0;right:0;background:rgba(20,20,20,0.75);backdrop-filter:blur(10px);-webkit-backdrop-filter:blur(10px);display:flex;justify-content:space-around;align-items:center;padding:8px 0 max(8px,env(safe-area-inset-bottom));box-shadow:0 -2px 20px rgba(0,0,0,0.35);z-index:1000;border-top:1px solid rgba(255,255,255,0.08)}
.bottom-nav-item{display:flex;flex-direction:column;align-items:center;text-decoration:none;color:#888;transition:all 0.3s ease;padding:5px;border-radius:8px;min-width:45px}
.bottom-nav-item:hover{color:#ffd700;transform:translateY(-2px)}
.bottom-nav-item.active{color:#ffd700}
.bottom-nav-item .icon{font-size:20px;margin-bottom:2px}
.bottom-nav-item .label{font-size:10px;font-weight:500;text-transform:uppercase;letter-spacing:0.5px}
.bottom-nav-item.center{color:white;border-radius:50%;width:55px;height:55px;margin-top:-25px}
.bottom-nav-item.center:hover{transform:translateY(-4px) scale(1.05);box-shadow:0 6px 25px rgba(255,107,53,0.6);color:white}
.bottom-nav-item.center .icon{font-size:24px;margin-bottom:0}
.bottom-nav-item.center .label{display:none}
.center-nav-icon{width:37px;height:37px;margin-top:16px}

.mobile-menu{position:fixed;top:0;left:-100%;width:280px;max-width:85vw;height:100vh;background:linear-gradient(135deg,#1a1a1a 0%,#2d2d2d 100%);z-index:2000;transition:left 0.3s ease;padding:20px;color:white;overflow-y:auto;visibility:hidden;opacity:0}
.mobile-menu.show{left:0;visibility:visible;opacity:1}
.mobile-menu-overlay{position:fixed;top:0;left:0;right:0;bottom:0;background:rgba(0,0,0,0.5);z-index:1999;opacity:0;visibility:hidden;transition:all 0.3s ease;pointer-events:none}
.mobile-menu-overlay.show{opacity:1;visibility:visible;pointer-events:auto}
.mobile-menu-header{display:flex;justify-content:space-between;align-items:center;margin-bottom:30px;padding-bottom:20px;border-bottom:1px solid #333}
.mobile-menu-header h3{margin:0;color:#ffd700}
.mobile-menu-close{background:none;border:none;color:white;font-size:24px;cursor:pointer;padding:5px}
.mobile-menu-item{display:flex;align-items:center;padding:15px 0;border-bottom:1px solid #333;color:white;text-decoration:none;transition:color 0.3s ease}
.mobile-menu-item:hover{color:#ffd700}
.mobile-menu-item i{margin-right:15px;width:20px;font-size:18px}

.age-overlay{position:fixed;inset:0;background:rgba(0,0,0,.65);z-index:9998;backdrop-filter:blur(2px)}
.age-modal{position:fixed;inset:0;z-index:9999;display:flex;align-items:center;justify-content:center;padding:18px}
.age-box{width:min(520px,92vw);background:#0f1419;border-radius:18px;padding:22px;border:1px solid rgba(255,255,255,.08);box-shadow:0 18px 60px rgba(0,0,0,.55);text-align:center}
.age-logo img{max-width:220px;height:auto;margin-bottom:10px}
.age-title{color:#fff;font-size:20px;font-weight:700;margin:10px 0 18px}
.age-actions{display:flex;gap:12px;justify-content:center;margin-bottom:16px}
.age-btn{flex:1;max-width:200px;border:none;border-radius:12px;padding:14px 10px;font-weight:800;font-size:15px;cursor:pointer}
.age-btn.yes{background:#22c55e;color:#fff}
.age-btn.no{background:#6b7280;color:#fff}
.age-authorized{background:transparent;border:none;padding:0;margin-top:12px;display:flex;justify-content:center}
.age-authorized-img{width:160px;height:auto}

.button.modalCadastro{background:transparent!important;border:none!important;box-shadow:none!important;padding:0!important}
.button.modalCadastro:hover,.button.modalCadastro:active,.button.modalCadastro:focus{background:transparent!important;box-shadow:none!important;outline:none!important}
.button.modalCadastro .btn-img{display:block;max-width:120px;height:auto;pointer-events:none}
.button.modalLogin{background:transparent!important;border:none!important;box-shadow:none!important;padding:0!important;color:#9e9e9e;font-weight:500;cursor:pointer}
.button.modalLogin:hover{color:#cfcfcf}
.button.modalLogin:active{color:#ffffff}
.button.modalLogin:focus{outline:none!important;box-shadow:none!important}
button{-webkit-tap-highlight-color:transparent}
button:focus,button:active,button:focus-visible{outline:none;box-shadow:none}
.app-banner{position:fixed;top:0;left:0;right:0;height:48px;background:#f6a300;color:#fff;display:flex;align-items:center;justify-content:center;gap:12px;font-size:14px;z-index:2001}
.app-banner-text{display:flex;align-items:center;gap:6px}
.app-banner-btn{background:#2b2f36;color:#fff;border:none;padding:6px 14px;border-radius:8px;font-size:14px;cursor:pointer}
.app-banner-close{position:absolute;right:12px;font-size:18px;cursor:pointer}
.top-bar{position:fixed;top:48px;left:0;right:0;z-index:2000;margin-top:0!important}
body{padding-top:91px;padding-bottom:70px}
.dots{display:none!important}
.busca-container{margin-top:-34px;padding-top:0}
.ganhos-container{margin-top:6px;padding-top:0}

@media (max-width: 480px) {
    .modal-content {
        margin: 10% auto;
        width: 95%;
        padding: 16px;
    }
    
    .modal-content h2 {
        font-size: 20px;
    }
    
    .input-icon {
        padding: 12px;
    }
    
    .submit-button {
        font-size: 16px;
        padding: 12px;
    }
    
    .bottom-nav-item .label{font-size:9px}
    .bottom-nav-item .icon{font-size:18px}
    .bottom-nav-item.center .icon{font-size:22px}
}

@media (max-width: 380px) {
    .modal-content {
        margin: 8% auto;
        padding: 14px;
    }
    
    .input-icon {
        padding: 10px;
    }
}

@media(min-width:1024px){.bottom-nav{display:none}body{padding-bottom:0}.mobile-menu,.mobile-menu-overlay{display:none!important}}

#alerta-login,
#alerta-cadastro {
    margin-bottom: 15px;
}
    </style>
</head>
<body>

<?php if ($mostrar_modal_18): ?>
<div class="age-overlay" id="ageOverlay"></div>
<div class="age-modal" id="ageModal" role="dialog" aria-modal="true">
  <div class="age-box">
    <div class="age-logo"><img src="imagens/<?= $Logo ?>" alt="Logo"></div>
    <h2 class="age-title">Você é maior de 18 anos?</h2>
    <div class="age-actions">
      <button class="age-btn yes" id="ageYes">SIM</button>
      <button class="age-btn no" id="ageNo">NÃO</button>
    </div>
    <div class="age-authorized">
      <img src="https://i.postimg.cc/c1DMNtpr/1620-autorizado-17359161041535.webp" alt="Autorizado" class="age-authorized-img">
    </div>
  </div>
</div>
<?php endif; ?>

<div id="sidebar" class="sidebar">
    <span class="close-sidebar"><i class="fas fa-times"></i></span> 
    <div class="sidebar-content" id="sidebarContent"></div>
</div>

<div class="overlay" id="overlay"></div>

<div id="modalLogin" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2>Login</h2>
        
        <div id="alerta-login"></div>
        
        <form id="formlogin" action="php/login.php">
            <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_login'] ?? '' ?>">
            
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-user"></i>
                    <input type="text" id="loginInput" name="login" placeholder="CPF ou Email">
                </div>
            </div>

            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-lock"></i>
                    <input type="password" id="senhaLogin" name="senha" placeholder="Senha">
                    <button class="auth-eye" type="button" data-toggle="#senhaLogin" aria-label="Mostrar senha">👁️</button>
                </div>
            </div>

            <div class="recover-password">
                <a class="modalRecuperarSenha">Recuperar Senha</a>
            </div>
            
            <input type="submit" id="subLogin" class="submit-button" value="Entrar">
        </form>
                <div class="create-account modalCadastro">
            <a>Criar Conta</a>
        </div>
    </div>
</div>

<div id="modalCadastro" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2>Criar conta</h2>
        
        <div id="alerta-cadastro"></div>
        
        <form id="formcadastro" action="php/cadastro.php">
            <?php
                $ref = (isset($_GET['ref']) && is_numeric($_GET['ref'])) ? $_GET['ref'] : '';
                $utm = (isset($_GET['utm']) && !empty($_GET['utm'])) ? $_GET['utm'] : '';
            ?>
            <input type="hidden" name="ref" value="<?php echo htmlspecialchars($ref); ?>">
            <input type="hidden" name="utm" value="<?php echo htmlspecialchars($utm, ENT_QUOTES, 'UTF-8'); ?>">
            <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_cadastro'] ?? '' ?>">

            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-user"></i>
                    <input type="text" id="nome" name="nome" placeholder="Nome completo">
                </div>
            </div>

            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-envelope"></i>
                    <input type="text" id="email" name="email" placeholder="Email">
                </div>
            </div>

            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-id-card"></i>
                    <input type="text" id="cpf" name="cpf" placeholder="CPF">
                </div>
            </div>


            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-lock"></i>
                    <input type="password" id="senha" name="senha" placeholder="Senha com no mínimo 8 caracteres">
                    <button class="auth-eye" type="button" data-toggle="#senha" aria-label="Mostrar senha">👁️</button>
                </div>
            </div>

            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-lock"></i>
                    <input type="password" id="confirmasenha" name="confirmasenha" placeholder="Confirme a senha">
                    <button class="auth-eye" type="button" data-toggle="#confirmasenha" aria-label="Mostrar senha">👁️</button>
                </div>
            </div>

            <input type="submit" id="subCadastro" class="submit-button abrir-conta" value="Abrir Conta">


        </form>
        
        <div class="create-account modalLogin">
            <a>Já tem uma conta? Fazer Login</a>
        </div>
    </div>
</div>

<div class="mobile-menu-overlay" id="mobileMenuOverlay"></div>
<div class="mobile-menu" id="mobileMenu">
    <div class="mobile-menu-header">
        <h3><i class="fas fa-bars"></i> Menu</h3>
        <button class="mobile-menu-close" id="mobileMenuClose"><i class="fas fa-times"></i></button>
    </div>
    <a href="#" class="mobile-menu-item"><i class="fas fa-home"></i><span>Início</span></a>
    <a href="#" class="mobile-menu-item"><i class="fas fa-futbol"></i><span>BINGO</span></a>
    <a href="#" class="mobile-menu-item"><i class="fas fa-dice"></i><span>CASSINO</span></a>
    <a href="#" class="mobile-menu-item"><i class="fas fa-broadcast-tower"></i><span>JOGO DO BICHO</span></a>
    <a href="#" class="mobile-menu-item modalContato"><i class="fas fa-headset"></i><span>Suporte</span></a>
</div>

<div class="app-banner">
    <span class="app-banner-text">📱 Baixe o aplicativo e ganhe pontos</span>
    <button class="app-banner-btn">Download</button>
    <span class="app-banner-close" onclick="this.parentElement.style.display='none'">✕</span>
</div>

<div class="top-bar">
    <div class="container">
        <div class="logo"><img src="imagens/<?= $Logo ?>"></div>
        <div class="buttons">
            <button class="button modalLogin">Entrar</button>
            <button class="button modalCadastro">
                <img src="https://i.postimg.cc/ncV6jRvr/befunky-2026-0-5-23-30-19.png" alt="Criar Conta" class="btn-img">
            </button>
        </div>
    </div>
</div>

<div class="slider-wrapper">
  <div class="slider-container">
    <div class="slides" id="slides">
      <div class="slide"><img src="imagens/<?= $slider1 ?>"></div>
      <div class="slide"><img src="imagens/<?= $slider2 ?>"></div>
      <div class="slide"><img src="imagens/<?= $slider3 ?>"></div>
    </div>
  </div>
  <div class="dots" id="dots">
    <span class="dot active" data-index="0"></span>
    <span class="dot" data-index="1"></span>
    <span class="dot" data-index="2"></span>
  </div>
</div>

<!-- ============================================================
     BUSCA / SEARCH
     ============================================================ -->
<div class="busca-container">
    <form id="form-busca" onsubmit="return false;">
        <div class="busca-input-icon">
            <i class="fas fa-search"></i>
<input type="text" id="input-busca" name="busca"
       placeholder="Pesquisar um jogo de cassino..."
       class="busca-input" autocomplete="off">

        </div>
    </form>
    <div id="resultado-busca" class="busca-resultado"></div>
</div>

<div class="ganhos-container">
  <div class="ganhos-fixo">
    <i class="fas fa-trophy"></i>
    <span>MAIORES<br>GANHOS<br>DE HOJE</span>
  </div>
  <div class="ganhos-rolando">
    <div class="ganhos-slider" id="ganhos-slider">
      <?php include 'funcoes/carrossel-ganhadores.php'; ?>
    </div>
  </div>
</div>

<div class="lista-jogos">
    <span class="titulo-lista-jogos">🔥 Jogados Da Semana</span>
    <div class="jogos-container">
        <?php include 'funcoes/jogo-semana.php'; ?>
    </div>
</div>

<div class="lista-jogos">
   <span class="titulo-lista-jogos">PRAGMATIC</span> 
   <div class="jogos-container">
        <?php include 'funcoes/jogo-pragmatic.php'; ?>
    </div>
</div>

<div class="lista-jogos">
   <span class="titulo-lista-jogos">PGSOFT</span> 
   <div class="jogos-container">
        <?php include 'funcoes/jogo-pgsoft.php'; ?>
    </div>
</div>

<div class="lista-jogos">
   <span class="titulo-lista-jogos">SPRIBE</span> 
   <div class="jogos-container">
        <?php include 'funcoes/jogo-spribe.php'; ?>
    </div>
</div>

<div class="lista-jogos">
    <span class="titulo-lista-jogos">Todos os jogos</span> 
  <div id="jogosCarregaveis" class="jogos-container"></div>
  <button id="verMaisBtn" class="btn-ver-mais">Ver mais</button>
</div>

<div class="footer-line"></div>

<div class="aovivo-resultados">
  <span class="aovivo-titulo">
  <span class="online-dot-red"></span> Resultados ao Vivo
</span>
  <div class="aovivo-resultado-container" id="aovivo-container"></div>
  <?php include 'funcoes/aovivo.php'; ?>
</div>

<div class="footer">
    <div class="container-footer">
        <div class="footer-column"><img src="imagens/<?= $Logo ?>"></div>
        <div class="footer-column">
            <h4>Sobre Nós</h4>
            <ul>
                <li><a id="termo-condicao">Termos e condições</a></li>
                <li><a id="termo-privacidade">Privacidade</a></li>
                <li><a id="termo-cookies">Política de cookies</a></li>
                <li><a id="termo-18anos">18 anos ou mais</a></li>
                <li><a id="termo-jogo-responsavel">Jogo Responsável</a></li>
            </ul>
        </div>
        <div class="footer-column">
            <h4>Contato</h4>
            <ul><li><a class="modalContato">Fale Conosco</a></li></ul>
        </div>
        <div class="footer-column">
            <h4>Pagamento</h4>
            <img class="pix-logo" src="imagens/logopix.png">
        </div>
        <div class="footer-column">
            <h4>Siga-nos</h4>
            <div class="social-icons">
                <a href="<?= $Instagram ?>" target="_blank"><i class="fab fa-instagram"></i></a>
                <a href="<?= $Telegram ?>" target="_blank"><i class="fab fa-telegram-plane"></i></a>
            </div>
        </div>
    </div>

    <div class="footer-line"></div>

    <div class="footer-text" id="footerText">
        Jogue com responsabilidade!<br><br>
        <div id="extraContent" style="display:none;">
        Nossa Plataforma não promove suas atividades para menores de 18 anos.
        </div>
        <button id="toggleButton" class="ver-mais-btn">Ver mais</button>
    </div>

    <div class="footer-line"></div>
    <div class="footer-centered-img"><img class="selo-img" src="imagens/logosigap.png"></div>
    <div class="footer-line"></div>

    <div class="footer-bottom">
        <p><strong>Suporte</strong> suporte@<?= $Site ?> | <strong>Jurídico</strong> juridico@<?= $Site ?></p>
        <p>© 2025 <?= $NomeSite ?>. Todos os direitos reservados.</p>
    </div>
</div>

<nav class="bottom-nav">
    <a href="#" class="bottom-nav-item" id="bottomMenuBtn">
        <i class="fas fa-bars icon"></i>
        <span class="label">Menu</span>
    </a>
    <a href="#" class="bottom-nav-item active">
        <i class="fas fa-home icon"></i>
        <span class="label">Home</span>
    </a>
    <a href="#" class="bottom-nav-item">
        <i class="fas fa-futbol icon"></i>
        <span class="label">BINGO</span>
    </a>
    <a href="#" class="bottom-nav-item center modalCadastro">
        <img src="https://i.postimg.cc/sxmqH7Cw/befunky-2026-0-5-23-30-40.png" alt="" class="center-nav-icon">
    </a>
    <a href="#" class="bottom-nav-item">
        <i class="fas fa-broadcast-tower icon"></i>
        <span class="label">JBICHO</span>
    </a>
    <a href="#" class="bottom-nav-item">
        <i class="fas fa-dice icon"></i>
        <span class="label">Slots</span>
    </a>
    <a href="#" class="bottom-nav-item modalLogin">
        <i class="fas fa-user icon"></i>
        <span class="label">Perfil</span>
    </a>
</nav>

<script src="js/scripts.js"></script>

<script>
// Função mostrar/ocultar senha
document.querySelectorAll('.auth-eye[data-toggle]').forEach(btn => {
    btn.addEventListener('click', () => {
        const selector = btn.getAttribute('data-toggle');
        const input = document.querySelector(selector);
        if (input) {
            if (input.type === 'password') {
                input.type = 'text';
                btn.textContent = '🙈';
            } else {
                input.type = 'password';
                btn.textContent = '👁️';
            }
        }
    });
});
</script>
</script>
<?php if ($mostrar_modal_18): ?>
<script>
(function(){
  const yes = document.getElementById('ageYes');
  const no  = document.getElementById('ageNo');
  const modal = document.getElementById('ageModal');
  const overlay = document.getElementById('ageOverlay');

  function setCookie(name, value, days){
    const d = new Date();
    d.setTime(d.getTime() + (days*24*60*60*1000));
    document.cookie = `${name}=${value}; expires=${d.toUTCString()}; path=/; SameSite=Lax`;
  }

  function closeGate(){
    modal?.remove();
    overlay?.remove();
    document.body.style.overflow = '';
  }

  // se já confirmou antes (localStorage), fecha sem dar erro
  if (localStorage.getItem('age_ok') === '1') {
    document.cookie = `age_ok=1; path=/; SameSite=Lax`;
    closeGate();
    return;
  }

  // bloqueia scroll enquanto modal aberto
  document.body.style.overflow = 'hidden';

  yes?.addEventListener('click', function () {
    setCookie('age_ok', '1', 30);
    localStorage.setItem('age_ok', '1');
    closeGate();

    if ('Notification' in window && Notification.permission === 'default') {
      Notification.requestPermission().then(p => console.log('Permissão de notificação:', p));
    }
  });

  no?.addEventListener('click', function(){
    window.location.href = 'https://google.com';
  });
})();
</script>
<?php endif; ?>
<script>
document.addEventListener('DOMContentLoaded', () => {
    const input = document.getElementById('input-busca');
    if (!input) return;

    const textos = [
        'Sweet Bonanza',
        'Fortune Tiger',
        'Fortune Ox',
        'Aviator',
        'Gates of Olympus',
        'Big Bass Bonanza'
    ];

    let textoIndex = 0;
    let charIndex = 0;
    let apagando = false;
    let ativo = true;

    const velocidadeDigitar = 120;
    const velocidadeApagar  = 80;
    const pausaAposDigitar  = 1200;
    const pausaAposApagar   = 400;

    function animarPlaceholder() {
        if (!ativo) return;

        const textoAtual = textos[textoIndex];

        if (!apagando) {
            // Digitando
            input.setAttribute(
                'placeholder',
                textoAtual.substring(0, charIndex + 1)
            );
            charIndex++;

            if (charIndex === textoAtual.length) {
                setTimeout(() => apagando = true, pausaAposDigitar);
            }
        } else {
            // Apagando
            input.setAttribute(
                'placeholder',
                textoAtual.substring(0, charIndex - 1)
            );
            charIndex--;

            if (charIndex === 0) {
                apagando = false;
                textoIndex = (textoIndex + 1) % textos.length;
                setTimeout(() => {}, pausaAposApagar);
            }
        }

        setTimeout(
            animarPlaceholder,
            apagando ? velocidadeApagar : velocidadeDigitar
        );
    }

    // Para animação quando usuário interagir
    input.addEventListener('focus', () => {
        ativo = false;
        input.setAttribute('placeholder', 'Pesquisar um jogo de cassino...');
    });

    input.addEventListener('blur', () => {
        if (input.value === '') {
            ativo = true;
            textoIndex = 0;
            charIndex = 0;
            apagando = false;
            animarPlaceholder();
        }
    });

    animarPlaceholder();
});

</script>
</body>
</html>