<?php
/**
 * minhas_apostas.php
 * Lista as apostas do usuário
 * Caminho: /dashboard/php/minhas_apostas.php
 */

session_start();
header('Content-Type: application/json');

// Verifica se está logado
if (!isset($_SESSION['usuario_id'])) {
    echo json_encode(['success' => false, 'message' => 'Usuário não autenticado.', 'apostas' => []]);
    exit;
}

require_once '../../includes/db.php';

$usuario_id = $_SESSION['usuario_id'];

try {
    // Busca apostas do usuário ordenadas por data (mais recente primeiro)
    $stmt = $pdo->prepare("
        SELECT 
            a.id,
            a.tipo_aposta,
            a.odd_selecionada,
            a.valor_apostado,
            a.retorno_potencial,
            a.status,
            a.descricao_partida,
            a.descricao_aposta,
            a.created_at,
            p.flag,
            p.liga,
            p.time_casa,
            p.time_fora,
            p.placar_casa,
            p.placar_fora,
            p.status as partida_status
        FROM apostas_esportivas a
        LEFT JOIN ticker_partidas p ON a.partida_id = p.id
        WHERE a.usuario_id = ?
        ORDER BY a.created_at DESC
        LIMIT 50
    ");
    $stmt->execute([$usuario_id]);
    $apostas = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Conta por status
    $stmt = $pdo->prepare("
        SELECT 
            status,
            COUNT(*) as total,
            SUM(valor_apostado) as valor_total,
            SUM(CASE WHEN status = 'ganhou' THEN retorno_potencial ELSE 0 END) as ganhos_total
        FROM apostas_esportivas 
        WHERE usuario_id = ?
        GROUP BY status
    ");
    $stmt->execute([$usuario_id]);
    $resumo = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Formata resumo
    $resumo_formatado = [
        'pendente' => 0,
        'ganhou' => 0,
        'perdeu' => 0,
        'total_apostado' => 0,
        'total_ganho' => 0
    ];
    
    foreach ($resumo as $r) {
        $resumo_formatado[$r['status']] = (int)$r['total'];
        $resumo_formatado['total_apostado'] += (float)$r['valor_total'];
        if ($r['status'] === 'ganhou') {
            $resumo_formatado['total_ganho'] = (float)$r['ganhos_total'];
        }
    }
    
    echo json_encode([
        'success' => true,
        'apostas' => $apostas,
        'resumo' => $resumo_formatado
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao carregar apostas.',
        'apostas' => []
    ]);
}
