<?php
session_start();

require_once '../../includes/db.php';
require_once '../../includes/config.php';
require_once 'auth.php';

$usuario_id = $_SESSION['usuario_id'] ?? null;
$saldo = $usuario['bet_saldo'] ?? 0;
$game_code = $_POST['game_id'] ?? null;

if (!$game_code) {
    die(json_encode(['status' => 'error', 'msg' => 'Código do jogo não informado']));
}

$sql = "SELECT game_code, game_original FROM bet_jogos WHERE game_code = :game_code LIMIT 1";
$stmt = $pdo->prepare($sql);
$stmt->bindValue(':game_code', $game_code, PDO::PARAM_STR);
$stmt->execute();

$jogo = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$jogo) {
    die(json_encode(['status' => 'error', 'msg' => 'Jogo não encontrado']));
}

$codigo = $jogo['game_code'];


if (empty($AgentTokenRoyal) || empty($AgentSecretRoyal) || empty($AgentCodeRoyal)) {
    die(json_encode(['status' => 'error', 'msg' => 'Credenciais da Royal Games não configuradas']));
}

$credentials = base64_encode($AgentTokenRoyal . ':' . $AgentSecretRoyal);

$authUrl = 'https://painel.royalgamess.com/api/v1/auth/authentication';

$ch = curl_init($authUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . $credentials,
    'Content-Type: application/json'
]);

$authResponse = curl_exec($ch);

if ($authResponse === false) {
    $error_msg = curl_error($ch);
    curl_close($ch);
    die(json_encode(['status' => 'error', 'msg' => 'Erro ao autenticar com a API Royal Games: ' . $error_msg]));
}

curl_close($ch);

$authData = json_decode($authResponse, true);

if (!isset($authData['access_token'])) {
    die(json_encode(['status' => 'error', 'msg' => 'Falha na autenticação: token não recebido']));
}

$accessToken = $authData['access_token'];

$apiUri = 'https://painel.royalgamess.com/api/v1';
$gameUrl = $apiUri . '/games/game_launch';

$gameParams = [
    'agent_code' => $AgentCodeRoyal,
    'agent_token' => $AgentTokenRoyal,
    'game_code' => ''.$codigo,
    'user_balance' => $saldo,
    'currency' => 'BRL',
    'lang' => 'BR',
    'user_code' => $usuario_id
];

$jsonParams = json_encode($gameParams);


$ch = curl_init($gameUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonParams);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . $accessToken,
    'Content-Type: application/json'
]);

$gameResponse = curl_exec($ch);
if ($gameResponse === false) {
    $error_msg = curl_error($ch);
    curl_close($ch);
    die(json_encode(['status' => 'error', 'msg' => 'Erro ao lançar o jogo: ' . $error_msg]));
}

curl_close($ch);

$gameData = json_decode($gameResponse, true);

if (isset($gameData['gameUrl']) && !empty($gameData['gameUrl'])) {
    echo json_encode([
        'status' => 'success',
        'launch_url' => $gameData['gameUrl']
    ]);
} else {
    die(json_encode(['status' => 'error', 'msg' => 'URL do jogo não encontrada na resposta']));
}