<?php
/**
 * dashboard/php/jbicho_loterias.php
 * Retorna loterias ativas e datas de sorteio disponíveis.
 */
session_start();
header('Content-Type: application/json');

// Caminho: este arquivo está em dashboard/php/
// includes/ está uma pasta acima de dashboard/ → ../../includes/
$base = __DIR__ . '/../../includes/';

if (!file_exists($base . 'db.php')) {
    echo json_encode(['success' => false, 'message' => 'Erro: db.php não encontrado em ' . realpath(__DIR__) . '/../../includes/']);
    exit;
}

require_once $base . 'db.php';
require_once $base . 'config.php';

if (!isset($_SESSION['usuario_id'])) {
    echo json_encode(['success' => false, 'message' => 'Não autenticado.']);
    exit;
}

try {
    // Loterias ativas
    $stmt = $pdo->prepare("SELECT id, nome, sigla FROM jbicho_loterias WHERE ativo = 1 ORDER BY nome ASC");
    $stmt->execute();
    $loterias = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Modalidades ativas
    $stmt = $pdo->prepare("SELECT * FROM jbicho_modalidades WHERE ativo = 1 ORDER BY nome ASC");
    $stmt->execute();
    $modalidades = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Datas disponíveis: hoje + próximos 6 dias
    $datas = [];
    for ($i = 0; $i < 7; $i++) {
        $ts = strtotime("+$i days");
        $datas[] = [
            'valor' => date('Y-m-d', $ts),
            'texto' => ($i === 0) ? 'Hoje' : date('d/m (l)', $ts)
        ];
    }

    // Saldo do usuário
    $stmt = $pdo->prepare("SELECT bet_saldo FROM bet_usuarios WHERE id = ?");
    $stmt->execute([$_SESSION['usuario_id']]);
    $usr = $stmt->fetch(PDO::FETCH_ASSOC);

    echo json_encode([
        'success'     => true,
        'loterias'    => $loterias,
        'modalidades' => $modalidades,
        'datas'       => $datas,
        'saldo'       => (float)($usr['bet_saldo'] ?? 0)
    ]);

} catch (Throwable $e) {
    echo json_encode(['success' => false, 'message' => 'Erro: ' . $e->getMessage()]);
}