<?php
require_once '../../includes/db.php';
require_once '../../includes/config.php';
require_once '../../includes/facebook_pixel.php';

// Verificar método POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit;
}

$input = file_get_contents('php://input');
$data = json_decode($input, true);

error_log("Webhook recebido: " . $input);

// Verificar se os dados estão dentro de requestBody
if (isset($data['requestBody']) && is_array($data['requestBody'])) {
    $data = $data['requestBody'];
}

$id_transacao = null;
$external_id = null;
$status = null;
$amount = null;
$transactionType = null;
$paymentType = null;
$dateApproval = null;
$creditParty = null;
$debitParty = null;

// Formato GeraPix
if (isset($data['id_transacao'], $data['status'])) {
    $id_transacao = $data['id_transacao'];
    $status = $data['status'];
    $amount = $data['valor'] ?? null;
}
// Formato Clash API
elseif (isset($data['transactionId'], $data['status'])) {
    $id_transacao = $data['transactionId'];
    $external_id = $data['external_id'] ?? null;
    $status = $data['status'];
    $amount = $data['amount'] ?? null;
    $transactionType = $data['transactionType'] ?? null;
    $paymentType = $data['paymentType'] ?? null;
    $dateApproval = $data['dateApproval'] ?? null;
    $creditParty = $data['creditParty'] ?? null;
    $debitParty = $data['debitParty'] ?? null;
}

if (!$id_transacao || !$status) {
    error_log("Webhook: Parâmetros obrigatórios não encontrados");
    error_log("ID Transação: " . ($id_transacao ?? 'null'));
    error_log("Status: " . ($status ?? 'null'));
    error_log("Dados recebidos: " . json_encode($data));
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Parâmetros obrigatórios não encontrados']);
    exit;
}

if ($status === 'Aprovado' || $status === 'PAID') {

    $query = "SELECT bet_usuario, bet_valor, bet_origem, bet_ip, bet_fbc, bet_fbp FROM bet_transacoes WHERE (bet_id_transacao = :id_transacao";
    $params = [':id_transacao' => $id_transacao];
    
    if ($external_id) {
        $query .= " OR bet_id_transacao = :external_id";
        $params[':external_id'] = $external_id;
    }
    
    $query .= ") AND bet_status != 'Aprovado' LIMIT 1";
    
    $stmt = $pdo->prepare($query);
    $stmt->execute($params);
    $transacao = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($transacao) {
        $usuario_id = $transacao['bet_usuario'];
        $valor = $transacao['bet_valor'];

        if ($amount && $amount != $valor) {
            error_log("Webhook: Valor divergente. Salvo: $valor, Recebido: $amount");
        }

        $stmtSaldo = $pdo->prepare("SELECT bet_saldo, bet_email FROM bet_usuarios WHERE id = :usuario_id LIMIT 1");
        $stmtSaldo->execute([':usuario_id' => $usuario_id]);
        $usuario = $stmtSaldo->fetch(PDO::FETCH_ASSOC);

        if ($usuario) {
            $email = $usuario['bet_email'];
            $saldo_atual = $usuario['bet_saldo'];
            $novo_saldo = $saldo_atual + $valor;

            try {
                $pdo->beginTransaction();

                $updateSaldo = $pdo->prepare("UPDATE bet_usuarios SET bet_saldo = :novo_saldo WHERE id = :usuario_id");
                $updateSaldo->execute([':novo_saldo' => $novo_saldo, ':usuario_id' => $usuario_id]);

                // Query de update simplificada - removendo campos inexistentes
                $updateQuery = "UPDATE bet_transacoes SET bet_status = 'Aprovado' WHERE bet_id_transacao = :id_transacao";
                $updateParams = [':id_transacao' => $id_transacao];
                
                $updateTransacao = $pdo->prepare($updateQuery);
                $updateTransacao->execute($updateParams);


                $pdo->commit();

                error_log("Webhook: Transação $id_transacao aprovada com sucesso. Usuário: $usuario_id, Valor: $valor");

                if (!empty($transacao['bet_origem']) && $transacao['bet_origem'] === 'facebook' && !empty($FacePixel) && !empty($FaceToken)) {
                    $ipUsuario = $transacao['bet_ip'];
                    $fbc = $transacao['bet_fbc'];
                    $fbp = $transacao['bet_fbp'];

                    $resultado_facebook = enviarEventoFacebookPurchase($email, $valor, $FacePixel, $FaceToken, $ipUsuario, $fbc, $fbp);
                    
                    if ($resultado_facebook) {
                        error_log("Webhook: Evento Facebook enviado com sucesso para transação $id_transacao");
                    } else {
                        error_log("Webhook: Falha ao enviar evento Facebook para transação $id_transacao");
                    }
                }

            } catch (Exception $e) {
                $pdo->rollback();
                error_log("Webhook: Erro ao processar transação $id_transacao: " . $e->getMessage());
                http_response_code(500);
                echo json_encode(['status' => 'error', 'message' => 'Erro interno do servidor']);
                exit;
            }
        } else {
            error_log("Webhook: Usuário não encontrado para transação $id_transacao");
            http_response_code(404);
            echo json_encode(['status' => 'error', 'message' => 'Usuário não encontrado']);
            exit;
        }
    } else {
        error_log("Webhook: Transação não encontrada ou já processada: $id_transacao");
        http_response_code(200);
        echo json_encode(['status' => 'success', 'message' => 'Transação já processada ou não encontrada']);
        exit;
    }
} else {
    error_log("Webhook: Status não aprovado: $status para transação $id_transacao");
    http_response_code(200);
    echo json_encode(['status' => 'success', 'message' => 'Status não processável']);
    exit;
}

http_response_code(200);
echo json_encode(['status' => 'success', 'message' => 'Transação processada com sucesso']);
exit;
?>