<?php
/**
 * dashboard/jbicho.php
 * Included from index.php when ?pagina=jbicho
 */

if (!isset($_SESSION['csrf_token_jbicho'])) {
    $_SESSION['csrf_token_jbicho'] = bin2hex(random_bytes(32));
}
$csrf_jbicho = $_SESSION['csrf_token_jbicho'];

$grupos_bicho = [
    ['num'=>'01','nome'=>'Elefante',   'emoji'=>'🐘'],
    ['num'=>'02','nome'=>'Engolidor',  'emoji'=>'🐍'],
    ['num'=>'03','nome'=>'Leão',       'emoji'=>'🦁'],
    ['num'=>'04','nome'=>'Arataca',    'emoji'=>'🐅'],
    ['num'=>'05','nome'=>'Veado',      'emoji'=>'🦌'],
    ['num'=>'06','nome'=>'Camelo',     'emoji'=>'🐫'],
    ['num'=>'07','nome'=>'Jacaré',     'emoji'=>'🐊'],
    ['num'=>'08','nome'=>'Macaco',     'emoji'=>'🐒'],
    ['num'=>'09','nome'=>'Cobra',      'emoji'=>'🐍'],
    ['num'=>'10','nome'=>'Cavalo',     'emoji'=>'🐴'],
    ['num'=>'11','nome'=>'Papagaio',   'emoji'=>'🦜'],
    ['num'=>'12','nome'=>'Cobra',      'emoji'=>'🐍'],
    ['num'=>'13','nome'=>'Gazela',     'emoji'=>'🦌'],
    ['num'=>'14','nome'=>'Urubu',      'emoji'=>'🦅'],
    ['num'=>'15','nome'=>'Galo',       'emoji'=>'🐓'],
    ['num'=>'16','nome'=>'Zebra',      'emoji'=>'🦓'],
    ['num'=>'17','nome'=>'Borboleta',  'emoji'=>'🦋'],
    ['num'=>'18','nome'=>'Burro',      'emoji'=>'🫏'],
    ['num'=>'19','nome'=>'Jabutí',     'emoji'=>'🐢'],
    ['num'=>'20','nome'=>'Gambá',      'emoji'=>'🐾'],
    ['num'=>'21','nome'=>'Leão',       'emoji'=>'🦁'],
    ['num'=>'22','nome'=>'Tigre',      'emoji'=>'🐯'],
    ['num'=>'23','nome'=>'Coelho',     'emoji'=>'🐇'],
    ['num'=>'24','nome'=>'Alce',       'emoji'=>'🦌'],
    ['num'=>'25','nome'=>'Pato',       'emoji'=>'🦆'],
];
?>

<!-- ============================================================
     MODAL SUCESSO
     ============================================================ -->
<div id="modalJbichoSucesso" class="jb-modal-overlay" style="display:none;">
    <div class="jb-modal-sucesso">
        <div class="jb-sucesso-icone">✅</div>
        <h2 class="jb-sucesso-titulo">Aposta Concluída!</h2>
        <p class="jb-sucesso-sub" id="jbSucessoMensagem">Sua aposta foi registrada com sucesso.</p>
        <div class="jb-sucesso-card">
            <div class="jb-sucesso-row"><span class="jb-sucesso-label">Modalidade</span><span class="jb-sucesso-valor" id="jbSucessoModalidade">—</span></div>
            <div class="jb-sucesso-row"><span class="jb-sucesso-label">Loteria</span><span class="jb-sucesso-valor" id="jbSucessoLoteria">—</span></div>
            <div class="jb-sucesso-row"><span class="jb-sucesso-label">Data</span><span class="jb-sucesso-valor" id="jbSucessoData">—</span></div>
            <div class="jb-sucesso-row"><span class="jb-sucesso-label">Palpites</span><span class="jb-sucesso-valor" id="jbSucessoPalpites">—</span></div>
            <div class="jb-sucesso-row"><span class="jb-sucesso-label">Valor</span><span class="jb-sucesso-valor jb-destaque" id="jbSucessoValor">R$ 0,00</span></div>
            <div class="jb-sucesso-row"><span class="jb-sucesso-label">Cotação</span><span class="jb-sucesso-valor" id="jbSucessoCotacao">—</span></div>
            <div class="jb-sucesso-row"><span class="jb-sucesso-label">Novo Saldo</span><span class="jb-sucesso-valor jb-destaque-verde" id="jbSucessoSaldo">R$ 0,00</span></div>
        </div>
        <button class="jb-btn-nova-aposta" onclick="jbReset()">Nova Aposta</button>
        <button class="jb-btn-fechar-sucesso" onclick="jbFecharSucesso()">Fechar</button>
    </div>
</div>

<!-- ============================================================
     MAIN CONTAINER
     ============================================================ -->
<div id="jbContainer" class="jb-container">

    <!-- ── TABS: Apostar | Minhas Apostas ────────────────────── -->
    <div class="jb-tabs">
        <button class="jb-tab active" data-tab="apostar" onclick="jbSwitchTab('apostar')">
            <i class="fas fa-gamepad"></i> Apostar
        </button>
        <button class="jb-tab" data-tab="minhas" onclick="jbSwitchTab('minhas')">
            <i class="fas fa-list-alt"></i> Minhas Apostas
            <span class="jb-tab-badge" id="jbBadgeMinhas" style="display:none;">0</span>
        </button>
    </div>

    <!-- ============================================================
         PAINEL: APOSTAR
         ============================================================ -->
    <div id="jbPainelApostar" class="jb-painel">

        <!-- Progress Bar -->
        <div class="jb-progress-bar">
            <div class="jb-step-indicator active" data-step="1">
                <div class="jb-step-circle"><span>1</span></div>
                <div class="jb-step-label">Modalidade</div>
            </div>
            <div class="jb-step-line"></div>
            <div class="jb-step-indicator" data-step="2">
                <div class="jb-step-circle"><span>2</span></div>
                <div class="jb-step-label">Palpite</div>
            </div>
            <div class="jb-step-line"></div>
            <div class="jb-step-indicator" data-step="3">
                <div class="jb-step-circle"><span>3</span></div>
                <div class="jb-step-label">Loteria</div>
            </div>
            <div class="jb-step-line"></div>
            <div class="jb-step-indicator" data-step="4">
                <div class="jb-step-circle"><span>4</span></div>
                <div class="jb-step-label">Colocação</div>
            </div>
            <div class="jb-step-line"></div>
            <div class="jb-step-indicator" data-step="5">
                <div class="jb-step-circle"><span>5</span></div>
                <div class="jb-step-label">Valor</div>
            </div>
        </div>

        <!-- Back Button -->
        <button class="jb-btn-voltar" id="jbBtnVoltar" style="display:none;" onclick="jbPrevStep()">
            <i class="fas fa-arrow-left"></i> Voltar
        </button>

        <!-- STEP 1 — MODALIDADE -->
        <div class="jb-step" id="jbStep1" data-step="1">
            <div class="jb-step-header">
                <h2>Escolha uma <span class="jb-highlight">modalidade</span></h2>
                <p>Selecione somente uma opção</p>
            </div>
            <div class="jb-modalidades-grid" id="jbModalidadesGrid">
                <div class="jb-loading">Carregando modalidades...</div>
            </div>
            <div class="jb-nav-buttons">
                <button class="jb-btn-proximo" id="jbBtn1Next" onclick="jbNextStep()" disabled>Próximo</button>
            </div>
        </div>

        <!-- STEP 2 — PALPITE -->
        <div class="jb-step" id="jbStep2" data-step="2" style="display:none;">
            <div class="jb-step-header">
                <h2>Escolha seu <span class="jb-highlight">palpite</span></h2>
                <p id="jbPalpiteInstrucao">Selecione um grupo</p>
            </div>
            <div id="jbGrupoGrid" class="jb-grupo-grid">
                <?php foreach ($grupos_bicho as $g): ?>
                <button class="jb-grupo-btn" data-grupo="<?= $g['num'] ?>" onclick="jbSelecionarGrupo(this)">
                    <span class="jb-grupo-emoji"><?= $g['emoji'] ?></span>
                    <span class="jb-grupo-num"><?= $g['num'] ?></span>
                    <span class="jb-grupo-nome"><?= $g['nome'] ?></span>
                </button>
                <?php endforeach; ?>
            </div>
            <div id="jbNumeroMode" class="jb-numero-mode" style="display:none;">
                <div class="jb-numero-inputs" id="jbNumeroInputs"></div>
                <div class="jb-teclado">
                    <button class="jb-tecla" onclick="jbTecla('1')">1</button>
                    <button class="jb-tecla" onclick="jbTecla('2')">2</button>
                    <button class="jb-tecla" onclick="jbTecla('3')">3</button>
                    <button class="jb-tecla" onclick="jbTecla('4')">4</button>
                    <button class="jb-tecla" onclick="jbTecla('5')">5</button>
                    <button class="jb-tecla" onclick="jbTecla('6')">6</button>
                    <button class="jb-tecla" onclick="jbTecla('7')">7</button>
                    <button class="jb-tecla" onclick="jbTecla('8')">8</button>
                    <button class="jb-tecla" onclick="jbTecla('9')">9</button>
                    <button class="jb-tecla" onclick="jbTecla('0')">0</button>
                    <button class="jb-tecla jb-tecla-apagar" onclick="jbTeclaApagar()"><i class="fas fa-backspace"></i></button>
                </div>
            </div>
            <div class="jb-selecao-atual" id="jbSelecaoAtual" style="display:none;">
                <span>Selecionado:</span>
                <div class="jb-tags" id="jbPalpiteTags"></div>
            </div>
            <div class="jb-nav-buttons">
                <button class="jb-btn-proximo" id="jbBtn2Next" onclick="jbNextStep()" disabled>Próximo</button>
            </div>
        </div>

        <!-- STEP 3 — LOTERIA -->
        <div class="jb-step" id="jbStep3" data-step="3" style="display:none;">
            <div class="jb-step-header">
                <h2>Escolha a <span class="jb-highlight">loteria</span></h2>
                <p>Selecione uma loteria e a data do sorteio</p>
            </div>
            <div class="jb-data-selector">
                <label>Data do sorteio</label>
                <div class="jb-datas-scroll" id="jbDatasScroll"></div>
            </div>
            <div class="jb-loterias-grid" id="jbLoteriasGrid"></div>
            <div class="jb-nav-buttons">
                <button class="jb-btn-proximo" id="jbBtn3Next" onclick="jbNextStep()" disabled>Próximo</button>
            </div>
        </div>

        <!-- STEP 4 — COLOCAÇÕES -->
        <div class="jb-step" id="jbStep4" data-step="4" style="display:none;">
            <div class="jb-step-header">
                <h2>Escolha as <span class="jb-highlight">colocações</span></h2>
                <p id="jbColocacaoInstrucao">Selecione em quais prêmios pode ganhar</p>
            </div>
            <div class="jb-colocacoes-grid" id="jbColocacoesGrid"></div>
            <div class="jb-nav-buttons">
                <button class="jb-btn-proximo" id="jbBtn4Next" onclick="jbNextStep()" disabled>Próximo</button>
            </div>
        </div>

        <!-- STEP 5 — VALOR & CONFIRMAR -->
        <div class="jb-step" id="jbStep5" data-step="5" style="display:none;">
            <div class="jb-step-header">
                <h2>Escolha o <span class="jb-highlight">valor</span></h2>
                <p>Insira o valor que você quer apostar</p>
            </div>
            <div class="jb-valores-rapidos">
                <button class="jb-valor-rapido" data-valor="5"   onclick="jbSetValor(5)">R$ 5</button>
                <button class="jb-valor-rapido" data-valor="10"  onclick="jbSetValor(10)">R$ 10</button>
                <button class="jb-valor-rapido" data-valor="25"  onclick="jbSetValor(25)">R$ 25</button>
                <button class="jb-valor-rapido" data-valor="50"  onclick="jbSetValor(50)">R$ 50</button>
                <button class="jb-valor-rapido" data-valor="100" onclick="jbSetValor(100)">R$ 100</button>
            </div>
            <div class="jb-valor-input-wrap">
                <span class="jb-valor-prefix">R$</span>
                <input type="number" id="jbValorInput" class="jb-valor-input" value="10" min="1" step="1" oninput="jbAtualizaValor()">
            </div>
            <div class="jb-resumo" id="jbResumo">
                <div class="jb-resumo-row"><span>Modalidade:</span><span id="jbResModalidade">—</span></div>
                <div class="jb-resumo-row"><span>Palpites:</span><span id="jbResPalpites">—</span></div>
                <div class="jb-resumo-row"><span>Loteria:</span><span id="jbResLoteria">—</span></div>
                <div class="jb-resumo-row"><span>Data:</span><span id="jbResData">—</span></div>
                <div class="jb-resumo-row"><span>Colocações:</span><span id="jbResColocacoes">—</span></div>
                <div class="jb-resumo-row"><span>Cotação:</span><span id="jbResCotacao">—</span></div>
                <div class="jb-resumo-row jb-resumo-total">
                    <span>Premiação máxima:</span>
                    <span id="jbResPremio" class="jb-destaque-verde">R$ 0,00</span>
                </div>
            </div>
            <div id="jbErroApostar" class="jb-erro" style="display:none;"></div>
            <button class="jb-btn-apostar" id="jbBtnApostar" onclick="jbApostar()">
                <i class="fas fa-play-circle"></i> Apostar <span id="jbBtnValorText">R$ 10,00</span>
            </button>
            <div class="jb-seguranca">
                <i class="fas fa-lock"></i> Pagamento seguro | Dados protegidos
            </div>
        </div>
    </div><!-- fim jbPainelApostar -->

    <!-- ============================================================
         PAINEL: MINHAS APOSTAS
         ============================================================ -->
    <div id="jbPainelMinhas" class="jb-painel" style="display:none;">

        <!-- Filtros -->
        <div class="jb-filtros">
            <button class="jb-filtro active" data-filtro="todas"  onclick="jbFiltrar('todas')"><i class="fas fa-th-list"></i> Todas</button>
            <button class="jb-filtro"        data-filtro="pendente" onclick="jbFiltrar('pendente')"><i class="fas fa-clock"></i> Pendente</button>
            <button class="jb-filtro"        data-filtro="ganhou"   onclick="jbFiltrar('ganhou')"><i class="fas fa-trophy"></i> Ganhou</button>
            <button class="jb-filtro"        data-filtro="perdeu"   onclick="jbFiltrar('perdeu')"><i class="fas fa-times-circle"></i> Perdeu</button>
        </div>

        <!-- Lista de apostas -->
        <div id="jbApostasList" class="jb-apostas-list">
            <div class="jb-loading">Carregando apostas...</div>
        </div>

        <!-- Load More -->
        <div id="jbLoadMoreWrap" class="jb-loadmore-wrap" style="display:none;">
            <button class="jb-btn-loadmore" id="jbBtnLoadMore" onclick="jbLoadMore()">
                <i class="fas fa-plus"></i> Ver mais
            </button>
        </div>

        <!-- Empty state -->
        <div id="jbEmptyState" class="jb-empty-state" style="display:none;">
            <i class="fas fa-sad-tear"></i>
            <p>Nenhuma aposta encontrada</p>
            <button class="jb-btn-ir-apostar" onclick="jbSwitchTab('apostar')">Fazer uma aposta</button>
        </div>
    </div><!-- fim jbPainelMinhas -->

</div><!-- fim #jbContainer -->

<!-- ============================================================
     COMO JOGAR
     ============================================================ -->
<div class="jb-como-jogar">
    <button class="jb-como-jogar-toggle" onclick="jbToggleComoJogar()">
        <i class="fas fa-question-circle"></i> Como jogar? <i class="fas fa-chevron-down" id="jbChevron"></i>
    </button>
    <div id="jbComoJogarContent" class="jb-como-jogar-content" style="display:none;">
        <div class="jb-cj-item"><h4>🐘 Grupo</h4><p>Escolha um grupo (animal). Para ganhar, o grupo deve sair na colocação selecionada (1º ao 7º prêmio). Cotação: 11x.</p></div>
        <div class="jb-cj-item"><h4>🔢 Milhar</h4><p>Escolha 4 dígitos (ex: 1234). Ganha se sua milhar sair exata na colocação. Cotação: 5.000x.</p></div>
        <div class="jb-cj-item"><h4>🔢 Centena</h4><p>Escolha 3 dígitos (ex: 123). Ganha se sua centena sair exata na colocação. Cotação: 500x.</p></div>
        <div class="jb-cj-item"><h4>🔢 Dezena</h4><p>Escolha 2 dígitos (ex: 12). Ganha se sua dezena sair exata na colocação. Cotação: 50x.</p></div>
        <div class="jb-cj-item"><h4>🐘🐘 Dupla de Grupo</h4><p>Escolha 2 grupos. Ganha se ambos saírem entre o 1º e 5º prêmio (qualquer ordem). Cotação: 121x.</p></div>
        <div class="jb-cj-item"><h4>🐘🐘🐘 Terno de Grupo</h4><p>Escolha 3 grupos. Ganha se os 3 saírem entre o 1º e 5º prêmio. Cotação: 1.331x.</p></div>
        <div class="jb-cj-item"><h4>🏆 Passe</h4><p>Escolha 2 grupos. O primeiro deve sair no 1º prêmio e o segundo entre 2º e 5º. Cotação: 55x.</p></div>
        <div class="jb-cj-item"><h4>🏆 Passe Vai Vem</h4><p>Escolha 2 grupos. Pelo menos um deve sair no 1º prêmio e o outro entre 2º e 5º. Cotação: 27.50x.</p></div>
    </div>
</div>

<!-- ============================================================
     CSS
     ============================================================ -->
<style>
/* ── Container ─────────────────────────────────────────────── */
.jb-container { max-width: 520px; margin: 0 auto; padding: 0 14px 100px; }

/* ── TABS ──────────────────────────────────────────────────── */
.jb-tabs {
    display: flex;
    gap: 8px;
    margin: 16px 0 20px;
    background: #161920;
    border-radius: 14px;
    padding: 5px;
}
.jb-tab {
    flex: 1;
    background: transparent;
    border: none;
    color: #6b7280;
    padding: 11px 8px;
    border-radius: 10px;
    font-size: 13px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.25s;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 7px;
    position: relative;
    white-space: nowrap;
}
.jb-tab:hover { color: #fff; background: rgba(255,255,255,0.05); }
.jb-tab.active {
    background: linear-gradient(135deg, #3b82f6, #2563eb);
    color: #fff;
    box-shadow: 0 3px 10px rgba(59,130,246,0.35);
}
.jb-tab i { font-size: 13px; }
.jb-tab-badge {
    background: #e53e3e;
    color: #fff;
    font-size: 10px;
    font-weight: 800;
    min-width: 18px;
    height: 18px;
    border-radius: 9px;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 0 5px;
}
.jb-tab.active .jb-tab-badge { background: rgba(255,255,255,0.25); }

/* ── Paineis ───────────────────────────────────────────────── */
.jb-painel { }

/* ── Progress Bar ──────────────────────────────────────────── */
.jb-progress-bar {
    display: flex; align-items: center; justify-content: center;
    gap: 0; margin: 4px 0 22px; padding: 0 4px;
}
.jb-step-indicator {
    display: flex; flex-direction: column; align-items: center;
    gap: 5px; flex-shrink: 0;
}
.jb-step-circle {
    width: 34px; height: 34px; border-radius: 50%;
    background: #2a2f3a; border: 2px solid #3a4050;
    display: flex; align-items: center; justify-content: center;
    color: #666; font-size: 13px; font-weight: 700;
    transition: all 0.3s;
}
.jb-step-indicator.active .jb-step-circle {
    background: linear-gradient(135deg, #3b82f6, #2563eb);
    border-color: #3b82f6; color: #fff;
    box-shadow: 0 3px 12px rgba(59,130,246,0.4);
}
.jb-step-indicator.completed .jb-step-circle {
    background: linear-gradient(135deg, #10b981, #059669);
    border-color: #10b981; color: #fff;
}
.jb-step-label { font-size: 9px; color: #555; text-transform: uppercase; letter-spacing: 0.4px; font-weight: 600; white-space: nowrap; }
.jb-step-indicator.active .jb-step-label { color: #3b82f6; }
.jb-step-indicator.completed .jb-step-label { color: #10b981; }
.jb-step-line {
    width: 36px; height: 2px; background: #2a2f3a;
    flex-shrink: 0; margin: 0 2px; margin-bottom: 20px;
    border-radius: 1px; transition: background 0.3s;
}
.jb-step-line.active { background: #3b82f6; }
.jb-step-line.completed { background: #10b981; }

@media (max-width: 400px) {
    .jb-step-circle { width: 28px; height: 28px; font-size: 11px; }
    .jb-step-label { font-size: 8px; }
    .jb-step-line { width: 22px; }
}

/* ── Back Button ───────────────────────────────────────────── */
.jb-btn-voltar {
    display: flex; align-items: center; gap: 6px;
    background: none; border: none; color: #6b7280;
    font-size: 14px; cursor: pointer; padding: 6px 0 12px;
    transition: color 0.2s;
}
.jb-btn-voltar:hover { color: #3b82f6; }

/* ── Step Header ───────────────────────────────────────────── */
.jb-step-header { margin-bottom: 20px; }
.jb-step-header h2 { color: #fff; font-size: 22px; font-weight: 700; margin: 0 0 6px; }
.jb-step-header p { color: #6b7280; font-size: 14px; margin: 0; }
.jb-highlight { color: #3b82f6; }
.jb-loading { color: #6b7280; text-align: center; padding: 30px 0; font-size: 14px; }

/* ── Modalidades Grid ──────────────────────────────────────── */
.jb-modalidades-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 10px; }
.jb-modalidade-btn {
    background: #1e2130; border: 2px solid #2e3545; border-radius: 14px;
    padding: 16px 12px; color: #fff; cursor: pointer;
    transition: all 0.25s; text-align: left; position: relative;
}
.jb-modalidade-btn:hover { border-color: #3b82f6; background: #252a3a; }
.jb-modalidade-btn.selected { border-color: #3b82f6; background: rgba(59,130,246,0.12); box-shadow: 0 0 16px rgba(59,130,246,0.25); }
.jb-mod-nome { font-size: 14px; font-weight: 700; margin-bottom: 4px; }
.jb-mod-cotacao { font-size: 11px; color: #f59e0b; font-weight: 600; }
.jb-mod-check { position: absolute; top: 10px; right: 10px; color: #3b82f6; font-size: 16px; display: none; }
.jb-modalidade-btn.selected .jb-mod-check { display: block; }
@media (max-width: 380px) { .jb-modalidades-grid { grid-template-columns: 1fr; } }

/* ── Grupo Grid ────────────────────────────────────────────── */
.jb-grupo-grid { display: grid; grid-template-columns: repeat(5, 1fr); gap: 8px; }
.jb-grupo-btn {
    background: #1e2130; border: 2px solid #2e3545; border-radius: 12px;
    padding: 10px 4px; cursor: pointer; text-align: center;
    transition: all 0.2s; display: flex; flex-direction: column;
    align-items: center; gap: 3px;
}
.jb-grupo-btn:hover { border-color: #3b82f6; background: #252a3a; }
.jb-grupo-btn.selected { border-color: #3b82f6; background: rgba(59,130,246,0.15); }
.jb-grupo-emoji { font-size: 20px; line-height: 1; }
.jb-grupo-num { font-size: 13px; font-weight: 800; color: #fff; }
.jb-grupo-nome { font-size: 8px; color: #6b7280; text-transform: uppercase; letter-spacing: 0.3px; }
@media (max-width: 380px) {
    .jb-grupo-grid { gap: 5px; }
    .jb-grupo-btn { padding: 7px 2px; }
    .jb-grupo-emoji { font-size: 17px; }
    .jb-grupo-num { font-size: 11px; }
    .jb-grupo-nome { font-size: 7px; }
}

/* ── Modo Número ───────────────────────────────────────────── */
.jb-numero-inputs { display: flex; justify-content: center; gap: 8px; margin-bottom: 20px; }
.jb-numero-input-box {
    width: 44px; height: 56px; background: #1e2130;
    border: 2px solid #2e3545; border-radius: 10px;
    display: flex; align-items: center; justify-content: center;
    color: #fff; font-size: 24px; font-weight: 800;
    transition: border-color 0.2s;
}
.jb-numero-input-box.active { border-color: #3b82f6; }
.jb-numero-input-box.filled { border-color: #10b981; background: rgba(16,185,129,0.1); }
.jb-numero-input-box .jb-cursor { width: 2px; height: 24px; background: #3b82f6; animation: blink 1s infinite; }
@keyframes blink { 0%,100%{opacity:1} 50%{opacity:0} }
.jb-teclado { display: grid; grid-template-columns: repeat(3, 1fr); gap: 8px; max-width: 240px; margin: 0 auto; }
.jb-tecla {
    background: #1e2130; border: 1px solid #2e3545; border-radius: 10px;
    color: #fff; font-size: 20px; font-weight: 700; height: 52px;
    cursor: pointer; transition: all 0.15s;
    display: flex; align-items: center; justify-content: center;
}
.jb-tecla:hover { background: #252a3a; border-color: #3b82f6; }
.jb-tecla:active { transform: scale(0.92); }
.jb-tecla-apagar { background: #2d1f1f; border-color: #4a2a2a; }
.jb-tecla-apagar:hover { background: #3d2525; border-color: #e53e3e; }

/* ── Tags ──────────────────────────────────────────────────── */
.jb-selecao-atual { margin-top: 16px; padding: 12px 14px; background: #1a1f2e; border-radius: 10px; border: 1px solid #2e3545; }
.jb-selecao-atual > span { color: #6b7280; font-size: 12px; font-weight: 600; display: block; margin-bottom: 8px; }
.jb-tags { display: flex; flex-wrap: wrap; gap: 6px; }
.jb-tag { background: rgba(59,130,246,0.15); border: 1px solid rgba(59,130,246,0.4); color: #60a5fa; padding: 4px 10px; border-radius: 20px; font-size: 13px; font-weight: 600; }

/* ── Datas ─────────────────────────────────────────────────── */
.jb-data-selector { margin-bottom: 20px; }
.jb-data-selector label { color: #6b7280; font-size: 12px; font-weight: 600; display: block; margin-bottom: 8px; text-transform: uppercase; letter-spacing: 0.5px; }
.jb-datas-scroll { display: flex; gap: 8px; overflow-x: auto; padding-bottom: 6px; -webkit-overflow-scrolling: touch; }
.jb-datas-scroll::-webkit-scrollbar { height: 0; }
.jb-data-btn {
    flex-shrink: 0; background: #1e2130; border: 2px solid #2e3545;
    border-radius: 10px; padding: 10px 14px; color: #fff; cursor: pointer;
    text-align: center; transition: all 0.2s; min-width: 72px;
}
.jb-data-btn:hover { border-color: #3b82f6; }
.jb-data-btn.selected { border-color: #3b82f6; background: rgba(59,130,246,0.12); }
.jb-data-dia { font-size: 18px; font-weight: 800; }
.jb-data-mes { font-size: 10px; color: #6b7280; text-transform: uppercase; }
.jb-data-hoje { font-size: 9px; color: #f59e0b; font-weight: 700; text-transform: uppercase; }

/* ── Loterias Grid ─────────────────────────────────────────── */
.jb-loterias-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 10px; }
.jb-loteria-btn {
    background: #1e2130; border: 2px solid #2e3545; border-radius: 14px;
    padding: 16px 12px; color: #fff; cursor: pointer;
    transition: all 0.2s; text-align: center; position: relative;
}
.jb-loteria-btn:hover { border-color: #3b82f6; background: #252a3a; }
.jb-loteria-btn.selected { border-color: #3b82f6; background: rgba(59,130,246,0.12); }
.jb-lot-sigla { font-size: 22px; font-weight: 800; color: #3b82f6; margin-bottom: 4px; }
.jb-lot-nome { font-size: 11px; color: #9ca3af; }
.jb-lot-check { position: absolute; top: 8px; right: 8px; color: #3b82f6; font-size: 14px; display: none; }
.jb-loteria-btn.selected .jb-lot-check { display: block; }

/* ── Colocações ────────────────────────────────────────────── */
.jb-colocacoes-grid { display: flex; flex-wrap: wrap; gap: 10px; justify-content: center; }
.jb-colocacao-btn {
    width: 72px; height: 72px; background: #1e2130;
    border: 2px solid #2e3545; border-radius: 14px; color: #fff;
    cursor: pointer; transition: all 0.2s;
    display: flex; flex-direction: column; align-items: center; justify-content: center; gap: 2px;
}
.jb-colocacao-btn:hover { border-color: #3b82f6; background: #252a3a; }
.jb-colocacao-btn.selected { border-color: #f59e0b; background: rgba(245,158,11,0.12); }
.jb-col-numero { font-size: 22px; font-weight: 800; }
.jb-col-texto { font-size: 9px; color: #6b7280; text-transform: uppercase; }
.jb-colocacao-btn.selected .jb-col-texto { color: #f59e0b; }

/* ── Valores Rápidos ───────────────────────────────────────── */
.jb-valores-rapidos { display: flex; gap: 8px; flex-wrap: wrap; justify-content: center; margin-bottom: 16px; }
.jb-valor-rapido {
    background: #1e2130; border: 2px solid #2e3545; border-radius: 10px;
    color: #fff; padding: 8px 14px; font-size: 14px; font-weight: 700;
    cursor: pointer; transition: all 0.2s;
}
.jb-valor-rapido:hover { border-color: #3b82f6; }
.jb-valor-rapido.selected { border-color: #f59e0b; background: rgba(245,158,11,0.1); color: #f59e0b; }

/* ── Valor Input ───────────────────────────────────────────── */
.jb-valor-input-wrap {
    display: flex; align-items: center; background: #1e2130;
    border: 2px solid #2e3545; border-radius: 12px;
    padding: 12px 16px; gap: 8px; margin-bottom: 24px;
}
.jb-valor-prefix { color: #9ca3af; font-size: 18px; font-weight: 700; }
.jb-valor-input { flex: 1; background: transparent; border: none; color: #fff; font-size: 28px; font-weight: 700; outline: none; width: 100%; }
.jb-valor-input::-webkit-inner-spin-button, .jb-valor-input::-webkit-outer-spin-button { -webkit-appearance: none; margin: 0; }

/* ── Resumo ────────────────────────────────────────────────── */
.jb-resumo { background: #1a1f2e; border: 1px solid #2e3545; border-radius: 14px; padding: 16px; margin-bottom: 20px; }
.jb-resumo-row { display: flex; justify-content: space-between; align-items: center; padding: 8px 0; border-bottom: 1px solid #252a3a; font-size: 13px; }
.jb-resumo-row:last-child { border-bottom: none; }
.jb-resumo-row span:first-child { color: #6b7280; }
.jb-resumo-row span:last-child { color: #fff; font-weight: 600; }
.jb-resumo-total { padding-top: 12px; margin-top: 4px; border-top: 1px solid #3a4050 !important; }
.jb-resumo-total span:first-child { color: #fff; font-weight: 700; font-size: 14px; }
.jb-destaque { color: #f59e0b !important; }
.jb-destaque-verde { color: #34d399 !important; font-size: 16px !important; }

/* ── Erro ──────────────────────────────────────────────────── */
.jb-erro { background: rgba(220,38,38,0.12); border: 1px solid rgba(220,38,38,0.4); color: #f87171; padding: 10px 14px; border-radius: 8px; font-size: 13px; margin-bottom: 16px; }

/* ── Botão Apostar ─────────────────────────────────────────── */
.jb-btn-apostar {
    width: 100%; background: linear-gradient(135deg, #10b981, #059669);
    border: none; border-radius: 14px; padding: 18px; color: #fff;
    font-size: 18px; font-weight: 700; cursor: pointer; transition: all 0.25s;
    box-shadow: 0 4px 16px rgba(16,185,129,0.35);
    display: flex; align-items: center; justify-content: center; gap: 8px;
}
.jb-btn-apostar:hover { transform: translateY(-2px); box-shadow: 0 6px 22px rgba(16,185,129,0.5); }
.jb-btn-apostar:active { transform: translateY(0); }
.jb-btn-apostar:disabled { background: #2e3545; box-shadow: none; cursor: not-allowed; color: #6b7280; }

/* ── Segurança ─────────────────────────────────────────────── */
.jb-seguranca { text-align: center; color: #4b5563; font-size: 11px; margin-top: 16px; display: flex; align-items: center; justify-content: center; gap: 6px; }

/* ── Nav Buttons ───────────────────────────────────────────── */
.jb-nav-buttons { margin-top: 24px; }
.jb-btn-proximo {
    width: 100%; background: linear-gradient(135deg, #3b82f6, #2563eb);
    border: none; border-radius: 14px; padding: 16px; color: #fff;
    font-size: 16px; font-weight: 700; cursor: pointer; transition: all 0.25s;
    box-shadow: 0 3px 14px rgba(59,130,246,0.35);
}
.jb-btn-proximo:hover { transform: translateY(-2px); box-shadow: 0 5px 20px rgba(59,130,246,0.5); }
.jb-btn-proximo:disabled { background: #2e3545; box-shadow: none; cursor: not-allowed; color: #555; }

/* ── Modal Sucesso ─────────────────────────────────────────── */
.jb-modal-overlay { position: fixed; inset: 0; background: rgba(0,0,0,0.75); z-index: 5000; display: flex; align-items: flex-end; justify-content: center; }
.jb-modal-sucesso {
    background: linear-gradient(180deg, #1a1f2e 0%, #141824 100%);
    width: 100%; max-width: 480px; border-radius: 24px 24px 0 0;
    padding: 32px 24px 40px; color: #fff; text-align: center;
    animation: jbSlideUp 0.3s ease; max-height: 90vh; overflow-y: auto;
}
@keyframes jbSlideUp { from{transform:translateY(100%)} to{transform:translateY(0)} }
.jb-sucesso-icone { font-size: 48px; margin-bottom: 12px; }
.jb-sucesso-titulo { font-size: 24px; font-weight: 700; margin: 0 0 6px; }
.jb-sucesso-sub { color: #6b7280; font-size: 14px; margin: 0 0 24px; }
.jb-sucesso-card { background: #1e2130; border: 1px solid #2e3545; border-radius: 14px; padding: 16px; margin-bottom: 24px; text-align: left; }
.jb-sucesso-row { display: flex; justify-content: space-between; padding: 9px 0; border-bottom: 1px solid #252a3a; font-size: 13px; }
.jb-sucesso-row:last-child { border-bottom: none; }
.jb-sucesso-label { color: #6b7280; }
.jb-sucesso-valor { color: #fff; font-weight: 600; }
.jb-btn-nova-aposta { display: block; width: 100%; background: linear-gradient(135deg, #3b82f6, #2563eb); border: none; border-radius: 12px; padding: 14px; color: #fff; font-size: 16px; font-weight: 700; cursor: pointer; margin-bottom: 10px; transition: all 0.2s; }
.jb-btn-nova-aposta:hover { transform: translateY(-1px); }
.jb-btn-fechar-sucesso { display: block; width: 100%; background: transparent; border: 1px solid #2e3545; border-radius: 12px; padding: 12px; color: #6b7280; font-size: 14px; cursor: pointer; transition: all 0.2s; }
.jb-btn-fechar-sucesso:hover { border-color: #4a5568; color: #9ca3af; }

/* ── Como Jogar ────────────────────────────────────────────── */
.jb-como-jogar { margin-top: 8px; max-width: 520px; margin-left: auto; margin-right: auto; padding: 0 14px; }
.jb-como-jogar-toggle { width: 100%; background: #1e2130; border: 1px solid #2e3545; border-radius: 12px; padding: 14px 16px; color: #9ca3af; font-size: 14px; font-weight: 600; cursor: pointer; display: flex; align-items: center; gap: 8px; transition: all 0.2s; }
.jb-como-jogar-toggle:hover { border-color: #3b82f6; color: #fff; }
.jb-como-jogar-toggle i:first-child { color: #3b82f6; }
#jbChevron { margin-left: auto; transition: transform 0.3s; }
#jbChevron.open { transform: rotate(180deg); }
.jb-como-jogar-content { background: #1a1f2e; border: 1px solid #2e3545; border-top: none; border-radius: 0 0 12px 12px; padding: 16px; margin-top: -1px; }
.jb-cj-item { margin-bottom: 14px; }
.jb-cj-item:last-child { margin-bottom: 0; }
.jb-cj-item h4 { color: #fff; font-size: 14px; margin: 0 0 4px; }
.jb-cj-item p { color: #6b7280; font-size: 12px; margin: 0; line-height: 1.5; }

/* ════════════════════════════════════════════════════════════════
   MINHAS APOSTAS
   ════════════════════════════════════════════════════════════════ */

/* ── Filtros ───────────────────────────────────────────────── */
.jb-filtros {
    display: flex; gap: 6px; overflow-x: auto;
    padding-bottom: 4px; margin-bottom: 18px;
    -webkit-overflow-scrolling: touch;
}
.jb-filtros::-webkit-scrollbar { height: 0; }
.jb-filtro {
    flex-shrink: 0;
    background: #1e2130;
    border: 1px solid #2e3545;
    border-radius: 20px;
    color: #6b7280;
    padding: 8px 14px;
    font-size: 12px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.2s;
    display: flex;
    align-items: center;
    gap: 5px;
    white-space: nowrap;
}
.jb-filtro:hover { border-color: #3b82f6; color: #fff; }
.jb-filtro.active { background: #3b82f6; border-color: #3b82f6; color: #fff; }
.jb-filtro[data-filtro="pendente"].active { background: #f59e0b; border-color: #f59e0b; }
.jb-filtro[data-filtro="ganhou"].active   { background: #10b981; border-color: #10b981; }
.jb-filtro[data-filtro="perdeu"].active   { background: #e53e3e; border-color: #e53e3e; }

/* ── Apostas List ──────────────────────────────────────────── */
.jb-apostas-list { display: flex; flex-direction: column; gap: 12px; }

/* ── Aposta Card ───────────────────────────────────────────── */
.jb-aposta-card {
    background: #1e2130;
    border: 1px solid #2e3545;
    border-radius: 16px;
    overflow: hidden;
    transition: transform 0.2s;
}
.jb-aposta-card:active { transform: scale(0.98); }

/* Header do card */
.jb-aposta-card-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 14px 16px 10px;
}
.jb-aposta-card-header-left {
    display: flex; align-items: center; gap: 10px;
}
.jb-aposta-card-icon {
    width: 38px; height: 38px;
    background: linear-gradient(135deg, #2a2f3a, #1e2130);
    border: 1px solid #2e3545;
    border-radius: 10px;
    display: flex; align-items: center; justify-content: center;
    font-size: 18px;
}
.jb-aposta-card-info .jb-aposta-card-titulo {
    color: #fff; font-size: 14px; font-weight: 700; line-height: 1.3;
}
.jb-aposta-card-info .jb-aposta-card-sub {
    color: #6b7280; font-size: 11px; margin-top: 2px;
}

/* Status Badge */
.jb-aposta-status {
    font-size: 10px; font-weight: 800;
    padding: 4px 10px; border-radius: 20px;
    text-transform: uppercase; letter-spacing: 0.5px;
    white-space: nowrap; flex-shrink: 0;
}
.jb-aposta-status.pendente { background: rgba(245,158,11,0.15); color: #f59e0b; border: 1px solid rgba(245,158,11,0.3); }
.jb-aposta-status.ganhou   { background: rgba(16,185,129,0.15); color: #10b981; border: 1px solid rgba(16,185,129,0.3); }
.jb-aposta-status.perdeu   { background: rgba(229,62,62,0.15);  color: #f87171; border: 1px solid rgba(229,62,62,0.3); }

/* Body do card */
.jb-aposta-card-body {
    padding: 0 16px 14px;
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 8px;
}
.jb-aposta-card-detail {
    background: rgba(255,255,255,0.03);
    border-radius: 8px;
    padding: 8px 6px;
    text-align: center;
}
.jb-aposta-card-detail .jb-detail-label {
    font-size: 8px; font-weight: 700; color: #4b5563;
    text-transform: uppercase; letter-spacing: 0.4px;
    margin-bottom: 4px;
}
.jb-aposta-card-detail .jb-detail-value {
    font-size: 12px; font-weight: 700; color: #fff;
    line-height: 1.2;
}
.jb-aposta-card-detail .jb-detail-value.jb-val-verde { color: #34d399; }
.jb-aposta-card-detail .jb-detail-value.jb-val-amarelo { color: #f59e0b; }

/* Footer do card — valor e premiação */
.jb-aposta-card-footer {
    border-top: 1px solid #2a2f3a;
    padding: 10px 16px;
    display: flex;
    align-items: center;
    justify-content: space-between;
}
.jb-aposta-card-footer .jb-footer-item { display: flex; flex-direction: column; gap: 1px; }
.jb-aposta-card-footer .jb-footer-label { font-size: 9px; color: #4b5563; text-transform: uppercase; letter-spacing: 0.4px; font-weight: 600; }
.jb-aposta-card-footer .jb-footer-value { font-size: 15px; font-weight: 800; color: #fff; }
.jb-aposta-card-footer .jb-footer-value.jb-val-verde { color: #34d399; }
.jb-aposta-card-footer .jb-footer-divider { width: 1px; height: 30px; background: #2e3545; }

/* ── Load More ─────────────────────────────────────────────── */
.jb-loadmore-wrap { text-align: center; margin-top: 18px; }
.jb-btn-loadmore {
    background: #1e2130; border: 1px solid #2e3545; border-radius: 10px;
    color: #9ca3af; padding: 10px 24px; font-size: 13px; font-weight: 600;
    cursor: pointer; transition: all 0.2s;
    display: inline-flex; align-items: center; gap: 6px;
}
.jb-btn-loadmore:hover { border-color: #3b82f6; color: #fff; }
.jb-btn-loadmore:disabled { opacity: 0.4; cursor: not-allowed; }

/* ── Empty State ───────────────────────────────────────────── */
.jb-empty-state {
    text-align: center; padding: 50px 20px;
}
.jb-empty-state i { font-size: 40px; color: #3a4050; margin-bottom: 14px; display: block; }
.jb-empty-state p { color: #6b7280; font-size: 15px; margin: 0 0 18px; }
.jb-btn-ir-apostar {
    background: linear-gradient(135deg, #3b82f6, #2563eb);
    border: none; border-radius: 10px; padding: 10px 22px;
    color: #fff; font-size: 14px; font-weight: 700; cursor: pointer;
    transition: all 0.2s;
}
.jb-btn-ir-apostar:hover { transform: translateY(-1px); }
</style>

<!-- ============================================================
     JS
     ============================================================ -->
<script>
(function() {
    // ══════════════════════════════════════════════════════════
    // STATE
    // ══════════════════════════════════════════════════════════
    const state = {
        step: 1,
        modalidades: [], loterias: [], datas: [],
        modalidade_id: null, modalidade: null,
        palpites: [], loteria_id: null,
        data_sorteio: null, colocacoes: [], valor: 10
    };

    // Minhas Apostas state
    const maState = {
        filtro: 'todas',
        pagina: 1,
        total_paginas: 1,
        apostas: []
    };

    // ══════════════════════════════════════════════════════════
    // TAB SWITCHING
    // ══════════════════════════════════════════════════════════
    window.jbSwitchTab = function(tab) {
        document.querySelectorAll('.jb-tab').forEach(t => t.classList.remove('active'));
        document.querySelector('.jb-tab[data-tab="' + tab + '"]').classList.add('active');

        document.getElementById('jbPainelApostar').style.display = (tab === 'apostar') ? 'block' : 'none';
        document.getElementById('jbPainelMinhas').style.display  = (tab === 'minhas')  ? 'block' : 'none';

        if (tab === 'minhas') {
            maState.pagina = 1;
            maState.apostas = [];
            jbCarregarApostas(true);
        }
    };

    // ══════════════════════════════════════════════════════════
    // LOAD DATA ON INIT
    // ══════════════════════════════════════════════════════════
    fetch('php/jbicho_loterias.php')
    .then(r => r.json())
    .then(data => {
        if (data.success) {
            state.modalidades = data.modalidades;
            state.loterias    = data.loterias;
            state.datas       = data.datas;
            renderModalidades();
            renderDatas();
            renderLoterias();
        } else {
            document.getElementById('jbModalidadesGrid').innerHTML = '<div class="jb-loading" style="color:#f87171;">' + (data.message||'Erro') + '</div>';
        }
    })
    .catch(() => {
        document.getElementById('jbModalidadesGrid').innerHTML = '<div class="jb-loading" style="color:#f87171;">Erro de conexão.</div>';
    });

    // ══════════════════════════════════════════════════════════
    // RENDER HELPERS (Apostar)
    // ══════════════════════════════════════════════════════════
    function renderModalidades() {
        document.getElementById('jbModalidadesGrid').innerHTML = state.modalidades.map(m => `
            <button class="jb-modalidade-btn" data-id="${m.id}" onclick="jbSelecionarModalidade(this, ${m.id})">
                <div class="jb-mod-nome">${m.nome}</div>
                <div class="jb-mod-cotacao">Cotação: ${parseFloat(m.cotacao).toLocaleString('pt-BR')}x</div>
                <i class="fas fa-check jb-mod-check"></i>
            </button>
        `).join('');
    }
    function renderDatas() {
        document.getElementById('jbDatasScroll').innerHTML = state.datas.map((d, i) => {
            const date = new Date(d.valor + 'T12:00:00');
            const dia  = date.getDate().toString().padStart(2,'0');
            const mes  = date.toLocaleString('pt-BR',{month:'short'});
            return `<button class="jb-data-btn ${i===0?'selected':''}" data-valor="${d.valor}" onclick="jbSelecionarData(this,'${d.valor}')">
                ${i===0 ? '<div class="jb-data-hoje">Hoje</div>' : ''}
                <div class="jb-data-dia">${dia}</div>
                <div class="jb-data-mes">${mes}</div>
            </button>`;
        }).join('');
        if (state.datas.length > 0) state.data_sorteio = state.datas[0].valor;
    }
    function renderLoterias() {
        document.getElementById('jbLoteriasGrid').innerHTML = state.loterias.map(l => `
            <button class="jb-loteria-btn" data-id="${l.id}" onclick="jbSelecionarLoteria(this,${l.id})">
                <div class="jb-lot-sigla">${l.sigla}</div>
                <div class="jb-lot-nome">${l.nome}</div>
                <i class="fas fa-check jb-lot-check"></i>
            </button>
        `).join('');
    }
    function renderColocacoes() {
        const max = state.modalidade ? parseInt(state.modalidade.premios_max) : 5;
        document.getElementById('jbColocacaoInstrucao').textContent = `Selecione do 1º ao ${max}º prêmio`;
        document.getElementById('jbColocacoesGrid').innerHTML = Array.from({length:max},(_,i) => {
            const n = i+1;
            return `<button class="jb-colocacao-btn" data-col="${n}" onclick="jbSelecionarColocacao(this,${n})">
                <span class="jb-col-numero">${n}º</span><span class="jb-col-texto">Prêmio</span>
            </button>`;
        }).join('');
    }

    // ══════════════════════════════════════════════════════════
    // SELECTIONS
    // ══════════════════════════════════════════════════════════
    window.jbSelecionarModalidade = function(el, id) {
        document.querySelectorAll('.jb-modalidade-btn').forEach(b => b.classList.remove('selected'));
        el.classList.add('selected');
        state.modalidade_id = id;
        state.modalidade = state.modalidades.find(m => m.id === id);
        state.palpites = [];
        document.getElementById('jbBtn1Next').disabled = false;
    };

    window.jbSelecionarGrupo = function(el) {
        const grupo = el.getAttribute('data-grupo');
        const max   = state.modalidade ? parseInt(state.modalidade.qtd_palpites) : 1;
        const idx   = state.palpites.indexOf(grupo);
        if (idx > -1) {
            state.palpites.splice(idx, 1);
            el.classList.remove('selected');
        } else {
            if (state.palpites.length < max) {
                state.palpites.push(grupo);
                el.classList.add('selected');
            } else if (max === 1) {
                document.querySelectorAll('.jb-grupo-btn').forEach(b => b.classList.remove('selected'));
                state.palpites = [grupo];
                el.classList.add('selected');
            }
        }
        updatePalpiteTags();
        document.getElementById('jbBtn2Next').disabled = (state.palpites.length !== max);
    };
    function updatePalpiteTags() {
        const container = document.getElementById('jbSelecaoAtual');
        const tags      = document.getElementById('jbPalpiteTags');
        if (state.palpites.length === 0) { container.style.display='none'; return; }
        container.style.display = 'block';
        tags.innerHTML = state.palpites.map(p => `<span class="jb-tag">${p}</span>`).join('');
    }

    window.jbSelecionarLoteria = function(el, id) {
        document.querySelectorAll('.jb-loteria-btn').forEach(b => b.classList.remove('selected'));
        el.classList.add('selected');
        state.loteria_id = id;
        document.getElementById('jbBtn3Next').disabled = false;
    };
    window.jbSelecionarData = function(el, valor) {
        document.querySelectorAll('.jb-data-btn').forEach(b => b.classList.remove('selected'));
        el.classList.add('selected');
        state.data_sorteio = valor;
    };
    window.jbSelecionarColocacao = function(el, num) {
        const idx = state.colocacoes.indexOf(num);
        if (idx > -1) { state.colocacoes.splice(idx,1); el.classList.remove('selected'); }
        else { state.colocacoes.push(num); el.classList.add('selected'); }
        document.getElementById('jbBtn4Next').disabled = (state.colocacoes.length === 0);
    };
    window.jbSetValor = function(v) {
        state.valor = v;
        document.getElementById('jbValorInput').value = v;
        document.querySelectorAll('.jb-valor-rapido').forEach(b => b.classList.toggle('selected', parseInt(b.dataset.valor)===v));
        jbAtualizaValor();
    };
    window.jbAtualizaValor = function() {
        const v = parseFloat(document.getElementById('jbValorInput').value) || 0;
        state.valor = v;
        document.querySelectorAll('.jb-valor-rapido').forEach(b => b.classList.toggle('selected', parseInt(b.dataset.valor)===v));
        updateResumo();
    };

    // ══════════════════════════════════════════════════════════
    // STEP NAV
    // ══════════════════════════════════════════════════════════
    function showStep(n) {
        state.step = n;
        document.querySelectorAll('.jb-step').forEach(s => s.style.display='none');
        document.getElementById('jbStep'+n).style.display = 'block';
        document.getElementById('jbBtnVoltar').style.display = (n>1)?'flex':'none';
        document.querySelectorAll('.jb-step-indicator').forEach(ind => {
            const s = parseInt(ind.dataset.step);
            ind.classList.remove('active','completed');
            if (s===n) ind.classList.add('active');
            else if (s<n) ind.classList.add('completed');
        });
        document.querySelectorAll('.jb-step-line').forEach((line,i) => {
            const s = i+1;
            line.classList.remove('active','completed');
            if (s < n-1) line.classList.add('completed');
            else if (s === n-1) line.classList.add('active');
        });
        if (n===2) prepareStep2();
        if (n===4) renderColocacoes();
        if (n===5) { prepareStep5(); updateResumo(); }
        window.scrollTo({top:0, behavior:'smooth'});
    }
    window.jbNextStep = function() { if (state.step<5) showStep(state.step+1); };
    window.jbPrevStep = function() { if (state.step>1) showStep(state.step-1); };

    // ── Step 2 prep ────────────────────────────────────────
    function prepareStep2() {
        const m = state.modalidade; if (!m) return;
        const grupoModes = ['grupo','dupla_grupo','terno_grupo','quadra_grupo','quina_grupo','passe','passe_vai_vem'];
        const isGrupo = grupoModes.includes(m.codigo);
        document.getElementById('jbGrupoGrid').style.display  = isGrupo?'grid':'none';
        document.getElementById('jbNumeroMode').style.display = isGrupo?'none':'block';
        document.querySelectorAll('.jb-grupo-btn').forEach(b => b.classList.remove('selected'));
        state.palpites = [];
        updatePalpiteTags();
        document.getElementById('jbBtn2Next').disabled = true;
        const instrucao = document.getElementById('jbPalpiteInstrucao');
        if (isGrupo) {
            instrucao.textContent = `Selecione ${m.qtd_palpites} grupo(s)`;
        } else {
            instrucao.textContent = `Insira sua ${m.codigo.replace('_combinada','')}`;
            renderNumeroInputs(m.codigo);
        }
    }

    // ── Numero keyboard ────────────────────────────────────
    let currentNumSlot = 0;
    let numSlotValues  = [];
    function getDigitsForCodigo(codigo) {
        if (codigo.includes('centena')) return 3;
        if (codigo.includes('dezena'))  return 2;
        return 4; // milhar default
    }
    function renderNumeroInputs(codigo) {
        const container = document.getElementById('jbNumeroInputs');
        const dpp = getDigitsForCodigo(codigo);
        const qtd = parseInt(state.modalidade.qtd_palpites);
        numSlotValues = Array(qtd).fill('');
        currentNumSlot = 0;
        container.innerHTML = Array.from({length:qtd},(_,si) =>
            `<div class="jb-numero-slot" data-slot="${si}" style="display:flex;gap:5px;">
                ${Array.from({length:dpp},(_,di) =>
                    `<div class="jb-numero-input-box ${si===0&&di===0?'active':''}" data-slot="${si}" data-digit="${di}">
                        <span class="jb-cursor"></span>
                    </div>`
                ).join('')}
            </div>`
        ).join('<div style="width:12px;"></div>');
    }
    window.jbTecla = function(digit) {
        const qtd = parseInt(state.modalidade.qtd_palpites);
        const dpp = getDigitsForCodigo(state.modalidade.codigo);
        if (currentNumSlot >= qtd) return;
        if (numSlotValues[currentNumSlot].length >= dpp) {
            currentNumSlot++;
            if (currentNumSlot >= qtd) return;
        }
        numSlotValues[currentNumSlot] += digit;
        renderDigitBoxes(dpp);
        if (numSlotValues[currentNumSlot].length >= dpp) currentNumSlot++;
        state.palpites = numSlotValues.filter(v => v.length === dpp);
        document.getElementById('jbBtn2Next').disabled = (state.palpites.length !== qtd);
        updatePalpiteTags();
    };
    window.jbTeclaApagar = function() {
        if (numSlotValues[currentNumSlot] && numSlotValues[currentNumSlot].length > 0) {
            numSlotValues[currentNumSlot] = numSlotValues[currentNumSlot].slice(0,-1);
        } else if (currentNumSlot > 0) {
            currentNumSlot--;
            numSlotValues[currentNumSlot] = numSlotValues[currentNumSlot].slice(0,-1);
        }
        const dpp = getDigitsForCodigo(state.modalidade.codigo);
        renderDigitBoxes(dpp);
        const qtd = parseInt(state.modalidade.qtd_palpites);
        state.palpites = numSlotValues.filter(v => v.length === dpp);
        document.getElementById('jbBtn2Next').disabled = (state.palpites.length !== qtd);
        updatePalpiteTags();
    };
    function renderDigitBoxes(dpp) {
        document.querySelectorAll('.jb-numero-input-box').forEach(box => {
            const slot = parseInt(box.dataset.slot);
            const dIdx = parseInt(box.dataset.digit);
            const val  = numSlotValues[slot] || '';
            box.classList.remove('active','filled');
            if (dIdx < val.length) { box.textContent = val[dIdx]; box.classList.add('filled'); }
            else if (dIdx === val.length && slot === currentNumSlot) { box.innerHTML='<span class="jb-cursor"></span>'; box.classList.add('active'); }
            else { box.innerHTML='<span class="jb-cursor" style="visibility:hidden;"></span>'; }
        });
    }

    // ── Step 5 ─────────────────────────────────────────────
    function prepareStep5() { state.valor = parseFloat(document.getElementById('jbValorInput').value)||10; updateResumo(); }
    function updateResumo() {
        const m   = state.modalidade;
        const lot = state.loterias.find(l => l.id === state.loteria_id);
        const date = state.data_sorteio ? new Date(state.data_sorteio+'T12:00:00') : null;
        const cotacao = m ? parseFloat(m.cotacao) : 0;
        const premio  = state.valor * cotacao;
        document.getElementById('jbResModalidade').textContent  = m ? m.nome : '—';
        document.getElementById('jbResPalpites').textContent    = state.palpites.join(', ') || '—';
        document.getElementById('jbResLoteria').textContent     = lot ? `${lot.sigla} - ${lot.nome}` : '—';
        document.getElementById('jbResData').textContent        = date ? date.toLocaleDateString('pt-BR') : '—';
        document.getElementById('jbResColocacoes').textContent  = state.colocacoes.length>0 ? state.colocacoes.map(c=>c+'º').join(', ') : '—';
        document.getElementById('jbResCotacao').textContent     = cotacao.toLocaleString('pt-BR')+'x';
        document.getElementById('jbResPremio').textContent      = 'R$ '+premio.toLocaleString('pt-BR',{minimumFractionDigits:2,maximumFractionDigits:2});
        document.getElementById('jbBtnValorText').textContent   = 'R$ '+state.valor.toLocaleString('pt-BR',{minimumFractionDigits:2,maximumFractionDigits:2});
    }

    // ══════════════════════════════════════════════════════════
    // PLACE BET
    // ══════════════════════════════════════════════════════════
    window.jbApostar = function() {
        const btn  = document.getElementById('jbBtnApostar');
        const erro = document.getElementById('jbErroApostar');
        erro.style.display = 'none';
        if (state.valor < 1) { erro.style.display='block'; erro.textContent='O valor mínimo de aposta é R$ 1,00.'; return; }
        let bitmask = 0;
        state.colocacoes.forEach(c => { bitmask |= (1<<(c-1)); });
        btn.disabled = true;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processando...';
        const fd = new URLSearchParams();
        fd.append('csrf_token',    '<?= $csrf_jbicho ?>');
        fd.append('modalidade_id', state.modalidade_id);
        fd.append('loteria_id',    state.loteria_id);
        fd.append('data_sorteio',  state.data_sorteio);
        fd.append('colocacoes',    bitmask);
        fd.append('palpites',      JSON.stringify(state.palpites));
        fd.append('valor',         state.valor);
        fetch('php/jbicho_apostar.php', { method:'POST', headers:{'Content-Type':'application/x-www-form-urlencoded'}, body:fd.toString() })
        .then(r => r.json())
        .then(data => {
            if (data.success) { jbMostrarSucesso(data); }
            else {
                erro.style.display='block'; erro.textContent=data.message;
                btn.disabled=false;
                btn.innerHTML='<i class="fas fa-play-circle"></i> Apostar <span id="jbBtnValorText">R$ '+state.valor.toLocaleString('pt-BR',{minimumFractionDigits:2})+'</span>';
            }
        })
        .catch(() => {
            erro.style.display='block'; erro.textContent='Erro de conexão. Tente novamente.';
            btn.disabled=false; btn.innerHTML='<i class="fas fa-play-circle"></i> Apostar';
        });
    };

    // ══════════════════════════════════════════════════════════
    // SUCCESS MODAL
    // ══════════════════════════════════════════════════════════
    function jbMostrarSucesso(data) {
        document.getElementById('jbSucessoModalidade').textContent = data.modalidade;
        document.getElementById('jbSucessoLoteria').textContent  = data.loteria || '—';
        document.getElementById('jbSucessoData').textContent     = data.data;
        document.getElementById('jbSucessoPalpites').textContent = data.palpites.join(', ');
        document.getElementById('jbSucessoValor').textContent    = 'R$ '+data.valor;
        document.getElementById('jbSucessoCotacao').textContent  = data.cotacao+'x';
        document.getElementById('jbSucessoSaldo').textContent    = 'R$ '+data.novo_saldo;
        document.getElementById('modalJbichoSucesso').style.display='flex';
    }
    window.jbFecharSucesso = function() { document.getElementById('modalJbichoSucesso').style.display='none'; };
    window.jbReset = function() {
        jbFecharSucesso();
        state.modalidade_id=null; state.modalidade=null; state.palpites=[];
        state.loteria_id=null; state.colocacoes=[]; state.valor=10;
        document.querySelectorAll('.jb-modalidade-btn').forEach(b=>b.classList.remove('selected'));
        document.querySelectorAll('.jb-grupo-btn').forEach(b=>b.classList.remove('selected'));
        document.querySelectorAll('.jb-loteria-btn').forEach(b=>b.classList.remove('selected'));
        document.querySelectorAll('.jb-colocacao-btn').forEach(b=>b.classList.remove('selected'));
        document.getElementById('jbValorInput').value=10;
        document.getElementById('jbBtn1Next').disabled=true;
        document.getElementById('jbBtn2Next').disabled=true;
        document.getElementById('jbBtn3Next').disabled=true;
        document.getElementById('jbBtn4Next').disabled=true;
        document.getElementById('jbErroApostar').style.display='none';
        document.getElementById('jbBtnApostar').disabled=false;
        document.getElementById('jbBtnApostar').innerHTML='<i class="fas fa-play-circle"></i> Apostar <span id="jbBtnValorText">R$ 10,00</span>';
        showStep(1);
    };

    // ══════════════════════════════════════════════════════════
    // MINHAS APOSTAS
    // ══════════════════════════════════════════════════════════
    window.jbFiltrar = function(filtro) {
        maState.filtro = filtro;
        maState.pagina = 1;
        maState.apostas = [];
        document.querySelectorAll('.jb-filtro').forEach(b => b.classList.remove('active'));
        document.querySelector('.jb-filtro[data-filtro="'+filtro+'"]').classList.add('active');
        jbCarregarApostas(true);
    };

    function jbCarregarApostas(reset) {
        if (reset) {
            maState.pagina = 1;
            maState.apostas = [];
            document.getElementById('jbApostasList').innerHTML = '<div class="jb-loading"><i class="fas fa-spinner fa-spin"></i> Carregando...</div>';
            document.getElementById('jbLoadMoreWrap').style.display = 'none';
            document.getElementById('jbEmptyState').style.display = 'none';
        }
        const url = `php/jbicho_minhas_apostas.php?status=${maState.filtro}&pagina=${maState.pagina}`;
        fetch(url)
        .then(r => r.json())
        .then(data => {
            if (!data.success) {
                document.getElementById('jbApostasList').innerHTML = '<div class="jb-loading" style="color:#f87171;">'+data.message+'</div>';
                return;
            }
            maState.total_paginas = data.total_paginas;
            maState.apostas = maState.apostas.concat(data.apostas);

            if (maState.apostas.length === 0) {
                document.getElementById('jbApostasList').innerHTML = '';
                document.getElementById('jbEmptyState').style.display = 'block';
                document.getElementById('jbLoadMoreWrap').style.display = 'none';
                return;
            }

            document.getElementById('jbEmptyState').style.display = 'none';

            if (reset) {
                document.getElementById('jbApostasList').innerHTML = '';
            }

            // Render new cards
            data.apostas.forEach(a => {
                document.getElementById('jbApostasList').insertAdjacentHTML('beforeend', renderApostaCard(a));
            });

            // Update badge
            const pendentes = maState.apostas.filter(a => a.status === 'pendente').length;
            const badge = document.getElementById('jbBadgeMinhas');
            badge.style.display = pendentes > 0 ? 'flex' : 'none';
            badge.textContent = pendentes;

            // Load more button
            document.getElementById('jbLoadMoreWrap').style.display = (maState.pagina < maState.total_paginas) ? 'flex' : 'none';
        })
        .catch(() => {
            document.getElementById('jbApostasList').innerHTML = '<div class="jb-loading" style="color:#f87171;">Erro de conexão.</div>';
        });
    }

    window.jbLoadMore = function() {
        maState.pagina++;
        document.getElementById('jbBtnLoadMore').disabled = true;
        document.getElementById('jbBtnLoadMore').innerHTML = '<i class="fas fa-spinner fa-spin"></i> Carregando...';
        jbCarregarApostas(false);
        document.getElementById('jbBtnLoadMore').disabled = false;
        document.getElementById('jbBtnLoadMore').innerHTML = '<i class="fas fa-plus"></i> Ver mais';
    };

    function renderApostaCard(a) {
        // Icon based on modalidade
        const codigos_grupo = ['grupo','dupla_grupo','terno_grupo','quadra_grupo','quina_grupo','passe','passe_vai_vem'];
        const isGrupo = codigos_grupo.includes(a.modalidade_codigo);
        const icon = isGrupo ? '🐾' : '🔢';

        // Premiação mostrar só se ganhou
        const premioHtml = a.status === 'ganhou'
            ? `<div class="jb-footer-item"><span class="jb-footer-label">Premiação</span><span class="jb-footer-value jb-val-verde">R$ ${a.premiacao_fmt}</span></div>`
            : `<div class="jb-footer-item"><span class="jb-footer-label">Premiação máx.</span><span class="jb-footer-value" style="font-size:13px;color:#6b7280;">R$ ${(parseFloat(a.valor)*parseFloat(a.cotacao_usada)).toLocaleString('pt-BR',{minimumFractionDigits:2})}</span></div>`;

        return `
        <div class="jb-aposta-card">
            <div class="jb-aposta-card-header">
                <div class="jb-aposta-card-header-left">
                    <div class="jb-aposta-card-icon">${icon}</div>
                    <div class="jb-aposta-card-info">
                        <div class="jb-aposta-card-titulo">${a.modalidade_nome}</div>
                        <div class="jb-aposta-card-sub">${a.loteria_sigla} - ${a.loteria_nome}</div>
                    </div>
                </div>
                <span class="jb-aposta-status ${a.status}">${a.status === 'pendente' ? '⏳ Pendente' : a.status === 'ganhou' ? '🏆 Ganhou' : '❌ Perdeu'}</span>
            </div>
            <div class="jb-aposta-card-body">
                <div class="jb-aposta-card-detail">
                    <div class="jb-detail-label">Palpites</div>
                    <div class="jb-detail-value">${a.palpites.join(', ')}</div>
                </div>
                <div class="jb-aposta-card-detail">
                    <div class="jb-detail-label">Colocações</div>
                    <div class="jb-detail-value">${a.colocacoes_texto}</div>
                </div>
                <div class="jb-aposta-card-detail">
                    <div class="jb-detail-label">Sorteio</div>
                    <div class="jb-detail-value">${a.data_sorteio_fmt}</div>
                </div>
            </div>
            <div class="jb-aposta-card-footer">
                <div class="jb-footer-item">
                    <span class="jb-footer-label">Valor</span>
                    <span class="jb-footer-value">R$ ${a.valor_fmt}</span>
                </div>
                <div class="jb-footer-divider"></div>
                <div class="jb-footer-item">
                    <span class="jb-footer-label">Cotação</span>
                    <span class="jb-footer-value" style="font-size:13px;">${a.cotacao_fmt}</span>
                </div>
                <div class="jb-footer-divider"></div>
                ${premioHtml}
            </div>
        </div>`;
    }

    // ══════════════════════════════════════════════════════════
    // COMO JOGAR
    // ══════════════════════════════════════════════════════════
    window.jbToggleComoJogar = function() {
        const content = document.getElementById('jbComoJogarContent');
        const chevron = document.getElementById('jbChevron');
        const open = content.style.display !== 'none';
        content.style.display = open ? 'none' : 'block';
        chevron.classList.toggle('open', !open);
    };

    // ── Init ───────────────────────────────────────────────
    showStep(1);
})();
</script>