<?php
session_start();

// Gerar um token CSRF único para cada página
function gerar_token_csrf($form) {
    $token = bin2hex(random_bytes(32));
    $_SESSION["csrf_token_$form"] = $token;
    return $token;
}

// SUBSTITUIR POR:
if ($_SERVER["REQUEST_METHOD"] == "GET") {
    // Gerar tokens CSRF apenas se não existirem (evita regeneração em cada GET)
    if (empty($_SESSION['csrf_token_deposito'])) {
        $token_deposito = gerar_token_csrf('deposito');
    }
    if (empty($_SESSION['csrf_token_retirada'])) {
        $token_retirada = gerar_token_csrf('retirada');
    }
    if (empty($_SESSION['csrf_token_dados'])) {
        $token_dados = gerar_token_csrf('dados');
    }
    if (empty($_SESSION['csrf_token_senha'])) {
        $token_senha = gerar_token_csrf('senha');
    }
    if (empty($_SESSION['csrf_token_contato'])) {
        $token_contato = gerar_token_csrf('contato');
    }
    if (empty($_SESSION['csrf_token_afiliados'])) {
        $token_afiliados = gerar_token_csrf('afiliados');
    }
    if (empty($_SESSION['csrf_token_bonus'])) {
        $token_bonus = gerar_token_csrf('bonus');
    }
    if (empty($_SESSION['csrf_token_jbicho'])) {
        $token_jbicho = gerar_token_csrf('jbicho');
    }
}

define('IN_INDEX', true);
require_once '../includes/db.php';
require_once '../includes/config.php';

// =========================
// BÔNUS USA (config global)
// =========================
$BonusUsaFrase = 'Claim your {valor} bonus now';
$BonusUsaValor = 750.00;

try {
    $stmt = $pdo->prepare("SELECT bonus_usa_valor, bonus_usa_frase FROM bet_config WHERE id = 1 LIMIT 1");
    $stmt->execute();
    $cfg = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($cfg) {
        $BonusUsaValor = (float)($cfg['bonus_usa_valor'] ?? 750);
        $BonusUsaFrase = trim($cfg['bonus_usa_frase'] ?? 'Claim your {valor} bonus now');
    }
} catch (Throwable $e) {}

// Cookie auth
if (!isset($_SESSION['usuario_id']) && isset($_COOKIE['auth_token'])) {
    $token = $_COOKIE['auth_token'];
    $stmt = $pdo->prepare("SELECT id, bet_status FROM bet_usuarios WHERE bet_token = ?");
    $stmt->execute([$token]);
    $usuario = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($usuario && $usuario['bet_status'] == 1) {
        $_SESSION['usuario_id'] = $usuario['id'];
    } else {
        setcookie("auth_token", "", time() - 3600, "/");
        header("Location: /");
        exit;
    }
}

if (!isset($_SESSION['usuario_id'])) {
    header("Location: /");
    exit;
} else {
    $stmt = $pdo->prepare("SELECT bet_nome, bet_email, bet_cpf, bet_saldo, bet_afiliado_por FROM bet_usuarios WHERE id = ?");
    $stmt->execute([$_SESSION['usuario_id']]);
    $usuario = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($usuario) {
        $nome        = $usuario['bet_nome'];
        $email       = $usuario['bet_email'];
        $cpf         = $usuario['bet_cpf'];
        $saldo       = $usuario['bet_saldo'];
        $porcentagem = $usuario['bet_afiliado_por'];
    }

    $stmt = $pdo->prepare("SELECT COALESCE(SUM(bet_bonus_valor), 0) AS total_bonus FROM bet_bonus WHERE bet_usuario = ? AND bet_bonus_status = 0");
    $stmt->execute([$_SESSION['usuario_id']]);
    $result      = $stmt->fetch(PDO::FETCH_ASSOC);
    $saldo_bonus = $result ? $result['total_bonus'] : 0;
}

$texto     = $BonusUsaFrase ?? 'Claim your {valor} bonus now';
$valor     = $BonusUsaValor ?? 750;
$textoFinal = str_replace('{valor}', '$'.number_format($valor, 0, '.', ''), $texto);
$mostrarBonusUsa = false;

if (isset($_SESSION['usuario_id'])) {
    $checkBonus = $pdo->prepare("
        SELECT 1
        FROM bet_bonus
        WHERE bet_usuario = ?
          AND bet_bonus_origem = 'USA'
        LIMIT 1
    ");
    $checkBonus->execute([$_SESSION['usuario_id']]);
    $mostrarBonusUsa = !$checkBonus->fetchColumn();
}

// =========================
// BINGO — busca sala atual
// =========================
$bingo_sala = null;
$bingo_status = 'aguardando'; // aguardando | em_andamento | finalizado
try {
    // Tenta sala em_andamento primeiro
    $stmt = $pdo->prepare("SELECT * FROM salas_bingo WHERE status = 'em_andamento' LIMIT 1");
    $stmt->execute();
    $bingo_sala = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($bingo_sala) {
        $bingo_status = 'em_andamento';
    } else {
        // Tenta sala aguardando
        $stmt = $pdo->prepare("SELECT * FROM salas_bingo WHERE status = 'aguardando' LIMIT 1");
        $stmt->execute();
        $bingo_sala = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($bingo_sala) {
            $bingo_status = 'aguardando';
        } else {
            // Tenta sala finalizada mais recente
            $stmt = $pdo->prepare("SELECT * FROM salas_bingo WHERE status = 'finalizado' ORDER BY id DESC LIMIT 1");
            $stmt->execute();
            $bingo_sala = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($bingo_sala) {
                $bingo_status = 'finalizado';
            }
        }
    }
} catch (Throwable $e) {}

// Cartelas do usuário nesta sala
$bingo_cartelas_count = 0;
if ($bingo_sala) {
    try {
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM cartelas_compradas WHERE usuario_id = ? AND sala_id = ?");
        $stmt->execute([$_SESSION['usuario_id'], $bingo_sala['id']]);
        $bingo_cartelas_count = (int)$stmt->fetchColumn();
    } catch (Throwable $e) {}
}

// Prêmios do bingo (para exibir no card)
$bingo_premio_quadra = (float)($bingo_sala['premio_quadra'] ?? 20.00);
$bingo_premio_quina  = (float)($bingo_sala['premio_quina'] ?? 30.00);
$bingo_premio_bingo  = (float)($bingo_sala['premio_cartela_cheia'] ?? 60.00);
// =========================
// TICKER PARTIDAS AO VIVO
// =========================
$ticker_partidas = [];
try {
    $stmt = $pdo->prepare("
        SELECT * FROM ticker_partidas 
        WHERE ativo = 1 
        ORDER BY 
            CASE status 
                WHEN 'live' THEN 1 
                WHEN 'upcoming' THEN 2 
                WHEN 'finished' THEN 3 
            END,
            ordem ASC
        LIMIT 20
    ");
    $stmt->execute();
    $ticker_partidas = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Throwable $e) {
    $ticker_partidas = [];
}

// Conta apostas pendentes do usuário
$apostas_pendentes = 0;
try {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM apostas_esportivas WHERE usuario_id = ? AND status = 'pendente'");
    $stmt->execute([$_SESSION['usuario_id']]);
    $apostas_pendentes = (int)$stmt->fetchColumn();
} catch (Throwable $e) {}
?>
<!DOCTYPE html>
<html lang="pt-BR" id="htmlRoot">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="format-detection" content="telephone=no">
    <title><?= $NomeSite ?> Casino & Online Betting with Exclusive Bonuses</title>
    <link rel="icon" type="image/png" href="../imagens/<?= $Favicon ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="css/estilos.php">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="js/scripts.js"></script>

    <style>
        /* ===================================
   MODAL RETIRADA - Design da Imagem
   =================================== */

.modal-retirada-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.85);
    backdrop-filter: blur(8px);
    z-index: 9999;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 20px;
    animation: fadeIn 0.3s ease;
}

@keyframes fadeIn {
    from {
        opacity: 0;
    }
    to {
        opacity: 1;
    }
}

.modal-retirada-container {
    transform: scale(0.9) translateX(-25px);
    transform-origin: center;
    width: 100%;
    max-width: 220px; /* aumentou um pouco */
    background: #1c1c1e;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.8);
    animation: slideUp 0.4s ease;
    max-height: 95vh;
    display: flex;
    flex-direction: column;
}
#alerta-retirada .alertanao {
    margin-left: -25px;
    padding: 4px 6px;
    font-size: 9px;
    border-radius: 4px;
    line-height: 1.1;
}





@keyframes slideUp {
    from {
        opacity: 0;
        transform: translateY(30px) scale(0.95);
    }
    to {
        opacity: 1;
        transform: translateY(0) scale(1);
    }
}

/* Header */
.modal-retirada-header {
    background: linear-gradient(135deg, #4a3728 0%, #6b5544 100%);
    padding: 25px 30px;
    display: flex;
    align-items: center;
    justify-content: space-between;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    flex-shrink: 0;
}

.header-content {
    display: flex;
    align-items: center;
    gap: 15px;
}

.icon-key {
    width: 60px;
    height: 60px;
    background: rgba(255, 255, 255, 0.15);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #fff;
    flex-shrink: 0;
}

.header-text h2 {
    font-size: 22px;
    font-weight: 600;
    margin: 0 0 5px 0;
    color: #fff;
}

.header-text p {
    font-size: 14px;
    color: rgba(255, 255, 255, 0.8);
    font-weight: 400;
    margin: 0;
}

.btn-close-modal {
    width: 45px;
    height: 45px;
    background: rgba(255, 255, 255, 0.1);
    border: none;
    border-radius: 10px;
    color: #fff;
    font-size: 24px;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}

.btn-close-modal:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: scale(1.05);
}

/* Body */
.modal-retirada-body {
    overflow-y: auto;
    flex: 1;
}

.chave-option-selected {
    padding: 20px 30px;
    display: flex;
    align-items: center;
    gap: 15px;
    background: #2c2c2e;
    border-bottom: 1px solid #3a3a3c;
}

.radio-icon-selected {
    width: 24px;
    height: 24px;
    border: 2px solid #ff9500;
    border-radius: 50%;
    position: relative;
    flex-shrink: 0;
}

.radio-icon-selected::after {
    content: '';
    position: absolute;
    width: 12px;
    height: 12px;
    background: #ff9500;
    border-radius: 50%;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
}

.chave-option-selected span {
    font-size: 16px;
    color: #fff;
    font-weight: 500;
}

/* Conteúdo do Saque */
.saque-content {
    padding: 40px 30px;
    background: #000;
}

.saque-content h3 {
    font-size: 28px;
    font-weight: 600;
    text-align: center;
    margin: 0 0 15px 0;
    color: #fff;
}

.subtitle-saque {
    font-size: 16px;
    color: #8e8e93;
    text-align: center;
    margin: 0 0 30px 0;
}

.saldo-info {
    text-align: center;
    font-size: 16px;
    color: #8e8e93;
    margin: 0 0 30px 0;
}

.saldo-info strong {
    color: #fff;
    font-size: 18px;
}

/* Alertas */
#alerta-retirada {
    margin-bottom: 20px;
}

#alerta-retirada .alertasim {
    background: rgba(52, 199, 89, 0.15);
    border: 1px solid #34c759;
    color: #34c759;
    padding: 15px 20px;
    border-radius: 10px;
    font-size: 14px;
    display: flex;
    align-items: center;
    justify-content: space-between;
    animation: slideDown 0.3s ease;
}

#alerta-retirada .alertanao {
    background: rgba(255, 59, 48, 0.15);
    border: 1px solid #ff3b30;
    color: #ff3b30;
    padding: 15px 20px;
    border-radius: 10px;
    font-size: 14px;
    display: flex;
    align-items: center;
    justify-content: space-between;
    animation: slideDown 0.3s ease;
}

@keyframes slideDown {
    from {
        opacity: 0;
        transform: translateY(-10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* Form Groups */
.form-group-retirada {
    margin-bottom: 25px;
}

.form-group-retirada label {
    display: block;
    font-size: 14px;
    color: #8e8e93;
    margin-bottom: 10px;
    font-weight: 500;
}

.input-wrapper-retirada {
    position: relative;
    display: flex;
    align-items: center;
}

.input-icon-retirada {
    position: absolute;
    left: 18px;
    color: #8e8e93;
    pointer-events: none;
    z-index: 1;
}

.input-wrapper-retirada input {
    width: 100%;
    padding: 18px 18px 18px 50px;
    background: #1c1c1e;
    border: 2px solid #3a3a3c;
    border-radius: 12px;
    color: #fff;
    font-size: 16px;
    transition: all 0.3s ease;
    font-family: inherit;
}

.input-wrapper-retirada input:focus {
    outline: none;
    border-color: #ff9500;
    background: #2c2c2e;
}

.input-wrapper-retirada input::placeholder {
    color: #636366;
}

.input-wrapper-retirada input:read-only {
    background: #2c2c2e;
    cursor: not-allowed;
    opacity: 0.7;
}

.input-wrapper-retirada input.valid {
    border-color: #34c759;
}

.input-wrapper-retirada input.invalid {
    border-color: #ff3b30;
}

/* Checkbox */
.checkbox-confirmacao {
    display: flex;
    align-items: flex-start;
    gap: 12px;
    margin-bottom: 30px;
}

.checkbox-confirmacao input[type="checkbox"] {
    width: 20px;
    height: 20px;
    margin-top: 2px;
    flex-shrink: 0;
    cursor: pointer;
    accent-color: #ff9500;
}

.checkbox-confirmacao label {
    font-size: 14px;
    color: #8e8e93;
    line-height: 1.5;
    cursor: pointer;
}

/* Botões */
.button-group-retirada {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 15px;
    margin-bottom: 25px;
}

.btn-secondary-retirada,
.btn-primary-retirada {
    padding: 16px 24px;
    border: none;
    border-radius: 12px;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    font-family: inherit;
}

.btn-secondary-retirada {
    background: #2c2c2e;
    color: #fff;
}

.btn-secondary-retirada:hover {
    background: #3a3a3c;
    transform: translateY(-2px);
}

.btn-primary-retirada {
    background: linear-gradient(135deg, #dc143c 0%, #b30000 100%);
    color: #fff;
    box-shadow: 0 4px 15px rgba(220, 20, 60, 0.4);
}

.btn-primary-retirada:hover:not(:disabled) {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(220, 20, 60, 0.5);
}

.btn-primary-retirada:active,
.btn-secondary-retirada:active {
    transform: translateY(0);
}

.btn-primary-retirada:disabled {
    opacity: 0.6;
    cursor: not-allowed;
}

/* Mensagens de Info */
.msg-retirada-info {
    text-align: center;
}

.msg-retirada-info p {
    font-size: 13px;
    color: #8e8e93;
    margin: 0 0 8px 0;
    line-height: 1.6;
}

.msg-retirada-info strong {
    color: #fff;
}

.warning-text-retirada {
    color: #ff9500 !important;
    margin-top: 15px !important;
}

/* Responsive */
@media (max-width: 768px) {
    .modal-retirada-container {
        max-width: 100%;
        border-radius: 0;
        max-height: 100vh;
    }

    .modal-retirada-header {
        padding: 20px;
    }

    .header-text h2 {
        font-size: 18px;
    }

    .header-text p {
        font-size: 13px;
    }

    .icon-key {
        width: 50px;
        height: 50px;
    }

    .saque-content {
        padding: 30px 20px;
    }

    .saque-content h3 {
        font-size: 24px;
    }

    .button-group-retirada {
        grid-template-columns: 1fr;
    }
}

/* Loading state para o botão */
.btn-primary-retirada.loading {
    position: relative;
    pointer-events: none;
}

.btn-primary-retirada.loading::after {
    content: '';
    position: absolute;
    width: 16px;
    height: 16px;
    border: 2px solid rgba(255, 255, 255, 0.3);
    border-top-color: #fff;
    border-radius: 50%;
    animation: spin 0.6s linear infinite;
    right: 20px;
    top: 50%;
    transform: translateY(-50%);
}

@keyframes spin {
    to {
        transform: translateY(-50%) rotate(360deg);
    }
}
/* ========================================================
   TICKER PARTIDAS AO VIVO - ESTILO BETANO
   ======================================================== */
.ticker-ao-vivo {
    width: 100%;
    overflow: hidden;
    background: #0d1117;
    padding: 12px 0;
    margin: 8px 0;
}

.ticker-strip {
    display: flex;
    gap: 12px;
    padding: 0 12px;
    width: max-content;
}

.ticker-strip:hover {
    animation-play-state: paused;
}

@keyframes tickerScroll {
    0% { transform: translateX(0); }
    100% { transform: translateX(-50%); }
}

/* Card da Partida */
.ticker-card {
    flex-shrink: 0;
    width: 280px;
    background: #1a1f2e;
    border-radius: 12px;
    overflow: hidden;
    cursor: pointer;
    transition: all 0.2s ease;
    border: 1px solid rgba(255,255,255,0.06);
}

.ticker-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.4);
    border-color: rgba(255,255,255,0.12);
}

/* Header do Card - Liga */
.ticker-card-header {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 10px 14px;
    background: #151a26;
    border-bottom: 1px solid rgba(255,255,255,0.05);
}

.ticker-flag { font-size: 16px; line-height: 1; }

.ticker-league {
    flex: 1;
    font-size: 12px;
    color: #8b95a5;
    font-weight: 500;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

/* Corpo do Card */
.ticker-card-body { padding: 12px 14px; }

/* Linha do tempo + badge */
.ticker-time-row {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 10px;
}

.ticker-time {
    font-size: 14px;
    font-weight: 600;
    color: #fff;
}

.ticker-badge {
    font-size: 10px;
    font-weight: 700;
    padding: 4px 8px;
    border-radius: 4px;
    text-transform: uppercase;
}

.ticker-badge.live {
    background: linear-gradient(135deg, #ff4757 0%, #ff6b81 100%);
    color: #fff;
    animation: pulseLive 2s infinite;
}

.ticker-badge.upcoming {
    background: linear-gradient(135deg, #f59e0b 0%, #fbbf24 100%);
    color: #000;
}

.ticker-badge.finished {
    background: #374151;
    color: #9ca3af;
}

@keyframes pulseLive {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.7; }
}

/* Times */
.ticker-teams { margin-bottom: 12px; }

.ticker-team-row {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 6px 0;
}

.ticker-team-info {
    display: flex;
    align-items: center;
    gap: 10px;
    flex: 1;
}

.ticker-team-icon {
    width: 22px;
    height: 22px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 16px;
}

.ticker-team-name {
    font-size: 14px;
    color: #fff;
    font-weight: 500;
    max-width: 160px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.ticker-card-indicator {
    width: 14px;
    height: 18px;
    border-radius: 2px;
    margin-left: 6px;
}

.ticker-card-indicator.red { background: #ef4444; }
.ticker-card-indicator.yellow { background: #fbbf24; }

.ticker-team-score {
    font-size: 18px;
    font-weight: 700;
    color: #fff;
    min-width: 30px;
    text-align: right;
}

/* Odds Clicáveis */
.ticker-odds {
    display: flex;
    gap: 8px;
}

.ticker-odd {
    flex: 1;
    background: #252d3d;
    border-radius: 8px;
    padding: 10px 12px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    cursor: pointer;
    transition: all 0.2s ease;
    border: 2px solid transparent;
}

.ticker-odd:hover {
    background: #2d3748;
    border-color: #3b82f6;
}

.ticker-odd.selected {
    background: #1e3a5f;
    border-color: #3b82f6;
}

.ticker-odd-label {
    font-size: 12px;
    color: #9ca3af;
    font-weight: 500;
}

.ticker-odd-value {
    font-size: 14px;
    font-weight: 700;
    color: #10b981;
}

/* ========================================================
   MODAL DE APOSTA - ESTILO BETANO/BET365
   ======================================================== */
.modal-aposta-overlay {
    position: fixed;
    inset: 0;
    background: rgba(0,0,0,0.7);
    z-index: 9998;
    opacity: 0;
    visibility: hidden;
    transition: all 0.3s ease;
}

.modal-aposta-overlay.show {
    opacity: 1;
    visibility: visible;
}

.modal-aposta {
    position: fixed;
    bottom: 0;
    left: 0;
    right: 0;
    background: linear-gradient(180deg, #1a1f2e 0%, #0f1419 100%);
    border-radius: 20px 20px 0 0;
    z-index: 9999;
    transform: translateY(100%);
    transition: transform 0.3s ease;
    max-height: 85vh;
    overflow-y: auto;
}

.modal-aposta.show {
    transform: translateY(0);
}

@media (min-width: 768px) {
    .modal-aposta {
        left: 50%;
        right: auto;
        bottom: 50%;
        transform: translate(-50%, 50%) scale(0.9);
        border-radius: 20px;
        width: 420px;
        max-height: 80vh;
    }
    
    .modal-aposta.show {
        transform: translate(-50%, 50%) scale(1);
    }
}

/* Header do Modal */
.aposta-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 16px 20px;
    border-bottom: 1px solid rgba(255,255,255,0.08);
    background: #151a26;
    border-radius: 20px 20px 0 0;
}

.aposta-header-title {
    display: flex;
    align-items: center;
    gap: 10px;
}

.aposta-header-title i {
    color: #fbbf24;
    font-size: 18px;
}

.aposta-header-title span {
    color: #fff;
    font-size: 16px;
    font-weight: 600;
}

.aposta-close-btn {
    background: rgba(255,255,255,0.1);
    border: none;
    color: #fff;
    width: 36px;
    height: 36px;
    border-radius: 50%;
    cursor: pointer;
    font-size: 18px;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.2s ease;
}

.aposta-close-btn:hover {
    background: rgba(255,255,255,0.2);
}

/* Conteúdo do Modal */
.aposta-content {
    padding: 20px;
}

/* Card da Seleção */
.aposta-selecao {
    background: #252d3d;
    border-radius: 12px;
    padding: 16px;
    margin-bottom: 20px;
    position: relative;
}

.aposta-remover {
    position: absolute;
    top: 12px;
    right: 12px;
    background: rgba(239,68,68,0.2);
    border: none;
    color: #ef4444;
    width: 24px;
    height: 24px;
    border-radius: 50%;
    cursor: pointer;
    font-size: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.aposta-remover:hover {
    background: rgba(239,68,68,0.3);
}

.aposta-partida {
    display: flex;
    align-items: center;
    gap: 8px;
    margin-bottom: 10px;
}

.aposta-partida-flag {
    font-size: 16px;
}

.aposta-partida-info {
    flex: 1;
}

.aposta-partida-liga {
    font-size: 11px;
    color: #6b7280;
    margin-bottom: 2px;
}

.aposta-partida-times {
    font-size: 13px;
    color: #fff;
    font-weight: 500;
}

.aposta-tipo {
    display: flex;
    align-items: center;
    justify-content: space-between;
    background: #1a1f2e;
    border-radius: 8px;
    padding: 12px;
}

.aposta-tipo-label {
    font-size: 13px;
    color: #9ca3af;
}

.aposta-tipo-odd {
    font-size: 16px;
    font-weight: 700;
    color: #10b981;
}

/* Input de Valor */
.aposta-valor-section {
    margin-bottom: 20px;
}

.aposta-valor-label {
    display: block;
    font-size: 13px;
    color: #9ca3af;
    margin-bottom: 10px;
}

.aposta-valor-input-container {
    display: flex;
    align-items: center;
    background: #252d3d;
    border-radius: 10px;
    border: 2px solid transparent;
    transition: all 0.2s ease;
    overflow: hidden;
}

.aposta-valor-input-container:focus-within {
    border-color: #3b82f6;
}

.aposta-valor-prefix {
    padding: 14px 12px;
    color: #9ca3af;
    font-weight: 600;
    font-size: 16px;
    background: #1a1f2e;
}

.aposta-valor-input {
    flex: 1;
    background: transparent;
    border: none;
    color: #fff;
    font-size: 18px;
    font-weight: 600;
    padding: 14px;
    outline: none;
}

.aposta-valor-input::placeholder {
    color: #4b5563;
}

/* Valores Rápidos */
.aposta-valores-rapidos {
    display: flex;
    gap: 8px;
    margin-bottom: 20px;
    flex-wrap: wrap;
}

.aposta-valor-btn {
    flex: 1;
    min-width: 70px;
    background: #252d3d;
    border: 1px solid rgba(255,255,255,0.1);
    color: #fff;
    padding: 10px;
    border-radius: 8px;
    font-size: 13px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.2s ease;
}

.aposta-valor-btn:hover {
    background: #2d3748;
    border-color: #3b82f6;
}

/* Resumo da Aposta */
.aposta-resumo {
    background: #252d3d;
    border-radius: 12px;
    padding: 16px;
    margin-bottom: 20px;
}

.aposta-resumo-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 8px 0;
}

.aposta-resumo-row:not(:last-child) {
    border-bottom: 1px solid rgba(255,255,255,0.05);
}

.aposta-resumo-label {
    font-size: 13px;
    color: #9ca3af;
}

.aposta-resumo-value {
    font-size: 14px;
    color: #fff;
    font-weight: 500;
}

.aposta-resumo-value.highlight {
    color: #10b981;
    font-size: 18px;
    font-weight: 700;
}

/* Saldo Disponível */
.aposta-saldo {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 12px 16px;
    background: rgba(16, 185, 129, 0.1);
    border-radius: 10px;
    margin-bottom: 20px;
    border: 1px solid rgba(16, 185, 129, 0.2);
}

.aposta-saldo-label {
    font-size: 13px;
    color: #9ca3af;
}

.aposta-saldo-value {
    font-size: 16px;
    font-weight: 700;
    color: #10b981;
}

/* Botão de Apostar */
.btn-fazer-aposta {
    width: 100%;
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    border: none;
    color: #fff;
    padding: 16px;
    border-radius: 12px;
    font-size: 16px;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.2s ease;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.btn-fazer-aposta:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(16, 185, 129, 0.4);
}

.btn-fazer-aposta:disabled {
    background: #374151;
    cursor: not-allowed;
    transform: none;
    box-shadow: none;
}

/* Alerta */
.aposta-alerta {
    padding: 12px 16px;
    border-radius: 10px;
    margin-bottom: 15px;
    font-size: 13px;
    display: none;
}

.aposta-alerta.show { display: block; }

.aposta-alerta.error {
    background: rgba(239, 68, 68, 0.15);
    border: 1px solid rgba(239, 68, 68, 0.3);
    color: #fca5a5;
}

.aposta-alerta.success {
    background: rgba(16, 185, 129, 0.15);
    border: 1px solid rgba(16, 185, 129, 0.3);
    color: #6ee7b7;
}

/* ========================================================
   BOTÃO MINHAS APOSTAS FLUTUANTE
   ======================================================== */
.btn-minhas-apostas {
    position: fixed;
    bottom: 90px;
    right: 16px;
    background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
    color: #fff;
    border: none;
    padding: 12px 20px;
    border-radius: 50px;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    z-index: 1000;
    display: flex;
    align-items: center;
    gap: 8px;
    box-shadow: 0 4px 20px rgba(59, 130, 246, 0.4);
    transition: all 0.2s ease;
}

.btn-minhas-apostas:hover {
    transform: translateY(-3px);
    box-shadow: 0 6px 25px rgba(59, 130, 246, 0.5);
}

.btn-minhas-apostas .badge {
    background: #ef4444;
    color: #fff;
    font-size: 11px;
    font-weight: 700;
    padding: 2px 8px;
    border-radius: 10px;
    min-width: 20px;
    text-align: center;
}

/* ========================================================
   MODAL MINHAS APOSTAS
   ======================================================== */
.modal-minhas-apostas {
    position: fixed;
    bottom: 0;
    left: 0;
    right: 0;
    background: linear-gradient(180deg, #1a1f2e 0%, #0f1419 100%);
    border-radius: 20px 20px 0 0;
    z-index: 9999;
    transform: translateY(100%);
    transition: transform 0.3s ease;
    max-height: 80vh;
    overflow-y: auto;
}

.modal-minhas-apostas.show {
    transform: translateY(0);
}

.minhas-apostas-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 16px 20px;
    border-bottom: 1px solid rgba(255,255,255,0.08);
    background: #151a26;
    border-radius: 20px 20px 0 0;
    position: sticky;
    top: 0;
}

.minhas-apostas-content {
    padding: 20px;
}

/* Card de Aposta */
.aposta-card {
    background: #252d3d;
    border-radius: 12px;
    padding: 16px;
    margin-bottom: 12px;
    border-left: 4px solid #fbbf24;
}

.aposta-card.ganhou { border-left-color: #10b981; }
.aposta-card.perdeu { border-left-color: #ef4444; }

.aposta-card-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 12px;
}

.aposta-card-partida {
    font-size: 13px;
    color: #fff;
    font-weight: 500;
}

.aposta-card-status {
    font-size: 10px;
    font-weight: 700;
    padding: 4px 10px;
    border-radius: 20px;
    text-transform: uppercase;
}

.aposta-card-status.pendente {
    background: rgba(251, 191, 36, 0.15);
    color: #fbbf24;
}

.aposta-card-status.ganhou {
    background: rgba(16, 185, 129, 0.15);
    color: #10b981;
}

.aposta-card-status.perdeu {
    background: rgba(239, 68, 68, 0.15);
    color: #ef4444;
}

.aposta-card-tipo {
    font-size: 12px;
    color: #9ca3af;
    margin-bottom: 12px;
}

.aposta-card-footer {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding-top: 12px;
    border-top: 1px solid rgba(255,255,255,0.05);
}

.aposta-card-valores {
    display: flex;
    gap: 20px;
}

.aposta-card-valor-item {
    text-align: center;
}

.aposta-card-valor-label {
    font-size: 10px;
    color: #6b7280;
    margin-bottom: 2px;
}

.aposta-card-valor-num {
    font-size: 14px;
    font-weight: 700;
    color: #fff;
}

.aposta-card-valor-num.green { color: #10b981; }

.aposta-vazia {
    text-align: center;
    padding: 40px 20px;
    color: #6b7280;
}

.aposta-vazia i {
    font-size: 48px;
    margin-bottom: 16px;
    opacity: 0.5;
}

.aposta-vazia p {
    font-size: 14px;
}

/* Responsivo */
@media (max-width: 480px) {
    .ticker-card { width: 390px; }
    .ticker-team-name { max-width: 130px; font-size: 13px; }
    .btn-minhas-apostas { bottom: 80px; right: 12px; padding: 10px 16px; font-size: 13px; }
}
        /* ========================================================
           BOTTOM NAVIGATION
           ======================================================== */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: rgba(20,20,20,0.75);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            display: flex;
            justify-content: space-around;
            align-items: center;
            padding: 8px 0 max(8px, env(safe-area-inset-bottom));
            box-shadow: 0 -2px 20px rgba(0,0,0,0.35);
            z-index: 1000;
            border-top: 1px solid rgba(255,255,255,0.08);
        }
        .bottom-nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-decoration: none;
            color: #888;
            transition: all 0.3s ease;
            padding: 5px;
            border-radius: 8px;
            min-width: 45px;
            cursor: pointer;
        }
        .bottom-nav-item:hover { color: #ffd700; transform: translateY(-2px); }
        .bottom-nav-item.active { color: #ffd700; }
        .bottom-nav-item .icon { font-size: 20px; margin-bottom: 2px; }
        .bottom-nav-item .label {
            font-size: 10px;
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        /* Botão central (Deposit) */
        .bottom-nav-item.center {
            color: white;
            border-radius: 50%;
            width: 55px;
            height: 55px;
            margin-top: -25px;
        }
        .bottom-nav-item.center:hover {
            transform: translateY(-4px) scale(1.05);
            box-shadow: 0 6px 25px rgba(255,107,53,0.6);
            color: white;
        }
        .bottom-nav-item.center .icon { font-size: 24px; margin-bottom: 0; }
        .bottom-nav-item.center .label { display: none; }
        .center-nav-icon { width: 37px; height: 37px; margin-top: 16px; }

        @media (max-width:480px) {
            .bottom-nav-item .label { font-size: 9px; }
            .bottom-nav-item .icon { font-size: 18px; }
            .bottom-nav-item.center .icon { font-size: 22px; }
        }

        body { padding-bottom: 70px; padding-top: 91px; }

        @media (min-width:1024px) {
            .bottom-nav { display: none; }
            body { padding-bottom: 0; }
        }

        /* ========================================================
           MENU MOBILE LATERAL
           ======================================================== */
        .mobile-menu {
            position: fixed;
            top: 0;
            left: -100%;
            width: 280px;
            max-width: 85vw;
            height: 100vh;
            background: linear-gradient(135deg,#1a1a1a 0%,#2d2d2d 100%);
            z-index: 2000;
            transition: left 0.3s ease;
            padding: 20px;
            color: white;
            overflow-y: auto;
            visibility: hidden;
            opacity: 0;
        }
        .mobile-menu.show { left: 0; visibility: visible; opacity: 1; }

        .mobile-menu-overlay {
            position: fixed; top:0; left:0; right:0; bottom:0;
            background: rgba(0,0,0,0.5);
            z-index: 1999;
            opacity: 0; visibility: hidden;
            transition: all 0.3s ease;
            pointer-events: none;
        }
        .mobile-menu-overlay.show { opacity:1; visibility:visible; pointer-events:auto; }

        .mobile-menu-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid #333;
        }
        .mobile-menu-header h3 { margin:0; color:#ffd700; }
        .mobile-menu-close {
            background:none; border:none; color:white;
            font-size:24px; cursor:pointer; padding:5px;
        }
        .mobile-menu-item {
            display: flex; align-items: center;
            padding: 15px 0;
            border-bottom: 1px solid #333;
            color: white; text-decoration: none;
            transition: color 0.3s ease; cursor: pointer;
        }
        .mobile-menu-item:hover { color: #ffd700; }
        .mobile-menu-item i { margin-right:15px; width:20px; font-size:18px; }

        /* Bingo badge no menu mobile */
        .mobile-menu-item .bingo-badge-menu {
            margin-left: auto;
            background: linear-gradient(135deg, #10b981, #059669);
            color: #fff;
            font-size: 9px;
            font-weight: 800;
            padding: 2px 7px;
            border-radius: 10px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        @media (max-width:1023px) { .mobile-menu { display:block; } }
        @media (min-width:1024px) {
            .mobile-menu, .mobile-menu-overlay { display:none !important; }
        }

        /* ========================================================
           MODAL PERFIL / PROFILE
           ======================================================== */
        #modalPerfil {
            display:none; position:fixed; z-index:2500;
            left:0; top:0; width:100%; height:100%;
            background-color:rgba(0,0,0,0.8);
            animation: fadeIn 0.3s ease;
        }
        #modalPerfil.show {
            display:flex; align-items:flex-end; justify-content:center;
        }
        .modal-perfil-content {
            background: linear-gradient(180deg,#1a1a2e 0%,#16213e 100%);
            width:100%; max-width:500px;
            border-radius:20px 20px 0 0;
            padding:30px 20px 40px;
            color:white; position:relative;
            animation: slideUp 0.3s ease;
            max-height:85vh; overflow-y:auto;
        }
        @keyframes fadeIn { from{opacity:0} to{opacity:1} }
        @keyframes slideUp { from{transform:translateY(100%)} to{transform:translateY(0)} }

        .perfil-close-btn {
            position:absolute; top:15px; right:15px;
            background:rgba(255,255,255,0.1); border:none; color:white;
            width:35px; height:35px; border-radius:50%; cursor:pointer;
            font-size:20px; display:flex; align-items:center; justify-content:center;
            transition:all 0.3s ease;
        }
        .perfil-close-btn:hover { background:rgba(255,255,255,0.2); transform:rotate(90deg); }

        .perfil-header { text-align:center; margin-bottom:30px; }
        .perfil-avatar {
            width:80px; height:80px; border-radius:50%;
            background:linear-gradient(135deg,#f6a300 0%,#ff6b35 100%);
            display:flex; align-items:center; justify-content:center;
            font-size:36px; font-weight:bold; color:white;
            margin:0 auto 15px; position:relative;
        }
        .perfil-status-dot {
            position:absolute; bottom:5px; right:5px;
            width:15px; height:15px; background:#ff4444;
            border-radius:50%; border:3px solid #1a1a2e;
        }
        .perfil-nome { font-size:22px; font-weight:600; margin-bottom:5px; }

        .perfil-info-item {
            display:flex; align-items:center; justify-content:space-between;
            padding:12px 15px; background:rgba(255,255,255,0.05);
            border-radius:10px; margin-bottom:10px; font-size:14px;
        }
        .perfil-info-label { display:flex; align-items:center; gap:10px; color:#aaa; }
        .perfil-info-label i { width:20px; text-align:center; color:#f6a300; }
        .perfil-info-value { color:white; font-weight:500; }
        .perfil-copy-btn {
            background:rgba(246,163,0,0.2); border:none; color:#f6a300;
            padding:5px 10px; border-radius:5px; cursor:pointer;
            font-size:12px; transition:all 0.3s ease;
        }
        .perfil-copy-btn:hover { background:rgba(246,163,0,0.3); }

        .perfil-section-title { font-size:16px; font-weight:600; margin:25px 0 15px; color:#f6a300; }

        .perfil-action-grid {
            display:grid; grid-template-columns:repeat(3,1fr);
            gap:15px; margin-bottom:20px;
        }
        .perfil-action-btn {
            background:rgba(255,255,255,0.05); border:none;
            padding:20px 10px; border-radius:15px; cursor:pointer;
            transition:all 0.3s ease; text-align:center; color:white;
        }
        .perfil-action-btn:hover { background:rgba(246,163,0,0.2); transform:translateY(-3px); }
        .perfil-action-btn i { font-size:24px; color:#f6a300; margin-bottom:8px; display:block; }
        .perfil-action-btn span { font-size:11px; display:block; }

        .perfil-minha-conta-btn {
            background:linear-gradient(135deg,#f6a300 0%,#ff6b35 100%);
            border:none; padding:15px; border-radius:15px;
            color:white; font-weight:600; font-size:16px;
            cursor:pointer; width:100%; margin-bottom:15px;
            transition:all 0.3s ease;
        }
        .perfil-minha-conta-btn:hover {
            transform:translateY(-2px);
            box-shadow:0 5px 20px rgba(246,163,0,0.4);
        }

        /* ========================================================
           APP BANNER TOPO
           ======================================================== */
        .app-banner {
            position:fixed; top:0; left:0; right:0; height:48px;
            background:#f6a300; color:#fff;
            display:flex; align-items:center; justify-content:center;
            gap:12px; font-size:14px; z-index:2001;
        }
        .app-banner-text { display:flex; align-items:center; gap:6px; }
        .app-banner-btn {
            background:#2b2f36; color:#fff; border:none;
            padding:6px 14px; border-radius:8px; font-size:14px; cursor:pointer;
        }
        .app-banner-close { position:absolute; right:12px; font-size:18px; cursor:pointer; }

        /* TOP BAR */
        .top-bar { position:fixed; top:48px; left:0; right:0; z-index:2000; margin-top:0 !important; }

        button { -webkit-tap-highlight-color:transparent; }
        button:focus, button:active, button:focus-visible { outline:none; box-shadow:none; }

        .dots { display:none !important; }
        .busca-container { margin-top:-34px; padding-top:0; }
        .ganhos-container { margin-top:6px; padding-top:0; }

        /* ========================================================
           BALANCE HEADER
           ======================================================== */
        .balance-header {
            display:flex; align-items:center; gap:6px;
            background:linear-gradient(135deg,#1a1f35 0%,#0f1419 100%);
            padding:6px 10px; border-radius:12px;
            margin-top:20px; margin-bottom:20px;
            box-shadow:0 3px 10px rgba(0,0,0,0.3);
        }
        .balance-display { flex:1; display:flex; flex-direction:column; gap:1px; }
        .main-balance { display:flex; align-items:baseline; gap:2px; }
        .balance-label { font-size:14px; font-weight:700; color:#fff; line-height:1; }
        .balance-amount { font-size:16px; font-weight:700; color:#fff; line-height:1; }
        .bonus-balance { display:flex; align-items:baseline; gap:2px; margin-top:1px; }
        .bonus-label { font-size:10px; font-weight:600; color:#6b7280; line-height:1; }
        .bonus-amount { font-size:10px; font-weight:600; color:#6b7280; line-height:1; }

        .btn-pix-deposit {
            background:url("https://i.postimg.cc/Y0gGGKmq/befunky-2026-0-6-12-55-20.png") center/contain no-repeat;
            border:none; width:70px; height:70px; cursor:pointer;
            padding:0; box-shadow:none; border-radius:0;
        }
        .btn-pix-deposit::before {
            content:''; position:absolute; top:4px; right:4px;
            width:5px; height:5px; background:#32cd32;
            border-radius:50%; border:1.5px solid #ff6b00;
        }
        .btn-pix-deposit:hover {
            transform:translateY(-2px);
            box-shadow:0 5px 14px rgba(255,107,0,0.5);
            background:linear-gradient(135deg,#ff7a10 0%,#ff9d52 100%);
        }
        .btn-pix-deposit:active { transform:translateY(0); }
        .pix-icon { width:22px; height:22px; filter:brightness(0) invert(1); }

        .btn-notification, .btn-message {
            background:#2d3748; border:none; border-radius:10px;
            width:36px; height:36px;
            display:flex; align-items:center; justify-content:center;
            cursor:pointer; transition:all 0.3s ease;
        }
        .btn-notification:hover, .btn-message:hover { background:#374151; transform:translateY(-2px); }
        .btn-notification i, .btn-message i { font-size:14px; color:#9ca3af; }

        @media (max-width:768px) {
            .balance-header { padding:5px 8px; gap:5px; margin-top:15px; }
            .balance-label { font-size:13px; }
            .balance-amount { font-size:15px; }
            .bonus-label, .bonus-amount { font-size:9px; }
            .btn-pix-deposit { width:36px; height:36px; }
            .pix-icon { width:20px; height:20px; }
            .btn-notification, .btn-message { width:32px; height:32px; }
            .btn-notification i, .btn-message i { font-size:12px; }
        }
        @media (max-width:480px) {
            .balance-header { padding:4px 6px; gap:4px; margin-top:10px; }
            .balance-label { font-size:12px; }
            .balance-amount { font-size:14px; }
            .btn-pix-deposit { width:32px; height:32px; }
            .pix-icon { width:18px; height:18px; }
            .btn-notification, .btn-message { width:40px; height:40px; }
            .btn-notification i, .btn-message i { font-size:11px; }
        }

        /* ========================================================
           MODAL DEPÓSITO / DEPOSIT
           ======================================================== */
        .modal-deposito {
            display:none; position:fixed; z-index:2500;
            left:0; top:0; width:100%; height:100%;
            background-color:rgba(0,0,0,0.8);
            animation:fadeIn 0.3s ease;
            opacity:0; visibility:hidden; transition:all 0.3s ease;
        }
        .modal-deposito.show {
            display:flex; align-items:flex-end; justify-content:center;
            opacity:1; visibility:visible;
        }
        .modal-deposito-content {
            background:#1a1a1a; width:100%; max-width:500px;
            border-radius:20px 20px 0 0; position:relative;
            animation:slideUp 0.3s ease; max-height:90vh; overflow-y:auto;
            transform:translateY(100%); transition:transform 0.3s ease;
        }
        .modal-deposito.show .modal-deposito-content { transform:translateY(0); }

        .banner-promocional {
            position:relative; width:100%;
            background:linear-gradient(135deg,#ff6b35 0%,#f6a300 50%,#4ecdc4 100%);
            padding:15px; min-height:200px;
            display:flex; align-items:center; justify-content:flex-start;
            border-radius:20px 20px 0 0; overflow:hidden;
        }
        .banner-promocional img {
            width:100%; max-width:95%; height:auto;
            object-fit:contain; margin-left:-15px; transform:translateX(-10px);
        }
        @media (max-width:480px) {
            .banner-promocional img { margin-left:-15px; transform:translateX(-8px); max-width:96%; }
        }

        .deposito-content { padding:25px 20px 40px; background:#1a1a1a; }
        .deposito-header { display:flex; align-items:center; gap:15px; margin-bottom:25px; }
        .btn-voltar {
            background:rgba(255,255,255,0.1); border:none; color:white;
            width:40px; height:40px; border-radius:10px;
            display:flex; align-items:center; justify-content:center;
            cursor:pointer; font-size:18px; transition:all 0.3s;
        }
        .btn-voltar:hover { background:rgba(255,255,255,0.15); }
        .deposito-title h2 { color:white; font-size:24px; font-weight:700; margin:0 0 4px 0; }
        .deposito-subtitle { color:#888; font-size:14px; margin:0; }

        .valor-section { margin-bottom:20px; }
        .valor-label { display:block; color:white; font-size:14px; font-weight:500; margin-bottom:10px; }
        .valor-input-container {
            background:rgba(255,255,255,0.05); border-radius:12px;
            padding:15px; display:flex; align-items:center; gap:10px;
        }
        .currency-prefix { color:#888; font-size:20px; font-weight:600; }
        .valor-input-container input {
            flex:1; background:transparent; border:none; color:white;
            font-size:28px; font-weight:700; outline:none; width:100%;
        }
        .valor-input-container input::-webkit-inner-spin-button,
        .valor-input-container input::-webkit-outer-spin-button { -webkit-appearance:none; margin:0; }
        .valor-controls { display:flex; flex-direction:column; gap:4px; }
        .btn-control {
            background:rgba(255,255,255,0.1); border:none; color:white;
            width:32px; height:24px; border-radius:6px;
            display:flex; align-items:center; justify-content:center;
            cursor:pointer; font-size:12px; transition:all 0.3s;
        }
        .btn-control:hover { background:rgba(255,255,255,0.15); }

        .valores-rapidos-grid { display:grid; grid-template-columns:repeat(3,1fr); gap:12px; margin-bottom:20px; }
        .valor-btn {
            position:relative; background:rgba(255,255,255,0.05);
            border:2px solid rgba(255,255,255,0.1); border-radius:12px;
            padding:18px 10px; cursor:pointer; transition:all 0.3s; overflow:hidden;
        }
        .valor-btn:hover { border-color:#ffd700; transform:translateY(-3px); box-shadow:0 5px 15px rgba(255,215,0,0.3); }
        .valor-btn.valor-selected { border-color:#ffd700; background:rgba(255,215,0,0.1); box-shadow:0 0 20px rgba(255,215,0,0.2); }
        .hot-badge {
            position:absolute; top:6px; right:6px;
            background:#ffd700; color:#000; font-size:9px; font-weight:700;
            padding:2px 6px; border-radius:4px; text-transform:uppercase;
        }
        .valor-text { display:block; color:#ffd700; font-size:20px; font-weight:700; text-align:center; }
        .valor-check {
            position:absolute; bottom:6px; right:6px; color:#ffd700; font-size:14px;
            background:rgba(255,215,0,0.2); width:22px; height:22px; border-radius:50%;
            display:flex; align-items:center; justify-content:center;
        }

        .bonus-checkbox-container { margin-bottom:20px; }
        .bonus-checkbox-label { display:flex; align-items:center; gap:10px; cursor:pointer; user-select:none; }
        .bonus-checkbox-label input[type="checkbox"] { display:none; }
        .checkbox-custom {
            width:24px; height:24px; border:2px solid #ffd700; border-radius:6px;
            display:flex; align-items:center; justify-content:center;
            transition:all 0.3s; flex-shrink:0;
        }
        .checkbox-custom i { color:#000; font-size:12px; opacity:0; transition:opacity 0.3s; }
        .bonus-checkbox-label input[type="checkbox"]:checked + .checkbox-custom { background:#ffd700; }
        .bonus-checkbox-label input[type="checkbox"]:checked + .checkbox-custom i { opacity:1; }
        .checkbox-text { color:#ccc; font-size:14px; line-height:1.4; }

        .btn-gerar-pix-custom {
            width:100%; background:linear-gradient(135deg,#00ff87 0%,#00cc6f 100%);
            border:none; border-radius:12px; padding:18px; color:#000;
            font-size:18px; font-weight:700; cursor:pointer; transition:all 0.3s;
            text-transform:uppercase; letter-spacing:0.5px;
            box-shadow:0 4px 15px rgba(0,255,135,0.3);
        }
        .btn-gerar-pix-custom:hover { transform:translateY(-2px); box-shadow:0 6px 20px rgba(0,255,135,0.5); }
        .btn-gerar-pix-custom:active { transform:translateY(0); }

        #alerta-deposito { margin-bottom:15px; }
        #alerta-deposito .alert { padding:12px; border-radius:8px; margin-bottom:10px; font-size:14px; }
        #alerta-deposito .alert-danger { background:rgba(220,53,69,0.2); border:1px solid rgba(220,53,69,0.5); color:#ff6b6b; }
        #alerta-deposito .alert-success { background:rgba(40,167,69,0.2); border:1px solid rgba(40,167,69,0.5); color:#51cf66; }

        @media (max-width:480px) {
            .deposito-content { padding:20px 15px 35px; }
            .valor-text { font-size:18px; }
            .valores-rapidos-grid { gap:8px; }
            .valor-btn { padding:15px 8px; }
        }
        @media (min-width:768px) {
            .modal-deposito.show { align-items:center; }
            .modal-deposito-content { border-radius:20px; max-height:90vh; }
            .banner-promocional { border-radius:20px 20px 0 0; }
        }

        /* ========================================================
           MODAL IDIOMA / LANGUAGE
           ======================================================== */
        .modal-idioma {
            position:fixed; inset:0; background:rgba(0,0,0,.6);
            display:none; align-items:center; justify-content:center; z-index:3000;
        }
        .modal-idioma.show { display:flex; }
        .idioma-box {
            background:#1a1f35; border-radius:14px; padding:14px;
            width:260px; display:flex; flex-direction:column; gap:10px;
        }
        .idioma-item {
            display:flex; align-items:center; gap:10px;
            background:#232842; border:none; color:#fff;
            padding:12px; border-radius:10px; cursor:pointer;
            font-size:14px; transition:.2s;
        }
        .idioma-item:hover { background:#2f3560; }
        .idioma-item img { width:26px; border-radius:4px; }

        /* ========================================================
           BONUS USA
           ======================================================== */
        .bonus-usa {
            display:flex; align-items:center; justify-content:space-between; gap:8px;
            background:linear-gradient(135deg,#1c1f26 0%,#111827 100%);
            border:1px solid rgba(255,255,255,0.08);
            padding:8px 14px; border-radius:12px;
            margin:10px 12px 4px; margin-top:71px;
            box-shadow:0 6px 18px rgba(0,0,0,.35);
        }
        .bonus-usa-text { color:#fff; font-size:14px; font-weight:600; line-height:1.2; }
        .bonus-usa-btn {
            background:#10b981; color:#fff; border:none;
            padding:10px 14px; border-radius:10px; font-weight:800;
            cursor:pointer; transition:.2s; white-space:nowrap;
        }
        .bonus-usa-btn:hover { transform:translateY(-1px); filter:brightness(1.05); }

        /* ========================================================
           CARD BINGO — integrado no dashboard
           ======================================================== */
        .bingo-card {
            margin: 12px 14px 8px;
            background: linear-gradient(135deg, #1a1f2e 0%, #0f1623 100%);
            border: 1px solid rgba(59, 130, 246, 0.25);
            border-radius: 16px;
            overflow: hidden;
            box-shadow: 0 6px 24px rgba(0,0,0,0.35);
            cursor: pointer;
            transition: transform 0.2s ease, box-shadow 0.2s ease;
            -webkit-tap-highlight-color: transparent;
        }
        .bingo-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 32px rgba(59, 130, 246, 0.25);
        }
        .bingo-card:active { transform: translateY(0); }

        /* Header gradiente do card */
        .bingo-card-header {
            background: linear-gradient(135deg, #1e3a5f 0%, #1a2744 50%, #162038 100%);
            padding: 14px 16px 10px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            position: relative;
            overflow: hidden;
        }
        /* Efeito de brilho no header */
        .bingo-card-header::before {
            content: '';
            position: absolute;
            top: -40px; right: -40px;
            width: 120px; height: 120px;
            background: radial-gradient(circle, rgba(59,130,246,0.18) 0%, transparent 70%);
            pointer-events: none;
        }

        .bingo-card-header-left {
            display: flex;
            align-items: center;
            gap: 10px;
            z-index: 1;
        }
        .bingo-card-icon {
            width: 38px; height: 38px;
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            border-radius: 10px;
            display: flex; align-items: center; justify-content: center;
            font-size: 18px; color: #fff;
            box-shadow: 0 3px 12px rgba(59, 130, 246, 0.4);
        }
        .bingo-card-title { color: #fff; font-size: 17px; font-weight: 700; line-height: 1.2; }
        .bingo-card-subtitle { color: #6b7fa3; font-size: 11px; margin-top: 1px; }

        /* Status badge */
        .bingo-status-badge {
            z-index: 1;
            font-size: 10px;
            font-weight: 800;
            padding: 4px 10px;
            border-radius: 20px;
            text-transform: uppercase;
            letter-spacing: 0.6px;
            white-space: nowrap;
        }
        .bingo-status-badge.aguardando {
            background: rgba(245, 158, 11, 0.15);
            color: #f59e0b;
            border: 1px solid rgba(245, 158, 11, 0.3);
        }
        .bingo-status-badge.em_andamento {
            background: rgba(16, 185, 129, 0.15);
            color: #10b981;
            border: 1px solid rgba(16, 185, 129, 0.3);
            animation: pulseBadge 2s infinite;
        }
        .bingo-status-badge.finalizado {
            background: rgba(156, 163, 175, 0.15);
            color: #9ca3af;
            border: 1px solid rgba(156, 163, 175, 0.3);
        }
        @keyframes pulseBadge {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.6; }
        }

        /* Body do card: prêmios */
        .bingo-card-body {
            padding: 12px 16px 14px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 8px;
        }
        .bingo-prizes-row {
            display: flex;
            gap: 10px;
            flex: 1;
        }
        .bingo-prize-item {
            flex: 1;
            text-align: center;
            background: rgba(255,255,255,0.04);
            border-radius: 10px;
            padding: 8px 4px;
        }
        .bingo-prize-label {
            font-size: 9px;
            font-weight: 700;
            color: #6b7fa3;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 3px;
        }
        .bingo-prize-value {
            font-size: 14px;
            font-weight: 800;
            color: #fbbf24;
            line-height: 1.1;
        }
        .bingo-prize-value.bingo-main { color: #34d399; font-size: 16px; }

        /* Botão Jogar / Ver Resultado */
        .bingo-play-btn {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            border: none;
            color: #fff;
            font-size: 13px;
            font-weight: 700;
            padding: 10px 18px;
            border-radius: 10px;
            cursor: pointer;
            transition: all 0.2s ease;
            white-space: nowrap;
            box-shadow: 0 3px 12px rgba(59, 130, 246, 0.4);
            flex-shrink: 0;
            display: flex;
            align-items: center;
            gap: 6px;
        }
        .bingo-play-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 5px 18px rgba(59, 130, 246, 0.5);
        }
        .bingo-play-btn:active { transform: translateY(0); }
        .bingo-play-btn.has-cartelas {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            box-shadow: 0 3px 12px rgba(16, 185, 129, 0.4);
        }
        .bingo-play-btn.has-cartelas:hover {
            box-shadow: 0 5px 18px rgba(16, 185, 129, 0.5);
        }

        /* Info inferior do card */
        .bingo-card-footer {
            padding: 0 16px 10px;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        .bingo-card-footer-info {
            font-size: 10px;
            color: #4b5563;
            display: flex;
            align-items: center;
            gap: 12px;
        }
        .bingo-card-footer-info span {
            display: flex;
            align-items: center;
            gap: 4px;
        }
        .bingo-card-footer-info i { color: #6b7fa3; font-size: 9px; }

        @media (max-width: 420px) {
            .bingo-card-header { padding: 12px 14px 8px; }
            .bingo-card-body { padding: 10px 14px 12px; flex-direction: column; align-items: stretch; }
            .bingo-play-btn { width: 100%; justify-content: center; }
            .bingo-prize-value { font-size: 13px; }
            .bingo-prize-value.bingo-main { font-size: 15px; }
        }
    </style>
</head>
<body>
  <div class="mobile-desktop-wrap">


<!-- ============================================================
     SIDEBAR TERMO
     ============================================================ -->
<div id="sidebartermo" class="sidebartermo">
    <span class="close-sidebartermo"><i class="fas fa-times"></i></span>
    <div class="sidebartermo-content" id="sidebartermoContent"></div>
</div>

<!-- ============================================================
     SIDEBAR DESKTOP
     ============================================================ -->
<div id="mySidebar" class="sidebar">
    <span class="close-btn" onclick="closeMenu()">×</span>
    <a href="/dashboard/"><i class="fas fa-gamepad"></i> <span class="i18n" data-key="nav_games">Jogos</span></a>
    <a href="/dashboard/?pagina=extrato"><i class="fas fa-file-invoice-dollar"></i> <span class="i18n" data-key="nav_statement">Extrato</span></a>
    <a href="/dashboard/bingo/main.php"><i class="fas fa-th"></i> <span class="i18n" data-key="nav_bingo">Bingo</span></a>
    <a class="btn-dados"><i class="fas fa-sync-alt"></i> <span class="i18n" data-key="nav_update_data">Atualizar dados</span></a>
    <a class="btn-senha"><i class="fas fa-user-lock"></i> <span class="i18n" data-key="nav_update_pass">Atualizar senha</span></a>
    <a href="/dashboard/?pagina=afiliado"><i class="fas fa-users"></i> <span class="i18n" data-key="nav_affiliate">Afiliado</span></a>
    <a href="php/logout.php"><i class="fas fa-sign-out-alt"></i> <span class="i18n" data-key="nav_logout">Sair</span></a>
</div>

<!-- ============================================================
     MENU MOBILE
     ============================================================ -->
<div class="mobile-menu-overlay" id="mobileMenuOverlay"></div>
<div class="mobile-menu" id="mobileMenu">
    <div class="mobile-menu-header">
        <h3><i class="fas fa-bars"></i> <span class="i18n" data-key="nav_menu">Menu</span></h3>
        <button class="mobile-menu-close" id="mobileMenuClose"><i class="fas fa-times"></i></button>
    </div>
    <a href="/dashboard/" class="mobile-menu-item">
        <i class="fas fa-gamepad"></i><span class="i18n" data-key="nav_games">Jogos</span>
    </a>
    <a href="/dashboard/?pagina=extrato" class="mobile-menu-item">
        <i class="fas fa-file-invoice-dollar"></i><span class="i18n" data-key="nav_statement">Extrato</span>
    </a>
    <a href="/dashboard/bingo/main.php" class="mobile-menu-item">
        <i class="fas fa-th"></i><span class="i18n" data-key="nav_bingo">Bingo</span>
        <?php if ($bingo_status === 'em_andamento'): ?>
            <span class="bingo-badge-menu">AO VIVO</span>
        <?php endif; ?>
    </a>
    <a class="mobile-menu-item btn-dados">
        <i class="fas fa-sync-alt"></i><span class="i18n" data-key="nav_update_data">Atualizar dados</span>
    </a>
    <a class="mobile-menu-item btn-senha">
        <i class="fas fa-user-lock"></i><span class="i18n" data-key="nav_update_pass">Atualizar senha</span>
    </a>
    <a href="/dashboard/?pagina=afiliado" class="mobile-menu-item">
        <i class="fas fa-users"></i><span class="i18n" data-key="nav_affiliate">Afiliado</span>
    </a>
    <a class="mobile-menu-item modalContato">
        <i class="fas fa-headset"></i><span class="i18n" data-key="nav_support">Suporte</span>
    </a>
    <a href="php/logout.php" class="mobile-menu-item">
        <i class="fas fa-sign-out-alt"></i><span class="i18n" data-key="nav_logout">Sair</span>
    </a>
</div>

<!-- ============================================================
     OVERLAY
     ============================================================ -->
<div class="overlay" id="overlay"></div>

<!-- ============================================================
     MODAL PERFIL / PROFILE
     ============================================================ -->
<div id="modalPerfil" class="modal-perfil">
    <div class="modal-perfil-content">
        <button class="perfil-close-btn" onclick="closePerfilModal()"><i class="fas fa-times"></i></button>

        <div class="perfil-header">
            <div class="perfil-avatar">
                <?php
                $iniciais = '';
                $nome_partes = explode(' ', $nome);
                if (count($nome_partes) >= 2)
                    $iniciais = strtoupper(substr($nome_partes[0],0,1) . substr($nome_partes[1],0,1));
                else
                    $iniciais = strtoupper(substr($nome,0,2));
                echo $iniciais;
                ?>
                <span class="perfil-status-dot"></span>
            </div>
            <div class="perfil-nome"><?= ucwords(strtolower($nome)); ?></div>
        </div>

        <div class="perfil-info-item">
            <div class="perfil-info-label">
                <i class="fas fa-envelope"></i>
                <span class="i18n" data-key="profile_email">Email</span>
            </div>
            <div class="perfil-info-value">
                <?= $email ?>
                <button class="perfil-copy-btn" onclick="copyToClipboard('<?= $email ?>')"><i class="fas fa-copy"></i></button>
            </div>
        </div>

        <div class="perfil-info-item">
            <div class="perfil-info-label">
                <i class="fas fa-hashtag"></i>
                <span class="i18n" data-key="profile_id">ID</span>
            </div>
            <div class="perfil-info-value">
                <?= $_SESSION['usuario_id'] ?>
                <button class="perfil-copy-btn" onclick="copyToClipboard('<?= $_SESSION['usuario_id'] ?>')"><i class="fas fa-copy"></i></button>
            </div>
        </div>

        <button class="perfil-minha-conta-btn" onclick="openMinhaContaPage()">
            <span class="i18n" data-key="profile_my_account">Minha conta</span>
        </button>

        <div class="perfil-section-title"><span class="i18n" data-key="profile_quick_actions">Ações Rápidas</span></div>

        <div class="perfil-action-grid">
            <button class="perfil-action-btn modalDeposito" onclick="closePerfilModal()">
                <i class="fas fa-dollar-sign"></i>
                <span class="i18n" data-key="action_deposit">Depósito</span>
            </button>
            <button class="perfil-action-btn modalRetirada" onclick="closePerfilModal()">
                <i class="fas fa-hand-holding-usd"></i>
                <span class="i18n" data-key="action_withdraw">Saque</span>
            </button>
            <button class="perfil-action-btn" onclick="window.location.href='/dashboard/bingo/main.php'">
                <i class="fas fa-th"></i>
                <span class="i18n" data-key="action_bingo">Bingo</span>
            </button>
            <button class="perfil-action-btn" onclick="window.location.href='/dashboard/?pagina=extrato'">
                <i class="fas fa-history"></i>
                <span class="i18n" data-key="action_game_history">Histórico</span>
            </button>
            <button class="perfil-action-btn" onclick="window.location.href='/dashboard/?pagina=extrato'">
                <i class="fas fa-exchange-alt"></i>
                <span class="i18n" data-key="action_transactions">Transações</span>
            </button>
            <button class="perfil-action-btn" type="button" onclick="closePerfilModal(); toggleIdioma();">
                <i class="fas fa-globe"></i>
                <span class="i18n" data-key="action_language">Linguagem</span>
            </button>
        </div>
    </div>
</div>

<!-- ============================================================
     MODAL DEPÓSITO / DEPOSIT
     ============================================================ -->
<div id="modalDeposito" class="modal-deposito">
    <div class="modal-deposito-content">
        <div class="banner-promocional">
            <img src="https://i.postimg.cc/mk2dSjBt/hi9YF4t4s92re35w3MUw6QP08JV4RN-meta-Z2Fua-GU0Nz-Awd-GFt-YW5obz-Euan-Bn.webp" alt="Banner">
        </div>
        <div class="deposito-content">
            <div class="deposito-header">
                <a href="/dashboard" class="btn-voltar" onclick="fecharModalDeposito()">
    <i class="fas fa-arrow-left"></i>
</a>

                <div class="deposito-title">
                    <h2 class="i18n" data-key="deposit_title">Depositar</h2>
                    <p class="deposito-subtitle i18n" data-key="deposit_subtitle">Adicione saldo à sua conta</p>
                </div>
            </div>
            <div id="alerta-deposito"></div>
            <form id="formdeposito" action="php/deposito.php">
                <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_deposito'] ?? '' ?>">
                <div class="valor-section">
                    <label class="valor-label i18n" data-key="deposit_amount_label">Valor a ser depositado:</label>
                    <div class="valor-input-container">
                        <span class="currency-prefix">R$</span>
                        <input type="number" id="deposito" name="deposito" value="50"
                               min="<?php echo $ValorDeposito; ?>" max="10000" step="10">
                        <div class="valor-controls">
                            <button type="button" class="btn-control btn-minus" onclick="diminuirValor()"><i class="fas fa-minus"></i></button>
                            <button type="button" class="btn-control btn-plus" onclick="aumentarValor()"><i class="fas fa-plus"></i></button>
                        </div>
                    </div>
                </div>
                <div class="valores-rapidos-grid">
                    <button type="button" class="valor-btn" data-valor="20" onclick="selecionarValor(20)">
                        <span class="hot-badge">HOT</span><span class="valor-text">R$ 20</span>
                    </button>
                    <button type="button" class="valor-btn valor-selected" data-valor="50" onclick="selecionarValor(50)">
                        <span class="hot-badge">HOT</span><span class="valor-text">R$ 50</span><i class="fas fa-check valor-check"></i>
                    </button>
                    <button type="button" class="valor-btn" data-valor="100" onclick="selecionarValor(100)">
                        <span class="hot-badge">HOT</span><span class="valor-text">R$ 100</span>
                    </button>
                    <button type="button" class="valor-btn" data-valor="250" onclick="selecionarValor(250)">
                        <span class="hot-badge">HOT</span><span class="valor-text">R$ 250</span>
                    </button>
                    <button type="button" class="valor-btn" data-valor="500" onclick="selecionarValor(500)">
                        <span class="hot-badge">HOT</span><span class="valor-text">R$ 500</span>
                    </button>
                    <button type="button" class="valor-btn" data-valor="1000" onclick="selecionarValor(1000)">
                        <span class="hot-badge">HOT</span><span class="valor-text">R$ 1,000</span>
                    </button>
                </div>
                <div class="bonus-checkbox-container">
                    <label class="bonus-checkbox-label">
                        <input type="checkbox" id="sem-bonus" name="sem_bonus" checked>
                        <span class="checkbox-custom"><i class="fas fa-check"></i></span>
                        <span class="checkbox-text i18n" data-key="deposit_no_bonus">Não quero receber nenhum bônus</span>
                    </label>
                </div>
                <button type="submit" id="subDeposito" class="btn-gerar-pix-custom">
                    <span class="btn-text i18n" data-key="deposit_generate_pix">Gerar PIX</span>
                </button>
            </form>
        </div>
    </div>
</div>

<!-- ============================================================
     MODAL RETIRADA / WITHDRAWAL
     ============================================================ -->
<!-- Modal de Retirada - Design idêntico à imagem -->
<div id="modalRetirada" class="modal-retirada-overlay" style="display: none;">
    <div class="modal-retirada-container">
        <div class="modal-retirada-header">
            <div class="header-content">
                <div class="icon-key">
                    <svg width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <circle cx="8" cy="8" r="6"/>
                        <path d="M18.09 10.37a6 6 0 1 1-8.48-8.48"/>
                        <line x1="12" y1="12" x2="20" y2="20"/>
                        <line x1="16" y1="16" x2="20" y2="20"/>
                    </svg>
                </div>
                <div class="header-text">
                    <h2>Minhas chaves</h2>
                    <p>Em qual chave você quer receber?</p>
                </div>
            </div>
            <a href="/dashboard" class="btn-close-modal">✕</a>

        </div>

        <div class="modal-retirada-body">
            <div class="chave-option-selected">
                <div class="radio-icon-selected"></div>
                <span>Nova chave</span>
            </div>

            <div class="saque-content">
                <h3>Seu saque está quase pronto</h3>
                <p class="subtitle-saque">Só falta o seu CPF para deixar tudo pronto</p>

                <!-- Container de alertas -->
                <div id="alerta-retirada"></div>

                <form id="formretirada" action="php/retirada.php">
                    <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_retirada'] ?? '' ?>">
                    
                    <p class="saldo-info">
                        <span class="i18n" data-key="withdrawal_balance">Seu saldo para retirada é de</span> 
                        R$ <strong><?= number_format($saldo, 2, ',', '.'); ?></strong>
                    </p>

                    <!-- Valor da Retirada -->
                    <div class="form-group-retirada">
                        <label>Valor da Retirada</label>
                        <div class="input-wrapper-retirada">
                            <svg class="input-icon-retirada" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <line x1="12" y1="1" x2="12" y2="23"></line>
                                <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"></path>
                            </svg>
                            <input type="text" id="retirada" name="retirada" class="currency" 
                                   placeholder="R$ 0,00" inputmode="decimal">
                        </div>
                    </div>

                    <!-- Titular -->
                    <div class="form-group-retirada">
                        <label>Titular</label>
                        <div class="input-wrapper-retirada">
                            <svg class="input-icon-retirada" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                <circle cx="12" cy="7" r="4"></circle>
                            </svg>
                            <input type="text" value="<?= ucwords(strtolower($nome)); ?>" readonly>
                        </div>
                    </div>

                    <!-- CPF -->
                    <div class="form-group-retirada">
                        <label>CPF</label>
                        <div class="input-wrapper-retirada">
                            <svg class="input-icon-retirada" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M12 11c0 3.517-1.009 6.799-2.753 9.571m-3.44-2.04l.054-.09A13.916 13.916 0 008 11a4 4 0 118 0c0 1.017-.07 2.019-.203 3m-2.118 6.844A21.88 21.88 0 0015.171 17m3.839 1.132c.645-2.266.99-4.659.99-7.132A8 8 0 008 4.07M3 15.364c.64-1.319 1-2.8 1-4.364 0-1.457.39-2.823 1.07-4"/>
                            </svg>
                            <input type="text" id="pix_cpf" name="pix_cpf" placeholder="000.000.000-00" 
                                   maxlength="14" value="<?= $cpf ?? '' ?>">
                        </div>
                    </div>

                    <!-- Checkbox de confirmação -->
                    <div class="checkbox-confirmacao">
                        <input type="checkbox" id="confirmInfo" required>
                        <label for="confirmInfo">Asseguro que todas as informações fornecidas são verdadeiras e pertencem a mim.</label>
                    </div>

                    <!-- Botões -->
                    <div class="button-group-retirada">
                        <button type="button" class="btn-secondary-retirada" onclick="fecharModalRetirada()">Fechar</button>
                        <button type="submit" id="subRetirada" class="btn-primary-retirada">Atualizar CPF</button>
                    </div>
                </form>

                <!-- Informações de retirada -->
                <div class="msg-retirada-info">
                    <p><span class="i18n" data-key="withdrawal_min">A retirada mínima é de</span> R$ <strong><?php echo number_format($ValorRetirada, 2, ',', ''); ?></strong>.</p>
                    <p><span class="i18n" data-key="withdrawal_max">A retirada máxima é de</span> R$ <strong>10.000,00</strong>.</p>
                    <p class="warning-text-retirada">Você não pode realizar saques para terceiros. Saque somente é válido para contas de sua titularidade.</p>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Função para abrir modal
function abrirModalRetirada() {
    document.getElementById('modalRetirada').style.display = 'flex';
    document.body.style.overflow = 'hidden';
}

// Função para fechar modal
function fecharModalRetirada() {
    document.getElementById('modalRetirada').style.display = 'none';
    document.body.style.overflow = 'auto';
}

// Fechar ao clicar fora do modal
document.getElementById('modalRetirada')?.addEventListener('click', function(e) {
    if (e.target === this) {
        fecharModalRetirada();
    }
});
</script>

<!-- ============================================================
     MODAL BONUS
     ============================================================ -->
<div id="modalBonus" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2 class="i18n" data-key="bonus_title">Resgatar bônus</h2>
        <div id="alerta-bonus"></div>
        <form id="formbonus" action="php/bonus.php">
            <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_bonus'] ?? '' ?>">
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-dollar-sign"></i>
                    <input type="text" name="valorbonus" value="R$ <?php echo number_format($saldo_bonus ?? 0,2,',',''); ?>" readonly>
                </div>
            </div>
            <input type="submit" id="subBonus" class="submit-button bonus" value="Resgatar">
        </form>
    </div>
</div>

<!-- ============================================================
     MODAL DADOS / UPDATE DATA
     ============================================================ -->
<div id="modalDados" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2 class="i18n" data-key="update_data_title">Atualizar dados</h2>
        <div id="alerta-dados"></div>
        <form id="formdados" action="php/dados.php">
            <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_dados'] ?? '' ?>">
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-user"></i>
                    <input type="text" value="<?= ucwords(strtolower($nome)); ?>" readonly>
                </div>
            </div>
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-id-card"></i>
                    <input type="text" value="CPF: <?= $cpf ?>" readonly>
                </div>
            </div>
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-envelope"></i>
                    <input type="text" name="emaildados" value="<?= $email ?>" placeholder="Email">
                </div>
            </div>
            <input type="submit" id="subDados" class="submit-button dados" value="Atualizar">
        </form>
    </div>
</div>

<!-- ============================================================
     MODAL SENHA / UPDATE PASSWORD
     ============================================================ -->
<div id="modalSenha" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2 class="i18n" data-key="update_pass_title">Atualizar Senha</h2>
        <div id="alerta-senha"></div>
        <form id="formsenha" action="php/senha.php">
            <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_senha'] ?? '' ?>">
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-lock"></i>
                    <input type="password" name="senha" placeholder="Senha com no mínimo 8 caracteres" id="senhaInput">
                </div>
            </div>
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-lock"></i>
                    <input type="password" name="confirmasenha" placeholder="Confirme a senha" id="senhaConfInput">
                </div>
            </div>
            <input type="submit" id="subSenha" class="submit-button senha" value="Atualizar">
        </form>
    </div>
</div>

<!-- ============================================================
     MODAL CONTATO / CONTACT
     ============================================================ -->
<div id="modalContato" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2 class="i18n" data-key="contact_title">Contato</h2>
        <div id="alerta-contato"></div>
        <form id="formcontato" action="php/contato.php">
            <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_contato'] ?? '' ?>">
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-user"></i>
                    <input type="text" id="nomeContato" name="nome" placeholder="Nome completo" value="<?= $nome ?>">
                </div>
            </div>
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-envelope"></i>
                    <input type="text" id="emailContato" name="email" placeholder="Email" value="<?= $email ?>">
                </div>
            </div>
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-comment"></i>
                    <input type="text" id="assunto" name="assunto" placeholder="Assunto">
                </div>
            </div>
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-pencil-alt"></i>
                    <textarea id="mensagem" name="mensagem" rows="4" style="height:60px;resize:none;" placeholder="Mensagem"></textarea>
                </div>
            </div>
            <input type="submit" id="subContato" class="submit-button contato" value="Enviar">
        </form>
    </div>
</div>

<!-- ============================================================
     APP BANNER
     ============================================================ -->
<div class="app-banner" id="appBanner">
    <span class="app-banner-text">
        📱 <span class="i18n" data-key="banner_download_text">Baixe o aplicativo e ganhe pontos</span>
    </span>
    <button class="app-banner-btn"><span class="i18n" data-key="banner_download_btn">Download</span></button>
    <span class="app-banner-close" onclick="this.parentElement.style.display='none'">✕</span>
</div>

<!-- ============================================================
     TOP BAR
     ============================================================ -->
<div class="top-bar">
    <div class="container">
        <div class="logo">
            <img src="../imagens/<?= $Logo ?>">
        </div>
        <div class="balance-header">
            <div class="balance-display">
                <div class="main-balance">
                    <span class="balance-label">R$</span>
                    <span class="balance-amount"><?php echo number_format($saldo,2,',',''); ?></span>
                </div>
                <div class="bonus-balance">
                    <span class="bonus-label">B$</span>
                    <span class="bonus-amount"><?php echo number_format($saldo_bonus ?? 0,2,',',''); ?></span>
                </div>
            </div>
            <button class="btn-pix-deposit modalDeposito" aria-label="Depositar"></button>
            <button class="btn-notification"><i class="fas fa-bell"></i></button>
            <button class="btn-message"><i class="fas fa-comment"></i></button>
        </div>
    </div>
</div>

<!-- ============================================================
     BONUS USA BAR
     ============================================================ -->
<div id="bonus-usa" class="bonus-usa" style="display:none;">
    <div class="bonus-usa-text"><?= $textoFinal ?></div>
    <button class="bonus-usa-btn" id="btnClaimBonusUsa">Claim</button>
</div>




<!-- ============================================================
     SLIDER
     ============================================================ -->
<div class="slider-wrapper">
    <div class="slider-container">
        <div class="slides" id="slides">
            <div class="slide"><img src="../imagens/<?= $slider1 ?>"></div>
            <div class="slide"><img src="../imagens/<?= $slider2 ?>"></div>
            <div class="slide"><img src="../imagens/<?= $slider3 ?>"></div>
        </div>
    </div>
    <div class="dots" id="dots">
        <span class="dot active" data-index="0"></span>
        <span class="dot" data-index="1"></span>
        <span class="dot" data-index="2"></span>
    </div>
</div>

<!-- ============================================================
     BUSCA / SEARCH
     ============================================================ -->
<div class="busca-container">
    <form id="form-busca" onsubmit="return false;">
        <div class="busca-input-icon">
            <i class="fas fa-search"></i>
<input type="text" id="input-busca" name="busca"
       placeholder="Pesquisar um jogo de cassino..."
       class="busca-input" autocomplete="off">

        </div>
    </form>
    <div id="resultado-busca" class="busca-resultado"></div>
</div>
<!-- ============================================================
     4. HTML DO TICKER - ADICIONE ONDE QUISER EXIBIR
     ============================================================ -->
<?php if (!empty($ticker_partidas)): ?>
<div class="ticker-ao-vivo">
    <div class="ticker-strip" id="tickerStrip">
        <?php
        for ($loop = 0; $loop < 1; $loop++):
            foreach ($ticker_partidas as $p):
                $badge_class = $p['status'] ?? 'live';
        ?>
        <div class="ticker-card" data-partida-id="<?= $p['id'] ?>">
            <div class="ticker-card-header">
                <span class="ticker-flag"><?= htmlspecialchars($p['flag'] ?? '⚽') ?></span>
                <span class="ticker-league"><?= htmlspecialchars($p['liga'] ?? '') ?></span>
            </div>
            
            <div class="ticker-card-body">
                <div class="ticker-time-row">
                    <div style="display: flex; align-items: center; gap: 10px;">
                        <span class="ticker-time"><?= htmlspecialchars($p['tempo'] ?? '') ?></span>
                        <span class="ticker-badge <?= $badge_class ?>">
                            <?= $badge_class === 'live' ? '🔥 AO VIVO' : ($badge_class === 'upcoming' ? 'EM BREVE' : 'ENCERRADO') ?>
                        </span>
                    </div>
                </div>
                
                <div class="ticker-teams">
                    <div class="ticker-team-row">
                        <div class="ticker-team-info">
                            <span class="ticker-team-icon">🏠</span>
                            <span class="ticker-team-name"><?= htmlspecialchars($p['time_casa'] ?? '') ?></span>
                            <?php if (!empty($p['cartao_casa'])): ?>
                            <span class="ticker-card-indicator <?= $p['cartao_casa'] ?>"></span>
                            <?php endif; ?>
                        </div>
                        <span class="ticker-team-score"><?= $p['placar_casa'] ?? 0 ?></span>
                    </div>
                    <div class="ticker-team-row">
                        <div class="ticker-team-info">
                            <span class="ticker-team-icon">✈️</span>
                            <span class="ticker-team-name"><?= htmlspecialchars($p['time_fora'] ?? '') ?></span>
                            <?php if (!empty($p['cartao_fora'])): ?>
                            <span class="ticker-card-indicator <?= $p['cartao_fora'] ?>"></span>
                            <?php endif; ?>
                        </div>
                        <span class="ticker-team-score"><?= $p['placar_fora'] ?? 0 ?></span>
                    </div>
                </div>
                
                <div class="ticker-odds">
                    <div class="ticker-odd" 
                         onclick="abrirModalAposta(<?= $p['id'] ?>, '<?= htmlspecialchars($p['flag'] ?? '') ?>', '<?= htmlspecialchars($p['liga'] ?? '') ?>', '<?= htmlspecialchars($p['time_casa'] ?? '') ?>', '<?= htmlspecialchars($p['time_fora'] ?? '') ?>', '<?= htmlspecialchars($p['odd_label_1'] ?? '') ?>', <?= $p['odd_valor_1'] ?? 1.50 ?>)">
                        <span class="ticker-odd-label"><?= htmlspecialchars($p['odd_label_1'] ?? 'Mais de 2.5') ?></span>
                        <span class="ticker-odd-value"><?= number_format($p['odd_valor_1'] ?? 1.50, 2) ?></span>
                    </div>
                    <div class="ticker-odd"
                         onclick="abrirModalAposta(<?= $p['id'] ?>, '<?= htmlspecialchars($p['flag'] ?? '') ?>', '<?= htmlspecialchars($p['liga'] ?? '') ?>', '<?= htmlspecialchars($p['time_casa'] ?? '') ?>', '<?= htmlspecialchars($p['time_fora'] ?? '') ?>', '<?= htmlspecialchars($p['odd_label_2'] ?? '') ?>', <?= $p['odd_valor_2'] ?? 2.00 ?>)">
                        <span class="ticker-odd-label"><?= htmlspecialchars($p['odd_label_2'] ?? 'Menos de 2.5') ?></span>
                        <span class="ticker-odd-value"><?= number_format($p['odd_valor_2'] ?? 2.00, 2) ?></span>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
        <?php endfor; ?>
    </div>
</div>
<?php endif; ?>

<!-- ============================================================
     5. BOTÃO MINHAS APOSTAS FLUTUANTE
     ============================================================ -->
<button class="btn-minhas-apostas" id="btnMinhasApostas" onclick="abrirMinhasApostas()">
    <i class="fas fa-receipt"></i>
    <span id="apostasTexto">Minhas Apostas</span>
    <span class="badge" id="apostasCount"><?= $apostas_pendentes ?? 0 ?></span>
</button>

<!-- ============================================================
     6. MODAL DE APOSTA
     ============================================================ -->
<div class="modal-aposta-overlay" id="modalApostaOverlay" onclick="fecharModalAposta()"></div>
<div class="modal-aposta" id="modalAposta">
    <div class="aposta-header">
        <div class="aposta-header-title">
            <i class="fas fa-ticket-alt"></i>
            <span>Bilhete de Aposta</span>
        </div>
        <button class="aposta-close-btn" onclick="fecharModalAposta()">
            <i class="fas fa-times"></i>
        </button>
    </div>
    
    <div class="aposta-content">
        <div class="aposta-alerta" id="apostaAlerta"></div>
        
        <!-- Seleção da Aposta -->
        <div class="aposta-selecao">
            <button class="aposta-remover" onclick="fecharModalAposta()">
                <i class="fas fa-times"></i>
            </button>
            <div class="aposta-partida">
                <span class="aposta-partida-flag" id="apostaFlag"></span>
                <div class="aposta-partida-info">
                    <div class="aposta-partida-liga" id="apostaLiga"></div>
                    <div class="aposta-partida-times" id="apostaPartida"></div>
                </div>
            </div>
            <div class="aposta-tipo">
                <span class="aposta-tipo-label" id="apostaTipo"></span>
                <span class="aposta-tipo-odd" id="apostaOdd"></span>
            </div>
        </div>
        
        <!-- Input de Valor -->
        <div class="aposta-valor-section">
            <label class="aposta-valor-label">Valor da aposta</label>
            <div class="aposta-valor-input-container">
                <span class="aposta-valor-prefix">R$</span>
                <input type="number" class="aposta-valor-input" id="apostaValorInput" 
                       placeholder="0,00" min="1" step="0.01" oninput="calcularRetorno()">
            </div>
        </div>
        
        <!-- Valores Rápidos -->
        <div class="aposta-valores-rapidos">
            <button class="aposta-valor-btn" onclick="setValorAposta(10)">R$ 10</button>
            <button class="aposta-valor-btn" onclick="setValorAposta(25)">R$ 25</button>
            <button class="aposta-valor-btn" onclick="setValorAposta(50)">R$ 50</button>
            <button class="aposta-valor-btn" onclick="setValorAposta(100)">R$ 100</button>
        </div>
        
        <!-- Resumo -->
        <div class="aposta-resumo">
            <div class="aposta-resumo-row">
                <span class="aposta-resumo-label">Odd</span>
                <span class="aposta-resumo-value" id="resumoOdd">0.00</span>
            </div>
            <div class="aposta-resumo-row">
                <span class="aposta-resumo-label">Valor apostado</span>
                <span class="aposta-resumo-value" id="resumoValor">R$ 0,00</span>
            </div>
            <div class="aposta-resumo-row">
                <span class="aposta-resumo-label">Retorno potencial</span>
                <span class="aposta-resumo-value highlight" id="resumoRetorno">R$ 0,00</span>
            </div>
        </div>
        
        <!-- Saldo -->
        <div class="aposta-saldo">
            <span class="aposta-saldo-label">Saldo disponível</span>
            <span class="aposta-saldo-value">R$ <?= number_format($saldo ?? 0, 2, ',', '.') ?></span>
        </div>
        
        <!-- Botão Apostar -->
        <button class="btn-fazer-aposta" id="btnFazerAposta" onclick="fazerAposta()" disabled>
            Fazer Aposta
        </button>
    </div>
</div>

<!-- ============================================================
     7. MODAL MINHAS APOSTAS
     ============================================================ -->
<div class="modal-aposta-overlay" id="modalMinhasApostasOverlay" onclick="fecharMinhasApostas()"></div>
<div class="modal-minhas-apostas" id="modalMinhasApostas">
    <div class="minhas-apostas-header">
        <div class="aposta-header-title">
            <i class="fas fa-receipt"></i>
            <span>Minhas Apostas</span>
        </div>
        <button class="aposta-close-btn" onclick="fecharMinhasApostas()">
            <i class="fas fa-times"></i>
        </button>
    </div>
    
    <div class="minhas-apostas-content" id="minhasApostasContent">
        <!-- Carregado via AJAX -->
    </div>
</div>

<!-- ============================================================
     8. JAVASCRIPT
     ============================================================ -->
<script>
// Variáveis globais da aposta atual
let apostaAtual = {
    partidaId: null,
    flag: '',
    liga: '',
    timeCasa: '',
    timeFora: '',
    tipoAposta: '',
    odd: 0
};

const saldoUsuario = <?= $saldo ?? 0 ?>;

// Abrir modal de aposta
function abrirModalAposta(partidaId, flag, liga, timeCasa, timeFora, tipoAposta, odd) {
    apostaAtual = { partidaId, flag, liga, timeCasa, timeFora, tipoAposta, odd };
    
    document.getElementById('apostaFlag').textContent = flag;
    document.getElementById('apostaLiga').textContent = liga;
    document.getElementById('apostaPartida').textContent = `${timeCasa} x ${timeFora}`;
    document.getElementById('apostaTipo').textContent = tipoAposta;
    document.getElementById('apostaOdd').textContent = odd.toFixed(2);
    document.getElementById('resumoOdd').textContent = odd.toFixed(2);
    document.getElementById('apostaValorInput').value = '';
    document.getElementById('resumoValor').textContent = 'R$ 0,00';
    document.getElementById('resumoRetorno').textContent = 'R$ 0,00';
    document.getElementById('btnFazerAposta').disabled = true;
    document.getElementById('apostaAlerta').classList.remove('show');
    
    document.getElementById('modalApostaOverlay').classList.add('show');
    document.getElementById('modalAposta').classList.add('show');
    document.body.style.overflow = 'hidden';
}

// Fechar modal de aposta
function fecharModalAposta() {
    document.getElementById('modalApostaOverlay').classList.remove('show');
    document.getElementById('modalAposta').classList.remove('show');
    document.body.style.overflow = '';
}

// Definir valor rápido
function setValorAposta(valor) {
    document.getElementById('apostaValorInput').value = valor;
    calcularRetorno();
}

// Calcular retorno potencial
function calcularRetorno() {
    const valor = parseFloat(document.getElementById('apostaValorInput').value) || 0;
    const odd = apostaAtual.odd;
    const retorno = valor * odd;
    
    document.getElementById('resumoValor').textContent = `R$ ${valor.toFixed(2).replace('.', ',')}`;
    document.getElementById('resumoRetorno').textContent = `R$ ${retorno.toFixed(2).replace('.', ',')}`;
    
    const btn = document.getElementById('btnFazerAposta');
    btn.disabled = valor <= 0 || valor > saldoUsuario;
}

// Fazer aposta
function fazerAposta() {
    const valor = parseFloat(document.getElementById('apostaValorInput').value) || 0;
    const alerta = document.getElementById('apostaAlerta');
    const btn = document.getElementById('btnFazerAposta');
    
    if (valor <= 0) {
        alerta.className = 'aposta-alerta error show';
        alerta.textContent = 'Digite um valor válido para apostar.';
        return;
    }
    
    if (valor > saldoUsuario) {
        alerta.className = 'aposta-alerta error show';
        alerta.textContent = 'Saldo insuficiente para esta aposta.';
        return;
    }
    
    btn.disabled = true;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processando...';
    
    fetch('php/fazer_aposta.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({
            partida_id: apostaAtual.partidaId,
            tipo_aposta: apostaAtual.tipoAposta,
            odd: apostaAtual.odd,
            valor: valor,
            descricao_partida: `${apostaAtual.timeCasa} x ${apostaAtual.timeFora}`,
            descricao_aposta: apostaAtual.tipoAposta
        })
    })
    .then(r => r.json())
    .then(data => {
        if (data.success) {
            alerta.className = 'aposta-alerta success show';
            alerta.textContent = '✓ Aposta realizada com sucesso!';
            
            // Atualiza contador
            const count = document.getElementById('apostasCount');
            count.textContent = parseInt(count.textContent) + 1;
            
            setTimeout(() => {
                fecharModalAposta();
                location.reload(); // Recarrega para atualizar saldo
            }, 1500);
        } else {
            alerta.className = 'aposta-alerta error show';
            alerta.textContent = data.message || 'Erro ao fazer aposta.';
            btn.disabled = false;
            btn.innerHTML = 'Fazer Aposta';
        }
    })
    .catch(() => {
        alerta.className = 'aposta-alerta error show';
        alerta.textContent = 'Erro de conexão. Tente novamente.';
        btn.disabled = false;
        btn.innerHTML = 'Fazer Aposta';
    });
}

// Abrir minhas apostas
function abrirMinhasApostas() {
    document.getElementById('modalMinhasApostasOverlay').classList.add('show');
    document.getElementById('modalMinhasApostas').classList.add('show');
    document.body.style.overflow = 'hidden';
    
    carregarMinhasApostas();
}

// Fechar minhas apostas
function fecharMinhasApostas() {
    document.getElementById('modalMinhasApostasOverlay').classList.remove('show');
    document.getElementById('modalMinhasApostas').classList.remove('show');
    document.body.style.overflow = '';
}

// Carregar minhas apostas
function carregarMinhasApostas() {
    const container = document.getElementById('minhasApostasContent');
    container.innerHTML = '<div style="text-align:center;padding:40px;"><i class="fas fa-spinner fa-spin" style="font-size:24px;color:#6b7280;"></i></div>';
    
    fetch('php/minhas_apostas.php')
    .then(r => r.json())
    .then(data => {
        if (data.apostas && data.apostas.length > 0) {
            let html = '';
            data.apostas.forEach(a => {
                html += `
                <div class="aposta-card ${a.status}">
                    <div class="aposta-card-header">
                        <span class="aposta-card-partida">${a.descricao_partida}</span>
                        <span class="aposta-card-status ${a.status}">${a.status.toUpperCase()}</span>
                    </div>
                    <div class="aposta-card-tipo">${a.descricao_aposta} @ ${parseFloat(a.odd_selecionada).toFixed(2)}</div>
                    <div class="aposta-card-footer">
                        <div class="aposta-card-valores">
                            <div class="aposta-card-valor-item">
                                <div class="aposta-card-valor-label">Apostado</div>
                                <div class="aposta-card-valor-num">R$ ${parseFloat(a.valor_apostado).toFixed(2).replace('.', ',')}</div>
                            </div>
                            <div class="aposta-card-valor-item">
                                <div class="aposta-card-valor-label">Retorno</div>
                                <div class="aposta-card-valor-num green">R$ ${parseFloat(a.retorno_potencial).toFixed(2).replace('.', ',')}</div>
                            </div>
                        </div>
                    </div>
                </div>
                `;
            });
            container.innerHTML = html;
        } else {
            container.innerHTML = `
            <div class="aposta-vazia">
                <i class="fas fa-receipt"></i>
                <p>Você ainda não fez nenhuma aposta.</p>
            </div>
            `;
        }
    })
    .catch(() => {
        container.innerHTML = '<div class="aposta-vazia"><p>Erro ao carregar apostas.</p></div>';
    });
}

// Ajusta velocidade do ticker
(function() {
    const strip = document.getElementById('tickerStrip');
    if (!strip) return;
    requestAnimationFrame(() => {
        const totalWidth = strip.scrollWidth / 2;
        strip.style.animationDuration = (totalWidth / 50) + 's';
    });
})();
</script>





<!-- ============================================================
     CARROSSEL GANHADORES / WINNERS
     ============================================================ -->
<div class="ganhos-container">
    <div class="ganhos-fixo">
        <i class="fas fa-trophy"></i>
        <span class="i18n" data-key="winners_title">MAIORES<br>GANHOS<br>DE HOJE</span>
    </div>
    <div class="ganhos-rolando">
        <div class="ganhos-slider" id="ganhos-slider">
            <?php include 'funcoes/carrossel-ganhadores.php'; ?>
        </div>
    </div>
</div>

<!-- ============================================================
     CONTENT BOX (pages)
     ============================================================ -->
<div class="content-box">
    <?php
    $pagina = $_GET["pagina"] ?? null;
    switch ($pagina) {
        case 'extrato':   include "extrato.php"; break;
        case 'afiliado':  include "afiliado.php"; break;
        case 'jbicho':   include "jbicho.php"; break;
        default:          include "dashboard.php"; break;
    }
    ?>
</div>

<!-- ============================================================
     AO VIVO / LIVE RESULTS
     ============================================================ -->
<div class="aovivo-resultados">
    <span class="aovivo-titulo">
        <span class="online-dot-red"></span>
        <span class="i18n" data-key="live_results">Resultados ao Vivo</span>
    </span>
    <div class="aovivo-resultado-container" id="aovivo-container"></div>
    <?php include 'funcoes/aovivo.php'; ?>
</div>

<!-- ============================================================
     MODAL SLOTS (game iframe)
     ============================================================ -->
<div id="modal" class="modal-slots">
    <div class="modal-slots-content">
        <button class="close-slots-modal" onclick="closeGameModal()"><i class="fas fa-times"></i></button>
        <iframe id="iframe" width="100%" height="100%" frameborder="0"></iframe>
    </div>
</div>

<!-- ============================================================
     FOOTER
     ============================================================ -->
<div class="footer">
    <div class="container-footer">
        <div class="footer-column">
            <img src="../imagens/<?= $Logo ?>">
        </div>
        <div class="footer-column">
            <h4 class="i18n" data-key="footer_about">Sobre Nós</h4>
            <ul>
                <li><a id="termo-condicao" class="i18n" data-key="footer_terms">Termos e condições</a></li>
                <li><a id="termo-privacidade" class="i18n" data-key="footer_privacy">Privacidade</a></li>
                <li><a id="termo-cookies" class="i18n" data-key="footer_cookies">Política de cookies</a></li>
                <li><a id="termo-18anos" class="i18n" data-key="footer_18plus">18 anos ou mais</a></li>
                <li><a id="termo-jogo-responsavel" class="i18n" data-key="footer_responsible">Jogo Responsável</a></li>
            </ul>
        </div>
        <div class="footer-column">
            <h4 class="i18n" data-key="footer_contact">Contato</h4>
            <ul>
                <li><a class="modalContato i18n" data-key="footer_talk">Fale Conosco</a></li>
            </ul>
        </div>
        <div class="footer-column">
            <h4 class="i18n" data-key="footer_payment">Pagamento</h4>
            <img class="pix-logo" src="../imagens/logopix.png">
        </div>
        <div class="footer-column">
            <h4 class="i18n" data-key="footer_follow">Siga-nos</h4>
            <div class="social-icons">
                <a href="<?= $Instagram ?>" target="_blank"><i class="fab fa-instagram"></i></a>
                <a href="<?= $Telegram ?>" target="_blank"><i class="fab fa-telegram-plane"></i></a>
            </div>
        </div>
    </div>

    <div class="footer-line"></div>

    <div class="footer-text" id="footerText">
        <span class="i18n" data-key="footer_disclaimer">Jogue com responsabilidade, Apostar pode ser viciante!</span><br><br>
        <div id="extraContent" style="display:none;">
            <span class="i18n" data-key="footer_disclaimer_extra">Nossa Plataforma não promove suas atividades para menores de 18 anos.</span>
        </div>
        <button id="toggleButton" class="ver-mais-btn"><span class="i18n" data-key="footer_see_more">Ver mais</span></button>
    </div>

    <div class="footer-line"></div>
    <div class="footer-centered-img">
        <img class="selo-img" src="../imagens/logosigap.png">
    </div>
    <div class="footer-line"></div>

    <div class="footer-bottom">
        <p>
            <strong class="i18n" data-key="footer_support">Suporte</strong> suporte@<?= $Site ?>
            <span>|</span>
            <strong class="i18n" data-key="footer_legal">Jurídico</strong> juridico@<?= $Site ?>
            <span>|</span>
            <strong class="i18n" data-key="footer_partners">Parceiros</strong> parceiros@<?= $Site ?>
        </p>
        <p>© 2025 <?= $NomeSite ?>. <span class="i18n" data-key="footer_rights">Todos os direitos reservados.</span></p>
    </div>
</div>

<!-- ============================================================
     BOTTOM NAVIGATION
     ============================================================ -->
<nav class="bottom-nav">
    <a href="#" class="bottom-nav-item" id="bottomMenuBtn">
        <i class="fas fa-bars icon"></i>
        <span class="label i18n" data-key="nav_menu">Menu</span>
    </a>
    <a href="/dashboard/" class="bottom-nav-item active">
        <i class="fas fa-home icon"></i>
        <span class="label i18n" data-key="nav_home">Home</span>
    </a>
    <a href="/dashboard/bingo/main.php" class="bottom-nav-item">
        <i class="fas fa-th icon"></i>
        <span class="label i18n" data-key="nav_bingo">BINGO</span>
    </a>
    <a href="#" class="bottom-nav-item center modalDeposito">
        <img src="https://i.postimg.cc/sxmqH7Cw/befunky-2026-0-5-23-30-40.png" alt="" class="center-nav-icon">
    </a>
<a href="/dashboard/?pagina=jbicho" class="bottom-nav-item">
    <i class="fas fa-paw icon"></i>
    <span class="label i18n" data-key="nav_jbicho">JBICHO</span>
</a>
    <a href="#" class="bottom-nav-item modalContato">
        <i class="fas fa-headset icon"></i>
        <span class="label i18n" data-key="nav_support">Suporte</span>
    </a>
    <a href="#" class="bottom-nav-item" id="btnAbrirPerfil">
        <i class="fas fa-user icon"></i>
        <span class="label i18n" data-key="nav_profile">Perfil</span>
    </a>
</nav>

<!-- ============================================================
     MODAL IDIOMA / LANGUAGE SELECTOR
     ============================================================ -->
<div id="modalIdioma" class="modal-idioma">
    <div class="idioma-box">
        <button onclick="selecionarIdioma('pt')" class="idioma-item">
            <img src="https://flagcdn.com/w40/br.png">
            <span>Português (Brasil)</span>
        </button>
        <button onclick="selecionarIdioma('en')" class="idioma-item">
            <img src="https://flagcdn.com/w40/us.png">
            <span>English (USA)</span>
        </button>
    </div>
</div>

<!-- ============================================================
     SCRIPTS
     ============================================================ -->
<script>
// ============================================================
// i18n DICTIONARY
// ============================================================
const i18n = {
    pt: {
        nav_menu:"Menu", nav_games:"Jogos", nav_statement:"Extrato",
        nav_bingo:"BINGO",
        nav_update_data:"Atualizar dados", nav_update_pass:"Atualizar senha",
        nav_affiliate:"JBICHO", nav_support:"Suporte", nav_logout:"Sair",
        nav_home:"Home", nav_profile:"Perfil",
        profile_email:"Email", profile_id:"ID",
        profile_my_account:"Minha conta", profile_quick_actions:"Ações Rápidas",
        action_deposit:"Depósito", action_withdraw:"Saque",
        action_bingo:"Bingo",
        action_game_history:"Histórico", action_transactions:"Transações",
        action_my_items:"Meus Itens", action_language:"Linguagem",
        deposit_title:"Depositar", deposit_subtitle:"Adicione saldo à sua conta",
        deposit_amount_label:"Valor a ser depositado:",
        deposit_no_bonus:"Não quero receber nenhum bônus",
        deposit_generate_pix:"Gerar PIX",
        deposit_min_error:"⚠️ O valor mínimo é R$ {min}",
        deposit_max_error:"⚠️ O valor máximo é R$ 10.000,00",
        deposit_processing:"Processando...",
        withdrawal_title:"Retirada", withdrawal_balance:"Seu saldo para retirada é de",
        withdrawal_placeholder:"Valor da retirada", withdrawal_holder:"Titular",
        withdrawal_pix_key:"Chave PIX CPF",
        withdrawal_min:"A retirada mínima é de", withdrawal_max:"A retirada máxima é de",
        withdrawal_submit:"Retirar",
        bonus_title:"Resgatar bônus", bonus_submit:"Resgatar",
        update_data_title:"Atualizar dados", update_data_submit:"Atualizar dados",
        update_pass_title:"Atualizar Senha",
        update_pass_placeholder:"Senha com no mínimo 8 caracteres",
        update_pass_confirm:"Confirme a senha", update_pass_submit:"Atualizar",
        contact_title:"Contato", contact_name:"Nome completo",
        contact_email:"Email", contact_subject:"Assunto",
        contact_message:"Mensagem", contact_submit:"Enviar",
        banner_download_text:"Baixe o aplicativo e ganhe pontos",
        banner_download_btn:"Download",
        search_placeholder:"Pesquisar um jogo de cassino...",
        winners_title:"MAIORES<br>GANHOS<br>DE HOJE",
        live_results:"Resultados ao Vivo",
        footer_about:"Sobre Nós", footer_terms:"Termos e condições",
        footer_privacy:"Privacidade", footer_cookies:"Política de cookies",
        footer_18plus:"18 anos ou mais", footer_responsible:"Jogo Responsável",
        footer_contact:"Contato", footer_talk:"Fale Conosco",
        footer_payment:"Pagamento", footer_follow:"Siga-nos",
        footer_disclaimer:"Jogue com responsabilidade, Apostar pode ser viciante!",
        footer_disclaimer_extra:"Nossa Plataforma não promove suas atividades para menores de 18 anos.",
        footer_see_more:"Ver mais", footer_support:"Suporte",
        footer_legal:"Jurídico", footer_partners:"Parceiros",
        footer_rights:"Todos os direitos reservados."
    },
    en: {
        nav_menu:"Menu", nav_games:"Games", nav_statement:"Statement",
        nav_bingo:"BINGO",
        nav_update_data:"Update info", nav_update_pass:"Update password",
        nav_affiliate:"Affiliate", nav_support:"Support", nav_logout:"Logout",
        nav_home:"Home", nav_profile:"Profile",
        profile_email:"Email", profile_id:"ID",
        profile_my_account:"My Account", profile_quick_actions:"Quick Actions",
        action_deposit:"Deposit", action_withdraw:"Withdraw",
        action_bingo:"Bingo",
        action_game_history:"Game History", action_transactions:"Transactions",
        action_my_items:"My Items", action_language:"Language",
        deposit_title:"Deposit", deposit_subtitle:"Add funds to your account",
        deposit_amount_label:"Amount to deposit:",
        deposit_no_bonus:"I don't want to receive any bonus",
        deposit_generate_pix:"Generate PIX",
        deposit_min_error:"⚠️ The minimum amount is R$ {min}",
        deposit_max_error:"⚠️ The maximum amount is R$ 10,000.00",
        deposit_processing:"Processing...",
        withdrawal_title:"Withdrawal", withdrawal_balance:"Your balance available for withdrawal is",
        withdrawal_placeholder:"Withdrawal amount", withdrawal_holder:"Account holder",
        withdrawal_pix_key:"PIX Key CPF",
        withdrawal_min:"The minimum withdrawal is", withdrawal_max:"The maximum withdrawal is",
        withdrawal_submit:"Withdraw",
        bonus_title:"Redeem Bonus", bonus_submit:"Redeem",
        update_data_title:"Update Info", update_data_submit:"Update Info",
        update_pass_title:"Update Password",
        update_pass_placeholder:"Password with at least 8 characters",
        update_pass_confirm:"Confirm password", update_pass_submit:"Update",
        contact_title:"Contact", contact_name:"Full name",
        contact_email:"Email", contact_subject:"Subject",
        contact_message:"Message", contact_submit:"Send",
        banner_download_text:"Download the app and earn points",
        banner_download_btn:"Download",
        search_placeholder:"Search for a casino game...",
        winners_title:"BIGGEST<br>WINS<br>TODAY",
        live_results:"Live Results",
        footer_about:"About Us", footer_terms:"Terms & Conditions",
        footer_privacy:"Privacy", footer_cookies:"Cookie Policy",
        footer_18plus:"18+ Only", footer_responsible:"Responsible Gaming",
        footer_contact:"Contact", footer_talk:"Talk to Us",
        footer_payment:"Payment", footer_follow:"Follow Us",
        footer_disclaimer:"Play responsibly. Gambling can be addictive!",
        footer_disclaimer_extra:"Our Platform does not promote its activities to anyone under the age of 18.",
        footer_see_more:"See more", footer_support:"Support",
        footer_legal:"Legal", footer_partners:"Partners",
        footer_rights:"All rights reserved."
    }
};

function applyLanguage(lang) {
    const dict = i18n[lang] || i18n['pt'];
    document.querySelectorAll('.i18n[data-key]').forEach(el => {
        const key = el.getAttribute('data-key');
        if (dict[key] !== undefined) el.innerHTML = dict[key];
    });
    const searchInput = document.getElementById('input-busca');
    if (searchInput) searchInput.placeholder = dict.search_placeholder;
    const retInput = document.getElementById('retirada');
    if (retInput) retInput.placeholder = dict.withdrawal_placeholder;
    const holderInput = document.getElementById('withdrawalHolderInput');
    if (holderInput) holderInput.value = dict.withdrawal_holder + ': <?= ucwords(strtolower($nome)); ?>';
    const pixInput = document.getElementById('withdrawalPixInput');
    if (pixInput) pixInput.value = dict.withdrawal_pix_key + ': <?= $cpf ?>';
    const subRet = document.getElementById('subRetirada');
    if (subRet) subRet.value = dict.withdrawal_submit;
    const subBonus = document.getElementById('subBonus');
    if (subBonus) subBonus.value = dict.bonus_submit;
    const subDados = document.getElementById('subDados');
    if (subDados) subDados.value = dict.update_data_submit;
    const senhaInput = document.getElementById('senhaInput');
    if (senhaInput) senhaInput.placeholder = dict.update_pass_placeholder;
    const senhaConfInput = document.getElementById('senhaConfInput');
    if (senhaConfInput) senhaConfInput.placeholder = dict.update_pass_confirm;
    const subSenha = document.getElementById('subSenha');
    if (subSenha) subSenha.value = dict.update_pass_submit;
    const nomeContato = document.getElementById('nomeContato');
    if (nomeContato) nomeContato.placeholder = dict.contact_name;
    const emailContato = document.getElementById('emailContato');
    if (emailContato) emailContato.placeholder = dict.contact_email;
    const assunto = document.getElementById('assunto');
    if (assunto) assunto.placeholder = dict.contact_subject;
    const mensagem = document.getElementById('mensagem');
    if (mensagem) mensagem.placeholder = dict.contact_message;
    const subContato = document.getElementById('subContato');
    if (subContato) subContato.value = dict.contact_submit;
    document.documentElement.setAttribute('lang', lang === 'en' ? 'en-US' : 'pt-BR');
}

function toggleIdioma() {
    document.getElementById('modalIdioma').classList.toggle('show');
}
function selecionarIdioma(lang) {
    localStorage.setItem('idioma', lang);
    document.getElementById('modalIdioma').classList.remove('show');
    applyLanguage(lang);
    const bonus = document.getElementById('bonus-usa');
    if (bonus) bonus.style.display = (lang === 'en') ? 'flex' : 'none';
}

// ============================================================
// DEPOSIT MODAL
// ============================================================
function abrirModalDeposito() {
    document.getElementById('modalDeposito').classList.add('show');
    document.body.style.overflow = 'hidden';
}
function fecharModalDeposito() {
    document.getElementById('modalDeposito').classList.remove('show');
    document.body.style.overflow = '';
}
function selecionarValor(valor) {
    document.querySelectorAll('.valor-btn').forEach(btn => btn.classList.remove('valor-selected'));
    event.target.closest('.valor-btn').classList.add('valor-selected');
    document.getElementById('deposito').value = valor;
}
function aumentarValor() {
    const input = document.getElementById('deposito');
    let valor = parseInt(input.value) || 50;
    if (valor < 10000) { valor += 10; input.value = valor; atualizarSelecaoValor(valor); }
}
function diminuirValor() {
    const input = document.getElementById('deposito');
    const minimo = <?php echo $ValorDeposito; ?>;
    let valor = parseInt(input.value) || 50;
    if (valor > minimo) { valor -= 10; input.value = valor; atualizarSelecaoValor(valor); }
}
function atualizarSelecaoValor(valor) {
    document.querySelectorAll('.valor-btn').forEach(btn => {
        btn.classList.toggle('valor-selected', parseInt(btn.getAttribute('data-valor')) === valor);
    });
}

// ============================================================
// PROFILE MODAL
// ============================================================
function openPerfilModal() {
    document.getElementById('modalPerfil').classList.add('show');
    document.body.style.overflow = 'hidden';
}
function closePerfilModal() {
    document.getElementById('modalPerfil').classList.remove('show');
    document.body.style.overflow = '';
}
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(
        () => alert('Copied: ' + text),
        () => alert('Copy failed')
    );
}
function openMinhaContaPage() {
    window.location.href = '/dashboard/?pagina=minha-conta';
}

// ============================================================
// DOM READY
// ============================================================
document.addEventListener('DOMContentLoaded', function() {
    
    const savedLang = localStorage.getItem('idioma') || 'pt';
    applyLanguage(savedLang);

    const bonus = document.getElementById('bonus-usa');
    if (bonus) bonus.style.display = (savedLang === 'en') ? 'flex' : 'none';

    const modalIdioma = document.getElementById('modalIdioma');
    if (modalIdioma) {
        modalIdioma.addEventListener('click', function(e) {
            if (e.target === this) this.classList.remove('show');
        });
    }

    const inputDeposito = document.getElementById('deposito');
    if (inputDeposito) {
        inputDeposito.addEventListener('input', function() {
            atualizarSelecaoValor(parseInt(this.value));
        });
    }

    const modalDeposito = document.getElementById('modalDeposito');
    if (modalDeposito) {
        modalDeposito.addEventListener('click', function(e) {
            if (e.target === modalDeposito) fecharModalDeposito();
        });
    }

    document.querySelectorAll('.modalDeposito').forEach(btn => {
        btn.addEventListener('click', function(e) { e.preventDefault(); abrirModalDeposito(); });
    });

    // ⭐ MODAL RETIRADA - Event Listeners ⭐
    document.querySelectorAll('.modalRetirada').forEach(btn => {
        btn.addEventListener('click', function(e) { 
            e.preventDefault(); 
            abrirModalRetirada(); 
        });
    });

    const modalRetirada = document.getElementById('modalRetirada');
    if (modalRetirada) {
        modalRetirada.addEventListener('click', function(e) {
            if (e.target === modalRetirada) fecharModalRetirada();
        });
    }

    // ... resto do código continua...

    // --- Deposit form submit (AJAX) ---
/**
 * INTEGRAÇÃO MODAL DEPÓSITO
 * Adicionar este código ao final do arquivo index.php, dentro do bloco DOMContentLoaded
 */

// Substituir o event listener do formdeposito existente
const formDeposito = document.getElementById('formdeposito');
if (formDeposito) {
    formDeposito.addEventListener('submit', function(e) {
        e.preventDefault();
        
        const lang = localStorage.getItem('idioma') || 'pt';
        const dict = i18n[lang] || i18n['pt'];
        const valor = parseFloat(document.getElementById('deposito').value);
        const minimo = <?php echo $ValorDeposito; ?>;

        // Limpar alertas anteriores
        document.getElementById('alerta-deposito').innerHTML = '';

        // Validações frontend
        if (valor < minimo) {
            document.getElementById('alerta-deposito').innerHTML =
                '<div class="alert alert-danger">' + dict.deposit_min_error.replace('{min}', minimo.toFixed(2)) + '</div>';
            return;
        }
        if (valor > 10000) {
            document.getElementById('alerta-deposito').innerHTML =
                '<div class="alert alert-danger">' + dict.deposit_max_error + '</div>';
            return;
        }

        const formData = new FormData(this);
        const botao = document.getElementById('subDeposito');
        
        // Desabilitar botão e mostrar loading
        botao.disabled = true;
        botao.innerHTML = '<i class="fas fa-spinner fa-spin"></i> ' + dict.deposit_processing;

        fetch('php/deposito.php', { 
            method: 'POST', 
            body: formData 
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Sucesso - Substituir conteúdo do modal com o QR Code
                const depositoContent = document.querySelector('.deposito-content');
                if (depositoContent) {
                    depositoContent.innerHTML = data.html;
                }
            } else {
                // Erro - Mostrar mensagem
                document.getElementById('alerta-deposito').innerHTML =
                    '<div class="alert alert-danger">⚠️ ' + data.message + '</div>';
                
                // Reabilitar botão
                botao.disabled = false;
                botao.innerHTML = '<span class="btn-text">' + dict.deposit_generate_pix + '</span>';
            }
        })
        .catch(error => {
            console.error('Erro:', error);
            document.getElementById('alerta-deposito').innerHTML =
                '<div class="alert alert-danger">⚠️ ' + 
                (lang === 'en' ? 'Error processing deposit. Try again.' : 'Erro ao processar depósito. Tente novamente.') + 
                '</div>';
            
            // Reabilitar botão
            botao.disabled = false;
            botao.innerHTML = '<span class="btn-text">' + dict.deposit_generate_pix + '</span>';
        });
    });
}

    // --- Mobile menu ---
    const bottomMenuBtn   = document.getElementById('bottomMenuBtn');
    const mobileMenu      = document.getElementById('mobileMenu');
    const mobileOverlay   = document.getElementById('mobileMenuOverlay');
    const mobileClose     = document.getElementById('mobileMenuClose');

    function openMobileMenu()  { mobileMenu.classList.add('show'); mobileOverlay.classList.add('show'); document.body.style.overflow='hidden'; }
    function closeMobileMenu() { mobileMenu.classList.remove('show'); mobileOverlay.classList.remove('show'); document.body.style.overflow=''; }

    if (bottomMenuBtn)  bottomMenuBtn.addEventListener('click',  function(e){ e.preventDefault(); e.stopPropagation(); openMobileMenu(); });
    if (mobileClose)    mobileClose.addEventListener('click',   function(e){ e.preventDefault(); e.stopPropagation(); closeMobileMenu(); });
    if (mobileOverlay)  mobileOverlay.addEventListener('click', function(e){ e.preventDefault(); e.stopPropagation(); closeMobileMenu(); });
    document.addEventListener('keydown', function(e){ if(e.key==='Escape' && mobileMenu.classList.contains('show')) closeMobileMenu(); });

    // --- Bottom nav active state ---
    document.querySelectorAll('.bottom-nav-item:not(.center)').forEach(item => {
        item.addEventListener('click', function() {
            if (this.id !== 'bottomMenuBtn') {
                document.querySelectorAll('.bottom-nav-item:not(.center)').forEach(i => i.classList.remove('active'));
                this.classList.add('active');
            }
        });
    });

    // --- Touch animations ---
    document.querySelectorAll('.bottom-nav-item').forEach(item => {
        item.addEventListener('touchstart', function(){ this.style.transform = this.classList.contains('center') ? 'translateY(-4px) scale(0.95)' : 'translateY(-2px) scale(0.95)'; });
        item.addEventListener('touchend',   function(){ this.style.transform = ''; });
    });

    // --- Profile modal ---
    const btnAbrirPerfil = document.getElementById('btnAbrirPerfil');
    const modalPerfil    = document.getElementById('modalPerfil');
    if (btnAbrirPerfil) btnAbrirPerfil.addEventListener('click', function(e){ e.preventDefault(); openPerfilModal(); });
    if (modalPerfil)    modalPerfil.addEventListener('click', function(e){ if(e.target===modalPerfil) closePerfilModal(); });

    // --- Bonus USA claim ---
    const btnClaim = document.getElementById('btnClaimBonusUsa');
    if (btnClaim) {
        btnClaim.addEventListener('click', function() {
            btnClaim.disabled = true;
            btnClaim.textContent = 'Processing...';
            fetch('php/bonus_usa.php', { method:'POST' })
            .then(r => r.json())
            .then(data => {
                alert(data.message);
                if (data.success) {
                    document.getElementById('bonus-usa').style.display = 'none';
                    setTimeout(() => location.reload(), 1200);
                } else {
                    btnClaim.disabled = false;
                    btnClaim.textContent = 'Claim';
                }
            })
            .catch(() => {
                alert('Error claiming bonus');
                btnClaim.disabled = false;
                btnClaim.textContent = 'Claim';
            });
        });
    }
});
// ============================================================
// CONTROLE BOTÃO MINHAS APOSTAS (SINGULAR/PLURAL + VISIBILIDADE)
// ============================================================
(function() {
    // CSS para esconder botão inicialmente
    const style = document.createElement('style');
    style.textContent = `
        .btn-minhas-apostas {
            display: none !important;
        }
        .btn-minhas-apostas.show {
            display: flex !important;
        }
    `;
    document.head.appendChild(style);

    // Função para atualizar texto (singular/plural)
    window.atualizarTextoBotaoApostas = function() {
        const count = parseInt(document.getElementById('apostasCount')?.textContent || 0);
        const texto = document.getElementById('apostasTexto');
        
        if (texto) {
            texto.textContent = count === 1 ? '1 Ticket' : 'Minhas Apostas';
        }
    };

    // Interceptar abertura do modal de aposta
    const originalAbrirModal = window.abrirModalAposta;
    window.abrirModalAposta = function(...args) {
        // Chamar função original
        originalAbrirModal.apply(this, args);
        
        // Mostrar botão e atualizar texto
        const btn = document.getElementById('btnMinhasApostas');
        if (btn) {
            btn.classList.add('show');
            atualizarTextoBotaoApostas();
        }
    };

    // Interceptar fazer aposta
    const originalFazerAposta = window.fazerAposta;
    window.fazerAposta = function() {
        const originalCallback = arguments[0];
        
        // Chamar função original
        originalFazerAposta.call(this);
        
        // Após sucesso, atualizar contador
        const observer = new MutationObserver(function() {
            atualizarTextoBotaoApostas();
        });
        
        const countElement = document.getElementById('apostasCount');
        if (countElement) {
            observer.observe(countElement, { 
                childList: true, 
                characterData: true, 
                subtree: true 
            });
        }
    };

    // Inicializar ao carregar
    document.addEventListener('DOMContentLoaded', function() {
        const count = parseInt(document.getElementById('apostasCount')?.textContent || 0);
        const btn = document.getElementById('btnMinhasApostas');
        
        if (count > 0 && btn) {
            btn.classList.add('show');
        }
        
        atualizarTextoBotaoApostas();
    });
})();
</script>
<script>
document.addEventListener('DOMContentLoaded', () => {
    const input = document.getElementById('input-busca');
    if (!input) return;

    const textos = [
        'Sweet Bonanza',
        'Fortune Tiger',
        'Fortune Ox',
        'Aviator',
        'Gates of Olympus',
        'Big Bass Bonanza'
    ];

    let textoIndex = 0;
    let charIndex = 0;
    let apagando = false;
    let ativo = true;

    const velocidadeDigitar = 120;
    const velocidadeApagar  = 80;
    const pausaAposDigitar  = 1200;
    const pausaAposApagar   = 400;

    function animarPlaceholder() {
        if (!ativo) return;

        const textoAtual = textos[textoIndex];

        if (!apagando) {
            // Digitando
            input.setAttribute(
                'placeholder',
                textoAtual.substring(0, charIndex + 1)
            );
            charIndex++;

            if (charIndex === textoAtual.length) {
                setTimeout(() => apagando = true, pausaAposDigitar);
            }
        } else {
            // Apagando
            input.setAttribute(
                'placeholder',
                textoAtual.substring(0, charIndex - 1)
            );
            charIndex--;

            if (charIndex === 0) {
                apagando = false;
                textoIndex = (textoIndex + 1) % textos.length;
                setTimeout(() => {}, pausaAposApagar);
            }
        }

        setTimeout(
            animarPlaceholder,
            apagando ? velocidadeApagar : velocidadeDigitar
        );
    }

    // Para animação quando usuário interagir
    input.addEventListener('focus', () => {
        ativo = false;
        input.setAttribute('placeholder', 'Pesquisar um jogo de cassino...');
    });

    input.addEventListener('blur', () => {
        if (input.value === '') {
            ativo = true;
            textoIndex = 0;
            charIndex = 0;
            apagando = false;
            animarPlaceholder();
        }
    });

    animarPlaceholder();
});

</script>
<script>
(function () {
  // Delegação: pega cliques futuros também (conteúdo via AJAX)
  document.addEventListener("click", async function (e) {
    const btn = e.target.closest("#btnCopiarPix");
    if (!btn) return;

    e.preventDefault();
    e.stopPropagation();

    const input = document.getElementById("pixCodeToCopy");
    if (!input) {
      console.error("pixCodeToCopy não encontrado");
      return;
    }

    const texto = input.value || "";

    // feedback
    const originalHTML = btn.innerHTML;

    const feedbackOk = () => {
      btn.innerHTML = '<i class="fas fa-check"></i> Copiado!';
      btn.style.background = "#059669";
      setTimeout(() => {
        btn.innerHTML = originalHTML;
        btn.style.background = "#10b981";
      }, 2000);
    };

    const fallback = () => {
      try {
        input.removeAttribute("readonly"); // alguns navegadores implicam
        input.focus();
        input.select();
        input.setSelectionRange(0, 999999);

        const ok = document.execCommand("copy");
        input.setAttribute("readonly", "readonly");

        if (ok) feedbackOk();
        else alert("Não foi possível copiar automaticamente. Copie manualmente.");
      } catch (err) {
        console.error("Fallback copy erro:", err);
        alert("Copie manualmente (Ctrl+C).");
      }
    };

    try {
      // Clipboard API só funciona em HTTPS e com clique real do usuário
      if (navigator.clipboard && window.isSecureContext) {
        await navigator.clipboard.writeText(texto);
        feedbackOk();
      } else {
        fallback();
      }
    } catch (err) {
      console.error("navigator.clipboard falhou:", err);
      fallback();
    }
  });
})();
</script>
<script>
// ===================================
// MODAL RETIRADA - JavaScript Integration
// ===================================

document.addEventListener('DOMContentLoaded', function() {
    const formRetirada = document.getElementById('formretirada');
    const cpfInput = document.getElementById('pix_cpf');
    const valorInput = document.getElementById('retirada');
    const confirmCheckbox = document.getElementById('confirmInfo');
    
    // ============= CPF MASK =============
    if (cpfInput) {
        cpfInput.addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            
            if (value.length <= 11) {
                value = value.replace(/(\d{3})(\d)/, '$1.$2');
                value = value.replace(/(\d{3})(\d)/, '$1.$2');
                value = value.replace(/(\d{3})(\d{1,2})$/, '$1-$2');
            }
            
            e.target.value = value;
        });

        // Validação visual em tempo real
        cpfInput.addEventListener('blur', function() {
            const cpf = this.value.replace(/\D/g, '');
            if (cpf.length === 11) {
                if (validarCPF(cpf)) {
                    this.classList.add('valid');
                    this.classList.remove('invalid');
                } else {
                    this.classList.add('invalid');
                    this.classList.remove('valid');
                }
            }
        });

        cpfInput.addEventListener('focus', function() {
            this.classList.remove('valid', 'invalid');
        });
    }

    // ============= CURRENCY MASK =============
    if (valorInput) {
        valorInput.addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            
            if (value === '') {
                e.target.value = '';
                return;
            }
            
            value = (parseInt(value) / 100).toFixed(2);
            value = value.replace('.', ',');
            value = value.replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1.');
            e.target.value = 'R$ ' + value;
        });

        valorInput.addEventListener('focus', function() {
            if (this.value === 'R$ 0,00' || this.value === '') {
                this.value = '';
            }
        });

        valorInput.addEventListener('blur', function() {
            if (this.value === '' || this.value === 'R$ ') {
                this.value = '';
            }
        });
    }

    // ============= CPF VALIDATION =============
    function validarCPF(cpf) {
        cpf = cpf.replace(/\D/g, '');
        
        if (cpf.length !== 11) return false;
        if (/^(\d)\1{10}$/.test(cpf)) return false;
        
        let add = 0;
        for (let i = 0; i < 9; i++) {
            add += parseInt(cpf.charAt(i)) * (10 - i);
        }
        let rev = 11 - (add % 11);
        if (rev === 10 || rev === 11) rev = 0;
        if (rev !== parseInt(cpf.charAt(9))) return false;
        
        add = 0;
        for (let i = 0; i < 10; i++) {
            add += parseInt(cpf.charAt(i)) * (11 - i);
        }
        rev = 11 - (add % 11);
        if (rev === 10 || rev === 11) rev = 0;
        if (rev !== parseInt(cpf.charAt(10))) return false;
        
        return true;
    }

    // ============= FORM SUBMIT (AJAX) =============
    if (formRetirada) {
        formRetirada.addEventListener('submit', function(e) {
            e.preventDefault();

            // Validações básicas do frontend
            const valor = valorInput.value;
            const cpf = cpfInput.value;
            const confirmed = confirmCheckbox.checked;

            if (!valor || valor === '') {
                mostrarAlerta('Por favor, insira o valor da retirada.', 'erro');
                valorInput.focus();
                return;
            }

            if (!cpf || cpf === '') {
                mostrarAlerta('Por favor, insira seu CPF.', 'erro');
                cpfInput.focus();
                return;
            }

            const cpfLimpo = cpf.replace(/\D/g, '');
            if (!validarCPF(cpfLimpo)) {
                mostrarAlerta('CPF inválido. Por favor, verifique os dados.', 'erro');
                cpfInput.focus();
                return;
            }

            if (!confirmed) {
                mostrarAlerta('Você precisa confirmar que as informações são verdadeiras.', 'erro');
                return;
            }

            // Submeter via AJAX
            submitRetirada();
        });
    }

    // ============= AJAX SUBMIT =============
    function submitRetirada() {
        const btnSubmit = document.getElementById('subRetirada');
        const originalText = btnSubmit.textContent;
        
        // Desabilita botão e mostra loading
        btnSubmit.disabled = true;
        btnSubmit.classList.add('loading');
        btnSubmit.textContent = 'Processando...';

        const formData = new FormData(formRetirada);

        fetch(formRetirada.action, {
            method: 'POST',
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            // Remove loading
            btnSubmit.disabled = false;
            btnSubmit.classList.remove('loading');
            btnSubmit.textContent = originalText;

            if (data.status === 'alertasim') {
                // Sucesso
                mostrarAlerta(data.message, 'sucesso');
                
                // Limpa formulário
                valorInput.value = '';
                confirmCheckbox.checked = false;
                
                // Recarrega após 2 segundos
                setTimeout(() => {
                    window.location.reload();
                }, 2000);
            } else {
                // Erro
                mostrarAlerta(data.message, 'erro');
            }
        })
        .catch(error => {
            console.error('Erro:', error);
            btnSubmit.disabled = false;
            btnSubmit.classList.remove('loading');
            btnSubmit.textContent = originalText;
            mostrarAlerta('Erro ao processar solicitação. Tente novamente.', 'erro');
        });
    }

    // ============= MOSTRAR ALERTAS =============
    function mostrarAlerta(message, tipo) {
        const alertContainer = document.getElementById('alerta-retirada');
        if (!alertContainer) return;

        // Remove HTML tags da mensagem
        const cleanMessage = message.replace(/<[^>]*>/g, '');
        
        // Cria alerta
        const classe = tipo === 'sucesso' ? 'alertasim' : 'alertanao';
        const icon = tipo === 'sucesso' ? 'fa-check' : 'fa-times';
        
        alertContainer.innerHTML = `
            <p class="${classe}">
                ${cleanMessage}
                <span><i class="fas ${icon}"></i></span>
            </p>
        `;

        // Scroll para o alerta
        alertContainer.scrollIntoView({ behavior: 'smooth', block: 'nearest' });

        // Remove após 5 segundos
        setTimeout(() => {
            alertContainer.innerHTML = '';
        }, 5000);
    }

    // ============= CHECKBOX INTERACTION =============
    if (confirmCheckbox) {
        confirmCheckbox.addEventListener('change', function() {
            const btnSubmit = document.getElementById('subRetirada');
            if (this.checked) {
                btnSubmit.style.opacity = '1';
            } else {
                btnSubmit.style.opacity = '0.7';
            }
        });
    }
});

// ============= MODAL FUNCTIONS =============
function abrirModalRetirada() {
    const modal = document.getElementById('modalRetirada');
    if (modal) {
        modal.style.display = 'flex';
        document.body.style.overflow = 'hidden';
    }
}

function fecharModalRetirada() {
    const modal = document.getElementById('modalRetirada');
    if (modal) {
        modal.style.display = 'none';
        document.body.style.overflow = 'auto';
        
        // Limpa alertas ao fechar
        const alertContainer = document.getElementById('alerta-retirada');
        if (alertContainer) {
            alertContainer.innerHTML = '';
        }
    }
}

// Fechar ao pressionar ESC
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        fecharModalRetirada();
    }
});

// Prevenir resubmissão do formulário
if (window.history.replaceState) {
    window.history.replaceState(null, null, window.location.href);
}
</script>
  <script src="/dashboard/js/modal-taxa-saque.js"></script>
  </div>

</body>
</html>