<?php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode([
        'success' => false,
        'status'  => 'alertanao',
        'message' => 'Método não permitido'
    ]);
    exit;
}

$https = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off');

session_set_cookie_params([
    'lifetime' => 0,
    'path'     => '/',
    'secure'   => $https,
    'httponly' => true,
    'samesite' => 'Lax'
]);

session_start();

require_once '../includes/db.php';

function valida_token_csrf(string $form): bool {
    $token = $_POST['csrf_token'] ?? '';
    return !empty($_SESSION["csrf_token_$form"]) && hash_equals($_SESSION["csrf_token_$form"], $token);
}

$email = trim(filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL));
$senha = $_POST['senha'] ?? '';

if (!valida_token_csrf('login')) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'status'  => 'alertanao',
        'message' => 'Token de segurança inválido. Recarregue a página.'
    ]);
    exit;
}

if (!$email || !filter_var($email, FILTER_VALIDATE_EMAIL) || $senha === '') {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'status'  => 'alertanao',
        'message' => 'Dados inválidos'
    ]);
    exit;
}

$stmt = $pdo->prepare("SELECT id, bet_senha, bet_status FROM bet_usuarios WHERE bet_email = :email LIMIT 1");
$stmt->execute([':email' => $email]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user || (int)$user['bet_status'] !== 1 || !password_verify($senha, $user['bet_senha'])) {
    http_response_code(401);
    echo json_encode([
        'success' => false,
        'status'  => 'alertanao',
        'message' => 'Email ou senha incorretos'
    ]);
    exit;
}

session_regenerate_id(true);

$auth_token = bin2hex(random_bytes(32));

$upd = $pdo->prepare("UPDATE bet_usuarios SET bet_token = :t WHERE id = :id");
$upd->execute([
    ':t'  => $auth_token,
    ':id' => $user['id']
]);

setcookie('auth_token', $auth_token, [
    'expires'  => time() + 31536000,
    'path'     => '/',
    'secure'   => $https,
    'httponly' => true,
    'samesite' => 'Lax'
]);

$_SESSION['usuario_id'] = $user['id'];
$_SESSION['csrf_token_login'] = bin2hex(random_bytes(32));

echo json_encode([
    'success'  => true,
    'status'   => 'alertasim',
    'message'  => 'Login realizado com sucesso',
    'redirect' => '/dashboard/'
]);
exit;
