<?php
session_start();
header('Content-Type: application/json');

require_once '../../../includes/db.php';

// Verifica autenticação
if (!isset($_SESSION['usuario_id']) || $_SESSION['nivel'] != 'admin') {
    echo json_encode(['status' => 'erro', 'mensagem' => 'Não autorizado']);
    exit;
}

// Verifica CSRF
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== ($_SESSION['csrf_token_bingo_premios'] ?? '')) {
    echo json_encode(['status' => 'erro', 'mensagem' => 'Token CSRF inválido']);
    exit;
}

try {
    $premio_quadra = (float)($_POST['premio_quadra'] ?? 20.00);
    $premio_quina = (float)($_POST['premio_quina'] ?? 30.00);
    $premio_bingo = (float)($_POST['premio_bingo'] ?? 60.00);

    // Validações
    if ($premio_quadra < 0) {
        throw new Exception('Prêmio da Quadra deve ser maior ou igual a zero');
    }

    if ($premio_quina < 0) {
        throw new Exception('Prêmio da Quina deve ser maior ou igual a zero');
    }

    if ($premio_bingo < 0) {
        throw new Exception('Prêmio do Bingo deve ser maior ou igual a zero');
    }

    // Atualiza no banco
    $stmt = $pdo->prepare("
        UPDATE configuracoes_jogo 
        SET premio_quadra_default = ?,
            premio_quina_default = ?,
            premio_cartela_cheia_default = ?
        WHERE id = 1
    ");
    
    $stmt->execute([
        $premio_quadra,
        $premio_quina,
        $premio_bingo
    ]);

    // Gera novo token CSRF
    $_SESSION['csrf_token_bingo_premios'] = bin2hex(random_bytes(32));

    echo json_encode([
        'status' => 'sucesso',
        'mensagem' => 'Prêmios atualizados com sucesso!'
    ]);

} catch (Exception $e) {
    echo json_encode([
        'status' => 'erro',
        'mensagem' => $e->getMessage()
    ]);
}
