<?php
session_start();
header('Content-Type: application/json');

require_once '../../../includes/db.php';

// Verifica autenticação
if (!isset($_SESSION['usuario_id']) || $_SESSION['nivel'] != 'admin') {
    echo json_encode(['status' => 'erro', 'mensagem' => 'Não autorizado']);
    exit;
}

// Verifica CSRF
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== ($_SESSION['csrf_token_bingo_geral'] ?? '')) {
    echo json_encode(['status' => 'erro', 'mensagem' => 'Token CSRF inválido']);
    exit;
}

try {
    $rtp = (int)($_POST['rtp'] ?? 85);
    $modo_inicio = $_POST['modo_inicio'] ?? 'tempo';
    $meta_arrecadacao = (float)($_POST['meta_arrecadacao'] ?? 0.00);
    $url_suporte = trim($_POST['url_suporte'] ?? '');

    // Validações
    if ($rtp < 50 || $rtp > 100) {
        throw new Exception('RTP deve estar entre 50% e 100%');
    }

    if (!in_array($modo_inicio, ['tempo', 'arrecadacao'])) {
        throw new Exception('Modo de início inválido');
    }

    if ($modo_inicio === 'arrecadacao' && $meta_arrecadacao <= 0) {
        throw new Exception('Meta de arrecadação deve ser maior que zero');
    }

    // Atualiza no banco
    $stmt = $pdo->prepare("
        UPDATE configuracoes_jogo 
        SET rtp = ?,
            modo_inicio_jogo = ?,
            meta_arrecadacao_minima = ?,
            url_suporte = ?
        WHERE id = 1
    ");
    
    $stmt->execute([
        $rtp,
        $modo_inicio,
        $meta_arrecadacao,
        $url_suporte
    ]);

    // Gera novo token CSRF
    $_SESSION['csrf_token_bingo_geral'] = bin2hex(random_bytes(32));

    echo json_encode([
        'status' => 'sucesso',
        'mensagem' => 'Configurações gerais atualizadas com sucesso!'
    ]);

} catch (Exception $e) {
    echo json_encode([
        'status' => 'erro',
        'mensagem' => $e->getMessage()
    ]);
}
