<?php
session_start();
header('Content-Type: application/json');

require_once '../../../includes/db.php';

// Verifica autenticação
if (!isset($_SESSION['usuario_id']) || $_SESSION['nivel'] != 'admin') {
    echo json_encode(['status' => 'erro', 'mensagem' => 'Não autorizado']);
    exit;
}

// Verifica CSRF
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== ($_SESSION['csrf_token_bingo_extra'] ?? '')) {
    echo json_encode(['status' => 'erro', 'mensagem' => 'Token CSRF inválido']);
    exit;
}

try {
    $ativar_bots = (int)($_POST['ativar_bots'] ?? 0);
    $ativar_narracao = (int)($_POST['ativar_narracao'] ?? 0);

    // Validações
    if (!in_array($ativar_bots, [0, 1])) {
        $ativar_bots = 0;
    }

    if (!in_array($ativar_narracao, [0, 1])) {
        $ativar_narracao = 0;
    }

    // Atualiza no banco
    $stmt = $pdo->prepare("
        UPDATE configuracoes_jogo 
        SET ativar_bots = ?,
            ativar_narracao = ?
        WHERE id = 1
    ");
    
    $stmt->execute([
        $ativar_bots,
        $ativar_narracao
    ]);

    // Gera novo token CSRF
    $_SESSION['csrf_token_bingo_extra'] = bin2hex(random_bytes(32));

    $msg_bots = $ativar_bots ? 'ativados' : 'desativados';
    $msg_narracao = $ativar_narracao ? 'ativada' : 'desativada';

    echo json_encode([
        'status' => 'sucesso',
        'mensagem' => "Bots {$msg_bots} e Narração {$msg_narracao}!"
    ]);

} catch (Exception $e) {
    echo json_encode([
        'status' => 'erro',
        'mensagem' => $e->getMessage()
    ]);
}
