<?php
session_start();
header('Content-Type: application/json');

require_once '../../../includes/db.php';

// Verifica autenticação
if (!isset($_SESSION['usuario_id']) || $_SESSION['nivel'] != 'admin') {
    echo json_encode(['status' => 'erro', 'mensagem' => 'Não autorizado']);
    exit;
}

// Verifica CSRF
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== ($_SESSION['csrf_token_bingo_cartelas'] ?? '')) {
    echo json_encode(['status' => 'erro', 'mensagem' => 'Token CSRF inválido']);
    exit;
}

try {
    $min_cartelas = (int)($_POST['min_cartelas'] ?? 1);
    $max_cartelas = (int)($_POST['max_cartelas'] ?? 50);
    $valores_cartela = trim($_POST['valores_cartela'] ?? '["0.10","0.20","0.30","0.50","1.00","5.00","10.00","50.00"]');

    // Validações
    if ($min_cartelas < 1) {
        throw new Exception('Mínimo de cartelas deve ser pelo menos 1');
    }

    if ($max_cartelas < $min_cartelas) {
        throw new Exception('Máximo de cartelas deve ser maior ou igual ao mínimo');
    }

    if ($max_cartelas > 200) {
        throw new Exception('Máximo de cartelas não pode exceder 200');
    }

    // Valida JSON dos valores
    $valores_array = json_decode($valores_cartela, true);
    if (!is_array($valores_array) || empty($valores_array)) {
        throw new Exception('Formato de valores inválido. Use JSON: ["0.10","0.20","0.50"]');
    }

    // Valida que todos os valores são numéricos positivos
    foreach ($valores_array as $valor) {
        if (!is_numeric($valor) || (float)$valor <= 0) {
            throw new Exception('Todos os valores devem ser números positivos');
        }
    }

    // Atualiza no banco
    $stmt = $pdo->prepare("
        UPDATE configuracoes_jogo 
        SET min_cartelas = ?,
            max_cartelas = ?,
            valores_cartela = ?
        WHERE id = 1
    ");
    
    $stmt->execute([
        $min_cartelas,
        $max_cartelas,
        $valores_cartela
    ]);

    // Gera novo token CSRF
    $_SESSION['csrf_token_bingo_cartelas'] = bin2hex(random_bytes(32));

    echo json_encode([
        'status' => 'sucesso',
        'mensagem' => 'Configurações de cartelas atualizadas com sucesso!'
    ]);

} catch (Exception $e) {
    echo json_encode([
        'status' => 'erro',
        'mensagem' => $e->getMessage()
    ]);
}
