<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../../config.php';
session_start();

if (!isset($_SESSION['usuario_id']) || ($_SESSION['usuario_tipo'] ?? '') !== 'admin') {
  echo json_encode(['ok'=>false,'error'=>'Não autorizado']); exit;
}
if (($_SERVER['HTTP_X_REQUESTED_WITH'] ?? '') !== 'XMLHttpRequest') {
  echo json_encode(['ok'=>false,'error'=>'Requisição inválida']); exit;
}
if (empty($_POST['csrf_token']) || empty($_SESSION['csrf_tables']) || !hash_equals($_SESSION['csrf_tables'], $_POST['csrf_token'])) {
  echo json_encode(['ok'=>false,'error'=>'CSRF inválido']); exit;
}

$ALLOW_TABLES = ['apostas_esportivas','ticker_partidas'];
$table = $_POST['table'] ?? '';
$pk    = $_POST['pk'] ?? '';
$pkVal = $_POST['pk_value'] ?? '';

if (!in_array($table, $ALLOW_TABLES, true)) { echo json_encode(['ok'=>false,'error'=>'Tabela inválida']); exit; }
if (!preg_match('/^[a-zA-Z0-9_]+$/', $pk)) { echo json_encode(['ok'=>false,'error'=>'PK inválida']); exit; }

$pdo = conectarDB();
if (!$pdo) { echo json_encode(['ok'=>false,'error'=>'Sem conexão']); exit; }

try {
  $st = $pdo->prepare("DELETE FROM `{$table}` WHERE `{$pk}` = :pk LIMIT 1");
  $st->execute([':pk' => $pkVal]);
  echo json_encode(['ok'=>true]);
} catch (Throwable $e) {
  echo json_encode(['ok'=>false,'error'=>'Erro: '.$e->getMessage()]);
}
