<?php
// Impede acesso direto via navegador (GET)
if (
    $_SERVER['REQUEST_METHOD'] !== 'POST' ||
    empty($_SERVER['HTTP_X_REQUESTED_WITH']) ||
    strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest'
) {
    header("Location: /painel/dashboard/");
    exit;
}

session_name('adm_session');
session_start();

require_once '../../../includes/db.php';

// Autenticação AJAX
require_once 'auth_ajax_adm.php';

// Função para validar CSRF
function valida_token_csrf($form_name) {
    $token = $_POST['csrf_token'] ?? '';
    return isset($_SESSION["csrf_token_$form_name"]) && hash_equals($_SESSION["csrf_token_$form_name"], $token);
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $errors = [];

    $valor_raw = trim($_POST['bonus_usa_valor'] ?? '');
    $frase     = trim($_POST['bonus_usa_frase'] ?? '');

    if (!valida_token_csrf('bonususa')) {
        $errors[] = "Falha. Por favor, tente novamente.";
    } elseif ($valor_raw === '') {
        $errors[] = "Informe o valor do bônus!";
    } elseif ($frase === '') {
        $errors[] = "Informe a frase!";
    } else {
        // Normaliza valor: aceita "750", "750.50" ou "750,50"
        $valor_norm = str_replace([' ', 'R$', '.'], ['', '', ''], $valor_raw);
        $valor_norm = str_replace(',', '.', $valor_norm);
        $valor = floatval($valor_norm);

        if ($valor <= 0) {
            $errors[] = "Valor inválido!";
        } elseif (mb_strlen($frase) > 120) {
            $errors[] = "Frase muito longa (máx 120 caracteres)!";
        } else {
            try {
                // ✅ AJUSTE AQUI PARA SUA TABELA/COLUNAS
                // Exemplo: tabela bet_config com id=1
                $update = $pdo->prepare("
                    UPDATE bet_config
                    SET bonus_usa_valor = :valor,
                        bonus_usa_frase = :frase
                    WHERE id = 1
                ");
                $update->execute([
                    ':valor' => $valor,
                    ':frase' => $frase
                ]);

            } catch (PDOException $e) {
                $errors[] = "Erro ao atualizar bônus USA: " . $e->getMessage();
            }
        }
    }

    if (!empty($errors)) {
        $response = [
            "status"  => "alertanao",
            "message" => "<p class='alertanao'>" . implode("<br>", $errors) . " <span><i class='fas fa-times'></i></span></p>"
        ];
    } else {
        $response = [
            "status"  => "alertasim",
            "message" => "<p class='alertasim'>Bônus USA atualizado com sucesso! <span><i class='fas fa-check'></i></span></p>"
        ];

        // Regenerar CSRF
        $_SESSION['csrf_token_bonususa'] = bin2hex(random_bytes(32));
    }

    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}
