<?php
// Impede acesso direto via navegador (GET)
if (
    $_SERVER['REQUEST_METHOD'] !== 'POST' ||
    empty($_SERVER['HTTP_X_REQUESTED_WITH']) ||
    strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest'
) {
    header("Location: /painel/dashboard/");
    exit;
}
session_name('adm_session');
session_start();
require_once '../../../includes/db.php';
// Autenticação AJAX
require_once 'auth_ajax_adm.php';
// Função para validar CSRF dinamicamente
function valida_token_csrf($form_name) {
    $token = $_POST['csrf_token'] ?? '';
    return isset($_SESSION["csrf_token_$form_name"]) && $token === $_SESSION["csrf_token_$form_name"];
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $errors = [];

    // Sanitiza e valida os dados de entrada
    $data = [
        'intervalo_jogos'   => trim($_POST['intervalo_jogos']   ?? ''),
        'velocidade_sorteio'=> trim($_POST['velocidade_sorteio'] ?? '')
    ];

    if (!valida_token_csrf('bingo_tempo')) {
        $errors[] = "Falha. Por favor, tente novamente.";
    } else {

        // ── intervalo_jogos ─────────────────────────────────────
        if ($data['intervalo_jogos'] === '') {
            $errors[] = "O campo intervalo entre jogos é obrigatório!";
        } else {
            $data['intervalo_jogos'] = (int)$data['intervalo_jogos'];
            if ($data['intervalo_jogos'] < 30) {
                $errors[] = "Intervalo entre jogos deve ser no mínimo 30 segundos!";
            }
            if ($data['intervalo_jogos'] > 3600) {
                $errors[] = "Intervalo entre jogos não pode exceder 1 hora (3600 segundos)!";
            }
        }

        // ── velocidade_sorteio ──────────────────────────────────
        if ($data['velocidade_sorteio'] === '') {
            $errors[] = "O campo velocidade do sorteio é obrigatório!";
        } else {
            $data['velocidade_sorteio'] = (int)$data['velocidade_sorteio'];
            if ($data['velocidade_sorteio'] < 1 || $data['velocidade_sorteio'] > 10) {
                $errors[] = "Velocidade do sorteio deve estar entre 1 e 10 segundos!";
            }
        }
    }

    if (!empty($errors)) {
        $response = [
            "status"  => "alertanao",
            "message" => "<p class='alertanao'>" . implode("<br>", $errors) . " <span><i class='fas fa-times'></i></span></p>"
        ];
    } else {
        try {
            $stmt = $pdo->prepare("
                UPDATE configuracoes_jogo
                SET intervalo_jogos    = :intervalo,
                    velocidade_sorteio = :velocidade
                WHERE id = 1
            ");
            $stmt->bindParam(':intervalo',  $data['intervalo_jogos']);
            $stmt->bindParam(':velocidade', $data['velocidade_sorteio']);
            $stmt->execute();

            // Regenera token CSRF
            $_SESSION['csrf_token_bingo_tempo'] = bin2hex(random_bytes(32));

            $tempo_total = $data['velocidade_sorteio'] * 75;
            $minutos     = floor($tempo_total / 60);
            $segundos    = $tempo_total % 60;

            $response = [
                "status"  => "alertasim",
                "message" => "<p class='alertasim'>Configurações atualizadas! Tempo estimado por jogo: {$minutos}min {$segundos}s <span><i class='fas fa-check'></i></span></p>"
            ];
        } catch (PDOException $e) {
            $response = [
                "status"  => "alertanao",
                "message" => "<p class='alertanao'>Erro ao atualizar: " . $e->getMessage() . " <span><i class='fas fa-times'></i></span></p>"
            ];
        }
    }

    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}
?>
