<?php
// Impede acesso direto via navegador (GET)
if (
    $_SERVER['REQUEST_METHOD'] !== 'POST' ||
    empty($_SERVER['HTTP_X_REQUESTED_WITH']) ||
    strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest'
) {
    header("Location: /painel/dashboard/");
    exit;
}
session_name('adm_session');
session_start();
require_once '../../../includes/db.php';
// Autenticação AJAX
require_once 'auth_ajax_adm.php';
// Função para validar CSRF dinamicamente
function valida_token_csrf($form_name) {
    $token = $_POST['csrf_token'] ?? '';
    return isset($_SESSION["csrf_token_$form_name"]) && $token === $_SESSION["csrf_token_$form_name"];
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $errors = [];

    // Sanitiza e valida os dados de entrada
    $data = [
        'rtp'              => trim($_POST['rtp']              ?? ''),
        'modo_inicio'      => trim($_POST['modo_inicio']      ?? ''),
        'meta_arrecadacao' => trim($_POST['meta_arrecadacao'] ?? ''),
        'url_suporte'      => trim($_POST['url_suporte']      ?? '')
    ];

    if (!valida_token_csrf('bingo_geral')) {
        $errors[] = "Falha. Por favor, tente novamente.";
    } else {

        // ── RTP ─────────────────────────────────────────────────
        if ($data['rtp'] === '') {
            $errors[] = "O campo RTP é obrigatório!";
        } else {
            $data['rtp'] = (int)$data['rtp'];
            if ($data['rtp'] < 50 || $data['rtp'] > 100) {
                $errors[] = "RTP deve estar entre 50% e 100%!";
            }
        }

        // ── modo_inicio ─────────────────────────────────────────
        if ($data['modo_inicio'] === '') {
            $errors[] = "O campo modo de início é obrigatório!";
        } elseif (!in_array($data['modo_inicio'], ['tempo', 'arrecadacao'])) {
            $errors[] = "Modo de início inválido!";
        }

        // ── meta_arrecadacao (obrigatória quando modo = arrecadacao) ──
        if (empty($errors) && $data['modo_inicio'] === 'arrecadacao') {
            // Remove R$, espaços e pontos dos milhares
            $cleanValue = str_replace(array('R$', ' ', ' '), array('', '', ''), $data['meta_arrecadacao']);
            $cleanValue = str_replace('.', '', $cleanValue);
            $cleanValue = str_replace(',', '.', $cleanValue);

            if ($cleanValue === '' || !preg_match('/^\d+(\.\d{1,2})?$/', $cleanValue)) {
                $errors[] = "Meta de arrecadação inválida!";
            } else {
                $data['meta_arrecadacao'] = (float)$cleanValue;
                if ($data['meta_arrecadacao'] <= 0) {
                    $errors[] = "Meta de arrecadação deve ser maior que zero!";
                }
            }
        } else {
            // modo = tempo: meta não é usada, zera
            $data['meta_arrecadacao'] = 0.00;
        }
    }

    if (!empty($errors)) {
        $response = [
            "status"  => "alertanao",
            "message" => "<p class='alertanao'>" . implode("<br>", $errors) . " <span><i class='fas fa-times'></i></span></p>"
        ];
    } else {
        try {
            $stmt = $pdo->prepare("
                UPDATE configuracoes_jogo
                SET rtp                     = :rtp,
                    modo_inicio_jogo        = :modo,
                    meta_arrecadacao_minima = :meta,
                    url_suporte             = :url
                WHERE id = 1
            ");
            $stmt->bindParam(':rtp',  $data['rtp']);
            $stmt->bindParam(':modo', $data['modo_inicio']);
            $stmt->bindParam(':meta', $data['meta_arrecadacao']);
            $stmt->bindParam(':url',  $data['url_suporte']);
            $stmt->execute();

            // Regenera token CSRF
            $_SESSION['csrf_token_bingo_geral'] = bin2hex(random_bytes(32));

            $response = [
                "status"  => "alertasim",
                "message" => "<p class='alertasim'>Configurações gerais atualizadas com sucesso! <span><i class='fas fa-check'></i></span></p>"
            ];
        } catch (PDOException $e) {
            $response = [
                "status"  => "alertanao",
                "message" => "<p class='alertanao'>Erro ao atualizar: " . $e->getMessage() . " <span><i class='fas fa-times'></i></span></p>"
            ];
        }
    }

    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}
?>
