// JavaScript para Configurações do Bingo
console.log('Bingo Config JS carregado!'); // Para debug

$(document).ready(function() {
    console.log('jQuery ready - Bingo Config'); // Para debug
    
    // ==========================================
    // ABRIR MODAIS DO BINGO
    // ==========================================
    $('.modalBingoGeral').on('click', function() {
        console.log('Abrindo modal Bingo Geral'); // Debug
        $('#modalBingoGeral').fadeIn();
        $('#overlay').fadeIn();
    });
    
    $('.modalBingoPremios').on('click', function() {
        console.log('Abrindo modal Bingo Premios'); // Debug
        $('#modalBingoPremios').fadeIn();
        $('#overlay').fadeIn();
    });
    
    $('.modalBingoCartelas').on('click', function() {
        console.log('Abrindo modal Bingo Cartelas'); // Debug
        $('#modalBingoCartelas').fadeIn();
        $('#overlay').fadeIn();
    });
    
    $('.modalBingoTempo').on('click', function() {
        console.log('Abrindo modal Bingo Tempo'); // Debug
        $('#modalBingoTempo').fadeIn();
        $('#overlay').fadeIn();
    });
    
    $('.modalBingoExtra').on('click', function() {
        console.log('Abrindo modal Bingo Extra'); // Debug
        $('#modalBingoExtra').fadeIn();
        $('#overlay').fadeIn();
    });

    // ==========================================
    // FORMULÁRIOS
    // ==========================================
    
    // Bingo Geral
    $('#formbingogeral').on('submit', function(e) {
        e.preventDefault();
        var formData = $(this).serialize();
        var submitBtn = $('#subBingoGeral');
        submitBtn.prop('disabled', true).val('Atualizando...');
        
        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'sucesso') {
                    mostrarAlerta('#alerta-bingo-geral', response.mensagem, 'sucesso');
                    setTimeout(() => location.reload(), 1500);
                } else {
                    mostrarAlerta('#alerta-bingo-geral', response.mensagem, 'erro');
                }
            },
            error: function() {
                mostrarAlerta('#alerta-bingo-geral', 'Erro ao conectar com o servidor', 'erro');
            },
            complete: function() {
                submitBtn.prop('disabled', false).val('Atualizar');
            }
        });
    });

    // Bingo Prêmios
    $('#formbingopremios').on('submit', function(e) {
        e.preventDefault();
        var formData = $(this).serialize();
        var submitBtn = $('#subBingoPremios');
        submitBtn.prop('disabled', true).val('Atualizando...');
        
        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'sucesso') {
                    mostrarAlerta('#alerta-bingo-premios', response.mensagem, 'sucesso');
                    setTimeout(() => location.reload(), 1500);
                } else {
                    mostrarAlerta('#alerta-bingo-premios', response.mensagem, 'erro');
                }
            },
            error: function() {
                mostrarAlerta('#alerta-bingo-premios', 'Erro ao conectar com o servidor', 'erro');
            },
            complete: function() {
                submitBtn.prop('disabled', false).val('Atualizar');
            }
        });
    });

    // Bingo Cartelas
    $('#formbingocartelas').on('submit', function(e) {
        e.preventDefault();
        var formData = $(this).serialize();
        var submitBtn = $('#subBingoCartelas');
        submitBtn.prop('disabled', true).val('Atualizando...');
        
        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'sucesso') {
                    mostrarAlerta('#alerta-bingo-cartelas', response.mensagem, 'sucesso');
                    setTimeout(() => location.reload(), 1500);
                } else {
                    mostrarAlerta('#alerta-bingo-cartelas', response.mensagem, 'erro');
                }
            },
            error: function() {
                mostrarAlerta('#alerta-bingo-cartelas', 'Erro ao conectar com o servidor', 'erro');
            },
            complete: function() {
                submitBtn.prop('disabled', false).val('Atualizar');
            }
        });
    });

    // Bingo Tempo
    $('#formbingotempo').on('submit', function(e) {
        e.preventDefault();
        var formData = $(this).serialize();
        var submitBtn = $('#subBingoTempo');
        submitBtn.prop('disabled', true).val('Atualizando...');
        
        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'sucesso') {
                    mostrarAlerta('#alerta-bingo-tempo', response.mensagem, 'sucesso');
                    setTimeout(() => location.reload(), 1500);
                } else {
                    mostrarAlerta('#alerta-bingo-tempo', response.mensagem, 'erro');
                }
            },
            error: function() {
                mostrarAlerta('#alerta-bingo-tempo', 'Erro ao conectar com o servidor', 'erro');
            },
            complete: function() {
                submitBtn.prop('disabled', false).val('Atualizar');
            }
        });
    });

    // Bingo Extra
    $('#formbingoextra').on('submit', function(e) {
        e.preventDefault();
        var formData = $(this).serialize();
        var submitBtn = $('#subBingoExtra');
        submitBtn.prop('disabled', true).val('Atualizando...');
        
        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'sucesso') {
                    mostrarAlerta('#alerta-bingo-extra', response.mensagem, 'sucesso');
                    setTimeout(() => location.reload(), 1500);
                } else {
                    mostrarAlerta('#alerta-bingo-extra', response.mensagem, 'erro');
                }
            },
            error: function() {
                mostrarAlerta('#alerta-bingo-extra', 'Erro ao conectar com o servidor', 'erro');
            },
            complete: function() {
                submitBtn.prop('disabled', false).val('Atualizar');
            }
        });
    });

});

// Função para mostrar alertas
function mostrarAlerta(seletor, mensagem, tipo) {
    var classe = tipo === 'sucesso' ? 'alerta-sucesso' : 'alerta-erro';
    var icone = tipo === 'sucesso' ? 'fa-check-circle' : 'fa-exclamation-triangle';
    
    $(seletor).html(
        '<div class="' + classe + '">' +
        '<i class="fas ' + icone + '"></i> ' + mensagem +
        '</div>'
    ).slideDown();
    
    setTimeout(function() {
        $(seletor).slideUp(function() {
            $(seletor).html('');
        });
    }, 5000);
}