<?php
if (!defined('IN_INDEX')) {
    header("Location: /painel/dashboard/");
    exit();
}

// =====================
// CARREGAR CONFIGURAÇÕES DO BINGO
// =====================
$stmt = $pdo->prepare("SELECT * FROM configuracoes_jogo WHERE id = 1 LIMIT 1");
$stmt->execute();
$configBingo = $stmt->fetch(PDO::FETCH_ASSOC);

if ($configBingo) {
    $valores_cartela = $configBingo['valores_cartela'] ?? '["0.10","0.20","0.30","0.50","1.00","5.00","10.00","50.00"]';
    $min_cartelas = (int)($configBingo['min_cartelas'] ?? 1);
    $max_cartelas = (int)($configBingo['max_cartelas'] ?? 50);
    $intervalo_jogos = (int)($configBingo['intervalo_jogos'] ?? 300);
    $rtp = (int)($configBingo['rtp'] ?? 85);
    $velocidade_sorteio = (int)($configBingo['velocidade_sorteio'] ?? 1);
    $ativar_bots = (int)($configBingo['ativar_bots'] ?? 1);
    $ativar_narracao = (int)($configBingo['ativar_narracao'] ?? 1);
    $meta_arrecadacao = (float)($configBingo['meta_arrecadacao_minima'] ?? 0.00);
    $modo_inicio = $configBingo['modo_inicio_jogo'] ?? 'tempo';
    $premio_quadra = (float)($configBingo['premio_quadra_default'] ?? 20.00);
    $premio_quina = (float)($configBingo['premio_quina_default'] ?? 30.00);
    $premio_bingo = (float)($configBingo['premio_cartela_cheia_default'] ?? 60.00);
    $url_suporte = $configBingo['url_suporte'] ?? '';
} else {
    // Valores padrão caso não exista configuração
    $valores_cartela = '["0.10","0.20","0.30","0.50","1.00","5.00","10.00","50.00"]';
    $min_cartelas = 1;
    $max_cartelas = 50;
    $intervalo_jogos = 300;
    $rtp = 85;
    $velocidade_sorteio = 1;
    $ativar_bots = 1;
    $ativar_narracao = 1;
    $meta_arrecadacao = 0.00;
    $modo_inicio = 'tempo';
    $premio_quadra = 20.00;
    $premio_quina = 30.00;
    $premio_bingo = 60.00;
    $url_suporte = '';
}

?>
<div class="container-conteudo">
    <h2 class="titulo-funcoes">Configurações do Bingo</h2>
    <div class="grid-boxes">
        <button class="box-funcao modalBingoGeral">
            <i class="fas fa-cog"></i>
            <span>Configurações Gerais</span>
        </button>

        <button class="box-funcao modalBingoPremios">
            <i class="fas fa-trophy"></i>
            <span>Prêmios Padrão</span>
        </button>

        <button class="box-funcao modalBingoCartelas">
            <i class="fas fa-th"></i>
            <span>Cartelas e Valores</span>
        </button>

        <button class="box-funcao modalBingoTempo">
            <i class="fas fa-clock"></i>
            <span>Tempo e Velocidade</span>
        </button>

        <button class="box-funcao modalBingoExtra">
            <i class="fas fa-sliders-h"></i>
            <span>Extras e Bots</span>
        </button>
    </div>
</div>

<!-- Modal: Configurações Gerais -->
<div id="modalBingoGeral" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2>Configurações Gerais do Bingo</h2>
        <div id="alerta-bingo-geral"></div>
        <form id="formbingogeral" action="php/bingo_geral.php">
            <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_bingo_geral'] ?? '' ?>">
            
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-percentage"></i>
                    <select name="rtp" id="select-rtp">
                        <option value="">Selecione o RTP (%)</option>
                        <option value="70" <?= $rtp == 70 ? 'selected' : '' ?>>70%</option>
                        <option value="75" <?= $rtp == 75 ? 'selected' : '' ?>>75%</option>
                        <option value="80" <?= $rtp == 80 ? 'selected' : '' ?>>80%</option>
                        <option value="85" <?= $rtp == 85 ? 'selected' : '' ?>>85%</option>
                        <option value="90" <?= $rtp == 90 ? 'selected' : '' ?>>90%</option>
                        <option value="95" <?= $rtp == 95 ? 'selected' : '' ?>>95%</option>
                    </select>
                </div>
            </div>

            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-play-circle"></i>
                    <select name="modo_inicio" id="select-modo-inicio">
                        <option value="tempo" <?= $modo_inicio == 'tempo' ? 'selected' : '' ?>>Iniciar por Tempo</option>
                        <option value="arrecadacao" <?= $modo_inicio == 'arrecadacao' ? 'selected' : '' ?>>Iniciar por Arrecadação</option>
                    </select>
                </div>
            </div>

            <div class="form-row" id="row-meta-arrecadacao" style="<?= $modo_inicio == 'arrecadacao' ? '' : 'display:none;' ?>">
                <div class="input-icon">
                    <i class="fas fa-dollar-sign"></i>
                    <input type="number" step="0.01" name="meta_arrecadacao" placeholder="Meta de Arrecadação (R$)" value="<?= number_format($meta_arrecadacao, 2, '.', '') ?>">
                </div>
            </div>

            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-link"></i>
                    <input type="text" name="url_suporte" placeholder="URL de Suporte (opcional)" value="<?= htmlspecialchars($url_suporte) ?>">
                </div>
            </div>

            <input type="submit" id="subBingoGeral" class="submit-button espacobutton" value="Atualizar">
        </form>

        <div class="info-modal">
            <p><strong>RTP (Return to Player):</strong> Percentual de retorno aos jogadores</p>
            <p><strong>Modo de Início:</strong> <?= $modo_inicio == 'tempo' ? 'Por tempo fixo' : 'Por meta de arrecadação' ?></p>
            <?php if ($modo_inicio == 'arrecadacao'): ?>
            <p><strong>Meta:</strong> R$ <?= number_format($meta_arrecadacao, 2, ',', '.') ?></p>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Modal: Prêmios Padrão -->
<div id="modalBingoPremios" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2>Prêmios Padrão do Bingo</h2>
        <div id="alerta-bingo-premios"></div>
        <form id="formbingopremios" action="php/bingo_premios.php">
            <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_bingo_premios'] ?? '' ?>">
            
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-award"></i>
                    <input type="number" step="0.01" name="premio_quadra" placeholder="Prêmio Quadra (R$)" value="<?= number_format($premio_quadra, 2, '.', '') ?>">
                </div>
            </div>

            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-medal"></i>
                    <input type="number" step="0.01" name="premio_quina" placeholder="Prêmio Quina (R$)" value="<?= number_format($premio_quina, 2, '.', '') ?>">
                </div>
            </div>

            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-trophy"></i>
                    <input type="number" step="0.01" name="premio_bingo" placeholder="Prêmio Bingo/Cartela Cheia (R$)" value="<?= number_format($premio_bingo, 2, '.', '') ?>">
                </div>
            </div>

            <input type="submit" id="subBingoPremios" class="submit-button espacobutton" value="Atualizar">
        </form>

        <div class="info-modal">
            <p><strong>Quadra:</strong> R$ <?= number_format($premio_quadra, 2, ',', '.') ?></p>
            <p><strong>Quina:</strong> R$ <?= number_format($premio_quina, 2, ',', '.') ?></p>
            <p><strong>Bingo (Cartela Cheia):</strong> R$ <?= number_format($premio_bingo, 2, ',', '.') ?></p>
        </div>
    </div>
</div>

<!-- Modal: Cartelas e Valores -->
<div id="modalBingoCartelas" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2>Cartelas e Valores</h2>
        <div id="alerta-bingo-cartelas"></div>
        <form id="formbingocartelas" action="php/bingo_cartelas.php">
            <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_bingo_cartelas'] ?? '' ?>">
            
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-arrow-down"></i>
                    <input type="number" min="1" name="min_cartelas" placeholder="Mínimo de Cartelas" value="<?= $min_cartelas ?>">
                </div>
            </div>

            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-arrow-up"></i>
                    <input type="number" min="1" name="max_cartelas" placeholder="Máximo de Cartelas" value="<?= $max_cartelas ?>">
                </div>
            </div>

            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-dollar-sign"></i>
                    <input type="text" name="valores_cartela" placeholder='Valores (JSON): ["0.10","0.20","0.50"]' value='<?= htmlspecialchars($valores_cartela) ?>'>
                </div>
            </div>

            <input type="submit" id="subBingoCartelas" class="submit-button espacobutton" value="Atualizar">
        </form>

        <div class="info-modal">
            <p><strong>Mínimo:</strong> <?= $min_cartelas ?> cartela(s)</p>
            <p><strong>Máximo:</strong> <?= $max_cartelas ?> cartelas</p>
            <p><strong>Valores disponíveis:</strong> <?= str_replace(['"','[',']'], '', $valores_cartela) ?></p>
        </div>
    </div>
</div>

<!-- Modal: Tempo e Velocidade -->
<div id="modalBingoTempo" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2>Tempo e Velocidade do Sorteio</h2>
        <div id="alerta-bingo-tempo"></div>
        <form id="formbingotempo" action="php/bingo_tempo.php">
            <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_bingo_tempo'] ?? '' ?>">
            
            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-clock"></i>
                    <input type="number" min="30" name="intervalo_jogos" placeholder="Intervalo entre Jogos (segundos)" value="<?= $intervalo_jogos ?>">
                </div>
            </div>

            <div class="form-row">
                <div class="input-icon">
                    <i class="fas fa-tachometer-alt"></i>
                    <select name="velocidade_sorteio" id="select-velocidade">
                        <option value="">Velocidade do Sorteio</option>
                        <option value="1" <?= $velocidade_sorteio == 1 ? 'selected' : '' ?>>1 segundo (Muito Rápido)</option>
                        <option value="2" <?= $velocidade_sorteio == 2 ? 'selected' : '' ?>>2 segundos (Rápido)</option>
                        <option value="3" <?= $velocidade_sorteio == 3 ? 'selected' : '' ?>>3 segundos (Normal)</option>
                        <option value="4" <?= $velocidade_sorteio == 4 ? 'selected' : '' ?>>4 segundos (Moderado)</option>
                        <option value="5" <?= $velocidade_sorteio == 5 ? 'selected' : '' ?>>5 segundos (Lento)</option>
                    </select>
                </div>
            </div>

            <input type="submit" id="subBingoTempo" class="submit-button espacobutton" value="Atualizar">
        </form>

        <div class="info-modal">
            <p><strong>Intervalo entre jogos:</strong> <?= $intervalo_jogos ?> segundos (<?= floor($intervalo_jogos/60) ?> min)</p>
            <p><strong>Velocidade do sorteio:</strong> <?= $velocidade_sorteio ?> segundo(s) por bola</p>
            <p><i class="fas fa-info-circle"></i> Tempo total estimado para 75 bolas: <?= ($velocidade_sorteio * 75) ?> segundos</p>
        </div>
    </div>
</div>

<!-- Modal: Extras e Bots -->
<div id="modalBingoExtra" class="modal">
    <div class="modal-content">
        <span class="close-modal"><i class="fas fa-times"></i></span>
        <h2>Configurações Extras</h2>
        <div id="alerta-bingo-extra"></div>
        <form id="formbingoextra" action="php/bingo_extra.php">
            <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_bingo_extra'] ?? '' ?>">
            
            <div class="form-row toggle-row">
                <label class="toggle-switch">
                    <input type="checkbox" id="toggleBots" name="toggleBots" <?= $ativar_bots == 1 ? 'checked' : '' ?>>
                    <span class="switch-slider"></span>
                </label>
                <span class="toggle-label">Ativar Bots (Jogadores Virtuais)</span>
            </div>

            <div class="form-row toggle-row">
                <label class="toggle-switch">
                    <input type="checkbox" id="toggleNarracao" name="toggleNarracao" <?= $ativar_narracao == 1 ? 'checked' : '' ?>>
                    <span class="switch-slider"></span>
                </label>
                <span class="toggle-label">Ativar Narração de Áudio</span>
            </div>

            <input type="hidden" name="ativar_bots" id="ativar_bots" value="<?= $ativar_bots ?>">
            <input type="hidden" name="ativar_narracao" id="ativar_narracao" value="<?= $ativar_narracao ?>">

            <input type="submit" id="subBingoExtra" class="submit-button espacobutton" value="Atualizar">
        </form>

        <div class="info-modal">
            <p><strong>Bots:</strong> <?= $ativar_bots == 1 ? 'Ativado' : 'Desativado' ?></p>
            <p><strong>Narração:</strong> <?= $ativar_narracao == 1 ? 'Ativada' : 'Desativada' ?></p>
        </div>
    </div>
</div>

<script>
// Script para exibir/ocultar meta de arrecadação
document.addEventListener('DOMContentLoaded', function() {
    const selectModoInicio = document.getElementById('select-modo-inicio');
    const rowMetaArrecadacao = document.getElementById('row-meta-arrecadacao');
    
    if (selectModoInicio) {
        selectModoInicio.addEventListener('change', function() {
            if (this.value === 'arrecadacao') {
                rowMetaArrecadacao.style.display = '';
            } else {
                rowMetaArrecadacao.style.display = 'none';
            }
        });
    }

    // Toggle Bots
    const toggleBots = document.getElementById('toggleBots');
    const inputBots = document.getElementById('ativar_bots');
    if (toggleBots && inputBots) {
        toggleBots.addEventListener('change', function() {
            inputBots.value = this.checked ? '1' : '0';
        });
    }

    // Toggle Narração
    const toggleNarracao = document.getElementById('toggleNarracao');
    const inputNarracao = document.getElementById('ativar_narracao');
    if (toggleNarracao && inputNarracao) {
        toggleNarracao.addEventListener('change', function() {
            inputNarracao.value = this.checked ? '1' : '0';
        });
    }
});
</script>
