async function registerPushAndSubscribe() {
  if (!('serviceWorker' in navigator) || !('PushManager' in window)) return;

  // registra sw.js (na raiz!)
  const reg = await navigator.serviceWorker.register('/sw.js');

  // pede permissão
  if (Notification.permission === 'default') {
    const perm = await Notification.requestPermission();
    if (perm !== 'granted') return;
  }

  // já inscrito?
  let sub = await reg.pushManager.getSubscription();
  if (!sub) {
    const vapidPublicKey = window.VAPID_PUBLIC_KEY; // você vai setar via PHP
    sub = await reg.pushManager.subscribe({
      userVisibleOnly: true,
      applicationServerKey: urlBase64ToUint8Array(vapidPublicKey)
    });
  }

  // envia subscription pro seu servidor (salva no banco)
  await fetch('/php/push_save_subscription.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify(sub)
  });

  localStorage.setItem('push_ok', '1');
}

// helper do VAPID
function urlBase64ToUint8Array(base64String) {
  const padding = '='.repeat((4 - (base64String.length % 4)) % 4);
  const base64 = (base64String + padding).replace(/-/g, '+').replace(/_/g, '/');
  const raw = atob(base64);
  const arr = new Uint8Array(raw.length);
  for (let i = 0; i < raw.length; ++i) arr[i] = raw.charCodeAt(i);
  return arr;
}
