<?php
session_start();
$usuario_logado = isset($_SESSION['usuario_id']);
$confirmou18 = isset($_COOKIE['age_ok']) && $_COOKIE['age_ok'] === '1';

// Mostra somente se NÃO está logado e ainda NÃO confirmou
$mostrar_modal_18 = (!$usuario_logado && !$confirmou18);
// Gerar um token CSRF único para cada página
function gerar_token_csrf($form) {
    $token = bin2hex(random_bytes(32));
    $_SESSION["csrf_token_$form"] = $token;
    return $token;
}

// Exemplo de como gerar para diferentes formulários
if ($_SERVER["REQUEST_METHOD"] == "GET") {
    // Gerando o token para cada formulário
    $token_contato = gerar_token_csrf('contato');
    $token_login = gerar_token_csrf('login');
    $token_cadastro = gerar_token_csrf('cadastro');
    $token_recuperar_senha = gerar_token_csrf('recuperar_senha');
}

define('IN_INDEX', true);
require_once 'includes/db.php';
require_once 'includes/config.php';

// Se já estiver logado via sessão
if (isset($_SESSION['usuario_id'])) {
    header("Location: /dashboard/");
    exit;
}

// Se tiver o token no cookie, tenta autenticar
if (isset($_COOKIE['auth_token'])) {
    $token = $_COOKIE['auth_token'];

    // Consulta com prefixo bet_ nas colunas e tabela
    $stmt = $pdo->prepare("SELECT id, bet_status FROM bet_usuarios WHERE bet_token = ?");
    $stmt->execute([$token]);
    $usuario = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($usuario && $usuario['bet_status'] == 1) {
        $_SESSION['usuario_id'] = $usuario['id'];
        header("Location: /dashboard/");
        exit;
    } else {
        // Apaga o cookie se o token for inválido
        setcookie("auth_token", "", time() - 3600, "/");
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="format-detection" content="telephone=no">
    <title><?= $NomeSite ?> Cassino e Apostas Online com Bônus Exclusivos</title>
    <link rel="icon" type="image/png" href="imagens/<?= $Favicon ?>">

        <!-- Meta Tags Essenciais -->
        <meta name="description" content="Jogue na <?= $NomeSite ?> e descubra o melhor cassino online ao vivo! Aposte em esportes e cassino com bônus exclusivos. Depósitos rápidos via Pix.">

        <!-- Open Graph / Facebook -->
        <meta property="og:type" content="website">
        <meta property="og:title" content="<?= $NomeSite ?> - O Melhor Cassino Online e Apostas Esportivas">
        <meta property="og:description" content="Aposte e ganhe na <?= $NomeSite ?>! Cassino ao vivo, jogos de roleta, blackjack, slots e apostas esportivas. Depósitos via Pix e saques instantâneos.">
        <meta property="og:image" content="https://<?= $Site ?>/imagens/<?= $Logo ?>">
        <meta property="og:url" content="https://<?= $Site ?>">
        <meta property="og:site_name" content="<?= $NomeSite ?>">

        <!-- Twitter -->
        <meta name="twitter:card" content="summary_large_image">
        <meta name="twitter:title" content="<?= $NomeSite ?> - Cassino Online e Apostas com Pix">
        <meta name="twitter:description" content="Entre no mundo das apostas com <?= $NomeSite ?>! Cassino ao vivo, jogos exclusivos e bônus especiais para novos jogadores.">
        <meta name="twitter:image" content="https://<?= $Site ?>/imagens/<?= $Logo ?>">

        <!-- SEO Keywords -->
        <meta name="keywords" content="Cassino online, apostas esportivas, jogos de azar, slots, roleta, blackjack, poker, cassino ao vivo, bônus cassino, <?= $NomeSite ?>, apostas com Pix">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="css/estilos.php">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
    <script src="js/scripts.js"></script>

    <!-- CSS DO BOTTOM NAVIGATION CORRIGIDO -->
    <style>
        
        /* ===== Modal Base ===== */
.auth-overlay{
  position:fixed; inset:0;
  background:rgba(0,0,0,.72);
  z-index:9998;
  backdrop-filter: blur(2px);
}
.auth-modal{
  position:fixed; inset:0;
  z-index:9999;
  display:flex;
  align-items:flex-start;
  justify-content:center;
  padding:18px 12px;
  overflow:auto;
}
.auth-card{
  width:min(520px, 94vw);
  background: linear-gradient(180deg, #1a1c22 0%, #111218 100%);
  border:1px solid rgba(255,255,255,.08);
  border-radius:18px;
  box-shadow:0 20px 80px rgba(0,0,0,.65);
  padding:14px 16px 18px;
  color:#fff;
}

/* ===== Top Tabs ===== */
.auth-top{
  display:flex;
  align-items:center;
  gap:14px;
  position:relative;
  padding:6px 2px 12px;
  border-bottom:1px solid rgba(255,255,255,.08);
}
.auth-tab{
  background:transparent;
  border:none;
  color:rgba(255,255,255,.75);
  font-size:18px;
  padding:10px 8px;
  cursor:pointer;
  position:relative;
}
.auth-tab.active{
  color:#f5a200;
}
.auth-tab.active::after{
  content:"";
  position:absolute;
  left:8px; right:8px; bottom:-13px;
  height:3px;
  border-radius:99px;
  background:#f5a200;
  box-shadow:0 6px 20px rgba(245,162,0,.35);
}
.auth-close{
  margin-left:auto;
  width:42px; height:42px;
  border-radius:12px;
  border:1px solid rgba(255,255,255,.12);
  background:rgba(0,0,0,.35);
  color:#fff;
  cursor:pointer;
  font-size:18px;
}

/* ===== Logo + subtitle ===== */
.auth-logo{
  display:flex;
  justify-content:center;
  padding:16px 0 6px;
}
.auth-logo img{
  max-width:180px;
  height:auto;
}
.auth-subtitle{
  text-align:center;
  color:rgba(255,255,255,.55);
  margin:6px 0 14px;
  font-size:16px;
}

/* ===== Panes ===== */
.auth-pane{ display:none; }
.auth-pane.show{ display:block; }

/* ===== Segmented control ===== */
.auth-seg{
  display:flex;
  border:1px solid rgba(255,255,255,.10);
  background:rgba(255,255,255,.04);
  border-radius:12px;
  overflow:hidden;
  margin: 0 4px 14px;
}
.auth-seg-btn{
  flex:1;
  padding:12px 10px;
  border:none;
  background:transparent;
  color:rgba(255,255,255,.75);
  cursor:pointer;
  font-weight:600;
}
.auth-seg-btn.active{
  background:#f5a200;
  color:#111;
}

/* ===== Inputs ===== */
.auth-field{
  display:flex;
  align-items:center;
  gap:10px;
  background: rgba(0,0,0,.25);
  border:1px solid rgba(255,255,255,.10);
  border-radius:14px;
  padding:14px 14px;
  margin: 10px 4px;
}
.auth-ico{
  width:28px;
  display:flex;
  justify-content:center;
  opacity:.9;
}
.auth-field input{
  flex:1;
  background:transparent;
  border:none;
  outline:none;
  color:#fff;
  font-size:16px;
}
.auth-field input::placeholder{
  color: rgba(255,255,255,.35);
}
.auth-eye{
  background:transparent;
  border:none;
  color:rgba(255,255,255,.65);
  cursor:pointer;
  font-size:16px;
}

/* ===== Links ===== */
.auth-link{
  background:transparent;
  border:none;
  color:#f5a200;
  cursor:pointer;
  padding:10px 4px;
  margin: 2px 0 10px;
  font-size:14px;
  text-align:left;
}
.auth-ref{
  display:flex;
  justify-content:flex-end;
  padding: 0 4px;
}

/* ===== Checkbox ===== */
.auth-check{
  display:flex;
  gap:10px;
  align-items:flex-start;
  margin: 8px 4px 14px;
  color:rgba(255,255,255,.70);
  font-size:14px;
}
.auth-check input{
  margin-top:3px;
  width:18px; height:18px;
  accent-color:#f5a200;
}
.auth-check b{ color:#f5a200; }

/* ===== Primary button ===== */
.auth-btn-primary{
  width: calc(100% - 8px);
  margin: 6px 4px 0;
  border:none;
  border-radius:12px;
  padding:14px 14px;
  cursor:pointer;
  font-size:18px;
  font-weight:800;
  color:#111;
  background: linear-gradient(180deg, #ffb300 0%, #f59f00 100%);
  box-shadow: 0 10px 26px rgba(245,162,0,.35);
}
.auth-btn-primary:active{
  transform: translateY(1px);
}

/* ===== Footer bottom ===== */
.auth-bottom{
  display:flex;
  justify-content:space-between;
  gap:10px;
  padding: 14px 4px 0;
  color:rgba(255,255,255,.55);
  font-size:14px;
}
.auth-bottom-link{
  background:transparent;
  border:none;
  color:#f5a200;
  cursor:pointer;
  font-weight:700;
}

        /* ========================================================
   TICKER PARTIDAS AO VIVO - ESTILO BETANO
   ======================================================== */
.ticker-ao-vivo {
    width: 100%;
    overflow: hidden;
    background: #0d1117;
    padding: 12px 0;
    margin: 8px 0;
}

.ticker-strip {
    display: flex;
    gap: 12px;
    padding: 0 12px;
    width: max-content;
}

.ticker-strip:hover {
    animation-play-state: paused;
}

@keyframes tickerScroll {
    0% { transform: translateX(0); }
    100% { transform: translateX(-50%); }
}

/* Card da Partida */
.ticker-card {
    flex-shrink: 0;
    width: 280px;
    background: #1a1f2e;
    border-radius: 12px;
    overflow: hidden;
    cursor: pointer;
    transition: all 0.2s ease;
    border: 1px solid rgba(255,255,255,0.06);
}

.ticker-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.4);
    border-color: rgba(255,255,255,0.12);
}

/* Header do Card - Liga */
.ticker-card-header {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 10px 14px;
    background: #151a26;
    border-bottom: 1px solid rgba(255,255,255,0.05);
}

.ticker-flag { font-size: 16px; line-height: 1; }

.ticker-league {
    flex: 1;
    font-size: 12px;
    color: #8b95a5;
    font-weight: 500;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

/* Corpo do Card */
.ticker-card-body { padding: 12px 14px; }

/* Linha do tempo + badge */
.ticker-time-row {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 10px;
}

.ticker-time {
    font-size: 14px;
    font-weight: 600;
    color: #fff;
}

.ticker-badge {
    font-size: 10px;
    font-weight: 700;
    padding: 4px 8px;
    border-radius: 4px;
    text-transform: uppercase;
}

.ticker-badge.live {
    background: linear-gradient(135deg, #ff4757 0%, #ff6b81 100%);
    color: #fff;
    animation: pulseLive 2s infinite;
}

.ticker-badge.upcoming {
    background: linear-gradient(135deg, #f59e0b 0%, #fbbf24 100%);
    color: #000;
}

.ticker-badge.finished {
    background: #374151;
    color: #9ca3af;
}

@keyframes pulseLive {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.7; }
}

/* Times */
.ticker-teams { margin-bottom: 12px; }

.ticker-team-row {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 6px 0;
}

.ticker-team-info {
    display: flex;
    align-items: center;
    gap: 10px;
    flex: 1;
}

.ticker-team-icon {
    width: 22px;
    height: 22px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 16px;
}

.ticker-team-name {
    font-size: 14px;
    color: #fff;
    font-weight: 500;
    max-width: 160px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.ticker-card-indicator {
    width: 14px;
    height: 18px;
    border-radius: 2px;
    margin-left: 6px;
}

.ticker-card-indicator.red { background: #ef4444; }
.ticker-card-indicator.yellow { background: #fbbf24; }

.ticker-team-score {
    font-size: 18px;
    font-weight: 700;
    color: #fff;
    min-width: 30px;
    text-align: right;
}

/* Odds Clicáveis */
.ticker-odds {
    display: flex;
    gap: 8px;
}

.ticker-odd {
    flex: 1;
    background: #252d3d;
    border-radius: 8px;
    padding: 10px 12px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    cursor: pointer;
    transition: all 0.2s ease;
    border: 2px solid transparent;
}

.ticker-odd:hover {
    background: #2d3748;
    border-color: #3b82f6;
}

.ticker-odd.selected {
    background: #1e3a5f;
    border-color: #3b82f6;
}

.ticker-odd-label {
    font-size: 12px;
    color: #9ca3af;
    font-weight: 500;
}

.ticker-odd-value {
    font-size: 14px;
    font-weight: 700;
    color: #10b981;
}

/* ========================================================
   MODAL DE APOSTA - ESTILO BETANO/BET365
   ======================================================== */
.modal-aposta-overlay {
    position: fixed;
    inset: 0;
    background: rgba(0,0,0,0.7);
    z-index: 9998;
    opacity: 0;
    visibility: hidden;
    transition: all 0.3s ease;
}

.modal-aposta-overlay.show {
    opacity: 1;
    visibility: visible;
}

.modal-aposta {
    position: fixed;
    bottom: 0;
    left: 0;
    right: 0;
    background: linear-gradient(180deg, #1a1f2e 0%, #0f1419 100%);
    border-radius: 20px 20px 0 0;
    z-index: 9999;
    transform: translateY(100%);
    transition: transform 0.3s ease;
    max-height: 85vh;
    overflow-y: auto;
}

.modal-aposta.show {
    transform: translateY(0);
}

@media (min-width: 768px) {
    .modal-aposta {
        left: 50%;
        right: auto;
        bottom: 50%;
        transform: translate(-50%, 50%) scale(0.9);
        border-radius: 20px;
        width: 420px;
        max-height: 80vh;
    }
    
    .modal-aposta.show {
        transform: translate(-50%, 50%) scale(1);
    }
}

/* Header do Modal */
.aposta-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 16px 20px;
    border-bottom: 1px solid rgba(255,255,255,0.08);
    background: #151a26;
    border-radius: 20px 20px 0 0;
}

.aposta-header-title {
    display: flex;
    align-items: center;
    gap: 10px;
}

.aposta-header-title i {
    color: #fbbf24;
    font-size: 18px;
}

.aposta-header-title span {
    color: #fff;
    font-size: 16px;
    font-weight: 600;
}

.aposta-close-btn {
    background: rgba(255,255,255,0.1);
    border: none;
    color: #fff;
    width: 36px;
    height: 36px;
    border-radius: 50%;
    cursor: pointer;
    font-size: 18px;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.2s ease;
}

.aposta-close-btn:hover {
    background: rgba(255,255,255,0.2);
}

/* Conteúdo do Modal */
.aposta-content {
    padding: 20px;
}

/* Card da Seleção */
.aposta-selecao {
    background: #252d3d;
    border-radius: 12px;
    padding: 16px;
    margin-bottom: 20px;
    position: relative;
}

.aposta-remover {
    position: absolute;
    top: 12px;
    right: 12px;
    background: rgba(239,68,68,0.2);
    border: none;
    color: #ef4444;
    width: 24px;
    height: 24px;
    border-radius: 50%;
    cursor: pointer;
    font-size: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.aposta-remover:hover {
    background: rgba(239,68,68,0.3);
}

.aposta-partida {
    display: flex;
    align-items: center;
    gap: 8px;
    margin-bottom: 10px;
}

.aposta-partida-flag {
    font-size: 16px;
}

.aposta-partida-info {
    flex: 1;
}

.aposta-partida-liga {
    font-size: 11px;
    color: #6b7280;
    margin-bottom: 2px;
}

.aposta-partida-times {
    font-size: 13px;
    color: #fff;
    font-weight: 500;
}

.aposta-tipo {
    display: flex;
    align-items: center;
    justify-content: space-between;
    background: #1a1f2e;
    border-radius: 8px;
    padding: 12px;
}

.aposta-tipo-label {
    font-size: 13px;
    color: #9ca3af;
}

.aposta-tipo-odd {
    font-size: 16px;
    font-weight: 700;
    color: #10b981;
}

/* Input de Valor */
.aposta-valor-section {
    margin-bottom: 20px;
}

.aposta-valor-label {
    display: block;
    font-size: 13px;
    color: #9ca3af;
    margin-bottom: 10px;
}

.aposta-valor-input-container {
    display: flex;
    align-items: center;
    background: #252d3d;
    border-radius: 10px;
    border: 2px solid transparent;
    transition: all 0.2s ease;
    overflow: hidden;
}

.aposta-valor-input-container:focus-within {
    border-color: #3b82f6;
}

.aposta-valor-prefix {
    padding: 14px 12px;
    color: #9ca3af;
    font-weight: 600;
    font-size: 16px;
    background: #1a1f2e;
}

.aposta-valor-input {
    flex: 1;
    background: transparent;
    border: none;
    color: #fff;
    font-size: 18px;
    font-weight: 600;
    padding: 14px;
    outline: none;
}

.aposta-valor-input::placeholder {
    color: #4b5563;
}

/* Valores Rápidos */
.aposta-valores-rapidos {
    display: flex;
    gap: 8px;
    margin-bottom: 20px;
    flex-wrap: wrap;
}

.aposta-valor-btn {
    flex: 1;
    min-width: 70px;
    background: #252d3d;
    border: 1px solid rgba(255,255,255,0.1);
    color: #fff;
    padding: 10px;
    border-radius: 8px;
    font-size: 13px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.2s ease;
}

.aposta-valor-btn:hover {
    background: #2d3748;
    border-color: #3b82f6;
}

/* Resumo da Aposta */
.aposta-resumo {
    background: #252d3d;
    border-radius: 12px;
    padding: 16px;
    margin-bottom: 20px;
}

.aposta-resumo-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 8px 0;
}

.aposta-resumo-row:not(:last-child) {
    border-bottom: 1px solid rgba(255,255,255,0.05);
}

.aposta-resumo-label {
    font-size: 13px;
    color: #9ca3af;
}

.aposta-resumo-value {
    font-size: 14px;
    color: #fff;
    font-weight: 500;
}

.aposta-resumo-value.highlight {
    color: #10b981;
    font-size: 18px;
    font-weight: 700;
}

/* Saldo Disponível */
.aposta-saldo {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 12px 16px;
    background: rgba(16, 185, 129, 0.1);
    border-radius: 10px;
    margin-bottom: 20px;
    border: 1px solid rgba(16, 185, 129, 0.2);
}

.aposta-saldo-label {
    font-size: 13px;
    color: #9ca3af;
}

.aposta-saldo-value {
    font-size: 16px;
    font-weight: 700;
    color: #10b981;
}

/* Botão de Apostar */
.btn-fazer-aposta {
    width: 100%;
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    border: none;
    color: #fff;
    padding: 16px;
    border-radius: 12px;
    font-size: 16px;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.2s ease;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.btn-fazer-aposta:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(16, 185, 129, 0.4);
}

.btn-fazer-aposta:disabled {
    background: #374151;
    cursor: not-allowed;
    transform: none;
    box-shadow: none;
}

/* Alerta */
.aposta-alerta {
    padding: 12px 16px;
    border-radius: 10px;
    margin-bottom: 15px;
    font-size: 13px;
    display: none;
}

.aposta-alerta.show { display: block; }

.aposta-alerta.error {
    background: rgba(239, 68, 68, 0.15);
    border: 1px solid rgba(239, 68, 68, 0.3);
    color: #fca5a5;
}

.aposta-alerta.success {
    background: rgba(16, 185, 129, 0.15);
    border: 1px solid rgba(16, 185, 129, 0.3);
    color: #6ee7b7;
}
/* ========================================================
   BOTÃO MINHAS APOSTAS FLUTUANTE
   ======================================================== */
.btn-minhas-apostas {
    position: fixed;
    bottom: 90px;
    right: 16px;
    background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
    color: #fff;
    border: none;
    padding: 12px 20px;
    border-radius: 50px;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    z-index: 1000;
    display: flex;
    align-items: center;
    gap: 8px;
    box-shadow: 0 4px 20px rgba(59, 130, 246, 0.4);
    transition: all 0.2s ease;
}

.btn-minhas-apostas:hover {
    transform: translateY(-3px);
    box-shadow: 0 6px 25px rgba(59, 130, 246, 0.5);
}

.btn-minhas-apostas .badge {
    background: #ef4444;
    color: #fff;
    font-size: 11px;
    font-weight: 700;
    padding: 2px 8px;
    border-radius: 10px;
    min-width: 20px;
    text-align: center;
}

/* ========================================================
   MODAL MINHAS APOSTAS
   ======================================================== */
.modal-minhas-apostas {
    position: fixed;
    bottom: 0;
    left: 0;
    right: 0;
    background: linear-gradient(180deg, #1a1f2e 0%, #0f1419 100%);
    border-radius: 20px 20px 0 0;
    z-index: 9999;
    transform: translateY(100%);
    transition: transform 0.3s ease;
    max-height: 80vh;
    overflow-y: auto;
}

.modal-minhas-apostas.show {
    transform: translateY(0);
}

.minhas-apostas-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 16px 20px;
    border-bottom: 1px solid rgba(255,255,255,0.08);
    background: #151a26;
    border-radius: 20px 20px 0 0;
    position: sticky;
    top: 0;
}

.minhas-apostas-content {
    padding: 20px;
}

/* Card de Aposta */
.aposta-card {
    background: #252d3d;
    border-radius: 12px;
    padding: 16px;
    margin-bottom: 12px;
    border-left: 4px solid #fbbf24;
}

.aposta-card.ganhou { border-left-color: #10b981; }
.aposta-card.perdeu { border-left-color: #ef4444; }

.aposta-card-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 12px;
}

.aposta-card-partida {
    font-size: 13px;
    color: #fff;
    font-weight: 500;
}

.aposta-card-status {
    font-size: 10px;
    font-weight: 700;
    padding: 4px 10px;
    border-radius: 20px;
    text-transform: uppercase;
}

.aposta-card-status.pendente {
    background: rgba(251, 191, 36, 0.15);
    color: #fbbf24;
}

.aposta-card-status.ganhou {
    background: rgba(16, 185, 129, 0.15);
    color: #10b981;
}

.aposta-card-status.perdeu {
    background: rgba(239, 68, 68, 0.15);
    color: #ef4444;
}

.aposta-card-tipo {
    font-size: 12px;
    color: #9ca3af;
    margin-bottom: 12px;
}

.aposta-card-footer {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding-top: 12px;
    border-top: 1px solid rgba(255,255,255,0.05);
}

.aposta-card-valores {
    display: flex;
    gap: 20px;
}

.aposta-card-valor-item {
    text-align: center;
}

.aposta-card-valor-label {
    font-size: 10px;
    color: #6b7280;
    margin-bottom: 2px;
}

.aposta-card-valor-num {
    font-size: 14px;
    font-weight: 700;
    color: #fff;
}

.aposta-card-valor-num.green { color: #10b981; }

.aposta-vazia {
    text-align: center;
    padding: 40px 20px;
    color: #6b7280;
}

.aposta-vazia i {
    font-size: 48px;
    margin-bottom: 16px;
    opacity: 0.5;
}

.aposta-vazia p {
    font-size: 14px;
}

/* Responsivo */
@media (max-width: 480px) {
    .ticker-card { width: 390px; }
    .ticker-team-name { max-width: 130px; font-size: 13px; }
    .btn-minhas-apostas { bottom: 80px; right: 12px; padding: 10px 16px; font-size: 13px; }
}
        /* BOTTOM NAVIGATION STYLES */
.bottom-nav {
    position: fixed;
    bottom: 0;
    left: 0;
    right: 0;

    background: rgba(20, 20, 20, 0.75); /* TRANSPARÊNCIA */
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);

    display: flex;
    justify-content: space-around;
    align-items: center;
    padding: 8px 0 max(8px, env(safe-area-inset-bottom));
    box-shadow: 0 -2px 20px rgba(0, 0, 0, 0.35);
    z-index: 1000;
    border-top: 1px solid rgba(255,255,255,0.08);
}


        .bottom-nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-decoration: none;
            color: #888;
            transition: all 0.3s ease;
            padding: 5px;
            border-radius: 8px;
            min-width: 45px;
        }

        .bottom-nav-item:hover {
            color: #ffd700;
            transform: translateY(-2px);
        }

        .bottom-nav-item.active {
            color: #ffd700;
        }

        .bottom-nav-item .icon {
            font-size: 20px;
            margin-bottom: 2px;
        }

        .bottom-nav-item .label {
            font-size: 10px;
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        /* BOTÃO CENTRAL DESTACADO (DEPÓSITO) */
        .bottom-nav-item.center {
            color: white;
            border-radius: 50%;
            width: 55px;
            height: 55px;
            margin-top: -25px;
        }

        .bottom-nav-item.center:hover {
            transform: translateY(-4px) scale(1.05);
            box-shadow: 0 6px 25px rgba(255, 107, 53, 0.6);
            color: white;
        }

        .bottom-nav-item.center .icon {
            font-size: 24px;
            margin-bottom: 0;
        }

        .bottom-nav-item.center .label {
            display: none;
        }

        /* RESPONSIVO */
        @media (max-width: 480px) {
            .bottom-nav-item .label {
                font-size: 9px;
            }
            
            .bottom-nav-item .icon {
                font-size: 18px;
            }

            .bottom-nav-item.center .icon {
                font-size: 22px;
            }
        }

        /* AJUSTAR BODY PARA NÃO SOBREPOR */
        body {
            padding-bottom: 70px;
        }

        /* ESCONDER EM DESKTOP */
        @media (min-width: 1024px) {
            .bottom-nav {
                display: none;
            }
            
            body {
                padding-bottom: 0;
            }
        }

        /* MODAL MENU MOBILE - CORRIGIDO */
        .mobile-menu {
            position: fixed;
            top: 0;
            left: -100%; /* CORRIGIDO: mudei de -300px para -100% */
            width: 280px;
            max-width: 85vw; /* ADICIONADO: máximo 85% da tela */
            height: 100vh;
            background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%);
            z-index: 2000;
            transition: left 0.3s ease;
            padding: 20px;
            color: white;
            overflow-y: auto;
            /* ADICIONADO: forçar que fique escondido */
            visibility: hidden;
            opacity: 0;
        }

        .mobile-menu.show {
            left: 0;
            visibility: visible; /* ADICIONADO */
            opacity: 1; /* ADICIONADO */
        }

        .mobile-menu-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 1999;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
            /* ADICIONADO: garantir que não interfira quando escondido */
            pointer-events: none;
        }

        .mobile-menu-overlay.show {
            opacity: 1;
            visibility: visible;
            pointer-events: auto; /* ADICIONADO */
        }

        .mobile-menu-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid #333;
        }

        .mobile-menu-header h3 {
            margin: 0;
            color: #ffd700;
        }

        .mobile-menu-close {
            background: none;
            border: none;
            color: white;
            font-size: 24px;
            cursor: pointer;
            padding: 5px;
        }

        .mobile-menu-item {
            display: flex;
            align-items: center;
            padding: 15px 0;
            border-bottom: 1px solid #333;
            color: white;
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .mobile-menu-item:hover {
            color: #ffd700;
        }

        .mobile-menu-item i {
            margin-right: 15px;
            width: 20px;
            font-size: 18px;
        }

        /* CORREÇÃO ADICIONAL: Garantir que não haja conflito com outros elementos */
        @media (max-width: 1023px) {
            .mobile-menu {
                display: block;
            }
        }

        @media (min-width: 1024px) {
            .mobile-menu,
            .mobile-menu-overlay {
                display: none !important;
            }
        }
.center-nav-icon {
    width: 37px;
    height: 37px;
    margin-top: 16px; /* DESCE a imagem */
}
/* REMOVE FUNDO AMARELO DO BOTÃO CADASTRO (TOPO) */
.button.modalCadastro {
    background: transparent !important;
    border: none !important;
    box-shadow: none !important;
    padding: 0 !important;
}

/* garante no hover/active/focus */
.button.modalCadastro:hover,
.button.modalCadastro:active,
.button.modalCadastro:focus {
    background: transparent !important;
    box-shadow: none !important;
    outline: none !important;
}

/* imagem do botão */
.button.modalCadastro .btn-img {
    display: block;
    max-width: 120px;
    height: auto;
    pointer-events: none;
}

/* BOTÃO LOGIN — SÓ TEXTO CINZA */
.button.modalLogin {
    background: transparent !important;
    border: none !important;
    box-shadow: none !important;
    padding: 0 !important;

    color: #9e9e9e;        /* CINZA */
    font-weight: 500;
    cursor: pointer;
}

/* hover / active / focus */
.button.modalLogin:hover {
    color: #cfcfcf;       /* cinza mais claro */
}

.button.modalLogin:active {
    color: #ffffff;
}

.button.modalLogin:focus {
    outline: none !important;
    box-shadow: none !important;
}
button {
    -webkit-tap-highlight-color: transparent;
}

button:focus,
button:active,
button:focus-visible {
    outline: none;
    box-shadow: none;
}
/* BANNER APP TOPO */
.app-banner {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;

    height: 48px;
    background: #f6a300; /* laranja */
    color: #fff;

    display: flex;
    align-items: center;
    justify-content: center;
    gap: 12px;

    font-size: 14px;
    z-index: 2001;
}

/* texto */
.app-banner-text {
    display: flex;
    align-items: center;
    gap: 6px;
}

/* botão download */
.app-banner-btn {
    background: #2b2f36;
    color: #fff;
    border: none;
    padding: 6px 14px;
    border-radius: 8px;
    font-size: 14px;
    cursor: pointer;
}

/* botão fechar */
.app-banner-close {
    position: absolute;
    right: 12px;
    font-size: 18px;
    cursor: pointer;
}

/* empurra o top-bar pra baixo */
.top-bar {
    margin-top: 48px;
}
body{
    padding-top: 91px; /* 48 (banner) + ~62 (top-bar) ajuste se precisar */
}

/* TOP BAR FIXA (acompanha o scroll) */
.top-bar{
    position: fixed;
    top: 48px; /* altura do banner */
    left: 0;
    right: 0;
    z-index: 2000;
    margin-top: 0 !important; /* cancela o margin-top que você colocou */
}
.dots {
    display: none !important;
}
.busca-container {
    margin-top: -34px;   /* diminui aqui */
    padding-top: 0;    /* garante sem espaço interno */
}
.ganhos-container {
    margin-top: 6px;   /* DIMINUI aqui */
    padding-top: 0;
}
.age-overlay{
  position: fixed;
  inset: 0;
  background: rgba(0,0,0,.65);
  z-index: 9998;
  backdrop-filter: blur(2px);
}

.age-modal{
  position: fixed;
  inset: 0;
  z-index: 9999;
  display: flex;
  align-items: center;
  justify-content: center;
  padding: 18px;
}

.age-box{
  width: min(520px, 92vw);
  background: #0f1419;
  border-radius: 18px;
  padding: 22px;
  border: 1px solid rgba(255,255,255,.08);
  box-shadow: 0 18px 60px rgba(0,0,0,.55);
  text-align: center;
}

.age-logo img{
  max-width: 220px;
  height: auto;
  margin-bottom: 10px;
}

.age-title{
  color: #fff;
  font-size: 20px;
  font-weight: 700;
  margin: 10px 0 18px;
}

.age-actions{
  display: flex;
  gap: 12px;
  justify-content: center;
  margin-bottom: 16px;
}

.age-btn{
  flex: 1;
  max-width: 200px;
  border: none;
  border-radius: 12px;
  padding: 14px 10px;
  font-weight: 800;
  font-size: 15px;
  cursor: pointer;
}

.age-btn.yes{ background: #22c55e; color: #fff; }
.age-btn.no{ background: #6b7280; color: #fff; }

.age-authorized{
  background: transparent;
  border: none;
  padding: 0;
  margin-top: 12px;

  display: flex;
  justify-content: center;
}


.age-authorized-img{
  width: 160px;   /* ajuste se quiser maior/menor */
  height: auto;
}


.age-authorized-text{
  text-align: left;
  color: #fff;
  line-height: 1.1;
}

.age-authorized-text span{
  color: rgba(255,255,255,.7);
  font-size: 12px;
}

    </style>
</head>
<body>
<?php if ($mostrar_modal_18): ?>
<div class="age-overlay" id="ageOverlay"></div>

<div class="age-modal" id="ageModal" role="dialog" aria-modal="true">
  <div class="age-box">
    <div class="age-logo">
      <img src="imagens/<?= $Logo ?>" alt="Logo">
    </div>

    <h2 class="age-title">Você é maior de 18 anos?</h2>

    <div class="age-actions">
      <button class="age-btn yes" id="ageYes">SIM</button>
      <button class="age-btn no" id="ageNo">NÃO</button>
    </div>

    <div class="age-authorized">
      <img src="https://i.postimg.cc/c1DMNtpr/1620-autorizado-17359161041535.webp" alt="Autorizado" class="age-authorized-img">
      <div class="age-authorized-text">
      </div>
    </div>
  </div>
</div>
<?php endif; ?>

   <!-- Conteúdo dos termos -->
<div id="sidebar" class="sidebar">
    <span class="close-sidebar"><i class="fas fa-times"></i></span> 
    <div class="sidebar-content" id="sidebarContent"></div>
</div>    
 

<!-- OVERLAY -->
<div class="auth-overlay" id="authOverlay" style="display:none;"></div>

<!-- MODAL AUTH (LOGIN + CADASTRO) -->
<div class="auth-modal" id="authModal" style="display:none;" role="dialog" aria-modal="true">
  <div class="auth-card">

    <!-- Header Tabs -->
    <div class="auth-top">
      <button class="auth-tab active" id="tabLogin" type="button">Conecte-se</button>
      <button class="auth-tab" id="tabCadastro" type="button">Inscrever-se</button>

      <button class="auth-close" id="authClose" type="button" aria-label="Fechar">
        ✕
      </button>
    </div>

    <!-- Logo -->
    <div class="auth-logo">
      <img src="imagens/<?= $Logo ?>" alt="Logo">
    </div>

    <!-- =========================
         LOGIN
    ========================== -->
    <div class="auth-pane show" id="paneLogin">

      <p class="auth-subtitle">Faça login com suas credenciais</p>

      <!-- Segmented: Email / Telefone -->
      <div class="auth-seg" role="tablist" aria-label="Método de login">
        <button type="button" class="auth-seg-btn active" id="segEmail">E-mail</button>
        <button type="button" class="auth-seg-btn" id="segTelefone">Telefone</button>
      </div>

      <div id="alerta-login"></div>

      <form id="formlogin" action="php/login.php" method="post">
        <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_login'] ?? '' ?>">

        <!-- EMAIL -->
        <div class="auth-field" id="loginEmailWrap">
          <span class="auth-ico">✉️</span>
          <input type="email" id="emaillogin" name="email" placeholder="E-mail" autocomplete="email">
        </div>

        <!-- TELEFONE -->
        <div class="auth-field" id="loginTelWrap" style="display:none;">
          <span class="auth-ico">🇧🇷</span>
          <input type="tel" id="telefonelogin" name="telefone" placeholder="Telefone" autocomplete="tel">
        </div>

        <!-- SENHA -->
        <div class="auth-field">
          <span class="auth-ico">🔒</span>
          <input type="password" id="senhaLogin" name="senha" placeholder="Digite sua senha" autocomplete="current-password">
          <button class="auth-eye" type="button" data-toggle="#senhaLogin" aria-label="Mostrar senha">👁️</button>
        </div>

        <button class="auth-link" type="button" id="btnAbrirRecuperar">Esqueceu sua senha?</button>

        <button type="submit" id="subLogin" class="auth-btn-primary">Iniciar Sessão</button>
      </form>

      <div class="auth-bottom">
        <span>Ainda não tem uma conta?</span>
        <button type="button" class="auth-bottom-link" id="goCadastro">Criar uma conta grátis</button>
      </div>
    </div>

<!-- =========================
     CADASTRO
========================== -->
<div class="auth-pane" id="paneCadastro">

  <p class="auth-subtitle">Vamos começar criando sua conta</p>

  <div id="alerta-cadastro"></div>

  <!-- ✅ FORM COM MESMA ESTRUTURA DO ANTIGO -->
  <form id="formcadastro" action="php/cadastro.php">

    <?php
        $ref = (isset($_GET['ref']) && is_numeric($_GET['ref'])) ? $_GET['ref'] : '';
        $utm = (isset($_GET['utm']) && !empty($_GET['utm'])) ? $_GET['utm'] : '';
    ?>
    <input type="hidden" name="ref" value="<?php echo htmlspecialchars($ref); ?>">
    <input type="hidden" name="utm" value="<?php echo htmlspecialchars($utm, ENT_QUOTES, 'UTF-8'); ?>">
    <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token_cadastro'] ?? '' ?>">

    <!-- NOME -->
    <div class="auth-field">
      <span class="auth-ico">🪪</span>
      <input type="text" id="nome" name="nome" placeholder="Nome completo" autocomplete="name">
    </div>

    <!-- EMAIL -->
    <div class="auth-field">
      <span class="auth-ico">✉️</span>
      <input type="email" id="email" name="email" placeholder="Email" autocomplete="email">
    </div>

    <!-- CPF -->
    <div class="auth-field">
      <span class="auth-ico">🆔</span>
      <input type="text" id="cpf" name="cpf" placeholder="CPF" inputmode="numeric" autocomplete="off">
    </div>

    <!-- DATA DE NASCIMENTO -->
    <div class="auth-field">
      <span class="auth-ico">📅</span>
      <input type="text" id="nascimento" name="nascimento" placeholder="Data de nascimento" autocomplete="bday">
    </div>

    <!-- SENHA -->
    <div class="auth-field">
      <span class="auth-ico">🔒</span>
      <input type="password" id="senha" name="senha" placeholder="Senha com no mínimo 8 caracteres" autocomplete="new-password">
      <button class="auth-eye" type="button" data-toggle="#senha" aria-label="Mostrar senha">👁️</button>
    </div>

    <!-- CONFIRMAR SENHA -->
    <div class="auth-field">
      <span class="auth-ico">🔒</span>
      <input type="password" id="confirmasenha" name="confirmasenha" placeholder="Confirme a senha" autocomplete="new-password">
      <button class="auth-eye" type="button" data-toggle="#confirmasenha" aria-label="Mostrar senha">👁️</button>
    </div>

    <!-- BOTÃO SUBMIT -->
    <button type="submit" id="subCadastro" class="auth-btn-primary">Abrir Conta</button>

    <!-- TERMOS -->
    <div class="auth-termos">
      <p style="color:rgba(255,255,255,.55);font-size:12px;margin:14px 4px 0;line-height:1.5;">
        <strong style="color:#f5a200;">Ao abrir uma conta:</strong><br>
        Eu aceito os <a id="termo-condicao" style="color:#f5a200;cursor:pointer;">Termos e condições</a> da <?= $NomeSite ?>. 
        Li e entendi a <a id="termo-privacidade" style="color:#f5a200;cursor:pointer;">Política de privacidade</a> e 
        <a id="termo-cookies" style="color:#f5a200;cursor:pointer;">Política de cookies</a> da <?= $NomeSite ?>, 
        conforme publicado no site e confirmo que tenho 
        <a id="termo-18anos" style="color:#f5a200;cursor:pointer;">18 anos de idade ou mais</a>.
      </p>
    </div>

    <!-- LINK PARA LOGIN -->
    <div class="auth-bottom">
      <span>Já tem uma conta?</span>
      <button type="button" class="auth-bottom-link" id="goLogin">Faça login aqui</button>
    </div>
  </form>
</div>

  </div>
</div>


<!-- MENU MOBILE OVERLAY - CORRIGIDO -->
<div class="mobile-menu-overlay" id="mobileMenuOverlay"></div>

<!-- MENU MOBILE - CORRIGIDO -->
<div class="mobile-menu" id="mobileMenu">
    <div class="mobile-menu-header">
        <h3><i class="fas fa-bars"></i> Menu</h3>
        <button class="mobile-menu-close" id="mobileMenuClose">
            <i class="fas fa-times"></i>
        </button>
    </div>
    
    <a href="#" class="mobile-menu-item">
        <i class="fas fa-home"></i>
        <span>Início</span>
    </a>
    
    <a href="#" class="mobile-menu-item">
        <i class="fas fa-futbol"></i>
        <span>BINGO</span>
    </a>
    
    <a href="#" class="mobile-menu-item">
        <i class="fas fa-dice"></i>
        <span>CASSINO</span>
    </a>
    
    <a href="#" class="mobile-menu-item">
        <i class="fas fa-broadcast-tower"></i>
        <span>JOGO DO BICHO</span>
    </a>
    
    <a href="#" class="mobile-menu-item modalContato">
        <i class="fas fa-headset"></i>
        <span>Suporte</span>
    </a>
    
    <a href="#termo-jogo-responsavel" class="mobile-menu-item">
        <i class="fas fa-shield-alt"></i>
        <span>Jogo Responsável</span>
    </a>
</div>

<!-- BANNER APP -->
<div class="app-banner">
    <span class="app-banner-text">
        📱 Baixe o aplicativo e ganhe pontos
    </span>

    <button class="app-banner-btn">Download</button>

    <span class="app-banner-close" onclick="this.parentElement.style.display='none'">✕</span>
</div>


 <!-- Container topo -->      
    <div class="top-bar">
        <div class="container">
            <div class="logo">
                <img src="imagens/<?= $Logo ?>">
            </div>
            <div class="buttons">
                <button class="button  modalLogin">Entrar</button>
                                <button class="button modalCadastro">
    <img 
        src="https://i.postimg.cc/ncV6jRvr/befunky-2026-0-5-23-30-19.png"
        alt="Criar Conta"
        class="btn-img"
    >
</button>
            </div>
        </div>
    </div>

<!-- Container slider -->  
<div class="slider-wrapper">
  <div class="slider-container">
    <div class="slides" id="slides">
      <div class="slide"><img src="imagens/<?= $slider1 ?>"></div>
      <div class="slide"><img src="imagens/<?= $slider2 ?>"></div>
      <div class="slide"><img src="imagens/<?= $slider3 ?>"></div>
    </div>
  </div>

  <div class="dots" id="dots">
    <span class="dot active" data-index="0"></span>
    <span class="dot" data-index="1"></span>
    <span class="dot" data-index="2"></span>
  </div>
</div>
<!-- Container busca --> 
    <div class="busca-container">
    <form id="form-busca" onsubmit="return false;">
  <div class="busca-input-icon">
      <i class="fas fa-search"></i>
      <input type="text" id="input-busca" name="busca"
       placeholder="Pesquisar um jogo de cassino..."
       class="busca-input" autocomplete="off">

  </div>
</form>
    <div id="resultado-busca" class="busca-resultado"></div>
</div>
<?php if (!empty($ticker_partidas)): ?>
<div class="ticker-ao-vivo">
    <div class="ticker-strip" id="tickerStrip">
        <?php
        for ($loop = 0; $loop < 1; $loop++):
            foreach ($ticker_partidas as $p):
                $badge_class = $p['status'] ?? 'live';
        ?>
        <div class="ticker-card" data-partida-id="<?= $p['id'] ?>">
            <div class="ticker-card-header">
                <span class="ticker-flag"><?= htmlspecialchars($p['flag'] ?? '⚽') ?></span>
                <span class="ticker-league"><?= htmlspecialchars($p['liga'] ?? '') ?></span>
            </div>
            
            <div class="ticker-card-body">
                <div class="ticker-time-row">
                    <div style="display: flex; align-items: center; gap: 10px;">
                        <span class="ticker-time"><?= htmlspecialchars($p['tempo'] ?? '') ?></span>
                        <span class="ticker-badge <?= $badge_class ?>">
                            <?= $badge_class === 'live' ? '🔥 AO VIVO' : ($badge_class === 'upcoming' ? 'EM BREVE' : 'ENCERRADO') ?>
                        </span>
                    </div>
                </div>
                
                <div class="ticker-teams">
                    <div class="ticker-team-row">
                        <div class="ticker-team-info">
                            <span class="ticker-team-icon">🏠</span>
                            <span class="ticker-team-name"><?= htmlspecialchars($p['time_casa'] ?? '') ?></span>
                            <?php if (!empty($p['cartao_casa'])): ?>
                            <span class="ticker-card-indicator <?= $p['cartao_casa'] ?>"></span>
                            <?php endif; ?>
                        </div>
                        <span class="ticker-team-score"><?= $p['placar_casa'] ?? 0 ?></span>
                            <?php if (!empty($p['cartao_fora'])): ?>
                            <span class="ticker-card-indicator <?= $p['cartao_fora'] ?>"></span>
                            <?php endif; ?>
                        </div>
                        <span class="ticker-team-score"><?= $p['placar_fora'] ?? 0 ?></span>
                    </div>
                </div>
                
                <div class="ticker-odds">
                    <div class="ticker-odd" 
                         onclick="abrirModalAposta(<?= $p['id'] ?>, '<?= htmlspecialchars($p['flag'] ?? '') ?>', '<?= htmlspecialchars($p['liga'] ?? '') ?>', '<?= htmlspecialchars($p['time_casa'] ?? '') ?>', '<?= htmlspecialchars($p['time_fora'] ?? '') ?>', '<?= htmlspecialchars($p['odd_label_1'] ?? '') ?>', <?= $p['odd_valor_1'] ?? 1.50 ?>)">
                        <span class="ticker-odd-label"><?= htmlspecialchars($p['odd_label_1'] ?? 'Mais de 2.5') ?></span>
                        <span class="ticker-odd-value"><?= number_format($p['odd_valor_1'] ?? 1.50, 2) ?></span>
                    </div>
                    <div class="ticker-odd"
                         onclick="abrirModalAposta(<?= $p['id'] ?>, '<?= htmlspecialchars($p['flag'] ?? '') ?>', '<?= htmlspecialchars($p['liga'] ?? '') ?>', '<?= htmlspecialchars($p['time_casa'] ?? '') ?>', '<?= htmlspecialchars($p['time_fora'] ?? '') ?>', '<?= htmlspecialchars($p['odd_label_2'] ?? '') ?>', <?= $p['odd_valor_2'] ?? 2.00 ?>)">
                     </div>
                    <div class="ticker-team-row">
                        <div class="ticker-team-info">
                            <span class="ticker-team-icon">✈️</span>
                            <span class="ticker-team-name"><?= htmlspecialchars($p['time_fora'] ?? '') ?></span>
                       <span class="ticker-odd-label"><?= htmlspecialchars($p['odd_label_2'] ?? 'Menos de 2.5') ?></span>
                        <span class="ticker-odd-value"><?= number_format($p['odd_valor_2'] ?? 2.00, 2) ?></span>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
        <?php endfor; ?>
    </div>
</div>
<?php endif; ?>

<!-- ============================================================
     5. BOTÃO MINHAS APOSTAS FLUTUANTE
     ============================================================ -->
<button class="btn-minhas-apostas" id="btnMinhasApostas" onclick="abrirMinhasApostas()">
    <i class="fas fa-receipt"></i>
    <span id="apostasTexto">Minhas Apostas</span>
    <span class="badge" id="apostasCount"><?= $apostas_pendentes ?? 0 ?></span>
</button>

<!-- ============================================================
     6. MODAL DE APOSTA
     ============================================================ -->
<div class="modal-aposta-overlay" id="modalApostaOverlay" onclick="fecharModalAposta()"></div>
<div class="modal-aposta" id="modalAposta">
    <div class="aposta-header">
        <div class="aposta-header-title">
            <i class="fas fa-ticket-alt"></i>
            <span>Bilhete de Aposta</span>
        </div>
        <button class="aposta-close-btn" onclick="fecharModalAposta()">
            <i class="fas fa-times"></i>
        </button>
    </div>
    
    <div class="aposta-content">
        <div class="aposta-alerta" id="apostaAlerta"></div>
        
        <!-- Seleção da Aposta -->
        <div class="aposta-selecao">
            <button class="aposta-remover" onclick="fecharModalAposta()">
                <i class="fas fa-times"></i>
            </button>
            <div class="aposta-partida">
                <span class="aposta-partida-flag" id="apostaFlag"></span>
                <div class="aposta-partida-info">
                    <div class="aposta-partida-liga" id="apostaLiga"></div>
                    <div class="aposta-partida-times" id="apostaPartida"></div>
                </div>
            </div>
            <div class="aposta-tipo">
                <span class="aposta-tipo-label" id="apostaTipo"></span>
                <span class="aposta-tipo-odd" id="apostaOdd"></span>
            </div>
        </div>
        
        <!-- Input de Valor -->
        <div class="aposta-valor-section">
            <label class="aposta-valor-label">Valor da aposta</label>
            <div class="aposta-valor-input-container">
                <span class="aposta-valor-prefix">R$</span>
                <input type="number" class="aposta-valor-input" id="apostaValorInput" 
                       placeholder="0,00" min="1" step="0.01" oninput="calcularRetorno()">
            </div>
        </div>
        
        <!-- Valores Rápidos -->
        <div class="aposta-valores-rapidos">
            <button class="aposta-valor-btn" onclick="setValorAposta(10)">R$ 10</button>
            <button class="aposta-valor-btn" onclick="setValorAposta(25)">R$ 25</button>
            <button class="aposta-valor-btn" onclick="setValorAposta(50)">R$ 50</button>
            <button class="aposta-valor-btn" onclick="setValorAposta(100)">R$ 100</button>
        </div>
        
        <!-- Resumo -->
        <div class="aposta-resumo">
            <div class="aposta-resumo-row">
                <span class="aposta-resumo-label">Odd</span>
                <span class="aposta-resumo-value" id="resumoOdd">0.00</span>
            </div>
            <div class="aposta-resumo-row">
                <span class="aposta-resumo-label">Valor apostado</span>
                <span class="aposta-resumo-value" id="resumoValor">R$ 0,00</span>
            </div>
            <div class="aposta-resumo-row">
                <span class="aposta-resumo-label">Retorno potencial</span>
                <span class="aposta-resumo-value highlight" id="resumoRetorno">R$ 0,00</span>
            </div>
        </div>
        
        <!-- Saldo -->
        <div class="aposta-saldo">
            <span class="aposta-saldo-label">Saldo disponível</span>
            <span class="aposta-saldo-value">R$ <?= number_format($saldo ?? 0, 2, ',', '.') ?></span>
        </div>
        
        <!-- Botão Apostar -->
        <button class="btn-fazer-aposta" id="btnFazerAposta" onclick="fazerAposta()" disabled>
            Fazer Aposta
        </button>
    </div>
</div>

<!-- ============================================================
     7. MODAL MINHAS APOSTAS
     ============================================================ -->
<div class="modal-aposta-overlay" id="modalMinhasApostasOverlay" onclick="fecharMinhasApostas()"></div>
<div class="modal-minhas-apostas" id="modalMinhasApostas">
    <div class="minhas-apostas-header">
        <div class="aposta-header-title">
            <i class="fas fa-receipt"></i>
            <span>Minhas Apostas</span>
        </div>
        <button class="aposta-close-btn" onclick="fecharMinhasApostas()">
            <i class="fas fa-times"></i>
        </button>
    </div>
    
    <div class="minhas-apostas-content" id="minhasApostasContent">
        <!-- Carregado via AJAX -->
    </div>
</div>

<!-- ============================================================
     8. JAVASCRIPT
     ============================================================ -->
<script>
// Variáveis globais da aposta atual
let apostaAtual = {
    partidaId: null,
    flag: '',
    liga: '',
    timeCasa: '',
    timeFora: '',
    tipoAposta: '',
    odd: 0
};

const saldoUsuario = <?= $saldo ?? 0 ?>;

// Abrir modal de aposta
function abrirModalAposta(partidaId, flag, liga, timeCasa, timeFora, tipoAposta, odd) {
    apostaAtual = { partidaId, flag, liga, timeCasa, timeFora, tipoAposta, odd };
    
    document.getElementById('apostaFlag').textContent = flag;
    document.getElementById('apostaLiga').textContent = liga;
    document.getElementById('apostaPartida').textContent = `${timeCasa} x ${timeFora}`;
    document.getElementById('apostaTipo').textContent = tipoAposta;
    document.getElementById('apostaOdd').textContent = odd.toFixed(2);
    document.getElementById('resumoOdd').textContent = odd.toFixed(2);
    document.getElementById('apostaValorInput').value = '';
    document.getElementById('resumoValor').textContent = 'R$ 0,00';
    document.getElementById('resumoRetorno').textContent = 'R$ 0,00';
    document.getElementById('btnFazerAposta').disabled = true;
    document.getElementById('apostaAlerta').classList.remove('show');
    
    document.getElementById('modalApostaOverlay').classList.add('show');
    document.getElementById('modalAposta').classList.add('show');
    document.body.style.overflow = 'hidden';
}

// Fechar modal de aposta
function fecharModalAposta() {
    document.getElementById('modalApostaOverlay').classList.remove('show');
    document.getElementById('modalAposta').classList.remove('show');
    document.body.style.overflow = '';
}

// Definir valor rápido
function setValorAposta(valor) {
    document.getElementById('apostaValorInput').value = valor;
    calcularRetorno();
}

// Calcular retorno potencial
function calcularRetorno() {
    const valor = parseFloat(document.getElementById('apostaValorInput').value) || 0;
    const odd = apostaAtual.odd;
    const retorno = valor * odd;
    
    document.getElementById('resumoValor').textContent = `R$ ${valor.toFixed(2).replace('.', ',')}`;
    document.getElementById('resumoRetorno').textContent = `R$ ${retorno.toFixed(2).replace('.', ',')}`;
    
    const btn = document.getElementById('btnFazerAposta');
    btn.disabled = valor <= 0 || valor > saldoUsuario;
}

// Fazer aposta
function fazerAposta() {
    const valor = parseFloat(document.getElementById('apostaValorInput').value) || 0;
    const alerta = document.getElementById('apostaAlerta');
    const btn = document.getElementById('btnFazerAposta');
    
    if (valor <= 0) {
        alerta.className = 'aposta-alerta error show';
        alerta.textContent = 'Digite um valor válido para apostar.';
        return;
    }
    
    if (valor > saldoUsuario) {
        alerta.className = 'aposta-alerta error show';
        alerta.textContent = 'Saldo insuficiente para esta aposta.';
        return;
    }
    
    btn.disabled = true;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processando...';
    
    fetch('php/fazer_aposta.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({
            partida_id: apostaAtual.partidaId,
            tipo_aposta: apostaAtual.tipoAposta,
            odd: apostaAtual.odd,
            valor: valor,
            descricao_partida: `${apostaAtual.timeCasa} x ${apostaAtual.timeFora}`,
            descricao_aposta: apostaAtual.tipoAposta
        })
    })
    .then(r => r.json())
    .then(data => {
        if (data.success) {
            alerta.className = 'aposta-alerta success show';
            alerta.textContent = '✓ Aposta realizada com sucesso!';
            
            // Atualiza contador
            const count = document.getElementById('apostasCount');
            count.textContent = parseInt(count.textContent) + 1;
            
            setTimeout(() => {
                fecharModalAposta();
                location.reload(); // Recarrega para atualizar saldo
            }, 1500);
        } else {
            alerta.className = 'aposta-alerta error show';
            alerta.textContent = data.message || 'Erro ao fazer aposta.';
            btn.disabled = false;
            btn.innerHTML = 'Fazer Aposta';
        }
    })
    .catch(() => {
        alerta.className = 'aposta-alerta error show';
        alerta.textContent = 'Erro de conexão. Tente novamente.';
        btn.disabled = false;
        btn.innerHTML = 'Fazer Aposta';
    });
}

// Abrir minhas apostas
function abrirMinhasApostas() {
    document.getElementById('modalMinhasApostasOverlay').classList.add('show');
    document.getElementById('modalMinhasApostas').classList.add('show');
    document.body.style.overflow = 'hidden';
    
    carregarMinhasApostas();
}

// Fechar minhas apostas
function fecharMinhasApostas() {
    document.getElementById('modalMinhasApostasOverlay').classList.remove('show');
    document.getElementById('modalMinhasApostas').classList.remove('show');
    document.body.style.overflow = '';
}

// Carregar minhas apostas
function carregarMinhasApostas() {
    const container = document.getElementById('minhasApostasContent');
    container.innerHTML = '<div style="text-align:center;padding:40px;"><i class="fas fa-spinner fa-spin" style="font-size:24px;color:#6b7280;"></i></div>';
    
    fetch('php/minhas_apostas.php')
    .then(r => r.json())
    .then(data => {
        if (data.apostas && data.apostas.length > 0) {
            let html = '';
            data.apostas.forEach(a => {
                html += `
                <div class="aposta-card ${a.status}">
                    <div class="aposta-card-header">
                        <span class="aposta-card-partida">${a.descricao_partida}</span>
                        <span class="aposta-card-status ${a.status}">${a.status.toUpperCase()}</span>
                    </div>
                    <div class="aposta-card-tipo">${a.descricao_aposta} @ ${parseFloat(a.odd_selecionada).toFixed(2)}</div>
                    <div class="aposta-card-footer">
                        <div class="aposta-card-valores">
                            <div class="aposta-card-valor-item">
                                <div class="aposta-card-valor-label">Apostado</div>
                                <div class="aposta-card-valor-num">R$ ${parseFloat(a.valor_apostado).toFixed(2).replace('.', ',')}</div>
                            </div>
                            <div class="aposta-card-valor-item">
                                <div class="aposta-card-valor-label">Retorno</div>
                                <div class="aposta-card-valor-num green">R$ ${parseFloat(a.retorno_potencial).toFixed(2).replace('.', ',')}</div>
                            </div>
                        </div>
                    </div>
                </div>
                `;
            });
            container.innerHTML = html;
        } else {
            container.innerHTML = `
            <div class="aposta-vazia">
                <i class="fas fa-receipt"></i>
                <p>Você ainda não fez nenhuma aposta.</p>
            </div>
            `;
        }
    })
    .catch(() => {
        container.innerHTML = '<div class="aposta-vazia"><p>Erro ao carregar apostas.</p></div>';
    });
}

// Ajusta velocidade do ticker
(function() {
    const strip = document.getElementById('tickerStrip');
    if (!strip) return;
    requestAnimationFrame(() => {
        const totalWidth = strip.scrollWidth / 2;
        strip.style.animationDuration = (totalWidth / 50) + 's';
    });
})();
</script>

<!-- carrossel-ganhadores -->
<div class="ganhos-container">
  <div class="ganhos-fixo">
    <i class="fas fa-trophy"></i>
    <span>MAIORES<br>GANHOS<br>DE HOJE</span>
  </div>
  <div class="ganhos-rolando">
    <div class="ganhos-slider" id="ganhos-slider">
      <?php include 'funcoes/carrossel-ganhadores.php'; ?>
    </div>
  </div>
</div>



<!-- Jogos da semana -->
<div class="lista-jogos">
    <span class="titulo-lista-jogos">🔥 Jogados Da Semana</span>
    <div class="jogos-container">
        <?php include 'funcoes/jogo-semana.php'; ?>
    </div>
</div>

<!-- Jogos da PRAGMATIC -->
<div class="lista-jogos">
   <span class="titulo-lista-jogos"> PRAGMATIC</span> 
   <div class="jogos-container">
        <?php include 'funcoes/jogo-pragmatic.php'; ?>
    </div>
</div>

<!-- Jogos da PGSOFT -->
<div class="lista-jogos">
   <span class="titulo-lista-jogos"> PGSOFT</span> 
   <div class="jogos-container">
        <?php include 'funcoes/jogo-pgsoft.php'; ?>
    </div>
</div>

<!-- Jogos da SPRIBE -->
<div class="lista-jogos">
   <span class="titulo-lista-jogos"> SPRIBE</span> 
   <div class="jogos-container">
        <?php include 'funcoes/jogo-spribe.php'; ?>
    </div>
</div>

<!-- Jogos todos -->
<div class="lista-jogos">
    <span class="titulo-lista-jogos"> Todos os jogos</span> 
  <div id="jogosCarregaveis" class="jogos-container"></div>
  <button id="verMaisBtn" class="btn-ver-mais">Ver mais</button>
</div>

<div class="footer-line"></div>

<!-- Resultados ao Vivo -->
<div class="aovivo-resultados">
  <span class="aovivo-titulo">
  <span class="online-dot-red"></span> Resultados ao Vivo
</span>
  <div class="aovivo-resultado-container" id="aovivo-container"></div>
  <?php include 'funcoes/aovivo.php'; ?>
</div>

 <!-- Container footer -->
 <div class="footer">
    <div class="container-footer">
        <div class="footer-column">
            <img src="imagens/<?= $Logo ?>">
        </div>

        <div class="footer-column">
            <h4>Sobre Nós</h4>
            <ul>
                <li><a id="termo-condicao">Termos e condições</a></li>
                <li><a id="termo-privacidade">Privacidade</a></li>
                <li><a id="termo-cookies">Política de cookies</a></li>
                <li><a id="termo-18anos">18 anos ou mais</a></li>
                <li><a id="termo-jogo-responsavel">Jogo Responsável</a></li>
            </ul>
        </div>
        <div class="footer-column">
            <h4>Contato</h4>
            <ul> 
                <li><a class="modalContato">Fale Conosco</a></li>
            </ul>
        </div>
        <div class="footer-column">
            <h4>Pagamento</h4>
            <img class="pix-logo" src="imagens/logopix.png">
        </div>
        <div class="footer-column">
    <h4>Siga-nos</h4>
    <div class="social-icons">
        <a href="<?= $Instagram ?>" target="_blank"><i class="fab fa-instagram"></i></a>
        <a href="<?= $Telegram ?>" target="_blank"><i class="fab fa-telegram-plane"></i></a>
    </div>
</div>
    </div>

    <div class="footer-line"></div>

    <div class="footer-text" id="footerText">
        Jogue com responsabilidade, Apostar pode ser viciante! O jogo pode ser prejudicial se não for controlado e feito com responsabilidade. Por isso, leia todas as informações disponíveis na nossa seção de Jogo Responsável. O acesso de pessoas menores de 18 anos é estritamente proibido.<br><br>
        <div id="extraContent" style="display: none;">
        Nossa Plataforma não promove suas atividades para menores de 18 anos. Crianças devem sempre ter permissão dos pais antes de enviar qualquer informação pessoal (como nome, endereço de e-mail e número de telefone) pela internet, seja para qualquer pessoa ou para nós. Se você tem menos de 18 anos (ou idade inferior àquela legalmente permitida para fazer apostas em seu país de residência), solicitamos que não acesse nossa plataforma. Jogar pode ser algo viciante. Jogue com responsabilidade. Para mais informações, visite nossa página Jogos Responsáveis.<br><br>
        Ao navegar nesse site aceite o uso de certos cookies de navegador com o objetivo de melhorar a sua experiência. Nossa plataforma apenas usa cookies que melhoram a sua experiência e não interferem em sua privacidade. Por favor acesse à nossa Política de Privacidade para mais informação em relação à forma como utilizamos cookies e como pode desativar ou gerenciar os mesmos, caso queira.
        </div>
        <button id="toggleButton" class="ver-mais-btn">Ver mais</button>
    </div>

    <div class="footer-line"></div>

    <div class="footer-centered-img">
        <img class="selo-img" src="imagens/logosigap.png">
    </div>

    <div class="footer-line"></div>

    <div class="footer-bottom">
        <p>
            <strong>Suporte</strong> suporte@<?= $Site ?>
            <span>|</span>
            <strong>Jurídico</strong> juridico@<?= $Site ?>
            <span>|</span>
            <strong>Parceiros</strong> parceiros@<?= $Site ?>
        </p>
        <p>© 2025 <?= $NomeSite ?>. Todos os direitos reservados.</p>
    </div>
</div>  

<!-- BOTTOM NAVIGATION -->
<nav class="bottom-nav">
    <!-- Menu -->
    <a href="#" class="bottom-nav-item" id="bottomMenuBtn">
        <i class="fas fa-bars icon"></i>
        <span class="label">Menu</span>
    </a>
    
    <!-- Home -->
    <a href="#" class="bottom-nav-item active">
        <i class="fas fa-home icon"></i>
        <span class="label">Home</span>
    </a>
    
    <!-- Esportes -->
    <a href="#" class="bottom-nav-item">
        <i class="fas fa-futbol icon"></i>
        <span class="label">BINGO</span>
    </a>
    
    <!-- Depósito (Botão Central) -->
<a href="#" class="bottom-nav-item center modalCadastro">
    <img 
        src="https://i.postimg.cc/sxmqH7Cw/befunky-2026-0-5-23-30-40.png"
        alt=""
        class="center-nav-icon"
    >
</a>


    
    <!-- Ao Vivo -->
    <a href="#" class="bottom-nav-item">
        <i class="fas fa-broadcast-tower icon"></i>
        <span class="label">JBICHO</span>
    </a>
    
    <!-- Slots -->
    <a href="#" class="bottom-nav-item">
        <i class="fas fa-dice icon"></i>
        <span class="label">Slots</span>
    </a>
    
    <!-- Perfil -->
    <a href="#" class="bottom-nav-item modalLogin">
        <i class="fas fa-user icon"></i>
        <span class="label">Perfil</span>
    </a>
</nav>

<script>
// ============================================================
// SCRIPT COMPLETO - SISTEMA DE AUTENTICAÇÃO E APOSTAS
// ============================================================

(function() {
    'use strict';

    // ============================================================
    // 1. UTILITÁRIOS E HELPERS
    // ============================================================
    
    const Utils = {
        // Toast de notificação
        showToast(message, type = 'success') {
            const toast = document.createElement('div');
            toast.className = `toast-notification toast-${type}`;
            toast.innerHTML = `
                <i class="fas fa-${type === 'success' ? 'check-circle' : 'exclamation-circle'}"></i>
                <span>${message}</span>
            `;
            
            document.body.appendChild(toast);
            
            setTimeout(() => toast.classList.add('show'), 10);
            setTimeout(() => {
                toast.classList.remove('show');
                setTimeout(() => toast.remove(), 300);
            }, 3000);
        },

        // Exibir erro acima do formulário
        showFormError(containerId, message) {
            const container = document.getElementById(containerId);
            if (!container) {
                console.error('Container de erro não encontrado:', containerId);
                return;
            }

            // Remove HTML tags da mensagem se houver
            const tempDiv = document.createElement('div');
            tempDiv.innerHTML = message;
            const cleanMessage = tempDiv.textContent || tempDiv.innerText || message;

            container.innerHTML = `
                <div style="
                    padding: 12px 14px;
                    border-radius: 10px;
                    background: rgba(239, 68, 68, 0.15);
                    border: 1px solid rgba(239, 68, 68, 0.35);
                    color: #fca5a5;
                    font-weight: 600;
                    margin: 6px 4px 12px;
                    display: flex;
                    align-items: center;
                    gap: 8px;
                    animation: slideDown 0.3s ease;
                ">
                    <i class="fas fa-times-circle"></i>
                    <span>${cleanMessage}</span>
                </div>
            `;

            // Scroll para o topo do modal
            const modal = document.getElementById('authModal');
            if (modal) {
                modal.scrollTo({ top: 0, behavior: 'smooth' });
            }

            console.log('Erro exibido:', cleanMessage);
        },

        // Exibir sucesso acima do formulário
        showFormSuccess(containerId, message) {
            const container = document.getElementById(containerId);
            if (!container) return;

            const tempDiv = document.createElement('div');
            tempDiv.innerHTML = message;
            const cleanMessage = tempDiv.textContent || tempDiv.innerText || message;

            container.innerHTML = `
                <div style="
                    padding: 12px 14px;
                    border-radius: 10px;
                    background: rgba(16, 185, 129, 0.15);
                    border: 1px solid rgba(16, 185, 129, 0.35);
                    color: #6ee7b7;
                    font-weight: 600;
                    margin: 6px 4px 12px;
                    display: flex;
                    align-items: center;
                    gap: 8px;
                    animation: slideDown 0.3s ease;
                ">
                    <i class="fas fa-check-circle"></i>
                    <span>${cleanMessage}</span>
                </div>
            `;

            const modal = document.getElementById('authModal');
            if (modal) {
                modal.scrollTo({ top: 0, behavior: 'smooth' });
            }
        },

        // Limpar erros
        clearFormError(containerId) {
            const container = document.getElementById(containerId);
            if (container) container.innerHTML = '';
        },

        // Set cookie
        setCookie(name, value, days) {
            const d = new Date();
            d.setTime(d.getTime() + (days * 24 * 60 * 60 * 1000));
            document.cookie = `${name}=${value}; expires=${d.toUTCString()}; path=/; SameSite=Lax`;
        }
    };

    // ============================================================
    // 2. MODAL DE VERIFICAÇÃO DE IDADE (+18)
    // ============================================================
    
    const AgeGate = {
        init() {
            const yesBtn = document.getElementById('ageYes');
            const noBtn = document.getElementById('ageNo');
            const modal = document.getElementById('ageModal');
            const overlay = document.getElementById('ageOverlay');

            if (!modal) return;

            // Se já confirmou antes
            if (localStorage.getItem('age_ok') === '1') {
                Utils.setCookie('age_ok', '1', 30);
                this.close();
                return;
            }

            // Bloqueia scroll
            document.body.style.overflow = 'hidden';

            // Eventos
            yesBtn?.addEventListener('click', () => {
                Utils.setCookie('age_ok', '1', 30);
                localStorage.setItem('age_ok', '1');
                this.close();

                // Pede permissão para notificações
                if ('Notification' in window && Notification.permission === 'default') {
                    Notification.requestPermission();
                }
            });

            noBtn?.addEventListener('click', () => {
                window.location.href = 'https://google.com';
            });
        },

        close() {
            const modal = document.getElementById('ageModal');
            const overlay = document.getElementById('ageOverlay');
            modal?.remove();
            overlay?.remove();
            document.body.style.overflow = '';
        }
    };

    // ============================================================
    // 3. MODAL DE AUTENTICAÇÃO (LOGIN + CADASTRO)
    // ============================================================
    
    const AuthModal = {
        overlay: null,
        modal: null,
        currentTab: 'login',

        init() {
            this.overlay = document.getElementById('authOverlay');
            this.modal = document.getElementById('authModal');

            if (!this.modal) return;

            this.bindEvents();
            this.setupPasswordToggles();
            this.setupLoginSegments();
        },

        bindEvents() {
            // Abrir modal (botões com classes antigas)
            document.querySelectorAll('.modalLogin').forEach(btn => {
                btn.addEventListener('click', (e) => {
                    e.preventDefault();
                    this.open('login');
                });
            });

            document.querySelectorAll('.modalCadastro').forEach(btn => {
                btn.addEventListener('click', (e) => {
                    e.preventDefault();
                    this.open('cadastro');
                });
            });

            // Fechar modal
            document.getElementById('authClose')?.addEventListener('click', () => this.close());
            this.overlay?.addEventListener('click', () => this.close());
            document.addEventListener('keydown', (e) => {
                if (e.key === 'Escape') this.close();
            });

            // Trocar tabs
            document.getElementById('tabLogin')?.addEventListener('click', () => this.switchTab('login'));
            document.getElementById('tabCadastro')?.addEventListener('click', () => this.switchTab('cadastro'));

            // Links de troca no footer
            document.getElementById('goCadastro')?.addEventListener('click', () => this.switchTab('cadastro'));
            document.getElementById('goLogin')?.addEventListener('click', () => this.switchTab('login'));

            // Recuperar senha
            document.getElementById('btnAbrirRecuperar')?.addEventListener('click', () => {
                this.close();
                Utils.showToast('Função em desenvolvimento', 'error');
            });
        },

        setupPasswordToggles() {
            document.querySelectorAll('.auth-eye[data-toggle]').forEach(btn => {
                btn.addEventListener('click', () => {
                    const selector = btn.getAttribute('data-toggle');
                    const input = document.querySelector(selector);
                    if (!input) return;

                    if (input.type === 'password') {
                        input.type = 'text';
                        btn.textContent = '🙈';
                    } else {
                        input.type = 'password';
                        btn.textContent = '👁️';
                    }
                });
            });
        },

        setupLoginSegments() {
            const segEmail = document.getElementById('segEmail');
            const segTelefone = document.getElementById('segTelefone');
            const emailWrap = document.getElementById('loginEmailWrap');
            const telWrap = document.getElementById('loginTelWrap');

            const setMode = (mode) => {
                if (mode === 'tel') {
                    segTelefone.classList.add('active');
                    segEmail.classList.remove('active');
                    telWrap.style.display = '';
                    emailWrap.style.display = 'none';
                    document.getElementById('emaillogin').value = '';
                } else {
                    segEmail.classList.add('active');
                    segTelefone.classList.remove('active');
                    emailWrap.style.display = '';
                    telWrap.style.display = 'none';
                    const telInput = document.getElementById('telefonelogin');
                    if (telInput) telInput.value = '';
                }
            };

            segEmail?.addEventListener('click', () => setMode('email'));
            segTelefone?.addEventListener('click', () => setMode('tel'));
        },

        open(tab = 'login') {
            this.overlay.style.display = 'block';
            this.modal.style.display = 'flex';
            document.body.style.overflow = 'hidden';
            this.switchTab(tab);
        },

        close() {
            this.overlay.style.display = 'none';
            this.modal.style.display = 'none';
            document.body.style.overflow = '';
            Utils.clearFormError('alerta-login');
            Utils.clearFormError('alerta-cadastro');
        },

        switchTab(tab) {
            this.currentTab = tab;

            const tabLogin = document.getElementById('tabLogin');
            const tabCadastro = document.getElementById('tabCadastro');
            const paneLogin = document.getElementById('paneLogin');
            const paneCadastro = document.getElementById('paneCadastro');

            if (tab === 'cadastro') {
                tabCadastro.classList.add('active');
                tabLogin.classList.remove('active');
                paneCadastro.classList.add('show');
                paneLogin.classList.remove('show');
            } else {
                tabLogin.classList.add('active');
                tabCadastro.classList.remove('active');
                paneLogin.classList.add('show');
                paneCadastro.classList.remove('show');
            }

            // Limpa erros ao trocar
            Utils.clearFormError('alerta-login');
            Utils.clearFormError('alerta-cadastro');
        }
    };

    // ============================================================
    // 4. FORMULÁRIOS (LOGIN E CADASTRO) - CORRIGIDO
    // ============================================================
    
    const Forms = {
        init() {
            this.setupMasks();
            this.setupLogin();
            this.setupCadastro();
        },

        setupMasks() {
            // Verifica se jQuery está carregado
            if (typeof jQuery !== 'undefined' && jQuery.fn.mask) {
                jQuery('#cpf').mask('000.000.000-00');
                jQuery('#nascimento').mask('00/00/0000');
            }
        },

        setupLogin() {
            const form = document.getElementById('formlogin');
            if (!form) {
                console.error('Formulário de login não encontrado!');
                return;
            }

            form.addEventListener('submit', (e) => {
                e.preventDefault();
                console.log('Login: Formulário enviado');

                const btn = document.getElementById('subLogin');
                const msgDiv = 'alerta-login';

                Utils.clearFormError(msgDiv);
                btn.disabled = true;
                btn.textContent = 'Entrando...';

                const formData = new FormData(form);

                // Log dos dados enviados
                console.log('Login: Dados do formulário:', Object.fromEntries(formData));

                fetch(form.action, {
                    method: 'POST',
                    body: formData
                })
                .then(res => {
                    console.log('Login: Status da resposta:', res.status);
                    return res.text();
                })
                .then(text => {
                    console.log('Login: Resposta raw:', text);
                    
                    let data;
                    try {
                        data = JSON.parse(text);
                    } catch (e) {
                        console.error('Login: Erro ao parsear JSON:', e);
                        throw new Error('Resposta inválida do servidor');
                    }

                    console.log('Login: Dados parseados:', data);

                    // Sucesso
                    if (data.success === true || data.status === 'alertasim') {
                        console.log('Login: Sucesso! Redirecionando...');
                        Utils.showFormSuccess(msgDiv, 'Login realizado com sucesso!');
                        Utils.showToast('Login realizado com sucesso! 🎉', 'success');
                        
                        setTimeout(() => {
                            window.location.href = data.redirect || '/dashboard/';
                        }, 1000);
                        return;
                    }

                    // Erro - Exibe mensagem
                    console.log('Login: Falha -', data.message);
                    
                    let errorMessage = 'Erro ao fazer login. Verifique seus dados.';
                    
                    if (data.message) {
                        errorMessage = data.message;
                    } else if (data.error) {
                        errorMessage = data.error;
                    }

                    Utils.showFormError(msgDiv, errorMessage);
                    btn.disabled = false;
                    btn.textContent = 'Iniciar Sessão';
                })
                .catch(error => {
                    console.error('Login: Erro na requisição:', error);
                    Utils.showFormError(msgDiv, 'Erro de conexão. Tente novamente.');
                    btn.disabled = false;
                    btn.textContent = 'Iniciar Sessão';
                });
            });
        },

        setupCadastro() {
            const form = document.getElementById('formcadastro');
            if (!form) {
                console.error('Formulário de cadastro não encontrado!');
                return;
            }

            form.addEventListener('submit', (e) => {
                e.preventDefault();
                console.log('Cadastro: Formulário enviado');

                const btn = document.getElementById('subCadastro');
                const msgDiv = 'alerta-cadastro';

                Utils.clearFormError(msgDiv);
                btn.disabled = true;
                btn.textContent = 'Criando conta...';

                const formData = new FormData(form);

                // Log dos dados enviados
                console.log('Cadastro: Dados do formulário:', Object.fromEntries(formData));

                fetch(form.action, {
                    method: 'POST',
                    body: formData
                })
                .then(res => {
                    console.log('Cadastro: Status da resposta:', res.status);
                    return res.text();
                })
                .then(text => {
                    console.log('Cadastro: Resposta raw:', text);
                    
                    let data;
                    try {
                        data = JSON.parse(text);
                    } catch (e) {
                        console.error('Cadastro: Erro ao parsear JSON:', e);
                        throw new Error('Resposta inválida do servidor');
                    }

                    console.log('Cadastro: Dados parseados:', data);

                    // Sucesso
                    if (data.success === true || data.status === 'alertasim') {
                        console.log('Cadastro: Sucesso! Redirecionando...');
                        Utils.showFormSuccess(msgDiv, 'Cadastro realizado com sucesso!');
                        Utils.showToast('Cadastro realizado com sucesso! 🎊', 'success');
                        
                        setTimeout(() => {
                            window.location.href = data.redirect || '/dashboard/';
                        }, 1500);
                        return;
                    }

                    // Erro - Exibe mensagem
                    console.log('Cadastro: Falha -', data.message);
                    
                    let errorMessage = 'Erro ao criar conta. Verifique os dados.';
                    
                    if (data.message) {
                        errorMessage = data.message;
                    } else if (data.error) {
                        errorMessage = data.error;
                    }

                    Utils.showFormError(msgDiv, errorMessage);
                    btn.disabled = false;
                    btn.textContent = 'Abrir Conta';
                })
                .catch(error => {
                    console.error('Cadastro: Erro na requisição:', error);
                    Utils.showFormError(msgDiv, 'Erro de conexão. Tente novamente.');
                    btn.disabled = false;
                    btn.textContent = 'Abrir Conta';
                });
            });
        }
    };

    // ============================================================
    // 5. MENU MOBILE
    // ============================================================
    
    const MobileMenu = {
        menu: null,
        overlay: null,

        init() {
            this.menu = document.getElementById('mobileMenu');
            this.overlay = document.getElementById('mobileMenuOverlay');

            if (!this.menu) return;

            const btnOpen = document.getElementById('bottomMenuBtn');
            const btnClose = document.getElementById('mobileMenuClose');

            btnOpen?.addEventListener('click', (e) => {
                e.preventDefault();
                e.stopPropagation();
                this.open();
            });

            btnClose?.addEventListener('click', (e) => {
                e.preventDefault();
                e.stopPropagation();
                this.close();
            });

            this.overlay?.addEventListener('click', (e) => {
                e.preventDefault();
                e.stopPropagation();
                this.close();
            });

            document.addEventListener('keydown', (e) => {
                if (e.key === 'Escape' && this.menu.classList.contains('show')) {
                    this.close();
                }
            });
        },

        open() {
            this.menu.classList.add('show');
            this.overlay.classList.add('show');
            document.body.style.overflow = 'hidden';
        },

        close() {
            this.menu.classList.remove('show');
            this.overlay.classList.remove('show');
            document.body.style.overflow = '';
        }
    };

    // ============================================================
    // 6. BOTTOM NAVIGATION
    // ============================================================
    
    const BottomNav = {
        init() {
            const items = document.querySelectorAll('.bottom-nav-item:not(.center)');

            items.forEach(item => {
                item.addEventListener('click', function(e) {
                    if (this.id !== 'bottomMenuBtn') {
                        items.forEach(i => i.classList.remove('active'));
                        this.classList.add('active');
                    }
                });

                item.addEventListener('touchstart', function() {
                    this.style.transform = this.classList.contains('center') 
                        ? 'translateY(-4px) scale(0.95)' 
                        : 'translateY(-2px) scale(0.95)';
                });

                item.addEventListener('touchend', function() {
                    this.style.transform = '';
                });
            });
        }
    };

    // ============================================================
    // 7. SISTEMA DE APOSTAS
    // ============================================================
    
    window.apostaAtual = {
        partidaId: null,
        flag: '',
        liga: '',
        timeCasa: '',
        timeFora: '',
        tipoAposta: '',
        odd: 0
    };

    const Apostas = {
        saldoUsuario: 0,

        init() {
            // Pega saldo do elemento
            const saldoElement = document.querySelector('.aposta-saldo-value');
            if (saldoElement) {
                const saldoText = saldoElement.textContent.replace('R$ ', '').replace('.', '').replace(',', '.');
                this.saldoUsuario = parseFloat(saldoText) || 0;
            }

            this.setupTickerAnimation();
            this.setupBotaoMinhasApostas();
        },

        setupTickerAnimation() {
            const strip = document.getElementById('tickerStrip');
            if (!strip) return;

            requestAnimationFrame(() => {
                const totalWidth = strip.scrollWidth / 2;
                strip.style.animation = `tickerScroll ${totalWidth / 50}s linear infinite`;
            });
        },

        setupBotaoMinhasApostas() {
            const style = document.createElement('style');
            style.textContent = `
                .btn-minhas-apostas { display: none !important; }
                .btn-minhas-apostas.show { display: flex !important; }
            `;
            document.head.appendChild(style);

            const originalAbrirModal = window.abrirModalAposta;
            window.abrirModalAposta = function(...args) {
                originalAbrirModal?.apply(this, args);
                document.getElementById('btnMinhasApostas')?.classList.add('show');
                Apostas.atualizarTextoBotao();
            };

            const count = parseInt(document.getElementById('apostasCount')?.textContent || 0);
            if (count > 0) {
                document.getElementById('btnMinhasApostas')?.classList.add('show');
            }
            this.atualizarTextoBotao();
        },

        atualizarTextoBotao() {
            const count = parseInt(document.getElementById('apostasCount')?.textContent || 0);
            const texto = document.getElementById('apostasTexto');
            if (texto) {
                texto.textContent = count === 1 ? '1 Ticket' : 'Minhas Apostas';
            }
        }
    };

    // Funções globais de apostas
    window.abrirModalAposta = function(partidaId, flag, liga, timeCasa, timeFora, tipoAposta, odd) {
        window.apostaAtual = { partidaId, flag, liga, timeCasa, timeFora, tipoAposta, odd };
        
        document.getElementById('apostaFlag').textContent = flag;
        document.getElementById('apostaLiga').textContent = liga;
        document.getElementById('apostaPartida').textContent = `${timeCasa} x ${timeFora}`;
        document.getElementById('apostaTipo').textContent = tipoAposta;
        document.getElementById('apostaOdd').textContent = odd.toFixed(2);
        document.getElementById('resumoOdd').textContent = odd.toFixed(2);
        document.getElementById('apostaValorInput').value = '';
        document.getElementById('resumoValor').textContent = 'R$ 0,00';
        document.getElementById('resumoRetorno').textContent = 'R$ 0,00';
        document.getElementById('btnFazerAposta').disabled = true;
        
        const alerta = document.getElementById('apostaAlerta');
        if (alerta) alerta.classList.remove('show');
        
        document.getElementById('modalApostaOverlay').classList.add('show');
        document.getElementById('modalAposta').classList.add('show');
        document.body.style.overflow = 'hidden';
    };

    window.fecharModalAposta = function() {
        document.getElementById('modalApostaOverlay').classList.remove('show');
        document.getElementById('modalAposta').classList.remove('show');
        document.body.style.overflow = '';
    };

    window.setValorAposta = function(valor) {
        document.getElementById('apostaValorInput').value = valor;
        window.calcularRetorno();
    };

    window.calcularRetorno = function() {
        const valor = parseFloat(document.getElementById('apostaValorInput').value) || 0;
        const odd = window.apostaAtual.odd;
        const retorno = valor * odd;
        
        document.getElementById('resumoValor').textContent = `R$ ${valor.toFixed(2).replace('.', ',')}`;
        document.getElementById('resumoRetorno').textContent = `R$ ${retorno.toFixed(2).replace('.', ',')}`;
        
        const btn = document.getElementById('btnFazerAposta');
        btn.disabled = valor <= 0 || valor > Apostas.saldoUsuario;
    };

    window.fazerAposta = function() {
        const valor = parseFloat(document.getElementById('apostaValorInput').value) || 0;
        const alerta = document.getElementById('apostaAlerta');
        const btn = document.getElementById('btnFazerAposta');
        
        if (valor <= 0) {
            alerta.className = 'aposta-alerta error show';
            alerta.textContent = 'Digite um valor válido para apostar.';
            return;
        }
        
        if (valor > Apostas.saldoUsuario) {
            alerta.className = 'aposta-alerta error show';
            alerta.textContent = 'Saldo insuficiente para esta aposta.';
            return;
        }
        
        btn.disabled = true;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processando...';
        
        fetch('php/fazer_aposta.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({
                partida_id: window.apostaAtual.partidaId,
                tipo_aposta: window.apostaAtual.tipoAposta,
                odd: window.apostaAtual.odd,
                valor: valor,
                descricao_partida: `${window.apostaAtual.timeCasa} x ${window.apostaAtual.timeFora}`,
                descricao_aposta: window.apostaAtual.tipoAposta
            })
        })
        .then(r => r.json())
        .then(data => {
            if (data.success) {
                Utils.showToast('✓ Aposta realizada com sucesso!', 'success');
                
                const count = document.getElementById('apostasCount');
                count.textContent = parseInt(count.textContent) + 1;
                
                setTimeout(() => {
                    window.fecharModalAposta();
                    location.reload();
                }, 1500);
            } else {
                alerta.className = 'aposta-alerta error show';
                alerta.textContent = data.message || 'Erro ao fazer aposta.';
                btn.disabled = false;
                btn.innerHTML = 'Fazer Aposta';
            }
        })
        .catch(() => {
            alerta.className = 'aposta-alerta error show';
            alerta.textContent = 'Erro de conexão. Tente novamente.';
            btn.disabled = false;
            btn.innerHTML = 'Fazer Aposta';
        });
    };

    window.abrirMinhasApostas = function() {
        document.getElementById('modalMinhasApostasOverlay').classList.add('show');
        document.getElementById('modalMinhasApostas').classList.add('show');
        document.body.style.overflow = 'hidden';
        window.carregarMinhasApostas();
    };

    window.fecharMinhasApostas = function() {
        document.getElementById('modalMinhasApostasOverlay').classList.remove('show');
        document.getElementById('modalMinhasApostas').classList.remove('show');
        document.body.style.overflow = '';
    };

    window.carregarMinhasApostas = function() {
        const container = document.getElementById('minhasApostasContent');
        container.innerHTML = '<div style="text-align:center;padding:40px;"><i class="fas fa-spinner fa-spin" style="font-size:24px;color:#6b7280;"></i></div>';
        
        fetch('php/minhas_apostas.php')
        .then(r => r.json())
        .then(data => {
            if (data.apostas && data.apostas.length > 0) {
                let html = '';
                data.apostas.forEach(a => {
                    html += `
                    <div class="aposta-card ${a.status}">
                        <div class="aposta-card-header">
                            <span class="aposta-card-partida">${a.descricao_partida}</span>
                            <span class="aposta-card-status ${a.status}">${a.status.toUpperCase()}</span>
                        </div>
                        <div class="aposta-card-tipo">${a.descricao_aposta} @ ${parseFloat(a.odd_selecionada).toFixed(2)}</div>
                        <div class="aposta-card-footer">
                            <div class="aposta-card-valores">
                                <div class="aposta-card-valor-item">
                                    <div class="aposta-card-valor-label">Apostado</div>
                                    <div class="aposta-card-valor-num">R$ ${parseFloat(a.valor_apostado).toFixed(2).replace('.', ',')}</div>
                                </div>
                                <div class="aposta-card-valor-item">
                                    <div class="aposta-card-valor-label">Retorno</div>
                                    <div class="aposta-card-valor-num green">R$ ${parseFloat(a.retorno_potencial).toFixed(2).replace('.', ',')}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    `;
                });
                container.innerHTML = html;
            } else {
                container.innerHTML = `
                <div class="aposta-vazia">
                    <i class="fas fa-receipt"></i>
                    <p>Você ainda não fez nenhuma aposta.</p>
                </div>
                `;
            }
        })
        .catch(() => {
            container.innerHTML = '<div class="aposta-vazia"><p>Erro ao carregar apostas.</p></div>';
        });
    };

    // ============================================================
    // 8. PLACEHOLDER ANIMADO (BUSCA)
    // ============================================================
    
    const SearchPlaceholder = {
        init() {
            const input = document.getElementById('input-busca');
            if (!input) return;

            const textos = [
                'Sweet Bonanza',
                'Fortune Tiger',
                'Fortune Ox',
                'Aviator',
                'Gates of Olympus',
                'Big Bass Bonanza'
            ];

            let textoIndex = 0;
            let charIndex = 0;
            let apagando = false;
            let ativo = true;

            const velocidadeDigitar = 120;
            const velocidadeApagar = 80;
            const pausaAposDigitar = 1200;
            const pausaAposApagar = 400;

            const animar = () => {
                if (!ativo) return;

                const textoAtual = textos[textoIndex];

                if (!apagando) {
                    input.setAttribute('placeholder', textoAtual.substring(0, charIndex + 1));
                    charIndex++;

                    if (charIndex === textoAtual.length) {
                        setTimeout(() => apagando = true, pausaAposDigitar);
                    }
                } else {
                    input.setAttribute('placeholder', textoAtual.substring(0, charIndex - 1));
                    charIndex--;

                    if (charIndex === 0) {
                        apagando = false;
                        textoIndex = (textoIndex + 1) % textos.length;
                        setTimeout(() => {}, pausaAposApagar);
                    }
                }

                setTimeout(animar, apagando ? velocidadeApagar : velocidadeDigitar);
            };

            input.addEventListener('focus', () => {
                ativo = false;
                input.setAttribute('placeholder', 'Pesquisar um jogo de cassino...');
            });

            input.addEventListener('blur', () => {
                if (input.value === '') {
                    ativo = true;
                    textoIndex = 0;
                    charIndex = 0;
                    apagando = false;
                    animar();
                }
            });

            animar();
        }
    };

    // ============================================================
    // 9. ANIMAÇÃO DE SLIDE DOWN PARA ERROS
    // ============================================================
    
    const style = document.createElement('style');
    style.textContent = `
        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
    `;
    document.head.appendChild(style);

    // ============================================================
    // 10. INICIALIZAÇÃO
    // ============================================================
    
    document.addEventListener('DOMContentLoaded', () => {
        console.log('Sistema inicializado');
        AgeGate.init();
        AuthModal.init();
        Forms.init();
        MobileMenu.init();
        BottomNav.init();
        Apostas.init();
        SearchPlaceholder.init();
    });

})();
</script>

</body>
</html>