<?php
/**
 * SISTEMA DE APOSTAS ESPORTIVAS - ESTILO BETANO/BET365
 * 
 * Arquivos necessários:
 * 1. SQL para criar tabelas
 * 2. CSS do sistema
 * 3. HTML do ticker + modal de apostas
 * 4. JavaScript para interações
 * 5. PHP backend para processar apostas
 */
?>

<!-- ============================================================
     1. SQL - EXECUTE NO PHPMYADMIN
     ============================================================ -->
<?php
/*

-- Tabela de partidas (ticker)
CREATE TABLE `ticker_partidas` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `flag` VARCHAR(10) DEFAULT '⚽',
    `liga` VARCHAR(100) NOT NULL,
    `time_casa` VARCHAR(100) NOT NULL,
    `time_fora` VARCHAR(100) NOT NULL,
    `placar_casa` INT DEFAULT 0,
    `placar_fora` INT DEFAULT 0,
    `tempo` VARCHAR(20) DEFAULT 'AO VIVO',
    `status` ENUM('live', 'upcoming', 'finished') DEFAULT 'live',
    `odd_label_1` VARCHAR(50) DEFAULT 'Mais de 2.5',
    `odd_valor_1` DECIMAL(5,2) DEFAULT 1.50,
    `odd_label_2` VARCHAR(50) DEFAULT 'Menos de 2.5',
    `odd_valor_2` DECIMAL(5,2) DEFAULT 2.00,
    `cartao_casa` VARCHAR(10) DEFAULT NULL,
    `cartao_fora` VARCHAR(10) DEFAULT NULL,
    `ativo` TINYINT(1) DEFAULT 1,
    `ordem` INT DEFAULT 0,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabela de apostas dos usuários
CREATE TABLE `apostas_esportivas` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `usuario_id` INT NOT NULL,
    `partida_id` INT NOT NULL,
    `tipo_aposta` VARCHAR(50) NOT NULL,
    `odd_selecionada` DECIMAL(5,2) NOT NULL,
    `valor_apostado` DECIMAL(10,2) NOT NULL,
    `retorno_potencial` DECIMAL(10,2) NOT NULL,
    `status` ENUM('pendente', 'ganhou', 'perdeu', 'cancelada') DEFAULT 'pendente',
    `descricao_partida` VARCHAR(255),
    `descricao_aposta` VARCHAR(100),
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (`usuario_id`) REFERENCES `bet_usuarios`(`id`) ON DELETE CASCADE,
    FOREIGN KEY (`partida_id`) REFERENCES `ticker_partidas`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Inserir partidas de exemplo
INSERT INTO `ticker_partidas` (`flag`, `liga`, `time_casa`, `time_fora`, `placar_casa`, `placar_fora`, `tempo`, `status`, `odd_label_1`, `odd_valor_1`, `odd_label_2`, `odd_valor_2`, `cartao_casa`, `cartao_fora`, `ativo`, `ordem`) VALUES
('🇧🇷', 'Brasil - Campeonato Paulista', 'São Paulo', 'Santos', 2, 0, '59:19', 'live', 'Mais de 2.5', 1.52, 'Menos de 2.5', 2.42, NULL, 'red', 1, 1),
('🇧🇷', 'Brasil - Brasileirão Série A', 'Flamengo', 'Palmeiras', 1, 1, '34:12', 'live', 'Mais de 2.5', 1.85, 'Menos de 2.5', 1.95, NULL, NULL, 1, 2),
('🇧🇷', 'Brasil - Brasileirão Série A', 'Corinthians', 'Grêmio', 0, 0, '12:45', 'live', 'Mais de 2.5', 2.10, 'Menos de 2.5', 1.70, 'yellow', NULL, 1, 3),
('🇬🇧', 'Inglaterra - Premier League', 'Liverpool', 'Man City', 2, 2, '78:30', 'live', 'Mais de 3.5', 1.65, 'Menos de 3.5', 2.20, NULL, NULL, 1, 4),
('🇪🇸', 'Espanha - La Liga', 'Real Madrid', 'Barcelona', 0, 0, '20:00', 'upcoming', 'Mais de 2.5', 1.90, 'Menos de 2.5', 1.90, NULL, NULL, 1, 5);

*/
?>

<!-- ============================================================
     2. QUERY PHP - ADICIONE ANTES DO <!DOCTYPE html>
     ============================================================ -->
<?php
/*
// =========================
// TICKER PARTIDAS AO VIVO
// =========================
$ticker_partidas = [];
try {
    $stmt = $pdo->prepare("
        SELECT * FROM ticker_partidas 
        WHERE ativo = 1 
        ORDER BY 
            CASE status 
                WHEN 'live' THEN 1 
                WHEN 'upcoming' THEN 2 
                WHEN 'finished' THEN 3 
            END,
            ordem ASC
        LIMIT 20
    ");
    $stmt->execute();
    $ticker_partidas = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Throwable $e) {
    $ticker_partidas = [];
}

// Conta apostas pendentes do usuário
$apostas_pendentes = 0;
try {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM apostas_esportivas WHERE usuario_id = ? AND status = 'pendente'");
    $stmt->execute([$_SESSION['usuario_id']]);
    $apostas_pendentes = (int)$stmt->fetchColumn();
} catch (Throwable $e) {}
*/
?>

<!-- ============================================================
     3. CSS - ADICIONE DENTRO DA TAG <style>
     ============================================================ -->
<style>
/* ========================================================
   TICKER PARTIDAS AO VIVO - ESTILO BETANO
   ======================================================== */
.ticker-ao-vivo {
    width: 100%;
    overflow: hidden;
    background: #0d1117;
    padding: 12px 0;
    margin: 8px 0;
}

.ticker-strip {
    display: flex;
    gap: 12px;
    padding: 0 12px;
    animation: tickerScroll 40s linear infinite;
    width: max-content;
}

.ticker-strip:hover {
    animation-play-state: paused;
}

@keyframes tickerScroll {
    0% { transform: translateX(0); }
    100% { transform: translateX(-50%); }
}

/* Card da Partida */
.ticker-card {
    flex-shrink: 0;
    width: 280px;
    background: #1a1f2e;
    border-radius: 12px;
    overflow: hidden;
    cursor: pointer;
    transition: all 0.2s ease;
    border: 1px solid rgba(255,255,255,0.06);
}

.ticker-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.4);
    border-color: rgba(255,255,255,0.12);
}

/* Header do Card - Liga */
.ticker-card-header {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 10px 14px;
    background: #151a26;
    border-bottom: 1px solid rgba(255,255,255,0.05);
}

.ticker-flag { font-size: 16px; line-height: 1; }

.ticker-league {
    flex: 1;
    font-size: 12px;
    color: #8b95a5;
    font-weight: 500;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

/* Corpo do Card */
.ticker-card-body { padding: 12px 14px; }

/* Linha do tempo + badge */
.ticker-time-row {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 10px;
}

.ticker-time {
    font-size: 14px;
    font-weight: 600;
    color: #fff;
}

.ticker-badge {
    font-size: 10px;
    font-weight: 700;
    padding: 4px 8px;
    border-radius: 4px;
    text-transform: uppercase;
}

.ticker-badge.live {
    background: linear-gradient(135deg, #ff4757 0%, #ff6b81 100%);
    color: #fff;
    animation: pulseLive 2s infinite;
}

.ticker-badge.upcoming {
    background: linear-gradient(135deg, #f59e0b 0%, #fbbf24 100%);
    color: #000;
}

.ticker-badge.finished {
    background: #374151;
    color: #9ca3af;
}

@keyframes pulseLive {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.7; }
}

/* Times */
.ticker-teams { margin-bottom: 12px; }

.ticker-team-row {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 6px 0;
}

.ticker-team-info {
    display: flex;
    align-items: center;
    gap: 10px;
    flex: 1;
}

.ticker-team-icon {
    width: 22px;
    height: 22px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 16px;
}

.ticker-team-name {
    font-size: 14px;
    color: #fff;
    font-weight: 500;
    max-width: 160px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.ticker-card-indicator {
    width: 14px;
    height: 18px;
    border-radius: 2px;
    margin-left: 6px;
}

.ticker-card-indicator.red { background: #ef4444; }
.ticker-card-indicator.yellow { background: #fbbf24; }

.ticker-team-score {
    font-size: 18px;
    font-weight: 700;
    color: #fff;
    min-width: 30px;
    text-align: right;
}

/* Odds Clicáveis */
.ticker-odds {
    display: flex;
    gap: 8px;
}

.ticker-odd {
    flex: 1;
    background: #252d3d;
    border-radius: 8px;
    padding: 10px 12px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    cursor: pointer;
    transition: all 0.2s ease;
    border: 2px solid transparent;
}

.ticker-odd:hover {
    background: #2d3748;
    border-color: #3b82f6;
}

.ticker-odd.selected {
    background: #1e3a5f;
    border-color: #3b82f6;
}

.ticker-odd-label {
    font-size: 12px;
    color: #9ca3af;
    font-weight: 500;
}

.ticker-odd-value {
    font-size: 14px;
    font-weight: 700;
    color: #10b981;
}

/* ========================================================
   MODAL DE APOSTA - ESTILO BETANO/BET365
   ======================================================== */
.modal-aposta-overlay {
    position: fixed;
    inset: 0;
    background: rgba(0,0,0,0.7);
    z-index: 9998;
    opacity: 0;
    visibility: hidden;
    transition: all 0.3s ease;
}

.modal-aposta-overlay.show {
    opacity: 1;
    visibility: visible;
}

.modal-aposta {
    position: fixed;
    bottom: 0;
    left: 0;
    right: 0;
    background: linear-gradient(180deg, #1a1f2e 0%, #0f1419 100%);
    border-radius: 20px 20px 0 0;
    z-index: 9999;
    transform: translateY(100%);
    transition: transform 0.3s ease;
    max-height: 85vh;
    overflow-y: auto;
}

.modal-aposta.show {
    transform: translateY(0);
}

@media (min-width: 768px) {
    .modal-aposta {
        left: 50%;
        right: auto;
        bottom: 50%;
        transform: translate(-50%, 50%) scale(0.9);
        border-radius: 20px;
        width: 420px;
        max-height: 80vh;
    }
    
    .modal-aposta.show {
        transform: translate(-50%, 50%) scale(1);
    }
}

/* Header do Modal */
.aposta-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 16px 20px;
    border-bottom: 1px solid rgba(255,255,255,0.08);
    background: #151a26;
    border-radius: 20px 20px 0 0;
}

.aposta-header-title {
    display: flex;
    align-items: center;
    gap: 10px;
}

.aposta-header-title i {
    color: #fbbf24;
    font-size: 18px;
}

.aposta-header-title span {
    color: #fff;
    font-size: 16px;
    font-weight: 600;
}

.aposta-close-btn {
    background: rgba(255,255,255,0.1);
    border: none;
    color: #fff;
    width: 36px;
    height: 36px;
    border-radius: 50%;
    cursor: pointer;
    font-size: 18px;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.2s ease;
}

.aposta-close-btn:hover {
    background: rgba(255,255,255,0.2);
}

/* Conteúdo do Modal */
.aposta-content {
    padding: 20px;
}

/* Card da Seleção */
.aposta-selecao {
    background: #252d3d;
    border-radius: 12px;
    padding: 16px;
    margin-bottom: 20px;
    position: relative;
}

.aposta-remover {
    position: absolute;
    top: 12px;
    right: 12px;
    background: rgba(239,68,68,0.2);
    border: none;
    color: #ef4444;
    width: 24px;
    height: 24px;
    border-radius: 50%;
    cursor: pointer;
    font-size: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.aposta-remover:hover {
    background: rgba(239,68,68,0.3);
}

.aposta-partida {
    display: flex;
    align-items: center;
    gap: 8px;
    margin-bottom: 10px;
}

.aposta-partida-flag {
    font-size: 16px;
}

.aposta-partida-info {
    flex: 1;
}

.aposta-partida-liga {
    font-size: 11px;
    color: #6b7280;
    margin-bottom: 2px;
}

.aposta-partida-times {
    font-size: 13px;
    color: #fff;
    font-weight: 500;
}

.aposta-tipo {
    display: flex;
    align-items: center;
    justify-content: space-between;
    background: #1a1f2e;
    border-radius: 8px;
    padding: 12px;
}

.aposta-tipo-label {
    font-size: 13px;
    color: #9ca3af;
}

.aposta-tipo-odd {
    font-size: 16px;
    font-weight: 700;
    color: #10b981;
}

/* Input de Valor */
.aposta-valor-section {
    margin-bottom: 20px;
}

.aposta-valor-label {
    display: block;
    font-size: 13px;
    color: #9ca3af;
    margin-bottom: 10px;
}

.aposta-valor-input-container {
    display: flex;
    align-items: center;
    background: #252d3d;
    border-radius: 10px;
    border: 2px solid transparent;
    transition: all 0.2s ease;
    overflow: hidden;
}

.aposta-valor-input-container:focus-within {
    border-color: #3b82f6;
}

.aposta-valor-prefix {
    padding: 14px 12px;
    color: #9ca3af;
    font-weight: 600;
    font-size: 16px;
    background: #1a1f2e;
}

.aposta-valor-input {
    flex: 1;
    background: transparent;
    border: none;
    color: #fff;
    font-size: 18px;
    font-weight: 600;
    padding: 14px;
    outline: none;
}

.aposta-valor-input::placeholder {
    color: #4b5563;
}

/* Valores Rápidos */
.aposta-valores-rapidos {
    display: flex;
    gap: 8px;
    margin-bottom: 20px;
    flex-wrap: wrap;
}

.aposta-valor-btn {
    flex: 1;
    min-width: 70px;
    background: #252d3d;
    border: 1px solid rgba(255,255,255,0.1);
    color: #fff;
    padding: 10px;
    border-radius: 8px;
    font-size: 13px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.2s ease;
}

.aposta-valor-btn:hover {
    background: #2d3748;
    border-color: #3b82f6;
}

/* Resumo da Aposta */
.aposta-resumo {
    background: #252d3d;
    border-radius: 12px;
    padding: 16px;
    margin-bottom: 20px;
}

.aposta-resumo-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 8px 0;
}

.aposta-resumo-row:not(:last-child) {
    border-bottom: 1px solid rgba(255,255,255,0.05);
}

.aposta-resumo-label {
    font-size: 13px;
    color: #9ca3af;
}

.aposta-resumo-value {
    font-size: 14px;
    color: #fff;
    font-weight: 500;
}

.aposta-resumo-value.highlight {
    color: #10b981;
    font-size: 18px;
    font-weight: 700;
}

/* Saldo Disponível */
.aposta-saldo {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 12px 16px;
    background: rgba(16, 185, 129, 0.1);
    border-radius: 10px;
    margin-bottom: 20px;
    border: 1px solid rgba(16, 185, 129, 0.2);
}

.aposta-saldo-label {
    font-size: 13px;
    color: #9ca3af;
}

.aposta-saldo-value {
    font-size: 16px;
    font-weight: 700;
    color: #10b981;
}

/* Botão de Apostar */
.btn-fazer-aposta {
    width: 100%;
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    border: none;
    color: #fff;
    padding: 16px;
    border-radius: 12px;
    font-size: 16px;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.2s ease;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.btn-fazer-aposta:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(16, 185, 129, 0.4);
}

.btn-fazer-aposta:disabled {
    background: #374151;
    cursor: not-allowed;
    transform: none;
    box-shadow: none;
}

/* Alerta */
.aposta-alerta {
    padding: 12px 16px;
    border-radius: 10px;
    margin-bottom: 15px;
    font-size: 13px;
    display: none;
}

.aposta-alerta.show { display: block; }

.aposta-alerta.error {
    background: rgba(239, 68, 68, 0.15);
    border: 1px solid rgba(239, 68, 68, 0.3);
    color: #fca5a5;
}

.aposta-alerta.success {
    background: rgba(16, 185, 129, 0.15);
    border: 1px solid rgba(16, 185, 129, 0.3);
    color: #6ee7b7;
}

/* ========================================================
   BOTÃO MINHAS APOSTAS FLUTUANTE
   ======================================================== */
.btn-minhas-apostas {
    position: fixed;
    bottom: 90px;
    right: 16px;
    background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
    color: #fff;
    border: none;
    padding: 12px 20px;
    border-radius: 50px;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    z-index: 1000;
    display: flex;
    align-items: center;
    gap: 8px;
    box-shadow: 0 4px 20px rgba(59, 130, 246, 0.4);
    transition: all 0.2s ease;
}

.btn-minhas-apostas:hover {
    transform: translateY(-3px);
    box-shadow: 0 6px 25px rgba(59, 130, 246, 0.5);
}

.btn-minhas-apostas .badge {
    background: #ef4444;
    color: #fff;
    font-size: 11px;
    font-weight: 700;
    padding: 2px 8px;
    border-radius: 10px;
    min-width: 20px;
    text-align: center;
}

/* ========================================================
   MODAL MINHAS APOSTAS
   ======================================================== */
.modal-minhas-apostas {
    position: fixed;
    bottom: 0;
    left: 0;
    right: 0;
    background: linear-gradient(180deg, #1a1f2e 0%, #0f1419 100%);
    border-radius: 20px 20px 0 0;
    z-index: 9999;
    transform: translateY(100%);
    transition: transform 0.3s ease;
    max-height: 80vh;
    overflow-y: auto;
}

.modal-minhas-apostas.show {
    transform: translateY(0);
}

.minhas-apostas-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 16px 20px;
    border-bottom: 1px solid rgba(255,255,255,0.08);
    background: #151a26;
    border-radius: 20px 20px 0 0;
    position: sticky;
    top: 0;
}

.minhas-apostas-content {
    padding: 20px;
}

/* Card de Aposta */
.aposta-card {
    background: #252d3d;
    border-radius: 12px;
    padding: 16px;
    margin-bottom: 12px;
    border-left: 4px solid #fbbf24;
}

.aposta-card.ganhou { border-left-color: #10b981; }
.aposta-card.perdeu { border-left-color: #ef4444; }

.aposta-card-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 12px;
}

.aposta-card-partida {
    font-size: 13px;
    color: #fff;
    font-weight: 500;
}

.aposta-card-status {
    font-size: 10px;
    font-weight: 700;
    padding: 4px 10px;
    border-radius: 20px;
    text-transform: uppercase;
}

.aposta-card-status.pendente {
    background: rgba(251, 191, 36, 0.15);
    color: #fbbf24;
}

.aposta-card-status.ganhou {
    background: rgba(16, 185, 129, 0.15);
    color: #10b981;
}

.aposta-card-status.perdeu {
    background: rgba(239, 68, 68, 0.15);
    color: #ef4444;
}

.aposta-card-tipo {
    font-size: 12px;
    color: #9ca3af;
    margin-bottom: 12px;
}

.aposta-card-footer {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding-top: 12px;
    border-top: 1px solid rgba(255,255,255,0.05);
}

.aposta-card-valores {
    display: flex;
    gap: 20px;
}

.aposta-card-valor-item {
    text-align: center;
}

.aposta-card-valor-label {
    font-size: 10px;
    color: #6b7280;
    margin-bottom: 2px;
}

.aposta-card-valor-num {
    font-size: 14px;
    font-weight: 700;
    color: #fff;
}

.aposta-card-valor-num.green { color: #10b981; }

.aposta-vazia {
    text-align: center;
    padding: 40px 20px;
    color: #6b7280;
}

.aposta-vazia i {
    font-size: 48px;
    margin-bottom: 16px;
    opacity: 0.5;
}

.aposta-vazia p {
    font-size: 14px;
}

/* Responsivo */
@media (max-width: 480px) {
    .ticker-card { width: 260px; }
    .ticker-team-name { max-width: 130px; font-size: 13px; }
    .btn-minhas-apostas { bottom: 80px; right: 12px; padding: 10px 16px; font-size: 13px; }
}
</style>

<!-- ============================================================
     4. HTML DO TICKER - ADICIONE ONDE QUISER EXIBIR
     ============================================================ -->
<?php if (!empty($ticker_partidas)): ?>
<div class="ticker-ao-vivo">
    <div class="ticker-strip" id="tickerStrip">
        <?php
        for ($loop = 0; $loop < 2; $loop++):
            foreach ($ticker_partidas as $p):
                $badge_class = $p['status'] ?? 'live';
        ?>
        <div class="ticker-card" data-partida-id="<?= $p['id'] ?>">
            <div class="ticker-card-header">
                <span class="ticker-flag"><?= htmlspecialchars($p['flag'] ?? '⚽') ?></span>
                <span class="ticker-league"><?= htmlspecialchars($p['liga'] ?? '') ?></span>
            </div>
            
            <div class="ticker-card-body">
                <div class="ticker-time-row">
                    <div style="display: flex; align-items: center; gap: 10px;">
                        <span class="ticker-time"><?= htmlspecialchars($p['tempo'] ?? '') ?></span>
                        <span class="ticker-badge <?= $badge_class ?>">
                            <?= $badge_class === 'live' ? '🔥 AO VIVO' : ($badge_class === 'upcoming' ? 'EM BREVE' : 'ENCERRADO') ?>
                        </span>
                    </div>
                </div>
                
                <div class="ticker-teams">
                    <div class="ticker-team-row">
                        <div class="ticker-team-info">
                            <span class="ticker-team-icon">🏠</span>
                            <span class="ticker-team-name"><?= htmlspecialchars($p['time_casa'] ?? '') ?></span>
                            <?php if (!empty($p['cartao_casa'])): ?>
                            <span class="ticker-card-indicator <?= $p['cartao_casa'] ?>"></span>
                            <?php endif; ?>
                        </div>
                        <span class="ticker-team-score"><?= $p['placar_casa'] ?? 0 ?></span>
                    </div>
                    <div class="ticker-team-row">
                        <div class="ticker-team-info">
                            <span class="ticker-team-icon">✈️</span>
                            <span class="ticker-team-name"><?= htmlspecialchars($p['time_fora'] ?? '') ?></span>
                            <?php if (!empty($p['cartao_fora'])): ?>
                            <span class="ticker-card-indicator <?= $p['cartao_fora'] ?>"></span>
                            <?php endif; ?>
                        </div>
                        <span class="ticker-team-score"><?= $p['placar_fora'] ?? 0 ?></span>
                    </div>
                </div>
                
                <div class="ticker-odds">
                    <div class="ticker-odd" 
                         onclick="abrirModalAposta(<?= $p['id'] ?>, '<?= htmlspecialchars($p['flag'] ?? '') ?>', '<?= htmlspecialchars($p['liga'] ?? '') ?>', '<?= htmlspecialchars($p['time_casa'] ?? '') ?>', '<?= htmlspecialchars($p['time_fora'] ?? '') ?>', '<?= htmlspecialchars($p['odd_label_1'] ?? '') ?>', <?= $p['odd_valor_1'] ?? 1.50 ?>)">
                        <span class="ticker-odd-label"><?= htmlspecialchars($p['odd_label_1'] ?? 'Mais de 2.5') ?></span>
                        <span class="ticker-odd-value"><?= number_format($p['odd_valor_1'] ?? 1.50, 2) ?></span>
                    </div>
                    <div class="ticker-odd"
                         onclick="abrirModalAposta(<?= $p['id'] ?>, '<?= htmlspecialchars($p['flag'] ?? '') ?>', '<?= htmlspecialchars($p['liga'] ?? '') ?>', '<?= htmlspecialchars($p['time_casa'] ?? '') ?>', '<?= htmlspecialchars($p['time_fora'] ?? '') ?>', '<?= htmlspecialchars($p['odd_label_2'] ?? '') ?>', <?= $p['odd_valor_2'] ?? 2.00 ?>)">
                        <span class="ticker-odd-label"><?= htmlspecialchars($p['odd_label_2'] ?? 'Menos de 2.5') ?></span>
                        <span class="ticker-odd-value"><?= number_format($p['odd_valor_2'] ?? 2.00, 2) ?></span>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
        <?php endfor; ?>
    </div>
</div>
<?php endif; ?>

<!-- ============================================================
     5. BOTÃO MINHAS APOSTAS FLUTUANTE
     ============================================================ -->
<button class="btn-minhas-apostas" id="btnMinhasApostas" onclick="abrirMinhasApostas()">
    <i class="fas fa-receipt"></i>
    Minhas Apostas
    <span class="badge" id="apostasCount"><?= $apostas_pendentes ?? 0 ?></span>
</button>

<!-- ============================================================
     6. MODAL DE APOSTA
     ============================================================ -->
<div class="modal-aposta-overlay" id="modalApostaOverlay" onclick="fecharModalAposta()"></div>
<div class="modal-aposta" id="modalAposta">
    <div class="aposta-header">
        <div class="aposta-header-title">
            <i class="fas fa-ticket-alt"></i>
            <span>Bilhete de Aposta</span>
        </div>
        <button class="aposta-close-btn" onclick="fecharModalAposta()">
            <i class="fas fa-times"></i>
        </button>
    </div>
    
    <div class="aposta-content">
        <div class="aposta-alerta" id="apostaAlerta"></div>
        
        <!-- Seleção da Aposta -->
        <div class="aposta-selecao">
            <button class="aposta-remover" onclick="fecharModalAposta()">
                <i class="fas fa-times"></i>
            </button>
            <div class="aposta-partida">
                <span class="aposta-partida-flag" id="apostaFlag"></span>
                <div class="aposta-partida-info">
                    <div class="aposta-partida-liga" id="apostaLiga"></div>
                    <div class="aposta-partida-times" id="apostaPartida"></div>
                </div>
            </div>
            <div class="aposta-tipo">
                <span class="aposta-tipo-label" id="apostaTipo"></span>
                <span class="aposta-tipo-odd" id="apostaOdd"></span>
            </div>
        </div>
        
        <!-- Input de Valor -->
        <div class="aposta-valor-section">
            <label class="aposta-valor-label">Valor da aposta</label>
            <div class="aposta-valor-input-container">
                <span class="aposta-valor-prefix">R$</span>
                <input type="number" class="aposta-valor-input" id="apostaValorInput" 
                       placeholder="0,00" min="1" step="0.01" oninput="calcularRetorno()">
            </div>
        </div>
        
        <!-- Valores Rápidos -->
        <div class="aposta-valores-rapidos">
            <button class="aposta-valor-btn" onclick="setValorAposta(10)">R$ 10</button>
            <button class="aposta-valor-btn" onclick="setValorAposta(25)">R$ 25</button>
            <button class="aposta-valor-btn" onclick="setValorAposta(50)">R$ 50</button>
            <button class="aposta-valor-btn" onclick="setValorAposta(100)">R$ 100</button>
        </div>
        
        <!-- Resumo -->
        <div class="aposta-resumo">
            <div class="aposta-resumo-row">
                <span class="aposta-resumo-label">Odd</span>
                <span class="aposta-resumo-value" id="resumoOdd">0.00</span>
            </div>
            <div class="aposta-resumo-row">
                <span class="aposta-resumo-label">Valor apostado</span>
                <span class="aposta-resumo-value" id="resumoValor">R$ 0,00</span>
            </div>
            <div class="aposta-resumo-row">
                <span class="aposta-resumo-label">Retorno potencial</span>
                <span class="aposta-resumo-value highlight" id="resumoRetorno">R$ 0,00</span>
            </div>
        </div>
        
        <!-- Saldo -->
        <div class="aposta-saldo">
            <span class="aposta-saldo-label">Saldo disponível</span>
            <span class="aposta-saldo-value">R$ <?= number_format($saldo ?? 0, 2, ',', '.') ?></span>
        </div>
        
        <!-- Botão Apostar -->
        <button class="btn-fazer-aposta" id="btnFazerAposta" onclick="fazerAposta()" disabled>
            Fazer Aposta
        </button>
    </div>
</div>

<!-- ============================================================
     7. MODAL MINHAS APOSTAS
     ============================================================ -->
<div class="modal-aposta-overlay" id="modalMinhasApostasOverlay" onclick="fecharMinhasApostas()"></div>
<div class="modal-minhas-apostas" id="modalMinhasApostas">
    <div class="minhas-apostas-header">
        <div class="aposta-header-title">
            <i class="fas fa-receipt"></i>
            <span>Minhas Apostas</span>
        </div>
        <button class="aposta-close-btn" onclick="fecharMinhasApostas()">
            <i class="fas fa-times"></i>
        </button>
    </div>
    
    <div class="minhas-apostas-content" id="minhasApostasContent">
        <!-- Carregado via AJAX -->
    </div>
</div>

<!-- ============================================================
     8. JAVASCRIPT
     ============================================================ -->
<script>
// Variáveis globais da aposta atual
let apostaAtual = {
    partidaId: null,
    flag: '',
    liga: '',
    timeCasa: '',
    timeFora: '',
    tipoAposta: '',
    odd: 0
};

const saldoUsuario = <?= $saldo ?? 0 ?>;

// Abrir modal de aposta
function abrirModalAposta(partidaId, flag, liga, timeCasa, timeFora, tipoAposta, odd) {
    apostaAtual = { partidaId, flag, liga, timeCasa, timeFora, tipoAposta, odd };
    
    document.getElementById('apostaFlag').textContent = flag;
    document.getElementById('apostaLiga').textContent = liga;
    document.getElementById('apostaPartida').textContent = `${timeCasa} x ${timeFora}`;
    document.getElementById('apostaTipo').textContent = tipoAposta;
    document.getElementById('apostaOdd').textContent = odd.toFixed(2);
    document.getElementById('resumoOdd').textContent = odd.toFixed(2);
    document.getElementById('apostaValorInput').value = '';
    document.getElementById('resumoValor').textContent = 'R$ 0,00';
    document.getElementById('resumoRetorno').textContent = 'R$ 0,00';
    document.getElementById('btnFazerAposta').disabled = true;
    document.getElementById('apostaAlerta').classList.remove('show');
    
    document.getElementById('modalApostaOverlay').classList.add('show');
    document.getElementById('modalAposta').classList.add('show');
    document.body.style.overflow = 'hidden';
}

// Fechar modal de aposta
function fecharModalAposta() {
    document.getElementById('modalApostaOverlay').classList.remove('show');
    document.getElementById('modalAposta').classList.remove('show');
    document.body.style.overflow = '';
}

// Definir valor rápido
function setValorAposta(valor) {
    document.getElementById('apostaValorInput').value = valor;
    calcularRetorno();
}

// Calcular retorno potencial
function calcularRetorno() {
    const valor = parseFloat(document.getElementById('apostaValorInput').value) || 0;
    const odd = apostaAtual.odd;
    const retorno = valor * odd;
    
    document.getElementById('resumoValor').textContent = `R$ ${valor.toFixed(2).replace('.', ',')}`;
    document.getElementById('resumoRetorno').textContent = `R$ ${retorno.toFixed(2).replace('.', ',')}`;
    
    const btn = document.getElementById('btnFazerAposta');
    btn.disabled = valor <= 0 || valor > saldoUsuario;
}

// Fazer aposta
function fazerAposta() {
    const valor = parseFloat(document.getElementById('apostaValorInput').value) || 0;
    const alerta = document.getElementById('apostaAlerta');
    const btn = document.getElementById('btnFazerAposta');
    
    if (valor <= 0) {
        alerta.className = 'aposta-alerta error show';
        alerta.textContent = 'Digite um valor válido para apostar.';
        return;
    }
    
    if (valor > saldoUsuario) {
        alerta.className = 'aposta-alerta error show';
        alerta.textContent = 'Saldo insuficiente para esta aposta.';
        return;
    }
    
    btn.disabled = true;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processando...';
    
    fetch('php/fazer_aposta.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({
            partida_id: apostaAtual.partidaId,
            tipo_aposta: apostaAtual.tipoAposta,
            odd: apostaAtual.odd,
            valor: valor,
            descricao_partida: `${apostaAtual.timeCasa} x ${apostaAtual.timeFora}`,
            descricao_aposta: apostaAtual.tipoAposta
        })
    })
    .then(r => r.json())
    .then(data => {
        if (data.success) {
            alerta.className = 'aposta-alerta success show';
            alerta.textContent = '✓ Aposta realizada com sucesso!';
            
            // Atualiza contador
            const count = document.getElementById('apostasCount');
            count.textContent = parseInt(count.textContent) + 1;
            
            setTimeout(() => {
                fecharModalAposta();
                location.reload(); // Recarrega para atualizar saldo
            }, 1500);
        } else {
            alerta.className = 'aposta-alerta error show';
            alerta.textContent = data.message || 'Erro ao fazer aposta.';
            btn.disabled = false;
            btn.innerHTML = 'Fazer Aposta';
        }
    })
    .catch(() => {
        alerta.className = 'aposta-alerta error show';
        alerta.textContent = 'Erro de conexão. Tente novamente.';
        btn.disabled = false;
        btn.innerHTML = 'Fazer Aposta';
    });
}

// Abrir minhas apostas
function abrirMinhasApostas() {
    document.getElementById('modalMinhasApostasOverlay').classList.add('show');
    document.getElementById('modalMinhasApostas').classList.add('show');
    document.body.style.overflow = 'hidden';
    
    carregarMinhasApostas();
}

// Fechar minhas apostas
function fecharMinhasApostas() {
    document.getElementById('modalMinhasApostasOverlay').classList.remove('show');
    document.getElementById('modalMinhasApostas').classList.remove('show');
    document.body.style.overflow = '';
}

// Carregar minhas apostas
function carregarMinhasApostas() {
    const container = document.getElementById('minhasApostasContent');
    container.innerHTML = '<div style="text-align:center;padding:40px;"><i class="fas fa-spinner fa-spin" style="font-size:24px;color:#6b7280;"></i></div>';
    
    fetch('php/minhas_apostas.php')
    .then(r => r.json())
    .then(data => {
        if (data.apostas && data.apostas.length > 0) {
            let html = '';
            data.apostas.forEach(a => {
                html += `
                <div class="aposta-card ${a.status}">
                    <div class="aposta-card-header">
                        <span class="aposta-card-partida">${a.descricao_partida}</span>
                        <span class="aposta-card-status ${a.status}">${a.status.toUpperCase()}</span>
                    </div>
                    <div class="aposta-card-tipo">${a.descricao_aposta} @ ${parseFloat(a.odd_selecionada).toFixed(2)}</div>
                    <div class="aposta-card-footer">
                        <div class="aposta-card-valores">
                            <div class="aposta-card-valor-item">
                                <div class="aposta-card-valor-label">Apostado</div>
                                <div class="aposta-card-valor-num">R$ ${parseFloat(a.valor_apostado).toFixed(2).replace('.', ',')}</div>
                            </div>
                            <div class="aposta-card-valor-item">
                                <div class="aposta-card-valor-label">Retorno</div>
                                <div class="aposta-card-valor-num green">R$ ${parseFloat(a.retorno_potencial).toFixed(2).replace('.', ',')}</div>
                            </div>
                        </div>
                    </div>
                </div>
                `;
            });
            container.innerHTML = html;
        } else {
            container.innerHTML = `
            <div class="aposta-vazia">
                <i class="fas fa-receipt"></i>
                <p>Você ainda não fez nenhuma aposta.</p>
            </div>
            `;
        }
    })
    .catch(() => {
        container.innerHTML = '<div class="aposta-vazia"><p>Erro ao carregar apostas.</p></div>';
    });
}

// Ajusta velocidade do ticker
(function() {
    const strip = document.getElementById('tickerStrip');
    if (!strip) return;
    requestAnimationFrame(() => {
        const totalWidth = strip.scrollWidth / 2;
        strip.style.animationDuration = (totalWidth / 50) + 's';
    });
})();
</script>
