<?php
header('Content-Type: application/json');
session_start();

require_once '../../includes/db.php';

if (!isset($_SESSION['usuario_id'])) {
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

$usuario_id = (int)$_SESSION['usuario_id'];

try {
    // Busca config do bônus USA (valor em USD + cotação)
    $stmt = $pdo->prepare("
        SELECT bonus_usa_valor, bonus_usa_cotacao
        FROM bet_config
        WHERE id = 1
        LIMIT 1
    ");
    $stmt->execute();
    $cfg = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$cfg) {
        echo json_encode(['success' => false, 'message' => 'Configuração não encontrada']);
        exit;
    }

    $valorUSD = (float)$cfg['bonus_usa_valor'];
    $cotacao  = (float)$cfg['bonus_usa_cotacao'];

    if ($valorUSD <= 0 || $cotacao <= 0) {
        echo json_encode(['success' => false, 'message' => 'Bônus indisponível']);
        exit;
    }

    // 💱 converte USD → BRL
    $valorBRL = round($valorUSD * $cotacao, 2);

    $pdo->beginTransaction();

    // trava usuário
    $lock = $pdo->prepare("SELECT id FROM bet_usuarios WHERE id = ? FOR UPDATE");
    $lock->execute([$usuario_id]);

    if (!$lock->fetch()) {
        $pdo->rollBack();
        echo json_encode(['success' => false, 'message' => 'Usuário não encontrado']);
        exit;
    }

    // evita resgate duplicado
    $check = $pdo->prepare("
        SELECT id FROM bet_bonus
        WHERE bet_usuario = ? AND bet_bonus_origem = 'USA'
        LIMIT 1
    ");
    $check->execute([$usuario_id]);

    if ($check->fetch()) {
        $pdo->rollBack();
        echo json_encode(['success' => false, 'message' => 'Bônus já resgatado']);
        exit;
    }

    // ✅ soma na carteira BRL
    $up = $pdo->prepare("
        UPDATE bet_usuarios
        SET bet_saldo = bet_saldo + :valor
        WHERE id = :id
    ");
    $up->execute([
        ':valor' => $valorBRL,
        ':id'    => $usuario_id
    ]);

    // grava controle
    $ins = $pdo->prepare("
        INSERT INTO bet_bonus (bet_usuario, bet_bonus_valor, bet_bonus_status, bet_bonus_origem)
        VALUES (?, ?, 1, 'USA')
    ");
    $ins->execute([$usuario_id, $valorUSD]);

    $pdo->commit();

    echo json_encode([
        'success' => true,
        'message' => 'Bônus creditado: US$ ' . number_format($valorUSD, 0) .
                     ' → R$ ' . number_format($valorBRL, 2, ',', '.')
    ]);
    exit;

} catch (Throwable $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    echo json_encode(['success' => false, 'message' => 'Erro interno']);
    exit;
}
