<?php
// ajax/sorteio_manual_status.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-cache, must-revalidate');

function jsonResponse($data, $code = 200) {
    http_response_code($code);
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
}

try {
    require_once('../conexao.php');
    
    $input = json_decode(file_get_contents('php://input'), true);
    $sala_id = isset($input['sala_id']) ? intval($input['sala_id']) : 0;
    
    if ($sala_id <= 0) {
        $stmt = $pdo->prepare("SELECT id FROM salas_bingo_manual WHERE status != 'finalizado' ORDER BY id DESC LIMIT 1");
        $stmt->execute();
        $sala_id = $stmt->fetchColumn();
        
        if (!$sala_id) {
            jsonResponse([
                'status' => 'aguardando',
                'numero' => null,
                'total_bolas' => 0,
                'numeros_sorteados' => [],
                'ganhadores' => [],
                'tempo_intervalo' => 30
            ]);
        }
    }
    
    // Busca dados da sala com tempo_intervalo
    $stmt = $pdo->prepare("SELECT status, numeros_sorteados, valor_quadra, valor_quina, valor_cartela_cheia, tempo_intervalo FROM salas_bingo_manual WHERE id = ?");
    $stmt->execute([$sala_id]);
    $sala = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$sala) {
        jsonResponse(['error' => 'Sala não encontrada'], 404);
    }
    
    $numeros_sorteados = json_decode($sala['numeros_sorteados'] ?? '[]', true) ?: [];
    $ultima_bola = end($numeros_sorteados) ?: null;
    
    // Busca ganhadores com tipo_premio
    $stmt_g = $pdo->prepare("SELECT nome_cliente, valor_premio, tipo_premio FROM ganhadores_manual WHERE sala_id = ? ORDER BY created_at DESC LIMIT 10");
    $stmt_g->execute([$sala_id]);
    $ganhadores = $stmt_g->fetchAll(PDO::FETCH_ASSOC);
    
    // Busca vencedor principal
    $vencedor = null;
    if ($sala['status'] === 'finalizado') {
        $stmt_v = $pdo->prepare("SELECT nome_cliente FROM ganhadores_manual WHERE sala_id = ? AND tipo_premio = 'cartela_cheia' ORDER BY created_at DESC LIMIT 1");
        $stmt_v->execute([$sala_id]);
        $vencedor = $stmt_v->fetchColumn();
    }
    
    jsonResponse([
        'status' => $sala['status'],
        'numero' => $ultima_bola,
        'total_bolas' => count($numeros_sorteados),
        'numeros_sorteados' => $numeros_sorteados,
        'ganhadores' => $ganhadores,
        'vencedor' => $vencedor,
        'tempo_intervalo' => intval($sala['tempo_intervalo'] ?? 30), // ADICIONE ESTA LINHA
        'premios' => [
            'quadra' => floatval($sala['valor_quadra']),
            'quina' => floatval($sala['valor_quina']),
            'cartela_cheia' => floatval($sala['valor_cartela_cheia'])
        ]
    ]);
    
} catch (Exception $e) {
    jsonResponse(['error' => 'Erro interno: ' . $e->getMessage()], 500);
}
?>